/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.telepathicgrunt.ultraamplified.UltraAmplified;

public class SunShrine
extends Feature<NoFeatureConfig> {
    protected static final Set<BlockState> acceptableBlocks = ImmutableSet.of((Object)Blocks.field_150346_d.func_176223_P(), (Object)Blocks.field_196658_i.func_176223_P(), (Object)Blocks.field_196661_l.func_176223_P(), (Object)Blocks.field_196660_k.func_176223_P(), (Object)Blocks.field_150354_m.func_176223_P(), (Object)Blocks.field_150322_A.func_176223_P(), (Object[])new BlockState[]{Blocks.field_185774_da.func_176223_P()});

    public SunShrine(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, NoFeatureConfig p_212245_5_) {
        if (!UltraAmplified.UAConfig.miniStructureGeneration.get().booleanValue() || position.func_177956_o() > 248) {
            return false;
        }
        boolean sunken = false;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(position);
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                if (Math.abs(x * z) <= 4 || Math.abs(x * z) >= 8) continue;
                blockpos$Mutable.func_189533_g((Vec3i)position).func_196234_d(-x, -1, -z);
                BlockState state = world.func_180495_p((BlockPos)blockpos$Mutable);
                if (acceptableBlocks.contains(state)) continue;
                state = world.func_180495_p(blockpos$Mutable.func_177977_b());
                if (!acceptableBlocks.contains(state)) {
                    return false;
                }
                sunken = true;
            }
        }
        if (sunken) {
            blockpos$Mutable.func_189533_g((Vec3i)position).func_196234_d(-3, -2, -3);
        } else {
            blockpos$Mutable.func_189533_g((Vec3i)position).func_196234_d(-3, -1, -3);
        }
        TemplateManager templatemanager = ((ServerWorld)world.func_201672_e()).func_217485_w().func_186340_h();
        Template template = templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_dimension:sunshrine"));
        if (template == null) {
            UltraAmplified.LOGGER.warn("sunshrine NTB does not exist!");
            return false;
        }
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a((ChunkPos)null);
        template.func_186253_b(world, (BlockPos)blockpos$Mutable, placementsettings);
        return true;
    }
}

