/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class TreeEnd
extends AbstractTreeFeature<TreeFeatureConfig> {
    private static final BlockState LOG = Blocks.field_196619_M.func_176223_P();
    private static final BlockState LEAF = (BlockState)Blocks.field_196574_ab.func_176223_P().func_206870_a((IProperty)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1));
    private static final BlockState PURPLE_TERRACOTTA = Blocks.field_196797_fz.func_176223_P();

    public TreeEnd(Function<Dynamic<?>, ? extends TreeFeatureConfig> p_i225808_1_) {
        super(p_i225808_1_);
    }

    public boolean func_225557_a_(IWorldGenerationReader world, Random rand, BlockPos position, Set<BlockPos> p_225557_4_, Set<BlockPos> p_225557_5_, MutableBoundingBox boundingBox, TreeFeatureConfig p_225557_7_) {
        int i = rand.nextInt(3) + 5;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= world.getMaxHeight()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < world.getMaxHeight()) {
                            if (TreeEnd.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)blockpos$Mutable.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (TreeEnd.isSoil((IWorldGenerationBaseReader)world, (BlockPos)position.func_177977_b(), (IPlantable)p_225557_7_.getSapling()) && position.func_177956_o() < world.getMaxHeight() - i - 1) {
                this.placeTerracottaCircle((IWorld)world, position.func_177977_b());
                for (int i2 = 0; i2 < i; ++i2) {
                    if (!TreeEnd.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)position.func_177981_b(i2))) continue;
                    this.func_202278_a((IWorldWriter)world, position.func_177981_b(i2), LOG);
                }
                BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
                for (int l1 = position.func_177956_o() - 3 + i; l1 <= position.func_177956_o() + i; ++l1) {
                    int j2 = l1 - (position.func_177956_o() + i);
                    int k2 = 1 - j2 / 2;
                    for (int l2 = position.func_177958_n() - k2; l2 <= position.func_177958_n() + k2; ++l2) {
                        int i3 = l2 - position.func_177958_n();
                        for (int j1 = position.func_177952_p() - k2; j1 <= position.func_177952_p() + k2; ++j1) {
                            int k1 = j1 - position.func_177952_p();
                            if (Math.abs(i3) == k2 && Math.abs(k1) == k2 && (rand.nextInt(2) == 0 || j2 == 0)) continue;
                            blockpos$Mutable.func_181079_c(l2, l1, j1);
                            if (!TreeEnd.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)blockpos$Mutable)) continue;
                            this.func_202278_a((IWorldWriter)world, (BlockPos)blockpos$Mutable, LEAF);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeTerracottaCircle(IWorld world, BlockPos center) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (Math.abs(x) + Math.abs(z) >= 3) continue;
                this.placeTerracottaAt(world, center.func_177982_a(x, 0, z));
            }
        }
    }

    private void placeTerracottaAt(IWorld world, BlockPos pos) {
        for (int level = 2; level >= -3; --level) {
            BlockPos blockpos = pos.func_177981_b(level);
            BlockState iblockstate = world.func_180495_p(blockpos);
            Block block = iblockstate.func_177230_c();
            if (block == Blocks.field_196658_i || block == Blocks.field_150346_d) {
                this.func_202278_a((IWorldWriter)world, blockpos, PURPLE_TERRACOTTA);
                break;
            }
            if (iblockstate.func_185904_a() != Material.field_151579_a && level < 0) break;
        }
    }
}

