/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class TreePodzolTaiga
extends AbstractTreeFeature<TreeFeatureConfig> {
    private static final BlockState TRUNK = Blocks.field_196618_L.func_176223_P();
    private static final BlockState LEAF = (BlockState)Blocks.field_196645_X.func_176223_P().func_206870_a((IProperty)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1));
    private static final BlockState PODZOL = Blocks.field_196661_l.func_176223_P();

    public TreePodzolTaiga(Function<Dynamic<?>, ? extends TreeFeatureConfig> p_i225808_1_) {
        super(p_i225808_1_);
    }

    public boolean func_225557_a_(IWorldGenerationReader worldReader, Random rand, BlockPos position, Set<BlockPos> p_225557_4_, Set<BlockPos> p_225557_5_, MutableBoundingBox boundingBox, TreeFeatureConfig p_225557_7_) {
        IWorld world = (IWorld)worldReader;
        int height = rand.nextInt(6) + 8;
        int bottomOfLeaves = 2 + rand.nextInt(3);
        int leavesRange = height - bottomOfLeaves;
        int l = 3 + rand.nextInt(2);
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            int bounds;
            for (int y = position.func_177956_o(); y <= position.func_177956_o() + 1 + height && flag; ++y) {
                bounds = y - position.func_177956_o() < bottomOfLeaves ? 0 : l;
                BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
                for (int x = position.func_177958_n() - bounds; x <= position.func_177958_n() + bounds && flag; ++x) {
                    for (int z = position.func_177952_p() - bounds; z <= position.func_177952_p() + bounds && flag; ++z) {
                        if (y >= 0 && y < 256) {
                            blockpos$Mutable.func_181079_c(x, y, z);
                            if (TreePodzolTaiga.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)blockpos$Mutable)) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (TreePodzolTaiga.isSoil((IWorldGenerationBaseReader)world, (BlockPos)position.func_177977_b(), (IPlantable)p_225557_7_.getSapling()) && position.func_177956_o() < world.getMaxHeight() - height - 1) {
                if (rand.nextBoolean()) {
                    this.placePodzolCircle(world, position.func_177976_e().func_177978_c());
                }
                if (rand.nextBoolean()) {
                    this.placePodzolCircle(world, position.func_177974_f().func_177978_c());
                }
                if (rand.nextBoolean()) {
                    this.placePodzolCircle(world, position.func_177976_e().func_177968_d());
                }
                if (rand.nextBoolean()) {
                    this.placePodzolCircle(world, position.func_177974_f().func_177968_d());
                }
                this.placePodzolCircle(world, position);
                this.setDirtAt((IWorldGenerationReader)world, position.func_177977_b(), position);
                int randomNum = rand.nextInt(3);
                for (int currentHeight = bottomOfLeaves; currentHeight < height - randomNum; ++currentHeight) {
                    BlockPos upN = position.func_177981_b(currentHeight);
                    if (!TreePodzolTaiga.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)upN)) continue;
                    this.func_202278_a((IWorldWriter)world, upN, TRUNK);
                }
                this.placeTrunkVines(world, p_225557_4_, rand, position, bottomOfLeaves, boundingBox);
                bounds = rand.nextInt(2);
                int j3 = 1;
                int k3 = 0;
                for (int currentHeight = 0; currentHeight <= leavesRange; ++currentHeight) {
                    int y = position.func_177956_o() + height - currentHeight;
                    for (int x = position.func_177958_n() - bounds; x <= position.func_177958_n() + bounds; ++x) {
                        int j2 = x - position.func_177958_n();
                        for (int z = position.func_177952_p() - bounds; z <= position.func_177952_p() + bounds; ++z) {
                            BlockPos blockpos;
                            int l2 = z - position.func_177952_p();
                            if (Math.abs(j2) == bounds && Math.abs(l2) == bounds && bounds > 0 || !TreePodzolTaiga.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)(blockpos = new BlockPos(x, y, z)))) continue;
                            this.func_202278_a((IWorldWriter)world, blockpos, LEAF);
                        }
                    }
                    if (bounds >= j3) {
                        bounds = k3;
                        k3 = 1;
                        if (++j3 <= l) continue;
                        j3 = l;
                        continue;
                    }
                    ++bounds;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void placePodzolCircle(IWorld world, BlockPos center) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                this.placePodzolAt(world, center.func_177982_a(x, 0, z));
            }
        }
    }

    private void placePodzolAt(IWorld world, BlockPos pos) {
        for (int level = 2; level >= -3; --level) {
            BlockPos blockpos = pos.func_177981_b(level);
            BlockState iblockstate = world.func_180495_p(blockpos);
            Block block = iblockstate.func_177230_c();
            if (block == Blocks.field_196658_i || block == Blocks.field_150346_d) {
                this.func_202278_a((IWorldWriter)world, blockpos, PODZOL);
                break;
            }
            if (iblockstate.func_185904_a() != Material.field_151579_a && level < 0) break;
        }
    }

    private void placeTrunkVines(IWorld world, Set<BlockPos> changedBlocks, Random rand, BlockPos position, int bottomLeavesHeight, MutableBoundingBox p_208519_5_) {
        for (int height = 0; height < bottomLeavesHeight; ++height) {
            BlockState iblockstate1 = world.func_180495_p(position.func_177981_b(height));
            if (!iblockstate1.canBeReplacedByLeaves((IWorldReader)world, position.func_177981_b(height))) continue;
            this.func_202278_a((IWorldWriter)world, position.func_177981_b(height), TRUNK);
            int chance = 1 + height;
            if (rand.nextInt(chance) == 0 && world.func_175623_d(position.func_177982_a(-1, height, 0))) {
                this.func_202278_a((IWorldWriter)world, position.func_177982_a(-1, height, 0), (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)VineBlock.field_176278_M, (Comparable)Boolean.valueOf(true)));
            }
            if (rand.nextInt(chance) == 0 && world.func_175623_d(position.func_177982_a(1, height, 0))) {
                this.func_202278_a((IWorldWriter)world, position.func_177982_a(1, height, 0), (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)VineBlock.field_176280_O, (Comparable)Boolean.valueOf(true)));
            }
            if (rand.nextInt(chance) == 0 && world.func_175623_d(position.func_177982_a(0, height, -1))) {
                this.func_202278_a((IWorldWriter)world, position.func_177982_a(0, height, -1), (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)VineBlock.field_176279_N, (Comparable)Boolean.valueOf(true)));
            }
            if (rand.nextInt(chance) != 0 || !world.func_175623_d(position.func_177982_a(0, height, 1))) continue;
            this.func_202278_a((IWorldWriter)world, position.func_177982_a(0, height, 1), (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)VineBlock.field_176273_b, (Comparable)Boolean.valueOf(true)));
        }
    }
}

