/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraftforge.common.Tags;

public class UndergroundPocket
extends Feature<OreFeatureConfig> {
    protected static final Set<Block> CARVABLE_NON_STONE_BLOCKS = ImmutableSet.of((Object)Blocks.field_150346_d, (Object)Blocks.field_196660_k, (Object)Blocks.field_196661_l, (Object)Blocks.field_196658_i, (Object)Blocks.field_150391_bh, (Object)Blocks.field_150355_j, (Object[])new Block[]{Blocks.field_150353_l, Blocks.field_150343_Z, Blocks.field_150351_n, Blocks.field_150377_bs, Blocks.field_150354_m, Blocks.field_150322_A, Blocks.field_196611_F, Blocks.field_180395_cM, Blocks.field_150432_aD, Blocks.field_150405_ch, Blocks.field_196722_fD, Blocks.field_196797_fz, Blocks.field_196719_fA, Blocks.field_196793_fx, Blocks.field_196720_fB, Blocks.field_196789_fv, Blocks.field_196782_fr, Blocks.field_196791_fw, Blocks.field_196780_fq, Blocks.field_196785_ft, Blocks.field_196787_fu, Blocks.field_196778_fp, Blocks.field_196721_fC, Blocks.field_196795_fy, Blocks.field_196783_fs, Blocks.field_196777_fo, Blocks.field_205164_gk, Blocks.field_150435_aG, Blocks.field_150403_cj, Blocks.field_150424_aL});

    public UndergroundPocket(Function<Dynamic<?>, ? extends OreFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkSettings, Random rand, BlockPos position, OreFeatureConfig config) {
        BlockPos.Mutable blockposMutable = new BlockPos.Mutable();
        float angleOfRotation = (float)(Math.PI * (double)rand.nextFloat());
        float sinOfAngle = MathHelper.func_76126_a((float)angleOfRotation);
        float cosOfAngle = MathHelper.func_76134_b((float)angleOfRotation);
        float size = (float)config.field_202443_c * 0.5f;
        int y = (int)(-size) / 3;
        while ((float)y <= size / 3.0f) {
            float percentageOfRadius = 1.0f - (float)y / size * ((float)y / size) * 3.0f;
            float majorRadiusSq = size * percentageOfRadius * (size * percentageOfRadius);
            float minorRadiusSq = size * 0.7f * percentageOfRadius * (size * 0.7f * percentageOfRadius);
            int x = (int)(-size);
            while ((float)x < size) {
                int z = (int)(-size);
                while ((float)z < size) {
                    float majorComp = (float)x * cosOfAngle - (float)z * sinOfAngle;
                    float minorComp = (float)x * sinOfAngle + (float)z * cosOfAngle;
                    float result = majorComp * majorComp / (majorRadiusSq * majorRadiusSq) + minorComp * minorComp / (minorRadiusSq * minorRadiusSq);
                    if (result * 100.0f < 1.0f && (x != 0 || z != 0 || !((float)(y * y) >= size * size))) {
                        blockposMutable.func_181079_c(position.func_177958_n() + x + 8, position.func_177956_o() + y, position.func_177952_p() + z + 8);
                        Block blockToReplace = world.func_180495_p((BlockPos)blockposMutable).func_177230_c();
                        if (UndergroundPocket.func_227249_a_((Block)blockToReplace) || Tags.Blocks.ORES.func_199685_a_((Object)blockToReplace) || CARVABLE_NON_STONE_BLOCKS.contains(blockToReplace)) {
                            world.func_180501_a((BlockPos)blockposMutable, config.field_202444_d, 3);
                        }
                    }
                    ++z;
                }
                ++x;
            }
            ++y;
        }
        return true;
    }
}

