/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.carver;

import com.mojang.datafixers.Dynamic;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.utils.OpenSimplexNoise;
import net.telepathicgrunt.ultraamplified.world.biome.UABiomes;

public class CaveCavityCarver
extends WorldCarver<ProbabilityConfig> {
    private final float[] ledgeWidthArrayYIndex = new float[1024];
    protected static long noiseSeed;
    protected static OpenSimplexNoise noiseGen;
    protected static final BlockState STONE;
    protected static final BlockState LAVA;
    protected static final BlockState WATER;
    protected static final BlockState MAGMA;
    protected static final BlockState OBSIDIAN;
    private static final Map<BlockState, BlockState> canReplaceMap;
    protected BlockState replacementBlock = Blocks.field_150348_b.func_176223_P();
    private static Map<Biome, BlockState> fillerBiomeMap;
    private static Map<Biome, BlockState> lavaFloorBiomeMap;

    public static void setFillerMap() {
        if (fillerBiomeMap == null) {
            fillerBiomeMap = new HashMap<Biome, BlockState>();
            fillerBiomeMap.put(UABiomes.NETHERLAND, Blocks.field_150424_aL.func_176223_P());
            fillerBiomeMap.put(UABiomes.ICED_TERRAIN, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(UABiomes.ICE_SPIKES, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(UABiomes.DEEP_FROZEN_OCEAN, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(UABiomes.FROZEN_OCEAN, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(UABiomes.BARREN_END_FIELD, Blocks.field_150377_bs.func_176223_P());
            fillerBiomeMap.put(UABiomes.END_FIELD, Blocks.field_150377_bs.func_176223_P());
        }
    }

    public static void setLavaFloorMap() {
        if (lavaFloorBiomeMap == null) {
            lavaFloorBiomeMap = new HashMap<Biome, BlockState>();
            lavaFloorBiomeMap.put(UABiomes.ICED_TERRAIN, Blocks.field_150343_Z.func_176223_P());
            lavaFloorBiomeMap.put(UABiomes.ICE_SPIKES, Blocks.field_196814_hQ.func_176223_P());
            lavaFloorBiomeMap.put(UABiomes.RELIC_SNOWY_TAIGA, Blocks.field_196814_hQ.func_176223_P());
            lavaFloorBiomeMap.put(UABiomes.SNOWY_ROCKY_TAIGA, Blocks.field_196814_hQ.func_176223_P());
            lavaFloorBiomeMap.put(UABiomes.SNOWY_TAIGA, Blocks.field_196814_hQ.func_176223_P());
            lavaFloorBiomeMap.put(UABiomes.SNOWY_TUNDRA, Blocks.field_196814_hQ.func_176223_P());
            lavaFloorBiomeMap.put(UABiomes.FROZEN_DESERT, Blocks.field_196814_hQ.func_176223_P());
            lavaFloorBiomeMap.put(UABiomes.DEEP_FROZEN_OCEAN, Blocks.field_196814_hQ.func_176223_P());
            lavaFloorBiomeMap.put(UABiomes.FROZEN_OCEAN, Blocks.field_196814_hQ.func_176223_P());
        }
    }

    public static void setSeed(long seed) {
        if (noiseSeed != seed || noiseGen == null) {
            noiseGen = new OpenSimplexNoise(seed);
            noiseSeed = seed;
        }
    }

    public CaveCavityCarver(Function<Dynamic<?>, ? extends ProbabilityConfig> probabilityConfig, int maximumHeight) {
        super(probabilityConfig, maximumHeight);
    }

    public boolean shouldCarve(Random random, int chunkX, int chunkZ, ProbabilityConfig config) {
        return random.nextFloat() <= (float)UltraAmplified.UAConfig.caveCavitySpawnrate.get().intValue() / 1000.0f;
    }

    public boolean func_225555_a_(IChunk region, Function<BlockPos, Biome> biomeBlockPos, Random random, int seaLevel, int chunkX, int chunkZ, int originalX, int originalZ, BitSet mask, ProbabilityConfig config) {
        int i = (this.func_222704_c() * 2 - 1) * 16;
        double xpos = chunkX * 16 + random.nextInt(16);
        double height = random.nextInt(random.nextInt(2) + 1) + 34;
        double zpos = chunkZ * 16 + random.nextInt(16);
        float xzNoise2 = random.nextFloat() * (float)Math.PI;
        float xzCosNoise = (random.nextFloat() - 0.5f) / 16.0f;
        float widthHeightBase = (random.nextFloat() + random.nextFloat()) / 16.0f;
        this.carveCavity(region, biomeBlockPos, random, seaLevel, originalX, originalZ, xpos, height, zpos, widthHeightBase, xzNoise2, xzCosNoise, 0, i, random.nextDouble() + 20.0, mask);
        return true;
    }

    private void carveCavity(IChunk world, Function<BlockPos, Biome> biomeBlockPos, Random random, int seaLevel, int mainChunkX, int mainChunkZ, double randomBlockX, double randomBlockY, double randomBlockZ, float widthHeightBase, float xzNoise2, float xzCosNoise, int startIteration, int maxIteration, double heightMultiplier, BitSet mask) {
        float ledgeWidth = 1.0f;
        for (int currentHeight = 0; currentHeight <= 70; ++currentHeight) {
            if (currentHeight > 44 && currentHeight < 60) {
                ledgeWidth = 1.0f + random.nextFloat() * 0.3f;
                ledgeWidth = (float)((double)ledgeWidth + Math.max(0.0, Math.pow((float)(currentHeight - 44) * 0.15f, 2.0)));
            } else if (currentHeight == 0 || random.nextInt(3) == 0) {
                ledgeWidth = 1.0f + random.nextFloat() * 0.5f;
            }
            this.ledgeWidthArrayYIndex[currentHeight] = ledgeWidth;
        }
        float f4 = 0.0f;
        float f1 = 0.0f;
        double placementXZBound = 2.0 + (double)(MathHelper.func_76126_a((float)((float)Math.PI / (float)maxIteration)) * widthHeightBase);
        double placementYBound = placementXZBound * heightMultiplier;
        placementXZBound *= 32.0;
        placementYBound *= 2.2;
        xzCosNoise = xzCosNoise * 0.5f + f1 * 0.04f;
        xzNoise2 += f4 * 0.05f;
        f1 *= 0.8f;
        f4 *= 0.5f;
        f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.5f;
        f4 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
        this.carveAtTarget(world, biomeBlockPos, random, mainChunkX, mainChunkZ, randomBlockX, randomBlockY, randomBlockZ, placementXZBound, placementYBound, mask);
    }

    protected boolean carveAtTarget(IChunk world, Function<BlockPos, Biome> biomeBlockPos, Random random, int mainChunkX, int mainChunkZ, double xRange, double yRange, double zRange, double placementXZBound, double placementYBound, BitSet mask) {
        double xPos = mainChunkX * 16 + 8;
        double zPos = mainChunkZ * 16 + 8;
        double multipliedXZBound = placementXZBound * 2.0;
        if (!(xRange < xPos - 16.0 - multipliedXZBound || zRange < zPos - 16.0 - multipliedXZBound || xRange > xPos + 16.0 + multipliedXZBound || zRange > zPos + 16.0 + multipliedXZBound)) {
            int xMin = Math.max(MathHelper.func_76128_c((double)(xRange - placementXZBound)) - mainChunkX * 16 - 1, 0);
            int xMax = Math.min(MathHelper.func_76128_c((double)(xRange + placementXZBound)) - mainChunkX * 16 + 1, 16);
            int yMin = Math.max(MathHelper.func_76128_c((double)(yRange - placementYBound)) - 1, 5);
            int yMax = Math.min(MathHelper.func_76128_c((double)(yRange + placementYBound)) + 1, this.field_222720_l);
            int zMin = Math.max(MathHelper.func_76128_c((double)(zRange - placementXZBound)) - mainChunkZ * 16 - 1, 0);
            int zMax = Math.min(MathHelper.func_76128_c((double)(zRange + placementXZBound)) - mainChunkZ * 16 + 1, 16);
            if (xMin <= xMax && yMin <= yMax && zMin <= zMax) {
                boolean flag = false;
                BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
                BlockPos.Mutable blockpos$Mutableup = new BlockPos.Mutable();
                BlockPos.Mutable blockpos$Mutabledown = new BlockPos.Mutable();
                double stalagmiteDouble = 0.0;
                for (int smallX = xMin; smallX < xMax; ++smallX) {
                    int x = smallX + mainChunkX * 16;
                    double xSquaringModified = ((double)x + 0.5 - xRange) / placementXZBound;
                    for (int smallZ = zMin; smallZ < zMax; ++smallZ) {
                        int z = smallZ + mainChunkZ * 16;
                        double zSquaringModified = ((double)z + 0.5 - zRange) / placementXZBound;
                        double xzSquaredModified = xSquaringModified * xSquaringModified + zSquaringModified * zSquaringModified;
                        if (!(xzSquaredModified < 1.0) || yMax < yMin) continue;
                        blockpos$Mutable.func_181079_c(x, 60, z);
                        Biome biome = biomeBlockPos.apply((BlockPos)blockpos$Mutable);
                        this.replacementBlock = fillerBiomeMap.get(biome);
                        if (this.replacementBlock == null) {
                            this.replacementBlock = STONE;
                        }
                        BlockState secondaryFloorBlockstate = lavaFloorBiomeMap.get(biome);
                        for (int y = yMax; y > yMin; --y) {
                            double ySquaringModified;
                            double yPillarModifier = y;
                            yPillarModifier = y > 30 ? (Math.pow((yPillarModifier - 30.0) * 0.033333, 2.0) * 30.0 - (double)y * 0.016666) * 18.0 : Math.pow(Math.pow(yPillarModifier - 30.0, 2.0) * 0.033333, 2.0) * 2.8;
                            if (yPillarModifier <= 0.0) {
                                yPillarModifier = 1.0E-5;
                            } else if (y < 10) {
                                yPillarModifier -= 50.0;
                            }
                            if (y < 60) {
                                boolean flagPillars;
                                boolean bl = flagPillars = noiseGen.eval((double)x * 0.045 + (double)(x % 16) * 0.002, (double)z * 0.045 + (double)(z % 16) * 0.002, (double)y * 0.015) - yPillarModifier * 0.001 + random.nextDouble() * 0.01 > -0.32;
                                if (!flagPillars) continue;
                                if (y > 32) {
                                    boolean flagStalagmites;
                                    stalagmiteDouble = noiseGen.eval((double)x * 0.25, (double)z * 0.25, (double)y * 0.005) * 15.0 + 480.0 / (double)y;
                                    if (y > 48) {
                                        stalagmiteDouble -= ((double)y - 53.0) / 3.0;
                                    }
                                    boolean bl2 = flagStalagmites = stalagmiteDouble > 4.9;
                                    if (!flagStalagmites) continue;
                                }
                            }
                            if (!(xzSquaredModified * (double)this.ledgeWidthArrayYIndex[y - 1] + (ySquaringModified = ((double)(y - 1) + 0.5 - yRange) / placementYBound) * ySquaringModified / 6.0 + (double)(random.nextFloat() * 0.015f) < 1.0)) continue;
                            blockpos$Mutable.func_181079_c(x, y, z);
                            BlockState currentBlockstate = world.func_180495_p((BlockPos)blockpos$Mutable);
                            blockpos$Mutableup.func_189533_g((Vec3i)blockpos$Mutable).func_189536_c(Direction.UP);
                            blockpos$Mutabledown.func_189533_g((Vec3i)blockpos$Mutable).func_189536_c(Direction.DOWN);
                            BlockState aboveBlockstate = world.func_180495_p((BlockPos)blockpos$Mutableup);
                            if (y >= 60) {
                                if (!currentBlockstate.func_204520_s().func_206888_e()) {
                                    world.func_177436_a((BlockPos)blockpos$Mutable, this.replacementBlock, false);
                                    continue;
                                }
                                if (aboveBlockstate.func_204520_s().func_206888_e()) continue;
                                world.func_177436_a((BlockPos)blockpos$Mutable, this.replacementBlock, false);
                                world.func_177436_a((BlockPos)blockpos$Mutableup, this.replacementBlock, false);
                                world.func_177436_a((BlockPos)blockpos$Mutabledown, this.replacementBlock, false);
                                flag = true;
                                continue;
                            }
                            if (!this.func_222707_a(currentBlockstate, aboveBlockstate) && !canReplaceMap.containsKey(currentBlockstate)) continue;
                            if (y < 11) {
                                currentBlockstate = LAVA;
                                if (secondaryFloorBlockstate != null) {
                                    if (secondaryFloorBlockstate == OBSIDIAN) {
                                        currentBlockstate = MAGMA;
                                    }
                                    if (stalagmiteDouble > 13.5) {
                                        if (y == 10) {
                                            currentBlockstate = secondaryFloorBlockstate;
                                        } else if (y == 9 && random.nextBoolean()) {
                                            currentBlockstate = secondaryFloorBlockstate;
                                        }
                                    }
                                }
                                world.func_177436_a((BlockPos)blockpos$Mutable, currentBlockstate, false);
                            } else {
                                world.func_177436_a((BlockPos)blockpos$Mutable, field_222715_g, false);
                            }
                            flag = true;
                        }
                    }
                }
                return flag;
            }
            return false;
        }
        return false;
    }

    protected boolean func_222708_a(double p_222708_1_, double p_222708_3_, double p_222708_5_, int p_222708_7_) {
        return true;
    }

    static {
        STONE = Blocks.field_150348_b.func_176223_P();
        LAVA = Blocks.field_150353_l.func_176223_P();
        WATER = Blocks.field_150355_j.func_176223_P();
        MAGMA = Blocks.field_196814_hQ.func_176223_P();
        OBSIDIAN = Blocks.field_150343_Z.func_176223_P();
        HashMap<BlockState, BlockState> result = new HashMap<BlockState, BlockState>();
        result.put(Blocks.field_150424_aL.func_176223_P(), Blocks.field_150424_aL.func_176223_P());
        result.put(Blocks.field_150432_aD.func_176223_P(), Blocks.field_150432_aD.func_176223_P());
        result.put(Blocks.field_196604_cC.func_176223_P(), Blocks.field_150432_aD.func_176223_P());
        result.put(Blocks.field_150377_bs.func_176223_P(), Blocks.field_150377_bs.func_176223_P());
        result.put(Blocks.field_150353_l.func_176223_P(), Blocks.field_150353_l.func_176223_P());
        canReplaceMap = result;
    }
}

