/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.placement;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.placement.Placement;
import net.telepathicgrunt.ultraamplified.utils.PlacingUtils;
import net.telepathicgrunt.ultraamplified.world.feature.config.PercentageAndFrequencyConfig;

public class ChanceOnAllLiquidBottoms
extends Placement<PercentageAndFrequencyConfig> {
    protected static final Set<BlockState> UNACCEPTABLE_BLOCKS = ImmutableSet.of((Object)Blocks.field_180397_cI.func_176223_P(), (Object)Blocks.field_196779_gQ.func_176223_P(), (Object)Blocks.field_196781_gR.func_176223_P(), (Object)Blocks.field_180398_cJ.func_176223_P());

    public ChanceOnAllLiquidBottoms(Function<Dynamic<?>, ? extends PercentageAndFrequencyConfig> configFactory) {
        super(configFactory);
    }

    public Stream<BlockPos> getPositions(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, PercentageAndFrequencyConfig pfConfig, BlockPos pos) {
        int lowestHeight = 40;
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(pos);
        block0: for (int i = 0; i < pfConfig.frequency; ++i) {
            blockpos$Mutable.func_181079_c(0, world.getMaxHeight(), 0);
            while (blockpos$Mutable.func_177956_o() > lowestHeight) {
                int x = random.nextInt(16);
                int z = random.nextInt(16);
                blockpos$Mutable.func_181079_c(pos.func_177958_n() + x, blockpos$Mutable.func_177956_o(), pos.func_177952_p() + z);
                int height = PlacingUtils.topOfUnderwaterSurfaceBelowHeight(world, blockpos$Mutable.func_177956_o(), lowestHeight, (BlockPos)blockpos$Mutable);
                blockpos$Mutable.func_189534_c(Direction.DOWN, blockpos$Mutable.func_177956_o() - height);
                if (UNACCEPTABLE_BLOCKS.contains(world.func_180495_p((BlockPos)blockpos$Mutable))) continue;
                if (blockpos$Mutable.func_177956_o() <= lowestHeight) continue block0;
                if (!(random.nextFloat() < pfConfig.percentage)) continue;
                blockPosList.add(blockpos$Mutable.func_177984_a());
            }
        }
        return IntStream.range(0, blockPosList.size()).mapToObj(p_215051_3_ -> (BlockPos)blockPosList.remove(0)).filter(Objects::nonNull);
    }
}

