/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.placement;

import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.placement.Placement;
import net.telepathicgrunt.ultraamplified.utils.PlacingUtils;
import net.telepathicgrunt.ultraamplified.world.feature.config.PercentageAndFrequencyConfig;

public class ChanceOnAllLiquidSurfaces
extends Placement<PercentageAndFrequencyConfig> {
    public ChanceOnAllLiquidSurfaces(Function<Dynamic<?>, ? extends PercentageAndFrequencyConfig> configFactory) {
        super(configFactory);
    }

    public Stream<BlockPos> getPositions(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, PercentageAndFrequencyConfig pfConfig, BlockPos pos) {
        int lowestHeight = 40;
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(pos);
        block0: for (int i = 0; i < pfConfig.frequency; ++i) {
            blockpos$Mutable.func_181079_c(0, world.getMaxHeight(), 0);
            while (blockpos$Mutable.func_177956_o() > lowestHeight) {
                int xOffset = random.nextInt(16);
                int zOffset = random.nextInt(16);
                blockpos$Mutable.func_181079_c(pos.func_177958_n() + xOffset, blockpos$Mutable.func_177956_o(), pos.func_177952_p() + zOffset);
                int height = PlacingUtils.topOfSurfaceBelowHeight(world, blockpos$Mutable.func_177956_o(), lowestHeight, (BlockPos)blockpos$Mutable);
                blockpos$Mutable.func_189534_c(Direction.UP, height - blockpos$Mutable.func_177956_o());
                if (!world.func_180495_p((BlockPos)blockpos$Mutable).func_204520_s().func_206888_e()) continue;
                if (blockpos$Mutable.func_177956_o() <= lowestHeight) continue block0;
                if (!(random.nextFloat() < pfConfig.percentage)) continue;
                blockPosList.add(blockpos$Mutable.func_177984_a());
            }
        }
        return IntStream.range(0, blockPosList.size()).mapToObj(p_215051_3_ -> (BlockPos)blockPosList.remove(0)).filter(Objects::nonNull);
    }
}

