/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.placement;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.placement.Placement;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.feature.config.LakeCountRangeAndTypeConfig;

public class LakePlacement
extends Placement<LakeCountRangeAndTypeConfig> {
    public LakePlacement(Function<Dynamic<?>, ? extends LakeCountRangeAndTypeConfig> configFactory) {
        super(configFactory);
    }

    public Stream<BlockPos> getPositions(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, LakeCountRangeAndTypeConfig lakeConfig, BlockPos pos) {
        int x = random.nextInt(16);
        int z = random.nextInt(16);
        switch (lakeConfig.type) {
            case LAVA_ALGORITHM: {
                int y;
                if (!UltraAmplified.UAConfig.lavaLakeGen.get().booleanValue()) {
                    return Stream.empty();
                }
                if (random.nextInt(lakeConfig.chance / 10) == 0 && ((y = random.nextInt(random.nextInt(chunkGenerator.func_207511_e() - 8) + 8)) < world.func_181545_F() || random.nextInt(lakeConfig.chance / 8) == 0)) {
                    return Stream.of(pos.func_177982_a(x, y, z));
                }
            }
            case ICE_ALGORITHM: {
                int y;
                if (random.nextInt(lakeConfig.chance / 10) == 0 && ((y = random.nextInt(random.nextInt(chunkGenerator.func_207511_e() - 8) + 8)) < world.func_181545_F() || random.nextInt(lakeConfig.chance / 8) == 0)) {
                    return Stream.of(pos.func_177982_a(x, y, z));
                }
            }
            case WATER_ALGORITHM: {
                int y;
                if (!UltraAmplified.UAConfig.waterLakeGen.get().booleanValue()) {
                    return Stream.empty();
                }
                if (random.nextInt(lakeConfig.chance) == 0) {
                    y = random.nextInt(chunkGenerator.func_207511_e());
                    return Stream.of(pos.func_177982_a(x, y, z));
                }
            }
            case SLIME_ALGORITHM: {
                int y;
                if (!UltraAmplified.UAConfig.slimeLakeGen.get().booleanValue()) {
                    return Stream.empty();
                }
                if (random.nextInt(lakeConfig.chance) == 0 && (y = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, pos.func_177958_n() + x, pos.func_177952_p() + z)) > world.func_181545_F() && y <= 170) {
                    return Stream.of(new BlockPos(pos.func_177958_n() + x, y - 2, pos.func_177952_p() + z));
                }
            }
            case HONEY_ALGORITHM: {
                int y;
                if (!UltraAmplified.UAConfig.honeyLakeGen.get().booleanValue()) {
                    return Stream.empty();
                }
                if (random.nextInt(lakeConfig.chance) != 0 || (y = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, pos.func_177958_n() + x, pos.func_177952_p() + z)) <= world.func_181545_F() || y > 170) break;
                return Stream.of(new BlockPos(pos.func_177958_n() + x, y - 2, pos.func_177952_p() + z));
            }
        }
        return Stream.empty();
    }
}

