/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.entity.EntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.feature.UAFeatures;
import net.telepathicgrunt.ultraamplified.world.feature.structure.OceanMonumentPiecesUA;

public class OceanMonumentStructureUA
extends Structure<NoFeatureConfig> {
    private static final List<Biome.SpawnListEntry> MONUMENT_ENEMIES = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry(EntityType.field_200761_A, 1, 2, 4)});

    public OceanMonumentStructureUA(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i51427_1_) {
        super(p_i51427_1_);
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int maxDistance = UltraAmplified.UAConfig.oceanMonumentSpawnrate.get();
        int minDistance = 8;
        if (maxDistance < 9) {
            minDistance = maxDistance - 1;
        }
        int k = x + maxDistance * spacingOffsetsX;
        int l = z + maxDistance * spacingOffsetsZ;
        int i1 = k < 0 ? k - maxDistance + 1 : k;
        int j1 = l < 0 ? l - maxDistance + 1 : l;
        int k1 = i1 / maxDistance;
        int l1 = j1 / maxDistance;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), k1, l1, 10387313);
        k1 *= maxDistance;
        l1 *= maxDistance;
        return new ChunkPos(k1 += (random.nextInt(maxDistance - minDistance) + random.nextInt(maxDistance - minDistance)) / 2, l1 += (random.nextInt(maxDistance - minDistance) + random.nextInt(maxDistance - minDistance)) / 2);
    }

    public boolean func_225558_a_(BiomeManager p_225558_1_, ChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ, Biome biome) {
        ChunkPos chunkpos = this.func_211744_a(chunkGen, rand, chunkPosX, chunkPosZ, 0, 0);
        if (chunkPosX == chunkpos.field_77276_a && chunkPosZ == chunkpos.field_77275_b) {
            for (Biome biome2 : chunkGen.func_202090_b().func_225530_a_(chunkPosX * 16 + 9, chunkGen.func_222530_f(), chunkPosZ * 16 + 9, 32)) {
                if (UltraAmplified.UAConfig.oceanMonumentSpawnrate.get() == 101 || !chunkGen.func_202094_a(biome2, UAFeatures.OCEAN_MONUMENT)) continue;
                return true;
            }
        }
        return false;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return "ultra_amplified_dimension:ocean_monument";
    }

    public int func_202367_b() {
        return 8;
    }

    public List<Biome.SpawnListEntry> func_202279_e() {
        return MONUMENT_ENEMIES;
    }

    public static class Start
    extends StructureStart {
        private boolean wasCreated;

        public Start(Structure<?> p_i225814_1_, int p_i225814_2_, int p_i225814_3_, MutableBoundingBox p_i225814_4_, int p_i225814_5_, long p_i225814_6_) {
            super(p_i225814_1_, p_i225814_2_, p_i225814_3_, p_i225814_4_, p_i225814_5_, p_i225814_6_);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            this.generate(chunkX, chunkZ);
        }

        private void generate(int chunkX, int chunkZ) {
            int i = chunkX * 16 - 29;
            int j = chunkZ * 16 - 29;
            Direction enumfacing = Direction.Plane.HORIZONTAL.func_179518_a((Random)this.field_214631_d);
            this.field_75075_a.add(new OceanMonumentPiecesUA.MonumentBuilding((Random)this.field_214631_d, i, j, enumfacing));
            this.func_202500_a();
            this.wasCreated = true;
        }

        public void func_225565_a_(IWorld world, ChunkGenerator<?> p_225565_2_, Random rand, MutableBoundingBox structurebb, ChunkPos pos) {
            if (!this.wasCreated) {
                this.field_75075_a.clear();
                this.generate(this.func_143019_e(), this.func_143018_f());
            }
            super.func_225565_a_(world, p_225565_2_, rand, structurebb, pos);
        }
    }
}

