/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.entity.EntityType;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.PillagerOutpostPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.feature.UAFeatures;

public class PillagerOutpostStructureUA
extends Structure<NoFeatureConfig> {
    private static final List<Biome.SpawnListEntry> PILLAGER_ENEMIES = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry(EntityType.field_220350_aJ, 1, 1, 1)});

    public PillagerOutpostStructureUA(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i51470_1_) {
        super(p_i51470_1_);
    }

    public String func_143025_a() {
        return "ultra_amplified_dimension:pillager_outpost";
    }

    public int func_202367_b() {
        return 3;
    }

    public List<Biome.SpawnListEntry> func_202279_e() {
        return PILLAGER_ENEMIES;
    }

    public boolean func_225558_a_(BiomeManager p_225558_1_, ChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ, Biome biome) {
        ((SharedSeedRandom)rand).func_202425_c(chunkGen.func_202089_c(), chunkPosX, chunkPosZ);
        if (UltraAmplified.UAConfig.pillageOutpostRarity.get() != 101 && chunkGen.func_202094_a(biome, UAFeatures.PILLAGER_OUTPOST) && (double)rand.nextFloat() < 1.0 / ((double)(UltraAmplified.UAConfig.pillageOutpostRarity.get() - 1) * 4.5 + 1.0)) {
            for (int k = chunkPosX - 3; k <= chunkPosX + 3; ++k) {
                for (int l = chunkPosZ - 3; l <= chunkPosZ + 3; ++l) {
                    if (!UAFeatures.VILLAGE.func_225558_a_(p_225558_1_, chunkGen, rand, k, l, biome)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    protected int getSeedModifier() {
        return 165745296;
    }

    public static class Start
    extends MarginedStructureStart {
        public Start(Structure<?> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            int offsetX = 7;
            int offsetZ = 7;
            int x = (chunkX << 4) + offsetX;
            int z = (chunkZ << 4) + offsetZ;
            int i1 = generator.func_222531_c(x, z, Heightmap.Type.WORLD_SURFACE_WG);
            int j1 = generator.func_222531_c(x, z + 1, Heightmap.Type.WORLD_SURFACE_WG);
            int k1 = generator.func_222531_c(x + 1, z, Heightmap.Type.WORLD_SURFACE_WG);
            int l1 = generator.func_222531_c(x + 1, z + 1, Heightmap.Type.WORLD_SURFACE_WG);
            int y = Math.max(Math.max(i1, j1), Math.max(k1, l1));
            if (y >= 70 && y <= 200) {
                BlockPos blockpos = new BlockPos(chunkX * 16, y, chunkZ * 16);
                PillagerOutpostPieces.func_215139_a(generator, (TemplateManager)templateManagerIn, (BlockPos)blockpos, (List)this.field_75075_a, (SharedSeedRandom)this.field_214631_d);
                this.func_202500_a();
            }
        }
    }
}

