/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.ShipwreckConfig;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTables;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.feature.structure.StructureInitUA;

public class ShipwreckPiecesUA {
    private static final BlockPos STRUCTURE_OFFSET = new BlockPos(4, 0, 15);
    private static final ResourceLocation[] BEACHED_SHIPS = new ResourceLocation[]{new ResourceLocation("shipwreck/with_mast"), new ResourceLocation("shipwreck/sideways_full"), new ResourceLocation("shipwreck/sideways_fronthalf"), new ResourceLocation("shipwreck/sideways_backhalf"), new ResourceLocation("shipwreck/rightsideup_full"), new ResourceLocation("shipwreck/rightsideup_fronthalf"), new ResourceLocation("shipwreck/rightsideup_backhalf"), new ResourceLocation("shipwreck/with_mast_degraded"), new ResourceLocation("shipwreck/rightsideup_full_degraded"), new ResourceLocation("shipwreck/rightsideup_fronthalf_degraded"), new ResourceLocation("shipwreck/rightsideup_backhalf_degraded")};
    private static final ResourceLocation[] NOT_BEACHED_SHIPS = new ResourceLocation[]{new ResourceLocation("shipwreck/with_mast"), new ResourceLocation("shipwreck/upsidedown_full"), new ResourceLocation("shipwreck/upsidedown_fronthalf"), new ResourceLocation("shipwreck/upsidedown_backhalf"), new ResourceLocation("shipwreck/sideways_full"), new ResourceLocation("shipwreck/sideways_fronthalf"), new ResourceLocation("shipwreck/sideways_backhalf"), new ResourceLocation("shipwreck/rightsideup_full"), new ResourceLocation("shipwreck/rightsideup_fronthalf"), new ResourceLocation("shipwreck/rightsideup_backhalf"), new ResourceLocation("shipwreck/with_mast_degraded"), new ResourceLocation("shipwreck/upsidedown_full_degraded"), new ResourceLocation("shipwreck/upsidedown_fronthalf_degraded"), new ResourceLocation("shipwreck/upsidedown_backhalf_degraded"), new ResourceLocation("shipwreck/sideways_full_degraded"), new ResourceLocation("shipwreck/sideways_fronthalf_degraded"), new ResourceLocation("shipwreck/sideways_backhalf_degraded"), new ResourceLocation("shipwreck/rightsideup_full_degraded"), new ResourceLocation("shipwreck/rightsideup_fronthalf_degraded"), new ResourceLocation("shipwreck/rightsideup_backhalf_degraded")};

    public static void beginGeneration(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> piecesList, Random random, ShipwreckConfig config, int height) {
        ResourceLocation resourcelocation = config.field_204753_a ? BEACHED_SHIPS[random.nextInt(BEACHED_SHIPS.length)] : NOT_BEACHED_SHIPS[random.nextInt(NOT_BEACHED_SHIPS.length)];
        piecesList.add((StructurePiece)new Piece(templateManager, resourcelocation, pos, rotation, config.field_204753_a, height));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private Rotation rotation;
        private ResourceLocation resourceLocation;
        private boolean isBeached;
        private int startHeight;

        public Piece(TemplateManager templateManager, ResourceLocation resourceLoc, BlockPos pos, Rotation rot, boolean isBeached, int startHeight) {
            super(StructureInitUA.SHIPWRECKUA, 0);
            this.field_186178_c = pos;
            this.rotation = rot;
            this.resourceLocation = resourceLoc;
            this.isBeached = isBeached;
            this.func_204754_a(templateManager);
            this.startHeight = startHeight;
        }

        public Piece(TemplateManager templateManager, CompoundNBT tagCompound) {
            super(StructureInitUA.SHIPWRECKUA, tagCompound);
            this.resourceLocation = new ResourceLocation(tagCompound.func_74779_i("Template"));
            this.isBeached = tagCompound.func_74767_n("isBeached");
            this.rotation = Rotation.valueOf((String)tagCompound.func_74779_i("Rot"));
            this.func_204754_a(templateManager);
            this.startHeight = tagCompound.func_74762_e("startHeight");
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.resourceLocation.toString());
            tagCompound.func_74757_a("isBeached", this.isBeached);
            tagCompound.func_74778_a("Rot", this.rotation.name());
            tagCompound.func_74768_a("startHeight", this.startHeight);
        }

        private void func_204754_a(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a(STRUCTURE_OFFSET).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld world, Random random, MutableBoundingBox structureBoundingBox) {
            if (UltraAmplified.UAConfig.chestGeneration.get().booleanValue()) {
                if ("map_chest".equals(function)) {
                    LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)random, (BlockPos)pos.func_177977_b(), (ResourceLocation)LootTables.field_204771_s);
                } else if ("treasure_chest".equals(function)) {
                    LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)random, (BlockPos)pos.func_177977_b(), (ResourceLocation)LootTables.field_204773_u);
                } else if ("supply_chest".equals(function)) {
                    LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)random, (BlockPos)pos.func_177977_b(), (ResourceLocation)LootTables.field_204772_t);
                }
            } else if (world.func_180495_p(pos.func_177977_b()).func_204520_s().func_206888_e()) {
                world.func_180501_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 2);
            } else {
                world.func_180501_a(pos.func_177977_b(), Blocks.field_150355_j.func_176223_P(), 2);
            }
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkGen, Random random, MutableBoundingBox structureBoundingBox, ChunkPos chunkPos) {
            BlockPos blockpos;
            BlockPos blockposSize = this.field_186176_a.func_186259_a();
            int k = blockposSize.func_177958_n() * blockposSize.func_177952_p();
            if (k == 0) {
                blockpos = new BlockPos(this.field_186178_c.func_177958_n(), this.startHeight, this.field_186178_c.func_177952_p());
            } else {
                blockpos = this.field_186178_c.func_177982_a(blockposSize.func_177958_n() - 1, 0, blockposSize.func_177952_p() - 1);
                blockpos = new BlockPos(blockpos.func_177958_n(), this.startHeight, blockpos.func_177952_p());
            }
            while (blockpos.func_177956_o() > 65 && world.func_180495_p(blockpos).func_204520_s().func_206888_e()) {
                blockpos = blockpos.func_177977_b();
            }
            while (blockpos.func_177956_o() > 65 && !world.func_180495_p(blockpos).func_204520_s().func_206888_e()) {
                blockpos = blockpos.func_177977_b();
            }
            this.field_186178_c = new BlockPos(this.field_186178_c.func_177958_n(), blockpos.func_177956_o() - 2, this.field_186178_c.func_177952_p());
            return super.func_225577_a_(world, chunkGen, random, structureBoundingBox, chunkPos);
        }
    }
}

