/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.ShipwreckConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.feature.structure.ShipwreckPiecesUA;

public class ShipwreckStructureUA
extends Structure<ShipwreckConfig> {
    public ShipwreckStructureUA(Function<Dynamic<?>, ? extends ShipwreckConfig> p_i51427_1_) {
        super(p_i51427_1_);
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int maxDistance = UltraAmplified.UAConfig.shipwreckSpawnrate.get();
        int minDistance = 8;
        if (maxDistance < 9) {
            minDistance = maxDistance - 1;
        }
        int k = x + maxDistance * spacingOffsetsX;
        int l = z + maxDistance * spacingOffsetsZ;
        int i1 = k < 0 ? k - maxDistance + 1 : k;
        int j1 = l < 0 ? l - maxDistance + 1 : l;
        int k1 = i1 / maxDistance;
        int l1 = j1 / maxDistance;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), k1, l1, this.getSeedModifier());
        k1 *= maxDistance;
        l1 *= maxDistance;
        return new ChunkPos(k1 += random.nextInt(maxDistance - minDistance), l1 += random.nextInt(maxDistance - minDistance));
    }

    public String func_143025_a() {
        return "ultra_amplified_dimension:shipwreck";
    }

    public int func_202367_b() {
        return 3;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    protected int getSeedModifier() {
        return 165745295;
    }

    public boolean func_225558_a_(BiomeManager p_225558_1_, ChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ, Biome biome) {
        ChunkPos chunkpos = this.func_211744_a(chunkGen, rand, chunkPosX, chunkPosZ, 0, 0);
        return chunkPosX == chunkpos.field_77276_a && chunkPosZ == chunkpos.field_77275_b && UltraAmplified.UAConfig.shipwreckSpawnrate.get() != 101 && chunkGen.func_202094_a(biome, (Structure)this);
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            int randHeight = this.field_214631_d.nextInt(130) + 70;
            BlockPos blockpos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
            ShipwreckConfig newShipwreckConfig = new ShipwreckConfig(this.field_214631_d.nextBoolean());
            ShipwreckPiecesUA.beginGeneration(templateManagerIn, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d, newShipwreckConfig, randHeight);
            this.func_202500_a();
        }
    }
}

