/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import com.mojang.datafixers.Dynamic;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.feature.structure.StrongholdPiecesUA;

public class StrongholdStructureUA
extends Structure<NoFeatureConfig> {
    public StrongholdStructureUA(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i51427_1_) {
        super(p_i51427_1_);
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int maxDistance = UltraAmplified.UAConfig.strongholdSpawnrate.get();
        int minDistance = maxDistance - 10;
        if (maxDistance < 12) {
            minDistance = maxDistance - 1;
        }
        int k = x + maxDistance * spacingOffsetsX;
        int l = z + maxDistance * spacingOffsetsZ;
        int i1 = k < 0 ? k - maxDistance + 1 : k;
        int j1 = l < 0 ? l - maxDistance + 1 : l;
        int k1 = i1 / maxDistance;
        int l1 = j1 / maxDistance;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), k1, l1, 143523564);
        k1 *= maxDistance;
        l1 *= maxDistance;
        return new ChunkPos(k1 += random.nextInt(maxDistance - minDistance), l1 += random.nextInt(maxDistance - minDistance));
    }

    public boolean func_225558_a_(BiomeManager p_225558_1_, ChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ, Biome biome) {
        ChunkPos chunkpos = this.func_211744_a(chunkGen, rand, chunkPosX, chunkPosZ, 0, 0);
        return chunkPosX == chunkpos.field_77276_a && chunkPosZ == chunkpos.field_77275_b && UltraAmplified.UAConfig.strongholdSpawnrate.get() != 501 && chunkGen.func_202094_a(biome, (Structure)this);
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return "ultra_amplified_dimension:stronghold";
    }

    public int func_202367_b() {
        return 8;
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            StrongholdPiecesUA.prepareStructurePieces();
            StrongholdPiecesUA.EntranceStairs strongholdpieces$entrancestairs = new StrongholdPiecesUA.EntranceStairs((Random)this.field_214631_d, (chunkX << 4) + 2, (chunkZ << 4) + 2);
            this.field_75075_a.add(strongholdpieces$entrancestairs);
            strongholdpieces$entrancestairs.func_74861_a(strongholdpieces$entrancestairs, this.field_75075_a, (Random)this.field_214631_d);
            List<StructurePiece> list = strongholdpieces$entrancestairs.pendingChildren;
            while (!list.isEmpty()) {
                int i = this.field_214631_d.nextInt(list.size());
                StructurePiece structurepiece = list.remove(i);
                structurepiece.func_74861_a((StructurePiece)strongholdpieces$entrancestairs, this.field_75075_a, (Random)this.field_214631_d);
            }
            if (strongholdpieces$entrancestairs.strongholdPortalRoom == null) {
                MutableBoundingBox box = ((StructurePiece)this.field_75075_a.get(this.field_75075_a.size() - 1)).func_74874_b();
                StrongholdPiecesUA.PortalRoom portalRoom = StrongholdPiecesUA.PortalRoom.createPiece(this.field_75075_a, (Random)this.field_214631_d, box.field_78897_a, box.field_78895_b + 1, box.field_78896_c, Direction.NORTH);
                this.field_75075_a.add(portalRoom);
                strongholdpieces$entrancestairs.pendingChildren.add(portalRoom);
                list = strongholdpieces$entrancestairs.pendingChildren;
                while (!list.isEmpty()) {
                    int i = this.field_214631_d.nextInt(list.size());
                    StructurePiece structurepiece = list.remove(i);
                    structurepiece.func_74861_a((StructurePiece)strongholdpieces$entrancestairs, this.field_75075_a, (Random)this.field_214631_d);
                }
            }
            this.func_202500_a();
            this.func_214626_a((Random)this.field_214631_d, 100, 120);
        }
    }
}

