/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.villager.IVillagerType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.BrewingStandTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTables;
import net.telepathicgrunt.ultraamplified.world.feature.structure.StructureInitUA;
import net.telepathicgrunt.ultraamplified.world.feature.structure.VillageConfigUA;

public class VillagePastStyledPiecesUA {
    private static final IVillagerType[] VILLAGER_TYPE_ENUM = new IVillagerType[]{IVillagerType.field_221175_c, IVillagerType.field_221173_a, IVillagerType.field_221176_d, IVillagerType.field_221179_g, IVillagerType.field_221177_e, IVillagerType.field_221178_f, IVillagerType.field_221174_b, IVillagerType.field_221179_g, IVillagerType.field_221174_b, IVillagerType.field_221179_g, IVillagerType.field_221173_a, IVillagerType.field_221177_e};

    public static List<PieceWeightUA> getStructureVillageWeightedPieceList(Random random, int size) {
        ArrayList list = Lists.newArrayList();
        list.add(new PieceWeightUA(FlatTopTinyHouse.class, 4, MathHelper.func_76136_a((Random)random, (int)(2 + size), (int)(4 + size * 2))));
        list.add(new PieceWeightUA(Church.class, 20, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(1 + size))));
        list.add(new PieceWeightUA(LibraryHouse.class, 20, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(2 + size))));
        list.add(new PieceWeightUA(TinyHouse.class, 3, MathHelper.func_76136_a((Random)random, (int)(2 + size), (int)(5 + size * 3))));
        list.add(new PieceWeightUA(WorkHouse.class, 15, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(2 + size))));
        list.add(new PieceWeightUA(Field1.class, 3, MathHelper.func_76136_a((Random)random, (int)(1 + size), (int)(4 + size))));
        list.add(new PieceWeightUA(Field2.class, 3, MathHelper.func_76136_a((Random)random, (int)(2 + size), (int)(4 + size * 2))));
        list.add(new PieceWeightUA(Blacksmith.class, 15, MathHelper.func_76136_a((Random)random, (int)0, (int)(1 + size))));
        list.add(new PieceWeightUA(LargeHouse.class, 8, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(3 + size * 2))));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (((PieceWeightUA)iterator.next()).villagePiecesLimit != 0) continue;
            iterator.remove();
        }
        return list;
    }

    private static int updatePieceWeight(List<PieceWeightUA> p_75079_0_) {
        boolean flag = false;
        int i = 0;
        for (PieceWeightUA villagepieces$pieceweight : p_75079_0_) {
            if (villagepieces$pieceweight.villagePiecesLimit > 0 && villagepieces$pieceweight.villagePiecesSpawned < villagepieces$pieceweight.villagePiecesLimit) {
                flag = true;
            }
            i += villagepieces$pieceweight.villagePieceWeight;
        }
        return flag ? i : -1;
    }

    private static Village findAndCreateComponentFactory(Start start, PieceWeightUA weight, List<StructurePiece> structureComponents, Random rand, int structureMinX, int structureMinY, int structureMinZ, Direction facing, int componentType) {
        Class<? extends Village> oclass = weight.villagePieceClass;
        Village villagepieces$village = null;
        if (oclass == FlatTopTinyHouse.class) {
            villagepieces$village = FlatTopTinyHouse.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == Church.class) {
            villagepieces$village = Church.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == LibraryHouse.class) {
            villagepieces$village = LibraryHouse.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == TinyHouse.class) {
            villagepieces$village = TinyHouse.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == WorkHouse.class) {
            villagepieces$village = WorkHouse.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == Field1.class) {
            villagepieces$village = Field1.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == Field2.class) {
            villagepieces$village = Field2.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == Blacksmith.class) {
            villagepieces$village = Blacksmith.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == LargeHouse.class) {
            villagepieces$village = LargeHouse.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        }
        return villagepieces$village;
    }

    private static Village generateComponent(Start start, List<StructurePiece> structureComponents, Random rand, int structureMinX, int structureMinY, int structureMinZ, Direction facing, int componentType) {
        int i = VillagePastStyledPiecesUA.updatePieceWeight(start.structureVillageWeightedPieceList);
        if (i <= 0) {
            return null;
        }
        int j = 0;
        block0: while (j < 5) {
            ++j;
            int k = rand.nextInt(i);
            for (PieceWeightUA villagepieces$pieceweight : start.structureVillageWeightedPieceList) {
                if ((k -= villagepieces$pieceweight.villagePieceWeight) >= 0) continue;
                if (!villagepieces$pieceweight.canSpawnMoreVillagePiecesOfType(componentType) || villagepieces$pieceweight == start.lastPlaced && start.structureVillageWeightedPieceList.size() > 1) continue block0;
                Village villagepieces$village = VillagePastStyledPiecesUA.findAndCreateComponentFactory(start, villagepieces$pieceweight, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
                if (villagepieces$village == null) continue;
                ++villagepieces$pieceweight.villagePiecesSpawned;
                start.lastPlaced = villagepieces$pieceweight;
                if (!villagepieces$pieceweight.canSpawnMoreVillagePieces()) {
                    start.structureVillageWeightedPieceList.remove(villagepieces$pieceweight);
                }
                return villagepieces$village;
            }
        }
        MutableBoundingBox mutableboundingbox = Torch.findPieceBox(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing);
        if (mutableboundingbox != null) {
            return new Torch(start, componentType, rand, mutableboundingbox, facing);
        }
        return null;
    }

    private static StructurePiece generateAndAddComponent(Start start, List<StructurePiece> structureComponents, Random rand, int structureMinX, int structureMinY, int structureMinZ, Direction facing, int componentType) {
        if (componentType > 50) {
            return null;
        }
        if (Math.abs(structureMinX - start.func_74874_b().field_78897_a) <= 112 && Math.abs(structureMinZ - start.func_74874_b().field_78896_c) <= 112) {
            Village structurepiece = VillagePastStyledPiecesUA.generateComponent(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType + 1);
            if (structurepiece != null) {
                structureComponents.add(structurepiece);
                start.pendingHouses.add(structurepiece);
                return structurepiece;
            }
            return null;
        }
        return null;
    }

    private static StructurePiece generateAndAddRoadPiece(Start start, List<StructurePiece> p_176069_1_, Random rand, int p_176069_3_, int p_176069_4_, int p_176069_5_, Direction facing, int p_176069_7_) {
        if (p_176069_7_ > 3 + start.terrainType) {
            return null;
        }
        if (Math.abs(p_176069_3_ - start.func_74874_b().field_78897_a) <= 112 && Math.abs(p_176069_5_ - start.func_74874_b().field_78896_c) <= 112) {
            MutableBoundingBox mutableboundingbox = Path.findPieceBox(start, p_176069_1_, rand, p_176069_3_, p_176069_4_, p_176069_5_, facing);
            if (mutableboundingbox != null && mutableboundingbox.field_78895_b > 10) {
                Path structurepiece = new Path(start, p_176069_7_, rand, mutableboundingbox, facing);
                p_176069_1_.add(structurepiece);
                start.pendingRoads.add(structurepiece);
                return structurepiece;
            }
            return null;
        }
        return null;
    }

    public static class TinyHouse
    extends Village {
        private boolean isTallHouse;
        private int tablePosition;

        protected TinyHouse(Start start, int type, Random rand, MutableBoundingBox boundingBoxIn, Direction facing) {
            super(start, StructureInitUA.VISMHUA, type);
            this.func_186164_a(facing);
            this.field_74887_e = boundingBoxIn;
        }

        public TinyHouse(TemplateManager p_i50111_1_, CompoundNBT p_i50111_2_) {
            super(StructureInitUA.VISMHUA, p_i50111_2_);
            this.isTallHouse = p_i50111_2_.func_74767_n("isTallHouse");
            this.tablePosition = p_i50111_2_.func_74762_e("tablePosition");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("isTallHouse", this.isTallHouse);
            tagCompound.func_74768_a("tablePosition", this.tablePosition);
        }

        public static TinyHouse createPiece(Start start, List<StructurePiece> p_175853_1_, Random rand, int p_175853_3_, int p_175853_4_, int p_175853_5_, Direction facing, int p_175853_7_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175853_3_, (int)p_175853_4_, (int)p_175853_5_, (int)0, (int)0, (int)0, (int)4, (int)6, (int)5, (Direction)facing);
            return TinyHouse.canVillageGoDeeper(mutableboundingbox) && StructurePiece.func_74883_a(p_175853_1_, (MutableBoundingBox)mutableboundingbox) == null ? new TinyHouse(start, p_175853_7_, rand, mutableboundingbox, facing) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getBestGroundLevel(world, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            BlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P());
            BlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_196662_n.func_176223_P());
            BlockState iblockstate2 = this.getBiomeSpecificBlockState((BlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.NORTH));
            BlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.field_196617_K.func_176223_P());
            BlockState iblockstate4 = this.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(world, structureBoundingBoxIn, 1, 1, 1, 3, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 0, 0, 3, 0, 4, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 0, 1, 2, 0, 3, Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P(), false);
            if (this.isTallHouse) {
                this.func_175804_a(world, structureBoundingBoxIn, 1, 4, 1, 2, 4, 3, iblockstate3, iblockstate3, false);
            } else {
                this.func_175804_a(world, structureBoundingBoxIn, 1, 5, 1, 2, 5, 3, iblockstate3, iblockstate3, false);
            }
            this.func_175811_a(world, iblockstate3, 1, 4, 0, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate3, 2, 4, 0, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate3, 1, 4, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate3, 2, 4, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate3, 0, 4, 1, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate3, 0, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate3, 0, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate3, 3, 4, 1, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate3, 3, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate3, 3, 4, 3, structureBoundingBoxIn);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 1, 0, 0, 3, 0, iblockstate3, iblockstate3, false);
            this.func_175804_a(world, structureBoundingBoxIn, 3, 1, 0, 3, 3, 0, iblockstate3, iblockstate3, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 1, 4, 0, 3, 4, iblockstate3, iblockstate3, false);
            this.func_175804_a(world, structureBoundingBoxIn, 3, 1, 4, 3, 3, 4, iblockstate3, iblockstate3, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 1, 1, 0, 3, 3, iblockstate1, iblockstate1, false);
            this.func_175804_a(world, structureBoundingBoxIn, 3, 1, 1, 3, 3, 3, iblockstate1, iblockstate1, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 1, 0, 2, 3, 0, iblockstate1, iblockstate1, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 1, 4, 2, 3, 4, iblockstate1, iblockstate1, false);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 3, 2, 2, structureBoundingBoxIn);
            if (this.tablePosition > 0) {
                if (iblockstate.func_196959_b((IProperty)FourWayBlock.field_196413_c)) {
                    this.func_175811_a(world, (BlockState)((BlockState)iblockstate4.func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)(this.tablePosition == 1 ? FourWayBlock.field_196414_y : FourWayBlock.field_196411_b), (Comparable)Boolean.valueOf(true)), this.tablePosition, 1, 3, structureBoundingBoxIn);
                } else {
                    this.func_175811_a(world, iblockstate4, this.tablePosition, 1, 3, structureBoundingBoxIn);
                }
                this.func_175811_a(world, Blocks.field_196663_cq.func_176223_P(), this.tablePosition, 2, 3, structureBoundingBoxIn);
                if (this.tablePosition == 1) {
                    this.func_175811_a(world, (BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.HEAD), 2, 1, 3, structureBoundingBoxIn);
                    this.func_175811_a(world, (BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.FOOT), 2, 1, 2, structureBoundingBoxIn);
                } else {
                    this.func_175811_a(world, (BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.HEAD), 1, 1, 3, structureBoundingBoxIn);
                    this.func_175811_a(world, (BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.FOOT), 1, 1, 2, structureBoundingBoxIn);
                }
            } else {
                this.func_175811_a(world, (BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.HEAD), 1, 1, 3, structureBoundingBoxIn);
                this.func_175811_a(world, (BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.FOOT), 1, 1, 2, structureBoundingBoxIn);
            }
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 1, 2, 0, structureBoundingBoxIn);
            this.createVillageDoor(world, structureBoundingBoxIn, random, 1, 1, 0, Direction.NORTH);
            if (this.func_175807_a((IBlockReader)world, 1, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a((IBlockReader)world, 1, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(world, iblockstate2, 1, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a((IBlockReader)world, 1, -1, -1, structureBoundingBoxIn).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(world, Blocks.field_196658_i.func_176223_P(), 1, -1, -1, structureBoundingBoxIn);
                }
            }
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.clearCurrentPositionBlocksUpwards(world, j, 6, i, structureBoundingBoxIn);
                    this.func_175808_b(world, iblockstate, j, -1, i, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(world, structureBoundingBoxIn, 1, 1, 2, 1, random);
            return true;
        }
    }

    public static class Well
    extends Village {
        protected Well(IStructurePieceType p_i50287_1_, CompoundNBT p_i50287_2_) {
            super(p_i50287_1_, p_i50287_2_);
        }

        public Well(Start start, int type, Random rand, int x, int z) {
            super(start, StructureInitUA.VIWUA, 0);
            this.func_186164_a(Direction.Plane.HORIZONTAL.func_179518_a(rand));
            this.field_74887_e = this.func_186165_e().func_176740_k() == Direction.Axis.Z ? new MutableBoundingBox(x, 64, z, x + 6 - 1, 78, z + 6 - 1) : new MutableBoundingBox(x, 64, z, x + 6 - 1, 78, z + 6 - 1);
        }

        public Well(TemplateManager p_i50665_1_, CompoundNBT p_i50665_2_) {
            super(StructureInitUA.VIWUA, p_i50665_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            VillagePastStyledPiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, Direction.WEST, this.func_74877_c());
            VillagePastStyledPiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, Direction.EAST, this.func_74877_c());
            VillagePastStyledPiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c - 1, Direction.NORTH, this.func_74877_c());
            VillagePastStyledPiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, this.func_74877_c());
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getBestGroundLevel(world, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 3, 0);
            }
            BlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P());
            BlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176223_P());
            this.func_175804_a(world, structureBoundingBoxIn, 1, 0, 1, 4, 12, 4, iblockstate, Blocks.field_150355_j.func_176223_P(), false);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 2, 12, 2, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 3, 12, 2, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 2, 12, 3, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 3, 12, 3, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate1, 1, 13, 1, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate1, 1, 14, 1, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate1, 4, 13, 1, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate1, 4, 14, 1, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate1, 1, 13, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate1, 1, 14, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate1, 4, 13, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate1, 4, 14, 4, structureBoundingBoxIn);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 15, 1, 4, 15, 4, iblockstate, iblockstate, false);
            this.func_175811_a(world, Blocks.field_222431_lT.func_176223_P(), 2, 13, 1, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_222422_lK.func_176223_P(), 4, 13, 3, structureBoundingBoxIn);
            for (int i = 0; i <= 5; ++i) {
                for (int j = 0; j <= 5; ++j) {
                    if (j != 0 && j != 5 && i != 0 && i != 5) continue;
                    this.func_175811_a(world, iblockstate, j, 11, i, structureBoundingBoxIn);
                    this.clearCurrentPositionBlocksUpwards(world, j, 12, i, structureBoundingBoxIn);
                }
            }
            return true;
        }
    }

    public static abstract class Village
    extends StructurePiece {
        protected int averageGroundLvl = -1;
        private int villagersSpawned;
        protected Type structureType;
        protected boolean isZombieInfested;

        protected Village(Start start, IStructurePieceType struct, int type) {
            super(struct, type);
            if (start != null) {
                this.structureType = start.structureType;
                this.isZombieInfested = start.isZombieInfested;
            }
        }

        public Village(IStructurePieceType p_i50111_1_, CompoundNBT p_i50111_2_) {
            super(p_i50111_1_, p_i50111_2_);
            this.structureType = Type.valueOf(p_i50111_2_.func_74779_i("Type"));
            this.isZombieInfested = p_i50111_2_.func_74767_n("Zombie");
            this.villagersSpawned = p_i50111_2_.func_74762_e("VCount");
            this.averageGroundLvl = p_i50111_2_.func_74762_e("HPos");
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            tagCompound.func_74778_a("Type", this.structureType.name());
            tagCompound.func_74757_a("Zombie", this.isZombieInfested);
            tagCompound.func_74768_a("VCount", this.villagersSpawned);
            tagCompound.func_74768_a("HPos", this.averageGroundLvl);
        }

        @Nullable
        protected StructurePiece getNextComponentNN(Start start, List<StructurePiece> structureComponents, Random rand, int p_74891_4_, int p_74891_5_) {
            Direction enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        return VillagePastStyledPiecesUA.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c + p_74891_5_, Direction.WEST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return VillagePastStyledPiecesUA.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c + p_74891_5_, Direction.WEST, this.func_74877_c());
                    }
                    case WEST: {
                        return VillagePastStyledPiecesUA.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74891_5_, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c - 1, Direction.NORTH, this.func_74877_c());
                    }
                    case EAST: 
                }
                return VillagePastStyledPiecesUA.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74891_5_, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c - 1, Direction.NORTH, this.func_74877_c());
            }
            return null;
        }

        @Nullable
        protected StructurePiece getNextComponentPP(Start start, List<StructurePiece> structureComponents, Random rand, int p_74894_4_, int p_74894_5_) {
            Direction enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        return VillagePastStyledPiecesUA.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78896_c + p_74894_5_, Direction.EAST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return VillagePastStyledPiecesUA.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78896_c + p_74894_5_, Direction.EAST, this.func_74877_c());
                    }
                    case WEST: {
                        return VillagePastStyledPiecesUA.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74894_5_, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, this.func_74877_c());
                    }
                    case EAST: 
                }
                return VillagePastStyledPiecesUA.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74894_5_, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, this.func_74877_c());
            }
            return null;
        }

        protected int getBestGroundLevel(IWorld world, MutableBoundingBox structurebb) {
            BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
            int halfXWidth = this.field_74887_e.func_78883_b();
            int halfZWidth = this.field_74887_e.func_78880_d();
            int x = this.field_74887_e.field_78897_a;
            int z = this.field_74887_e.field_78896_c;
            int[] heightArray = new int[halfXWidth * halfZWidth];
            for (int j = 0; j < this.field_74887_e.func_78883_b(); ++j) {
                for (int k = 0; k < this.field_74887_e.func_78880_d(); ++k) {
                    blockpos$Mutable.func_181079_c(x + j, this.field_74887_e.field_78895_b, z + k);
                    if (!structurebb.func_175898_b((Vec3i)blockpos$Mutable)) continue;
                    heightArray[k + j * this.field_74887_e.func_78880_d()] = world.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, (BlockPos)blockpos$Mutable).func_177956_o();
                }
            }
            int bestHeight = this.findPopular(heightArray);
            if (bestHeight > 243) {
                bestHeight = 243;
            }
            return bestHeight;
        }

        protected void clearCurrentPositionBlocksUpwards(IWorld world, int x, int y, int z, MutableBoundingBox structurebb) {
            BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            if (structurebb.func_175898_b((Vec3i)blockpos)) {
                while (!world.func_175623_d(blockpos) && blockpos.func_177956_o() < 255) {
                    world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 2);
                    blockpos = blockpos.func_177984_a();
                }
            }
        }

        public int findPopular(int[] heightArray) {
            if (heightArray == null || heightArray.length == 0) {
                return -1;
            }
            Arrays.sort(heightArray);
            int previous = heightArray[0];
            int popular = heightArray[0];
            int count = 1;
            int maxCount = 1;
            for (int i = 1; i < heightArray.length; ++i) {
                if (heightArray[i] == 0) continue;
                if (heightArray[i] == previous) {
                    ++count;
                    continue;
                }
                if (count > maxCount) {
                    popular = heightArray[i - 1];
                    maxCount = count;
                }
                previous = heightArray[i];
                count = 1;
            }
            return count > maxCount ? heightArray[heightArray.length - 1] : popular;
        }

        protected static boolean canVillageGoDeeper(MutableBoundingBox structurebb) {
            return structurebb != null && structurebb.field_78895_b > 10;
        }

        protected void spawnVillagers(IWorld world, MutableBoundingBox structurebb, int x, int y, int z, int count, Random random) {
            if (this.villagersSpawned < count) {
                int l;
                int k;
                int j;
                for (int i = this.villagersSpawned; i < count && structurebb.func_175898_b((Vec3i)new BlockPos(j = this.func_74865_a(x + i, z), k = this.func_74862_a(y), l = this.func_74873_b(x + i, z))); ++i) {
                    ++this.villagersSpawned;
                    if (this.isZombieInfested) {
                        ZombieVillagerEntity entityzombievillager = (ZombieVillagerEntity)EntityType.field_200727_aF.func_200721_a(world.func_201672_e());
                        entityzombievillager.func_70012_b((double)j + 0.5, (double)k, (double)l + 0.5, 0.0f, 0.0f);
                        entityzombievillager.func_213386_a(world, world.func_175649_E(new BlockPos((Entity)entityzombievillager)), SpawnReason.STRUCTURE, (ILivingEntityData)null, (CompoundNBT)null);
                        entityzombievillager.func_110163_bv();
                        world.func_217376_c((Entity)entityzombievillager);
                        continue;
                    }
                    VillagerEntity entityvillager = (VillagerEntity)EntityType.field_200756_av.func_200721_a(world.func_201672_e());
                    entityvillager.func_70012_b((double)j + 0.5, (double)k, (double)l + 0.5, 0.0f, 0.0f);
                    entityvillager.func_213386_a(world, world.func_175649_E(new BlockPos((Entity)entityvillager)), SpawnReason.STRUCTURE, (ILivingEntityData)null, (CompoundNBT)null);
                    entityvillager.func_213753_a(new VillagerData(VILLAGER_TYPE_ENUM[this.structureType.ordinal()], VillagerProfession.field_221151_a, 1));
                    world.func_217376_c((Entity)entityvillager);
                }
            }
        }

        protected BlockState getBiomeSpecificBlockState(BlockState blockstateIn) {
            Block block = blockstateIn.func_177230_c();
            if (this.structureType == Type.SANDSTONE) {
                if (block.func_203417_a(BlockTags.field_200031_h) || block == Blocks.field_150347_e) {
                    return Blocks.field_150322_A.func_176223_P();
                }
                if (block.func_203417_a(BlockTags.field_199898_b)) {
                    return Blocks.field_196585_ak.func_176223_P();
                }
                if (block == Blocks.field_150476_ad) {
                    return (BlockState)Blocks.field_150372_bz.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, blockstateIn.func_177229_b((IProperty)StairsBlock.field_176309_a));
                }
                if (block == Blocks.field_196659_cl) {
                    return (BlockState)Blocks.field_150372_bz.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, blockstateIn.func_177229_b((IProperty)StairsBlock.field_176309_a));
                }
                if (block == Blocks.field_150351_n) {
                    return Blocks.field_150322_A.func_176223_P();
                }
                if (block == Blocks.field_196663_cq) {
                    return Blocks.field_196667_cs.func_176223_P();
                }
            } else if (this.structureType == Type.SPRUCE) {
                if (block.func_203417_a(BlockTags.field_200031_h)) {
                    return (BlockState)Blocks.field_196618_L.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, blockstateIn.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M));
                }
                if (block.func_203417_a(BlockTags.field_199898_b)) {
                    return Blocks.field_196664_o.func_176223_P();
                }
                if (block == Blocks.field_150476_ad) {
                    return (BlockState)Blocks.field_150485_bF.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, blockstateIn.func_177229_b((IProperty)StairsBlock.field_176309_a));
                }
                if (block == Blocks.field_180407_aO) {
                    return Blocks.field_180408_aP.func_176223_P();
                }
                if (block == Blocks.field_196663_cq) {
                    return Blocks.field_196665_cr.func_176223_P();
                }
            } else if (this.structureType == Type.ACACIA) {
                if (block.func_203417_a(BlockTags.field_200031_h)) {
                    return (BlockState)Blocks.field_196621_O.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, blockstateIn.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M));
                }
                if (block.func_203417_a(BlockTags.field_199898_b)) {
                    return Blocks.field_196670_r.func_176223_P();
                }
                if (block == Blocks.field_150476_ad) {
                    return (BlockState)Blocks.field_150400_ck.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, blockstateIn.func_177229_b((IProperty)StairsBlock.field_176309_a));
                }
                if (block == Blocks.field_150347_e) {
                    return (BlockState)Blocks.field_196621_O.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y);
                }
                if (block == Blocks.field_180407_aO) {
                    return Blocks.field_180405_aT.func_176223_P();
                }
                if (block == Blocks.field_196663_cq) {
                    return Blocks.field_196671_cu.func_176223_P();
                }
            }
            if (this.structureType == Type.DARK) {
                if (block.func_203417_a(BlockTags.field_200031_h)) {
                    return Blocks.field_196623_P.func_176223_P();
                }
                if (block.func_203417_a(BlockTags.field_199898_b)) {
                    return Blocks.field_196672_s.func_176223_P();
                }
                if (block == Blocks.field_150476_ad) {
                    return (BlockState)Blocks.field_150401_cl.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, blockstateIn.func_177229_b((IProperty)StairsBlock.field_176309_a));
                }
                if (block == Blocks.field_196659_cl) {
                    return (BlockState)Blocks.field_150401_cl.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, blockstateIn.func_177229_b((IProperty)StairsBlock.field_176309_a));
                }
                if (block == Blocks.field_180407_aO) {
                    return Blocks.field_180406_aS.func_176223_P();
                }
                if (block == Blocks.field_150463_bK) {
                    return Blocks.field_180406_aS.func_176223_P();
                }
                if (block == Blocks.field_150351_n) {
                    return Blocks.field_196660_k.func_176223_P();
                }
                if (block == Blocks.field_196663_cq) {
                    return Blocks.field_196673_cv.func_176223_P();
                }
                if (block == Blocks.field_150347_e) {
                    return Blocks.field_196660_k.func_176223_P();
                }
            } else if (this.structureType == Type.JUNGLE) {
                if (block.func_203417_a(BlockTags.field_200031_h)) {
                    return (BlockState)Blocks.field_196620_N.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, blockstateIn.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M));
                }
                if (block.func_203417_a(BlockTags.field_199898_b)) {
                    return Blocks.field_196668_q.func_176223_P();
                }
                if (block == Blocks.field_150476_ad) {
                    return (BlockState)Blocks.field_150481_bH.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, blockstateIn.func_177229_b((IProperty)StairsBlock.field_176309_a));
                }
                if (block == Blocks.field_180407_aO) {
                    return Blocks.field_180403_aR.func_176223_P();
                }
                if (block == Blocks.field_150463_bK) {
                    return Blocks.field_180403_aR.func_176223_P();
                }
                if (block == Blocks.field_196663_cq) {
                    return Blocks.field_196669_ct.func_176223_P();
                }
                if (block == Blocks.field_150347_e) {
                    return Blocks.field_196698_dj.func_176223_P();
                }
            } else if (this.structureType == Type.STONE) {
                if (block.func_203417_a(BlockTags.field_200031_h)) {
                    return Blocks.field_150348_b.func_176223_P();
                }
                if (block.func_203417_a(BlockTags.field_199898_b)) {
                    return Blocks.field_196656_g.func_176223_P();
                }
                if (block == Blocks.field_150476_ad) {
                    return Blocks.field_150333_U.func_176223_P();
                }
                if (block == Blocks.field_150347_e) {
                    return Blocks.field_150348_b.func_176223_P();
                }
                if (block == Blocks.field_150346_d) {
                    return Blocks.field_150348_b.func_176223_P();
                }
                if (block == Blocks.field_180407_aO) {
                    return Blocks.field_196656_g.func_176223_P();
                }
                if (block == Blocks.field_196663_cq) {
                    return Blocks.field_150456_au.func_176223_P();
                }
                if (block == Blocks.field_150351_n) {
                    return Blocks.field_196656_g.func_176223_P();
                }
                if (block == Blocks.field_196698_dj) {
                    return Blocks.field_196700_dk.func_176223_P();
                }
            } else if (this.structureType == Type.END) {
                if (block.func_203417_a(BlockTags.field_200031_h)) {
                    return Blocks.field_185767_cT.func_176223_P();
                }
                if (block.func_203417_a(BlockTags.field_199898_b)) {
                    return Blocks.field_196806_hJ.func_176223_P();
                }
                if (block == Blocks.field_150476_ad) {
                    return (BlockState)Blocks.field_185769_cV.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, blockstateIn.func_177229_b((IProperty)StairsBlock.field_176309_a));
                }
                if (block == Blocks.field_196659_cl) {
                    return (BlockState)Blocks.field_185769_cV.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, blockstateIn.func_177229_b((IProperty)StairsBlock.field_176309_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_196591_bQ) {
                    return (BlockState)Blocks.field_185764_cQ.func_176223_P().func_206870_a((IProperty)DirectionalBlock.field_176387_N, blockstateIn.func_177229_b((IProperty)WallTorchBlock.field_196532_a));
                }
                if (block == Blocks.field_150478_aa) {
                    return (BlockState)Blocks.field_185764_cQ.func_176223_P().func_206870_a((IProperty)DirectionalBlock.field_176387_N, (Comparable)Direction.UP);
                }
                if (block == Blocks.field_150347_e || block == Blocks.field_185774_da) {
                    return Blocks.field_185767_cT.func_176223_P();
                }
                if (block == Blocks.field_150346_d) {
                    return (BlockState)Blocks.field_185768_cU.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y);
                }
                if (block == Blocks.field_180407_aO) {
                    return Blocks.field_185767_cT.func_176223_P();
                }
                if (block == Blocks.field_150463_bK) {
                    return Blocks.field_196806_hJ.func_176223_P();
                }
                if (block == Blocks.field_196663_cq) {
                    return Blocks.field_185771_cX.func_176223_P();
                }
                if (block == Blocks.field_150351_n) {
                    return Blocks.field_185768_cU.func_176223_P();
                }
                if (block == Blocks.field_196698_dj) {
                    return Blocks.field_196806_hJ.func_176223_P();
                }
            } else if (this.structureType == Type.HELL) {
                if (block.func_203417_a(BlockTags.field_200031_h)) {
                    return Blocks.field_196653_dH.func_176223_P();
                }
                if (block.func_203417_a(BlockTags.field_199898_b)) {
                    return Blocks.field_196653_dH.func_176223_P();
                }
                if (block == Blocks.field_150476_ad) {
                    return (BlockState)Blocks.field_150387_bl.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, blockstateIn.func_177229_b((IProperty)StairsBlock.field_176309_a));
                }
                if (block == Blocks.field_196659_cl) {
                    return (BlockState)Blocks.field_150387_bl.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, blockstateIn.func_177229_b((IProperty)StairsBlock.field_176309_a));
                }
                if (block == Blocks.field_150347_e) {
                    return Blocks.field_196653_dH.func_176223_P();
                }
                if (block == Blocks.field_150346_d) {
                    return Blocks.field_150425_aM.func_176223_P();
                }
                if (block == Blocks.field_180407_aO) {
                    return Blocks.field_150386_bk.func_176223_P();
                }
                if (block == Blocks.field_150463_bK) {
                    return Blocks.field_150386_bk.func_176223_P();
                }
                if (block == Blocks.field_196663_cq) {
                    return Blocks.field_196575_bC.func_176223_P();
                }
                if (block == Blocks.field_196602_ba) {
                    return Blocks.field_150426_aN.func_176223_P();
                }
                if (block == Blocks.field_196591_bQ) {
                    return (BlockState)Blocks.field_196677_cy.func_176223_P().func_206870_a((IProperty)WallTorchBlock.field_196532_a, blockstateIn.func_177229_b((IProperty)WallTorchBlock.field_196532_a));
                }
                if (block == Blocks.field_150478_aa) {
                    return Blocks.field_150429_aA.func_176223_P();
                }
                if (block == Blocks.field_196698_dj) {
                    return Blocks.field_196722_fD.func_176223_P();
                }
            } else if (this.structureType == Type.BADLANDS) {
                if (block.func_203417_a(BlockTags.field_200031_h)) {
                    return Blocks.field_196721_fC.func_176223_P();
                }
                if (block.func_203417_a(BlockTags.field_199898_b)) {
                    return Blocks.field_196721_fC.func_176223_P();
                }
                if (block == Blocks.field_150476_ad) {
                    return (BlockState)Blocks.field_180396_cN.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, blockstateIn.func_177229_b((IProperty)StairsBlock.field_176309_a));
                }
                if (block == Blocks.field_196659_cl) {
                    return (BlockState)Blocks.field_180396_cN.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, blockstateIn.func_177229_b((IProperty)StairsBlock.field_176309_a));
                }
                if (block == Blocks.field_150347_e) {
                    return Blocks.field_196798_hA.func_176223_P();
                }
                if (block == Blocks.field_150346_d) {
                    return Blocks.field_196611_F.func_176223_P();
                }
                if (block == Blocks.field_180407_aO) {
                    return Blocks.field_180406_aS.func_176223_P();
                }
                if (block == Blocks.field_150463_bK) {
                    return Blocks.field_180406_aS.func_176223_P();
                }
                if (block == Blocks.field_196663_cq) {
                    return Blocks.field_196673_cv.func_176223_P();
                }
                if (block == Blocks.field_150351_n) {
                    return Blocks.field_180395_cM.func_176223_P();
                }
                if (block == Blocks.field_196698_dj) {
                    return Blocks.field_196798_hA.func_176223_P();
                }
            } else if (this.structureType == Type.ICY) {
                if (block.func_203417_a(BlockTags.field_200031_h)) {
                    return Blocks.field_196604_cC.func_176223_P();
                }
                if (block.func_203417_a(BlockTags.field_199898_b)) {
                    return Blocks.field_196604_cC.func_176223_P();
                }
                if (block == Blocks.field_150476_ad) {
                    return Blocks.field_150403_cj.func_176223_P();
                }
                if (block == Blocks.field_196659_cl) {
                    return Blocks.field_150403_cj.func_176223_P();
                }
                if (block == Blocks.field_150347_e) {
                    return Blocks.field_150432_aD.func_176223_P();
                }
                if (block == Blocks.field_150346_d) {
                    return Blocks.field_150432_aD.func_176223_P();
                }
                if (block == Blocks.field_180407_aO) {
                    return Blocks.field_150403_cj.func_176223_P();
                }
                if (block == Blocks.field_150463_bK) {
                    return Blocks.field_150403_cj.func_176223_P();
                }
                if (block == Blocks.field_196663_cq) {
                    return Blocks.field_150433_aE.func_176223_P();
                }
                if (block == Blocks.field_150351_n) {
                    return Blocks.field_150432_aD.func_176223_P();
                }
                if (block == Blocks.field_196591_bQ) {
                    return (BlockState)Blocks.field_196677_cy.func_176223_P().func_206870_a((IProperty)WallTorchBlock.field_196532_a, blockstateIn.func_177229_b((IProperty)WallTorchBlock.field_196532_a));
                }
                if (block == Blocks.field_150478_aa) {
                    return Blocks.field_150429_aA.func_176223_P();
                }
                if (block == Blocks.field_196698_dj) {
                    return Blocks.field_205164_gk.func_176223_P();
                }
                if (block == Blocks.field_150353_l) {
                    return Blocks.field_196866_iV.func_176223_P();
                }
            }
            return blockstateIn;
        }

        protected DoorBlock biomeDoor() {
            if (this.structureType == Type.DARK) {
                return (DoorBlock)Blocks.field_180409_at;
            }
            if (this.structureType == Type.END) {
                return (DoorBlock)Blocks.field_180412_aq;
            }
            if (this.structureType == Type.HELL) {
                return (DoorBlock)Blocks.field_180409_at;
            }
            if (this.structureType == Type.JUNGLE) {
                return (DoorBlock)Blocks.field_180411_ar;
            }
            if (this.structureType == Type.BADLANDS) {
                return (DoorBlock)Blocks.field_180410_as;
            }
            if (this.structureType == Type.ICY) {
                return (DoorBlock)Blocks.field_180412_aq;
            }
            if (this.structureType == Type.STONE) {
                return (DoorBlock)Blocks.field_180414_ap;
            }
            return (DoorBlock)Blocks.field_180413_ao;
        }

        protected void generateDoor(IWorld world, MutableBoundingBox sbb, Random rand, int x, int y, int z, Direction facing, DoorBlock door) {
            this.func_175811_a(world, (BlockState)door.func_176223_P().func_206870_a((IProperty)DoorBlock.field_176520_a, (Comparable)facing), x, y, z, sbb);
            this.func_175811_a(world, (BlockState)((BlockState)door.func_176223_P().func_206870_a((IProperty)DoorBlock.field_176520_a, (Comparable)facing)).func_206870_a((IProperty)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER), x, y + 1, z, sbb);
        }

        protected void createVillageDoor(IWorld p_189927_1_, MutableBoundingBox p_189927_2_, Random p_189927_3_, int p_189927_4_, int p_189927_5_, int p_189927_6_, Direction p_189927_7_) {
            if (!this.isZombieInfested) {
                this.generateDoor(p_189927_1_, p_189927_2_, p_189927_3_, p_189927_4_, p_189927_5_, p_189927_6_, Direction.NORTH, this.biomeDoor());
            }
        }

        protected void placeTorch(IWorld p_189926_1_, Direction p_189926_2_, int p_189926_3_, int p_189926_4_, int p_189926_5_, MutableBoundingBox p_189926_6_) {
            if (!this.isZombieInfested) {
                this.func_175811_a(p_189926_1_, this.getBiomeSpecificBlockState((BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)p_189926_2_)), p_189926_3_, p_189926_4_, p_189926_5_, p_189926_6_);
            }
        }

        protected void func_175808_b(IWorld world, BlockState blockstateIn, int x, int y, int z, MutableBoundingBox boundingboxIn) {
            BlockState iblockstate = this.getBiomeSpecificBlockState(blockstateIn);
            super.func_175808_b(world, iblockstate, x, y, z, boundingboxIn);
        }

        protected void func_202579_a(Type p_202579_1_) {
            this.structureType = p_202579_1_;
        }
    }

    public static enum Type {
        OAK(1),
        SANDSTONE(2),
        ACACIA(3),
        SPRUCE(4),
        SNOWYSPRUCE(5),
        DARK(5),
        JUNGLE(6),
        STONE(7),
        END(8),
        HELL(9),
        BADLANDS(10),
        ICY(11);

        private final int field_202605_e;

        private Type(int p_i48768_3_) {
            this.field_202605_e = p_i48768_3_;
        }

        public int func_202604_a() {
            return this.field_202605_e;
        }

        public static Type typeById(int p_202603_0_) {
            Type[] avillagepieces$type = Type.values();
            return p_202603_0_ >= 0 && p_202603_0_ < avillagepieces$type.length ? avillagepieces$type[p_202603_0_] : DARK;
        }
    }

    public static class Torch
    extends Village {
        protected Torch(Start start, int type, Random rand, MutableBoundingBox boundingBoxIn, Direction facing) {
            super(start, StructureInitUA.VILUA, type);
            this.func_186164_a(facing);
            this.field_74887_e = boundingBoxIn;
        }

        public Torch(TemplateManager p_i50111_1_, CompoundNBT p_i50111_2_) {
            super(StructureInitUA.VILUA, p_i50111_2_);
        }

        public static MutableBoundingBox findPieceBox(Start start, List<StructurePiece> p_175856_1_, Random rand, int p_175856_3_, int p_175856_4_, int p_175856_5_, Direction facing) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175856_3_, (int)p_175856_4_, (int)p_175856_5_, (int)0, (int)0, (int)0, (int)3, (int)4, (int)2, (Direction)facing);
            return StructurePiece.func_74883_a(p_175856_1_, (MutableBoundingBox)mutableboundingbox) != null ? null : mutableboundingbox;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getBestGroundLevel(world, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            BlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(world, structureBoundingBoxIn, 0, 0, 0, 2, 3, 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(world, iblockstate, 1, 0, 0, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 1, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBiomeSpecificBlockState(Blocks.field_196602_ba.func_176223_P()), 1, 3, 0, structureBoundingBoxIn);
            this.placeTorch(world, Direction.EAST, 2, 3, 0, structureBoundingBoxIn);
            this.placeTorch(world, Direction.NORTH, 1, 3, 1, structureBoundingBoxIn);
            this.placeTorch(world, Direction.WEST, 0, 3, 0, structureBoundingBoxIn);
            this.placeTorch(world, Direction.SOUTH, 1, 3, -1, structureBoundingBoxIn);
            return true;
        }
    }

    public static class Start
    extends Well {
        public int terrainType;
        public PieceWeightUA lastPlaced;
        public List<PieceWeightUA> structureVillageWeightedPieceList;
        public List<StructurePiece> pendingHouses = Lists.newArrayList();
        public List<StructurePiece> pendingRoads = Lists.newArrayList();
        @Nullable
        public Biome biome;

        public Start(TemplateManager p_i50253_1_, CompoundNBT p_i50253_2_) {
            super(StructureInitUA.VISTARTUA, p_i50253_2_);
        }

        public Start(int p_i48769_1_, Random p_i48769_2_, int p_i48769_3_, int p_i48769_4_, List<PieceWeightUA> p_i48769_5_, VillageConfigUA p_i48769_6_, Biome biome) {
            super(null, 0, p_i48769_2_, p_i48769_3_, p_i48769_4_);
            this.structureVillageWeightedPieceList = p_i48769_5_;
            this.terrainType = p_i48769_6_.terrainType;
            this.structureType = p_i48769_6_.type;
            this.func_202579_a(this.structureType);
            this.isZombieInfested = p_i48769_2_.nextInt(50) == 0;
            this.biome = biome;
        }
    }

    public static class PieceWeightUA {
        public Class<? extends Village> villagePieceClass;
        public final int villagePieceWeight;
        public int villagePiecesSpawned;
        public int villagePiecesLimit;

        public PieceWeightUA(Class<? extends Village> classIn, int weightIn, int limitIn) {
            this.villagePieceClass = classIn;
            this.villagePieceWeight = weightIn;
            this.villagePiecesLimit = limitIn;
        }

        public boolean canSpawnMoreVillagePiecesOfType(int componentType) {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }

        public boolean canSpawnMoreVillagePieces() {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }
    }

    public static class Path
    extends Village {
        private int length;

        protected Path(Start start, int p_i45573_1_, Random p_i45573_2_, MutableBoundingBox boundingBoxIn, Direction facing) {
            super(start, StructureInitUA.VISRUA, p_i45573_1_);
            this.func_186164_a(facing);
            this.field_74887_e = boundingBoxIn;
            this.length = Math.max(boundingBoxIn.func_78883_b(), boundingBoxIn.func_78880_d());
        }

        public Path(TemplateManager p_i50111_1_, CompoundNBT p_i50111_2_) {
            super(StructureInitUA.VISRUA, p_i50111_2_);
            this.length = p_i50111_2_.func_74762_e("length");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74768_a("length", this.length);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            boolean flag = false;
            for (int i = rand.nextInt(5); i < this.length - 8; i += 2 + rand.nextInt(5)) {
                StructurePiece structurepiece = this.getNextComponentNN((Start)componentIn, listIn, rand, 0, i);
                if (structurepiece == null) continue;
                i += Math.max(structurepiece.func_74874_b().func_78883_b(), structurepiece.func_74874_b().func_78880_d());
                flag = true;
            }
            for (int j = rand.nextInt(5); j < this.length - 8; j += 2 + rand.nextInt(5)) {
                StructurePiece structurepiece1 = this.getNextComponentPP((Start)componentIn, listIn, rand, 0, j);
                if (structurepiece1 == null) continue;
                j += Math.max(structurepiece1.func_74874_b().func_78883_b(), structurepiece1.func_74874_b().func_78880_d());
                flag = true;
            }
            Direction enumfacing = this.func_186165_e();
            if (flag && rand.nextInt(3) > 0 && enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        VillagePastStyledPiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, Direction.WEST, this.func_74877_c());
                        break;
                    }
                    case SOUTH: {
                        VillagePastStyledPiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, Direction.WEST, this.func_74877_c());
                        break;
                    }
                    case WEST: {
                        VillagePastStyledPiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, this.func_74877_c());
                        break;
                    }
                    case EAST: {
                        VillagePastStyledPiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, this.func_74877_c());
                    }
                }
            }
            if (flag && rand.nextInt(3) > 0 && enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        VillagePastStyledPiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, Direction.EAST, this.func_74877_c());
                        break;
                    }
                    case SOUTH: {
                        VillagePastStyledPiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, Direction.EAST, this.func_74877_c());
                        break;
                    }
                    case WEST: {
                        VillagePastStyledPiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, this.func_74877_c());
                        break;
                    }
                    case EAST: {
                        VillagePastStyledPiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, this.func_74877_c());
                    }
                }
            }
        }

        public static MutableBoundingBox findPieceBox(Start start, List<StructurePiece> p_175848_1_, Random rand, int p_175848_3_, int p_175848_4_, int p_175848_5_, Direction facing) {
            for (int i = 7 * MathHelper.func_76136_a((Random)rand, (int)3, (int)5); i >= 7; i -= 7) {
                MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175848_3_, (int)p_175848_4_, (int)p_175848_5_, (int)0, (int)0, (int)0, (int)3, (int)3, (int)i, (Direction)facing);
                if (StructurePiece.func_74883_a(p_175848_1_, (MutableBoundingBox)mutableboundingbox) != null) continue;
                return mutableboundingbox;
            }
            return null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            BlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_185774_da.func_176223_P());
            BlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_196662_n.func_176223_P());
            BlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.field_150351_n.func_176223_P());
            BlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P());
            BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
            this.field_74887_e.field_78895_b = 1000;
            this.field_74887_e.field_78894_e = 0;
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    blockpos$Mutable.func_181079_c(i, 64, j);
                    if (!structureBoundingBoxIn.func_175898_b((Vec3i)blockpos$Mutable)) continue;
                    int k = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, blockpos$Mutable.func_177958_n(), blockpos$Mutable.func_177952_p());
                    blockpos$Mutable.func_181079_c(blockpos$Mutable.func_177958_n(), k, blockpos$Mutable.func_177952_p()).func_189536_c(Direction.DOWN);
                    if (blockpos$Mutable.func_177956_o() < world.func_181545_F()) {
                        blockpos$Mutable.func_185336_p(world.func_181545_F() - 1);
                    }
                    while (blockpos$Mutable.func_177956_o() >= world.func_181545_F() - 1) {
                        BlockState iblockstate4 = world.func_180495_p((BlockPos)blockpos$Mutable);
                        Block block = iblockstate4.func_177230_c();
                        if (block == Blocks.field_196658_i && world.func_175623_d(blockpos$Mutable.func_177984_a())) {
                            world.func_180501_a((BlockPos)blockpos$Mutable, iblockstate, 2);
                            break;
                        }
                        if (iblockstate4.func_185904_a().func_76224_d()) {
                            world.func_180501_a(new BlockPos((Vec3i)blockpos$Mutable), iblockstate1, 2);
                            break;
                        }
                        if (block == Blocks.field_150348_b || block == Blocks.field_150354_m || block == Blocks.field_196611_F || block == Blocks.field_150322_A || block == Blocks.field_196583_aj || block == Blocks.field_196585_ak || block == Blocks.field_180395_cM || block == Blocks.field_196583_aj || block == Blocks.field_196585_ak || block == Blocks.field_150377_bs || block == Blocks.field_150424_aL || block == Blocks.field_196604_cC || block == Blocks.field_196778_fp) {
                            world.func_180501_a((BlockPos)blockpos$Mutable, iblockstate2, 2);
                            world.func_180501_a(blockpos$Mutable.func_177977_b(), iblockstate3, 2);
                            break;
                        }
                        blockpos$Mutable.func_189536_c(Direction.DOWN);
                    }
                    this.field_74887_e.field_78895_b = Math.min(this.field_74887_e.field_78895_b, blockpos$Mutable.func_177956_o());
                    this.field_74887_e.field_78894_e = Math.max(this.field_74887_e.field_78894_e, blockpos$Mutable.func_177956_o());
                }
            }
            return true;
        }
    }

    public static class FlatTopTinyHouse
    extends Village {
        private boolean isRoofAccessible;

        protected FlatTopTinyHouse(Start start, int p_i45573_1_, Random rand, MutableBoundingBox boundingBoxIn, Direction facing) {
            super(start, StructureInitUA.VISHUA, p_i45573_1_);
            this.func_186164_a(facing);
            this.field_74887_e = boundingBoxIn;
            this.isRoofAccessible = rand.nextBoolean();
        }

        public FlatTopTinyHouse(TemplateManager p_i50111_1_, CompoundNBT p_i50111_2_) {
            super(StructureInitUA.VISHUA, p_i50111_2_);
            this.isRoofAccessible = p_i50111_2_.func_74767_n("isRoofAccessible");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("isRoofAccessible", this.isRoofAccessible);
        }

        public static FlatTopTinyHouse createPiece(Start start, List<StructurePiece> p_175858_1_, Random rand, int p_175858_3_, int p_175858_4_, int p_175858_5_, Direction facing, int p_175858_7_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175858_3_, (int)p_175858_4_, (int)p_175858_5_, (int)0, (int)0, (int)0, (int)5, (int)6, (int)5, (Direction)facing);
            return StructurePiece.func_74883_a(p_175858_1_, (MutableBoundingBox)mutableboundingbox) != null ? null : new FlatTopTinyHouse(start, p_175858_7_, rand, mutableboundingbox, facing);
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getBestGroundLevel(world, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            BlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P());
            BlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_196662_n.func_176223_P());
            BlockState iblockstate2 = this.getBiomeSpecificBlockState((BlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.NORTH));
            BlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.field_196617_K.func_176223_P());
            BlockState iblockstate4 = this.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(world, structureBoundingBoxIn, 0, 0, 0, 4, 0, 4, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 4, 0, 4, 4, 4, iblockstate3, iblockstate3, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 4, 1, 3, 4, 3, iblockstate1, iblockstate1, false);
            this.func_175811_a(world, (BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.HEAD), 1, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.FOOT), 1, 1, 2, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_222426_lO.func_176223_P(), 1, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 0, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 0, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 0, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 4, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 4, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 4, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 0, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 0, 3, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 4, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 4, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 4, 3, 4, structureBoundingBoxIn);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 1, 1, 0, 3, 3, iblockstate1, iblockstate1, false);
            this.func_175804_a(world, structureBoundingBoxIn, 4, 1, 1, 4, 3, 3, iblockstate1, iblockstate1, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 1, 4, 3, 3, 4, iblockstate1, iblockstate1, false);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 2, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 4, 2, 2, structureBoundingBoxIn);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 1, 0, 1, 3, 0, iblockstate1, iblockstate1, false);
            this.func_175811_a(world, iblockstate1, 2, 3, 0, structureBoundingBoxIn);
            this.func_175804_a(world, structureBoundingBoxIn, 3, 1, 0, 3, 3, 0, iblockstate1, iblockstate1, false);
            this.createVillageDoor(world, structureBoundingBoxIn, random, 2, 1, 0, Direction.NORTH);
            if (this.func_175807_a((IBlockReader)world, 2, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a((IBlockReader)world, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(world, iblockstate2, 2, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a((IBlockReader)world, 2, -1, -1, structureBoundingBoxIn).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(world, Blocks.field_196658_i.func_176223_P(), 2, -1, -1, structureBoundingBoxIn);
                }
            }
            this.func_175804_a(world, structureBoundingBoxIn, 1, 1, 1, 3, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            if (this.isRoofAccessible) {
                for (int k = 0; k <= 4; ++k) {
                    for (int l = 0; l <= 4; ++l) {
                        boolean flag3;
                        boolean flag1;
                        boolean flag = k == 0 || k == 4;
                        boolean bl = flag1 = l == 0 || l == 4;
                        if (!flag && !flag1) continue;
                        boolean flag2 = k == 0 || k == 4;
                        boolean bl2 = flag3 = l == 0 || l == 4;
                        if (iblockstate.func_196959_b((IProperty)FourWayBlock.field_196413_c)) {
                            BlockState iblockstate5 = (BlockState)((BlockState)((BlockState)((BlockState)iblockstate4.func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(flag2 && l != 0))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(flag2 && l != 4))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(flag3 && k != 0))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(flag3 && k != 4));
                            this.func_175811_a(world, iblockstate5, k, 5, l, structureBoundingBoxIn);
                            continue;
                        }
                        this.func_175811_a(world, iblockstate4, k, 5, l, structureBoundingBoxIn);
                    }
                }
            }
            if (this.isRoofAccessible) {
                BlockState iblockstate6 = (BlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a((IProperty)LadderBlock.field_176382_a, (Comparable)Direction.SOUTH);
                this.func_175811_a(world, iblockstate6, 3, 1, 3, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate6, 3, 2, 3, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate6, 3, 3, 3, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate6, 3, 4, 3, structureBoundingBoxIn);
            }
            this.placeTorch(world, Direction.NORTH, 2, 3, 1, structureBoundingBoxIn);
            for (int i1 = 0; i1 < 5; ++i1) {
                for (int j1 = 0; j1 < 5; ++j1) {
                    this.clearCurrentPositionBlocksUpwards(world, j1, 6, i1, structureBoundingBoxIn);
                    this.func_175808_b(world, iblockstate, j1, -1, i1, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(world, structureBoundingBoxIn, 1, 1, 2, 1, random);
            return true;
        }
    }

    public static class LargeHouse
    extends Village {
        private boolean hasMadeChest;

        protected LargeHouse(Start start, int p_i45573_1_, Random p_i45573_2_, MutableBoundingBox boundingBoxIn, Direction facing) {
            super(start, StructureInitUA.VITRHUA, p_i45573_1_);
            this.func_186164_a(facing);
            this.field_74887_e = boundingBoxIn;
        }

        public LargeHouse(TemplateManager p_i50111_1_, CompoundNBT p_i50111_2_) {
            super(StructureInitUA.VITRHUA, p_i50111_2_);
            this.hasMadeChest = p_i50111_2_.func_74767_n("hasMadeChest");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("hasMadeChest", this.hasMadeChest);
        }

        public static LargeHouse createPiece(Start start, List<StructurePiece> p_175849_1_, Random rand, int p_175849_3_, int p_175849_4_, int p_175849_5_, Direction facing, int p_175849_7_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175849_3_, (int)p_175849_4_, (int)p_175849_5_, (int)0, (int)0, (int)0, (int)9, (int)7, (int)12, (Direction)facing);
            return LargeHouse.canVillageGoDeeper(mutableboundingbox) && StructurePiece.func_74883_a(p_175849_1_, (MutableBoundingBox)mutableboundingbox) == null ? new LargeHouse(start, p_175849_7_, rand, mutableboundingbox, facing) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getBestGroundLevel(world, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            BlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P());
            BlockState iblockstate1 = this.getBiomeSpecificBlockState((BlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.NORTH));
            BlockState iblockstate2 = this.getBiomeSpecificBlockState((BlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH));
            BlockState iblockstate3 = this.getBiomeSpecificBlockState((BlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.EAST));
            BlockState iblockstate4 = this.getBiomeSpecificBlockState((BlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.WEST));
            BlockState iblockstate5 = this.getBiomeSpecificBlockState(Blocks.field_196662_n.func_176223_P());
            BlockState iblockstate6 = this.getBiomeSpecificBlockState(Blocks.field_196617_K.func_176223_P());
            this.func_175804_a(world, structureBoundingBoxIn, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 2, 0, 5, 8, 0, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 0, 1, 7, 0, 4, iblockstate5, iblockstate5, false);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.HEAD)).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.WEST), 3, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.HEAD)).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.WEST), 3, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.HEAD)).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.WEST), 3, 1, 7, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.HEAD)).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.WEST), 3, 1, 8, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.FOOT)).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.WEST), 4, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.FOOT)).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.WEST), 4, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.FOOT)).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.WEST), 4, 1, 7, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.FOOT)).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.WEST), 4, 1, 8, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.HEAD)).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.EAST), 7, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.HEAD)).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.EAST), 7, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.HEAD)).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.EAST), 7, 1, 7, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.HEAD)).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.EAST), 7, 1, 8, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.FOOT)).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.EAST), 6, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.FOOT)).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.EAST), 6, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.FOOT)).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.EAST), 6, 1, 7, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.FOOT)).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.EAST), 6, 1, 8, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_222426_lO.func_176223_P(), 5, 1, 9, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_222421_lJ.func_176223_P(), 6, 1, 9, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)Blocks.field_150383_bp.func_176223_P().func_206870_a((IProperty)CauldronBlock.field_176591_a, (Comparable)Integer.valueOf(2)), 4, 1, 9, structureBoundingBoxIn);
            if (!this.hasMadeChest && structureBoundingBoxIn.func_175898_b((Vec3i)new BlockPos(this.func_74865_a(3, 8), this.func_74862_a(1), this.func_74873_b(3, 6)))) {
                this.hasMadeChest = true;
                this.func_186167_a(world, structureBoundingBoxIn, random, 3, 1, 6, LootTables.field_215821_l);
            }
            if (!this.hasMadeChest && structureBoundingBoxIn.func_175898_b((Vec3i)new BlockPos(this.func_74865_a(7, 8), this.func_74862_a(1), this.func_74873_b(7, 6)))) {
                this.hasMadeChest = true;
                this.func_186167_a(world, structureBoundingBoxIn, random, 7, 1, 6, LootTables.field_215826_q);
            }
            this.func_175811_a(world, Blocks.field_150462_ai.func_176223_P(), 3, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_150462_ai.func_176223_P(), 7, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBiomeSpecificBlockState(Blocks.field_150478_aa.func_176223_P()), 3, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBiomeSpecificBlockState(Blocks.field_150478_aa.func_176223_P()), 7, 2, 5, structureBoundingBoxIn);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 0, 0, 0, 3, 5, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 8, 0, 0, 8, 3, 10, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 0, 0, 7, 2, 0, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 0, 5, 2, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 2, 0, 6, 2, 3, 10, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 3, 0, 10, 7, 3, 10, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 2, 0, 7, 3, 0, iblockstate5, iblockstate5, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 2, 5, 2, 3, 5, iblockstate5, iblockstate5, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 4, 1, 8, 4, 1, iblockstate5, iblockstate5, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 4, 4, 3, 4, 4, iblockstate5, iblockstate5, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 5, 2, 8, 5, 3, iblockstate5, iblockstate5, false);
            this.func_175811_a(world, iblockstate5, 0, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate5, 0, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate5, 8, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate5, 8, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate5, 8, 4, 4, structureBoundingBoxIn);
            BlockState iblockstate7 = iblockstate1;
            BlockState iblockstate8 = iblockstate2;
            BlockState iblockstate9 = iblockstate4;
            BlockState iblockstate10 = iblockstate3;
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.func_175811_a(world, iblockstate7, j, 4 + i, i, structureBoundingBoxIn);
                    if (i <= -1 && j > 1 || i <= 0 && j > 3 || i <= 1 && j > 4 && j < 6) continue;
                    this.func_175811_a(world, iblockstate8, j, 4 + i, 5 - i, structureBoundingBoxIn);
                }
            }
            this.func_175804_a(world, structureBoundingBoxIn, 3, 4, 5, 3, 4, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(world, structureBoundingBoxIn, 7, 4, 2, 7, 4, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(world, structureBoundingBoxIn, 4, 5, 4, 4, 5, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(world, structureBoundingBoxIn, 6, 5, 4, 6, 5, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(world, structureBoundingBoxIn, 5, 6, 3, 5, 6, 10, iblockstate5, iblockstate5, false);
            for (int k = 4; k >= 1; --k) {
                this.func_175811_a(world, iblockstate5, k, 2 + k, 7 - k, structureBoundingBoxIn);
                for (int k1 = 8 - k; k1 <= 10; ++k1) {
                    this.func_175811_a(world, iblockstate10, k, 2 + k, k1, structureBoundingBoxIn);
                }
            }
            this.func_175811_a(world, iblockstate5, 6, 6, 3, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate5, 7, 5, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate4, 6, 6, 4, structureBoundingBoxIn);
            for (int l = 6; l <= 8; ++l) {
                for (int l1 = 5; l1 <= 10; ++l1) {
                    this.func_175811_a(world, iblockstate9, l, 12 - l, l1, structureBoundingBoxIn);
                }
            }
            this.func_175811_a(world, iblockstate6, 0, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate6, 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 0, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate6, 4, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 5, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate6, 6, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate6, 8, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 8, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 8, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate6, 8, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate5, 8, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate6, 8, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 8, 2, 7, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 8, 2, 8, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate6, 8, 2, 9, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate6, 2, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 2, 2, 7, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 2, 2, 8, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate6, 2, 2, 9, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate6, 4, 4, 10, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 5, 4, 10, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate6, 6, 4, 10, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate5, 5, 5, 10, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, structureBoundingBoxIn);
            this.placeTorch(world, Direction.NORTH, 2, 3, 1, structureBoundingBoxIn);
            this.createVillageDoor(world, structureBoundingBoxIn, random, 2, 1, 0, Direction.NORTH);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 0, -1, 3, 2, -1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            if (this.func_175807_a((IBlockReader)world, 2, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a((IBlockReader)world, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(world, iblockstate7, 2, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a((IBlockReader)world, 2, -1, -1, structureBoundingBoxIn).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(world, Blocks.field_196658_i.func_176223_P(), 2, -1, -1, structureBoundingBoxIn);
                }
            }
            for (int i1 = 0; i1 < 5; ++i1) {
                for (int i2 = 0; i2 < 9; ++i2) {
                    this.clearCurrentPositionBlocksUpwards(world, i2, 7, i1, structureBoundingBoxIn);
                    this.func_175808_b(world, iblockstate, i2, -1, i1, structureBoundingBoxIn);
                }
            }
            for (int j1 = 5; j1 < 11; ++j1) {
                for (int j2 = 2; j2 < 9; ++j2) {
                    this.clearCurrentPositionBlocksUpwards(world, j2, 7, j1, structureBoundingBoxIn);
                    this.func_175808_b(world, iblockstate, j2, -1, j1, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(world, structureBoundingBoxIn, 4, 1, 2, 2, random);
            return true;
        }
    }

    public static class Blacksmith
    extends Village {
        private boolean hasMadeChest;

        protected Blacksmith(Start start, int type, Random rand, MutableBoundingBox boundingBoxIn, Direction facing) {
            super(start, StructureInitUA.VISUA, type);
            this.func_186164_a(facing);
            this.field_74887_e = boundingBoxIn;
        }

        public Blacksmith(TemplateManager p_i50111_1_, CompoundNBT p_i50111_2_) {
            super(StructureInitUA.VISUA, p_i50111_2_);
            this.hasMadeChest = p_i50111_2_.func_74767_n("hasMadeChest");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("hasMadeChest", this.hasMadeChest);
        }

        public static Blacksmith createPiece(Start start, List<StructurePiece> p_175855_1_, Random rand, int p_175855_3_, int p_175855_4_, int p_175855_5_, Direction facing, int p_175855_7_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175855_3_, (int)p_175855_4_, (int)p_175855_5_, (int)0, (int)0, (int)0, (int)10, (int)6, (int)7, (Direction)facing);
            return Blacksmith.canVillageGoDeeper(mutableboundingbox) && StructurePiece.func_74883_a(p_175855_1_, (MutableBoundingBox)mutableboundingbox) == null ? new Blacksmith(start, p_175855_7_, rand, mutableboundingbox, facing) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getBestGroundLevel(world, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            BlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P());
            BlockState iblockstate1 = this.getBiomeSpecificBlockState((BlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.NORTH));
            BlockState iblockstate2 = this.getBiomeSpecificBlockState((BlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.WEST));
            BlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.field_196662_n.func_176223_P());
            BlockState iblockstate4 = this.getBiomeSpecificBlockState((BlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.NORTH));
            BlockState iblockstate5 = this.getBiomeSpecificBlockState(Blocks.field_196617_K.func_176223_P());
            BlockState iblockstate6 = this.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(world, structureBoundingBoxIn, 0, 1, 0, 9, 4, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 0, 0, 9, 0, 6, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 4, 0, 9, 4, 6, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 5, 0, 9, 5, 6, Blocks.field_150333_U.func_176223_P(), Blocks.field_150333_U.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 5, 1, 8, 5, 5, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 1, 0, 2, 3, 0, iblockstate3, iblockstate3, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 1, 0, 0, 4, 0, iblockstate5, iblockstate5, false);
            this.func_175804_a(world, structureBoundingBoxIn, 3, 1, 0, 3, 4, 0, iblockstate5, iblockstate5, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 1, 6, 0, 4, 6, iblockstate5, iblockstate5, false);
            this.func_175811_a(world, iblockstate3, 3, 3, 1, structureBoundingBoxIn);
            this.createVillageDoor(world, structureBoundingBoxIn, random, 3, 1, 1, Direction.SOUTH);
            this.func_175804_a(world, structureBoundingBoxIn, 3, 1, 2, 3, 3, 2, iblockstate3, iblockstate3, false);
            this.func_175804_a(world, structureBoundingBoxIn, 4, 1, 3, 5, 3, 3, iblockstate3, iblockstate3, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 1, 1, 0, 3, 5, iblockstate3, iblockstate3, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 1, 6, 5, 3, 6, iblockstate3, iblockstate3, false);
            this.func_175804_a(world, structureBoundingBoxIn, 5, 2, 0, 5, 3, 0, iblockstate6, iblockstate6, false);
            this.func_175804_a(world, structureBoundingBoxIn, 9, 1, 0, 9, 3, 0, iblockstate6, iblockstate6, false);
            this.func_175804_a(world, structureBoundingBoxIn, 6, 1, 4, 9, 4, 6, iblockstate, iblockstate, false);
            this.func_175811_a(world, this.getBiomeSpecificBlockState(Blocks.field_150353_l.func_176223_P()), 7, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBiomeSpecificBlockState(Blocks.field_150353_l.func_176223_P()), 8, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), 9, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 9, 2, 4, structureBoundingBoxIn);
            this.func_175804_a(world, structureBoundingBoxIn, 7, 2, 4, 8, 2, 5, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(world, iblockstate, 6, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)Blocks.field_222424_lM.func_176223_P().func_206870_a((IProperty)AbstractFurnaceBlock.field_220090_a, (Comparable)Direction.SOUTH), 6, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)Blocks.field_222424_lM.func_176223_P().func_206870_a((IProperty)AbstractFurnaceBlock.field_220090_a, (Comparable)Direction.SOUTH), 6, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_222429_lR.func_176223_P(), 8, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_222430_lS.func_176223_P(), 8, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_150467_bQ.func_176223_P(), 5, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 2, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 4, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate6, 2, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBiomeSpecificBlockState(Blocks.field_196663_cq.func_176223_P()), 2, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_222427_lP.func_176223_P(), 5, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate3, 5, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate3, 1, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate1, 2, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate2, 1, 1, 4, structureBoundingBoxIn);
            if (!this.hasMadeChest && structureBoundingBoxIn.func_175898_b((Vec3i)new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(1), this.func_74873_b(5, 5)))) {
                this.hasMadeChest = true;
                this.func_186167_a(world, structureBoundingBoxIn, random, 5, 1, 5, LootTables.field_215814_e);
            }
            for (int i = 6; i <= 8; ++i) {
                if (this.func_175807_a((IBlockReader)world, i, 0, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a || this.func_175807_a((IBlockReader)world, i, -1, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a) continue;
                this.func_175811_a(world, iblockstate4, i, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a((IBlockReader)world, i, -1, -1, structureBoundingBoxIn).func_177230_c() != Blocks.field_185774_da) continue;
                this.func_175811_a(world, Blocks.field_196658_i.func_176223_P(), i, -1, -1, structureBoundingBoxIn);
            }
            for (int k = 0; k < 7; ++k) {
                for (int j = 0; j < 10; ++j) {
                    this.clearCurrentPositionBlocksUpwards(world, j, 6, k, structureBoundingBoxIn);
                    this.func_175808_b(world, iblockstate, j, -1, k, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(world, structureBoundingBoxIn, 7, 1, 1, 1, random);
            return true;
        }

        protected int chooseProfession(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class LibraryHouse
    extends Village {
        protected LibraryHouse(Start start, int type, Random rand, MutableBoundingBox boundingBoxIn, Direction facing) {
            super(start, StructureInitUA.VIBHUA, type);
            this.func_186164_a(facing);
            this.field_74887_e = boundingBoxIn;
        }

        public LibraryHouse(TemplateManager p_i50111_1_, CompoundNBT p_i50111_2_) {
            super(StructureInitUA.VIBHUA, p_i50111_2_);
        }

        public static LibraryHouse createPiece(Start start, List<StructurePiece> p_175850_1_, Random rand, int p_175850_3_, int p_175850_4_, int p_175850_5_, Direction facing, int p_175850_7_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175850_3_, (int)p_175850_4_, (int)p_175850_5_, (int)0, (int)0, (int)0, (int)9, (int)9, (int)6, (Direction)facing);
            return LibraryHouse.canVillageGoDeeper(mutableboundingbox) && StructurePiece.func_74883_a(p_175850_1_, (MutableBoundingBox)mutableboundingbox) == null ? new LibraryHouse(start, p_175850_7_, rand, mutableboundingbox, facing) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getBestGroundLevel(world, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 9 - 1, 0);
            }
            BlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P());
            BlockState iblockstate1 = this.getBiomeSpecificBlockState((BlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.NORTH));
            BlockState iblockstate2 = this.getBiomeSpecificBlockState((BlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH));
            BlockState iblockstate3 = this.getBiomeSpecificBlockState((BlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.EAST));
            BlockState iblockstate4 = this.getBiomeSpecificBlockState(Blocks.field_196662_n.func_176223_P());
            BlockState iblockstate5 = this.getBiomeSpecificBlockState((BlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.NORTH));
            BlockState iblockstate6 = this.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(world, structureBoundingBoxIn, 1, 1, 1, 7, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 0, 0, 8, 0, 5, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 5, 0, 8, 5, 5, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 6, 1, 8, 6, 4, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 7, 2, 8, 7, 3, iblockstate, iblockstate, false);
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.func_175811_a(world, iblockstate1, j, 6 + i, i, structureBoundingBoxIn);
                    this.func_175811_a(world, iblockstate2, j, 6 + i, 5 - i, structureBoundingBoxIn);
                }
            }
            this.func_175804_a(world, structureBoundingBoxIn, 0, 1, 0, 0, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 1, 5, 8, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 8, 1, 0, 8, 1, 4, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 2, 1, 0, 7, 1, 0, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 2, 0, 0, 4, 0, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 2, 5, 0, 4, 5, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 8, 2, 5, 8, 4, 5, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 8, 2, 0, 8, 4, 0, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 2, 1, 0, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 2, 5, 7, 4, 5, iblockstate4, iblockstate4, false);
            this.func_175804_a(world, structureBoundingBoxIn, 8, 2, 1, 8, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 2, 0, 7, 4, 0, iblockstate4, iblockstate4, false);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 4, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 5, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 6, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 4, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 5, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 6, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 0, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 0, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 0, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 8, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 8, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 8, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 8, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 2, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 3, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 5, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 6, 2, 5, structureBoundingBoxIn);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 4, 1, 7, 4, 1, iblockstate4, iblockstate4, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 4, 4, 7, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 3, 4, 7, 3, 4, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            this.func_175811_a(world, iblockstate4, 7, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate3, 7, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate1, 6, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate1, 5, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate1, 4, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate1, 3, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate6, 6, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBiomeSpecificBlockState(Blocks.field_196663_cq.func_176223_P()), 6, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate6, 4, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBiomeSpecificBlockState(Blocks.field_196663_cq.func_176223_P()), 4, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_222425_lN.func_176223_P(), 7, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBiomeSpecificBlockState(Blocks.field_150478_aa.func_176223_P()), 7, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_222425_lN.func_176223_P(), 1, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBiomeSpecificBlockState(Blocks.field_150478_aa.func_176223_P()), 1, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_150342_X.func_176223_P(), 2, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_222428_lQ.func_176223_P(), 5, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_222428_lQ.func_176223_P(), 6, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 1, 2, 0, structureBoundingBoxIn);
            this.createVillageDoor(world, structureBoundingBoxIn, random, 1, 1, 0, Direction.NORTH);
            if (this.func_175807_a((IBlockReader)world, 1, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a((IBlockReader)world, 1, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(world, iblockstate5, 1, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a((IBlockReader)world, 1, -1, -1, structureBoundingBoxIn).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(world, Blocks.field_196658_i.func_176223_P(), 1, -1, -1, structureBoundingBoxIn);
                }
            }
            for (int l = 0; l < 6; ++l) {
                for (int k = 0; k < 9; ++k) {
                    this.clearCurrentPositionBlocksUpwards(world, k, 9, l, structureBoundingBoxIn);
                    this.func_175808_b(world, iblockstate, k, -1, l, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(world, structureBoundingBoxIn, 2, 1, 2, 1, random);
            return true;
        }
    }

    public static class WorkHouse
    extends Village {
        protected WorkHouse(Start start, int type, Random rand, MutableBoundingBox boundingBoxIn, Direction facing) {
            super(start, StructureInitUA.VIPHUA, type);
            this.func_186164_a(facing);
            this.field_74887_e = boundingBoxIn;
        }

        public WorkHouse(TemplateManager p_i50111_1_, CompoundNBT p_i50111_2_) {
            super(StructureInitUA.VIPHUA, p_i50111_2_);
        }

        public static WorkHouse createPiece(Start start, List<StructurePiece> p_175857_1_, Random rand, int p_175857_3_, int p_175857_4_, int p_175857_5_, Direction facing, int p_175857_7_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175857_3_, (int)p_175857_4_, (int)p_175857_5_, (int)0, (int)0, (int)0, (int)9, (int)7, (int)11, (Direction)facing);
            return WorkHouse.canVillageGoDeeper(mutableboundingbox) && StructurePiece.func_74883_a(p_175857_1_, (MutableBoundingBox)mutableboundingbox) == null ? new WorkHouse(start, p_175857_7_, rand, mutableboundingbox, facing) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getBestGroundLevel(world, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            BlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P());
            BlockState iblockstate1 = this.getBiomeSpecificBlockState((BlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.NORTH));
            BlockState iblockstate2 = this.getBiomeSpecificBlockState((BlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH));
            BlockState iblockstate3 = this.getBiomeSpecificBlockState((BlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.WEST));
            BlockState iblockstate4 = this.getBiomeSpecificBlockState(Blocks.field_196662_n.func_176223_P());
            BlockState iblockstate5 = this.getBiomeSpecificBlockState(Blocks.field_196617_K.func_176223_P());
            BlockState iblockstate6 = this.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(world, structureBoundingBoxIn, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 2, 0, 6, 8, 0, 10, Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P(), false);
            this.func_175811_a(world, iblockstate, 6, 0, 6, structureBoundingBoxIn);
            BlockState iblockstate7 = iblockstate6;
            BlockState iblockstate8 = iblockstate6;
            if (iblockstate.func_196959_b((IProperty)FourWayBlock.field_196413_c)) {
                iblockstate7 = (BlockState)((BlockState)iblockstate6.func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true));
                iblockstate8 = (BlockState)((BlockState)iblockstate6.func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true));
                this.func_175811_a(world, (BlockState)((BlockState)iblockstate6.func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), 2, 1, 10, structureBoundingBoxIn);
                this.func_175811_a(world, (BlockState)((BlockState)iblockstate6.func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 8, 1, 10, structureBoundingBoxIn);
            } else {
                this.func_175811_a(world, iblockstate6, 2, 1, 10, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate6, 8, 1, 10, structureBoundingBoxIn);
            }
            this.func_175804_a(world, structureBoundingBoxIn, 2, 1, 6, 2, 1, 9, iblockstate7, iblockstate7, false);
            this.func_175804_a(world, structureBoundingBoxIn, 8, 1, 6, 8, 1, 9, iblockstate7, iblockstate7, false);
            this.func_175804_a(world, structureBoundingBoxIn, 3, 1, 10, 7, 1, 10, iblockstate8, iblockstate8, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 0, 1, 7, 0, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 0, 0, 0, 3, 5, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 8, 0, 0, 8, 3, 5, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 0, 0, 7, 1, 0, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 0, 5, 7, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 2, 0, 7, 3, 0, iblockstate4, iblockstate4, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 2, 5, 7, 3, 5, iblockstate4, iblockstate4, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 4, 1, 8, 4, 1, iblockstate4, iblockstate4, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 4, 4, 8, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 5, 2, 8, 5, 3, iblockstate4, iblockstate4, false);
            this.func_175811_a(world, iblockstate4, 0, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate4, 0, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate4, 8, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate4, 8, 4, 3, structureBoundingBoxIn);
            BlockState iblockstate9 = iblockstate1;
            BlockState iblockstate10 = iblockstate2;
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.func_175811_a(world, iblockstate9, j, 4 + i, i, structureBoundingBoxIn);
                    this.func_175811_a(world, iblockstate10, j, 4 + i, 5 - i, structureBoundingBoxIn);
                }
            }
            this.func_175811_a(world, iblockstate5, 0, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate5, 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate5, 8, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate5, 8, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 0, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 8, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 8, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 2, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 3, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 5, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate6, 2, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(world, this.getBiomeSpecificBlockState(Blocks.field_196663_cq.func_176223_P()), 2, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_222421_lJ.func_176223_P(), 3, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate4, 1, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate9, 2, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate3, 1, 1, 3, structureBoundingBoxIn);
            BlockState iblockstate11 = (BlockState)Blocks.field_150333_U.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
            this.func_175804_a(world, structureBoundingBoxIn, 5, 0, 1, 7, 0, 3, iblockstate11, iblockstate11, false);
            this.func_175811_a(world, Blocks.field_222423_lL.func_176223_P(), 6, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_222423_lL.func_176223_P(), 6, 1, 2, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)Blocks.field_150383_bp.func_176223_P().func_206870_a((IProperty)CauldronBlock.field_176591_a, (Comparable)Integer.valueOf(3)), 6, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, structureBoundingBoxIn);
            this.placeTorch(world, Direction.NORTH, 2, 3, 1, structureBoundingBoxIn);
            this.createVillageDoor(world, structureBoundingBoxIn, random, 2, 1, 0, Direction.NORTH);
            if (this.func_175807_a((IBlockReader)world, 2, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a((IBlockReader)world, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(world, iblockstate9, 2, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a((IBlockReader)world, 2, -1, -1, structureBoundingBoxIn).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(world, Blocks.field_196658_i.func_176223_P(), 2, -1, -1, structureBoundingBoxIn);
                }
            }
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 6, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 6, 2, 5, structureBoundingBoxIn);
            this.placeTorch(world, Direction.SOUTH, 6, 3, 4, structureBoundingBoxIn);
            this.createVillageDoor(world, structureBoundingBoxIn, random, 6, 1, 5, Direction.SOUTH);
            for (int l = 0; l < 5; ++l) {
                for (int k = 0; k < 9; ++k) {
                    this.clearCurrentPositionBlocksUpwards(world, k, 7, l, structureBoundingBoxIn);
                    this.func_175808_b(world, iblockstate, k, -1, l, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(world, structureBoundingBoxIn, 4, 1, 2, 2, random);
            return true;
        }
    }

    public static class Field2
    extends Village {
        private BlockState cropTypeA;
        private BlockState cropTypeB;

        protected Field2(Start start, int type, Random rand, MutableBoundingBox boundingBoxIn, Direction facing) {
            super(start, StructureInitUA.VIFUA, type);
            this.func_186164_a(facing);
            this.field_74887_e = boundingBoxIn;
            this.cropTypeA = Field2.randomCrop(rand);
            this.cropTypeB = Field2.randomCrop(rand);
        }

        public Field2(TemplateManager p_i50111_1_, CompoundNBT p_i50111_2_) {
            super(StructureInitUA.VIFUA, p_i50111_2_);
            this.cropTypeA = NBTUtil.func_190008_d((CompoundNBT)p_i50111_2_.func_74775_l("cropTypeA"));
            this.cropTypeB = NBTUtil.func_190008_d((CompoundNBT)p_i50111_2_.func_74775_l("cropTypeB"));
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_218657_a("cropTypeA", (INBT)NBTUtil.func_190009_a((BlockState)this.cropTypeA));
            tagCompound.func_218657_a("cropTypeB", (INBT)NBTUtil.func_190009_a((BlockState)this.cropTypeB));
        }

        private static BlockState randomCrop(Random rand) {
            switch (rand.nextInt(10)) {
                case 0: 
                case 1: {
                    return Blocks.field_150459_bM.func_176223_P();
                }
                case 2: 
                case 3: {
                    return Blocks.field_150469_bN.func_176223_P();
                }
                case 4: {
                    return Blocks.field_185773_cZ.func_176223_P();
                }
            }
            return Blocks.field_150464_aj.func_176223_P();
        }

        public static Field2 createPiece(Start start, List<StructurePiece> p_175852_1_, Random rand, int p_175852_3_, int p_175852_4_, int p_175852_5_, Direction facing, int p_175852_7_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175852_3_, (int)p_175852_4_, (int)p_175852_5_, (int)0, (int)0, (int)0, (int)7, (int)4, (int)9, (Direction)facing);
            return Field2.canVillageGoDeeper(mutableboundingbox) && StructurePiece.func_74883_a(p_175852_1_, (MutableBoundingBox)mutableboundingbox) == null ? new Field2(start, p_175852_7_, rand, mutableboundingbox, facing) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getBestGroundLevel(world, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            BlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_196617_K.func_176223_P());
            this.func_175804_a(world, structureBoundingBoxIn, 0, 1, 0, 6, 4, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 0, 1, 2, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 4, 0, 1, 5, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 0, 0, 0, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 6, 0, 0, 6, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 0, 0, 5, 0, 0, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 0, 8, 5, 0, 8, iblockstate, iblockstate, false);
            this.func_175811_a(world, Blocks.field_222436_lZ.func_176223_P(), 0, 1, 8, structureBoundingBoxIn);
            this.func_175804_a(world, structureBoundingBoxIn, 3, 0, 1, 3, 0, 7, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
            for (int i = 1; i <= 7; ++i) {
                CropsBlock CropsBlock2 = (CropsBlock)this.cropTypeA.func_177230_c();
                int j = CropsBlock2.func_185526_g();
                int k = j / 3;
                this.func_175811_a(world, (BlockState)this.cropTypeA.func_206870_a((IProperty)CropsBlock2.func_185524_e(), (Comparable)Integer.valueOf(MathHelper.func_76136_a((Random)random, (int)k, (int)j))), 1, 1, i, structureBoundingBoxIn);
                this.func_175811_a(world, (BlockState)this.cropTypeA.func_206870_a((IProperty)CropsBlock2.func_185524_e(), (Comparable)Integer.valueOf(MathHelper.func_76136_a((Random)random, (int)k, (int)j))), 2, 1, i, structureBoundingBoxIn);
                CropsBlock2 = (CropsBlock)this.cropTypeB.func_177230_c();
                int l = CropsBlock2.func_185526_g();
                int i1 = l / 3;
                this.func_175811_a(world, (BlockState)this.cropTypeB.func_206870_a((IProperty)CropsBlock2.func_185524_e(), (Comparable)Integer.valueOf(MathHelper.func_76136_a((Random)random, (int)i1, (int)l))), 4, 1, i, structureBoundingBoxIn);
                this.func_175811_a(world, (BlockState)this.cropTypeB.func_206870_a((IProperty)CropsBlock2.func_185524_e(), (Comparable)Integer.valueOf(MathHelper.func_76136_a((Random)random, (int)i1, (int)l))), 5, 1, i, structureBoundingBoxIn);
            }
            for (int j1 = 0; j1 < 9; ++j1) {
                for (int k1 = 0; k1 < 7; ++k1) {
                    this.clearCurrentPositionBlocksUpwards(world, k1, 4, j1, structureBoundingBoxIn);
                    this.func_175808_b(world, Blocks.field_150346_d.func_176223_P(), k1, -1, j1, structureBoundingBoxIn);
                }
            }
            return true;
        }
    }

    public static class Field1
    extends Village {
        private BlockState cropTypeA;
        private BlockState cropTypeB;
        private BlockState cropTypeC;
        private BlockState cropTypeD;

        protected Field1(Start start, int type, Random rand, MutableBoundingBox boundingBoxIn, Direction facing) {
            super(start, StructureInitUA.VIDFUA, type);
            this.func_186164_a(facing);
            this.field_74887_e = boundingBoxIn;
            this.cropTypeA = Field1.randomCrop(rand);
            this.cropTypeB = Field1.randomCrop(rand);
            this.cropTypeC = Field1.randomCrop(rand);
            this.cropTypeD = Field1.randomCrop(rand);
        }

        public Field1(TemplateManager p_i50111_1_, CompoundNBT p_i50111_2_) {
            super(StructureInitUA.VIDFUA, p_i50111_2_);
            this.cropTypeA = NBTUtil.func_190008_d((CompoundNBT)p_i50111_2_.func_74775_l("cropTypeA"));
            this.cropTypeB = NBTUtil.func_190008_d((CompoundNBT)p_i50111_2_.func_74775_l("cropTypeB"));
            this.cropTypeC = NBTUtil.func_190008_d((CompoundNBT)p_i50111_2_.func_74775_l("cropTypeC"));
            this.cropTypeD = NBTUtil.func_190008_d((CompoundNBT)p_i50111_2_.func_74775_l("cropTypeD"));
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_218657_a("cropTypeA", (INBT)NBTUtil.func_190009_a((BlockState)this.cropTypeA));
            tagCompound.func_218657_a("cropTypeB", (INBT)NBTUtil.func_190009_a((BlockState)this.cropTypeB));
            tagCompound.func_218657_a("cropTypeC", (INBT)NBTUtil.func_190009_a((BlockState)this.cropTypeC));
            tagCompound.func_218657_a("cropTypeD", (INBT)NBTUtil.func_190009_a((BlockState)this.cropTypeD));
        }

        private static BlockState randomCrop(Random rand) {
            switch (rand.nextInt(10)) {
                case 0: 
                case 1: {
                    return Blocks.field_150459_bM.func_176223_P();
                }
                case 2: 
                case 3: {
                    return Blocks.field_150469_bN.func_176223_P();
                }
                case 4: {
                    return Blocks.field_185773_cZ.func_176223_P();
                }
            }
            return Blocks.field_150464_aj.func_176223_P();
        }

        public static Field1 createPiece(Start start, List<StructurePiece> p_175851_1_, Random rand, int p_175851_3_, int p_175851_4_, int p_175851_5_, Direction facing, int p_175851_7_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175851_3_, (int)p_175851_4_, (int)p_175851_5_, (int)0, (int)0, (int)0, (int)13, (int)4, (int)9, (Direction)facing);
            return Field1.canVillageGoDeeper(mutableboundingbox) && StructurePiece.func_74883_a(p_175851_1_, (MutableBoundingBox)mutableboundingbox) == null ? new Field1(start, p_175851_7_, rand, mutableboundingbox, facing) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getBestGroundLevel(world, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            BlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_196617_K.func_176223_P());
            this.func_175804_a(world, structureBoundingBoxIn, 0, 1, 0, 12, 4, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 0, 1, 2, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 4, 0, 1, 5, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 7, 0, 1, 8, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 10, 0, 1, 11, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 0, 0, 0, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 6, 0, 0, 6, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 12, 0, 0, 12, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 0, 0, 11, 0, 0, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 0, 8, 11, 0, 8, iblockstate, iblockstate, false);
            this.func_175811_a(world, Blocks.field_222436_lZ.func_176223_P(), 6, 1, 0, structureBoundingBoxIn);
            this.func_175804_a(world, structureBoundingBoxIn, 3, 0, 1, 3, 0, 7, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 9, 0, 1, 9, 0, 7, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
            for (int i = 1; i <= 7; ++i) {
                CropsBlock CropsBlock2 = (CropsBlock)this.cropTypeA.func_177230_c();
                int j = CropsBlock2.func_185526_g();
                int k = j / 3;
                this.func_175811_a(world, (BlockState)this.cropTypeA.func_206870_a((IProperty)CropsBlock2.func_185524_e(), (Comparable)Integer.valueOf(MathHelper.func_76136_a((Random)random, (int)k, (int)j))), 1, 1, i, structureBoundingBoxIn);
                this.func_175811_a(world, (BlockState)this.cropTypeA.func_206870_a((IProperty)CropsBlock2.func_185524_e(), (Comparable)Integer.valueOf(MathHelper.func_76136_a((Random)random, (int)k, (int)j))), 2, 1, i, structureBoundingBoxIn);
                CropsBlock2 = (CropsBlock)this.cropTypeB.func_177230_c();
                int l = CropsBlock2.func_185526_g();
                int i1 = l / 3;
                this.func_175811_a(world, (BlockState)this.cropTypeB.func_206870_a((IProperty)CropsBlock2.func_185524_e(), (Comparable)Integer.valueOf(MathHelper.func_76136_a((Random)random, (int)i1, (int)l))), 4, 1, i, structureBoundingBoxIn);
                this.func_175811_a(world, (BlockState)this.cropTypeB.func_206870_a((IProperty)CropsBlock2.func_185524_e(), (Comparable)Integer.valueOf(MathHelper.func_76136_a((Random)random, (int)i1, (int)l))), 5, 1, i, structureBoundingBoxIn);
                CropsBlock2 = (CropsBlock)this.cropTypeC.func_177230_c();
                int j1 = CropsBlock2.func_185526_g();
                int k1 = j1 / 3;
                this.func_175811_a(world, (BlockState)this.cropTypeC.func_206870_a((IProperty)CropsBlock2.func_185524_e(), (Comparable)Integer.valueOf(MathHelper.func_76136_a((Random)random, (int)k1, (int)j1))), 7, 1, i, structureBoundingBoxIn);
                this.func_175811_a(world, (BlockState)this.cropTypeC.func_206870_a((IProperty)CropsBlock2.func_185524_e(), (Comparable)Integer.valueOf(MathHelper.func_76136_a((Random)random, (int)k1, (int)j1))), 8, 1, i, structureBoundingBoxIn);
                CropsBlock2 = (CropsBlock)this.cropTypeD.func_177230_c();
                int l1 = CropsBlock2.func_185526_g();
                int i2 = l1 / 3;
                this.func_175811_a(world, (BlockState)this.cropTypeD.func_206870_a((IProperty)CropsBlock2.func_185524_e(), (Comparable)Integer.valueOf(MathHelper.func_76136_a((Random)random, (int)i2, (int)l1))), 10, 1, i, structureBoundingBoxIn);
                this.func_175811_a(world, (BlockState)this.cropTypeD.func_206870_a((IProperty)CropsBlock2.func_185524_e(), (Comparable)Integer.valueOf(MathHelper.func_76136_a((Random)random, (int)i2, (int)l1))), 11, 1, i, structureBoundingBoxIn);
            }
            for (int j2 = 0; j2 < 9; ++j2) {
                for (int k2 = 0; k2 < 13; ++k2) {
                    this.clearCurrentPositionBlocksUpwards(world, k2, 4, j2, structureBoundingBoxIn);
                    this.func_175808_b(world, Blocks.field_150346_d.func_176223_P(), k2, -1, j2, structureBoundingBoxIn);
                }
            }
            return true;
        }
    }

    public static class Church
    extends Village {
        protected Church(Start start, int type, Random rand, MutableBoundingBox boundingBoxIn, Direction facing) {
            super(start, StructureInitUA.VISTUA, type);
            this.func_186164_a(facing);
            this.field_74887_e = boundingBoxIn;
        }

        public Church(TemplateManager p_i50111_1_, CompoundNBT p_i50111_2_) {
            super(StructureInitUA.VISTUA, p_i50111_2_);
        }

        public static Church createPiece(Start start, List<StructurePiece> p_175854_1_, Random rand, int p_175854_3_, int p_175854_4_, int p_175854_5_, Direction facing, int p_175854_7_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175854_3_, (int)p_175854_4_, (int)p_175854_5_, (int)0, (int)0, (int)0, (int)5, (int)12, (int)9, (Direction)facing);
            return Church.canVillageGoDeeper(mutableboundingbox) && StructurePiece.func_74883_a(p_175854_1_, (MutableBoundingBox)mutableboundingbox) == null ? new Church(start, p_175854_7_, rand, mutableboundingbox, facing) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            int j;
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getBestGroundLevel(world, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 12 - 1, 0);
            }
            BlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_196698_dj.func_176223_P());
            BlockState iblockstate1 = this.getBiomeSpecificBlockState((BlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.NORTH));
            BlockState iblockstate2 = this.getBiomeSpecificBlockState((BlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.WEST));
            BlockState iblockstate3 = this.getBiomeSpecificBlockState((BlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.EAST));
            this.func_175804_a(world, structureBoundingBoxIn, 1, 1, 1, 3, 3, 7, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 5, 1, 3, 9, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 0, 0, 3, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 1, 0, 3, 10, 0, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 1, 1, 0, 10, 3, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 4, 1, 1, 4, 10, 3, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 0, 4, 0, 4, 7, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 4, 0, 4, 4, 4, 7, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 1, 8, 3, 4, 8, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 5, 4, 3, 10, 4, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 1, 5, 5, 3, 5, 7, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 9, 0, 4, 9, 4, iblockstate, iblockstate, false);
            this.func_175804_a(world, structureBoundingBoxIn, 0, 4, 0, 4, 4, 4, iblockstate, iblockstate, false);
            this.func_175811_a(world, iblockstate, 0, 11, 2, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 4, 11, 2, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 2, 11, 0, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 2, 11, 4, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 1, 1, 6, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 1, 1, 7, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 2, 1, 7, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 3, 1, 6, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 3, 1, 7, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate1, 1, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate1, 2, 1, 6, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate1, 3, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_150382_bo.func_176223_P(), 2, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate2, 1, 2, 7, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate3, 3, 2, 7, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 0, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 4, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 4, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 0, 6, 2, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 0, 7, 2, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 4, 6, 2, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 4, 7, 2, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 2, 6, 0, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 2, 7, 0, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 2, 6, 4, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 2, 7, 4, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 0, 3, 6, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 4, 3, 6, structureBoundingBoxIn);
            this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 2, 3, 8, structureBoundingBoxIn);
            this.placeTorch(world, Direction.SOUTH, 2, 4, 7, structureBoundingBoxIn);
            this.placeTorch(world, Direction.EAST, 1, 4, 6, structureBoundingBoxIn);
            this.placeTorch(world, Direction.WEST, 3, 4, 6, structureBoundingBoxIn);
            this.placeTorch(world, Direction.NORTH, 2, 4, 5, structureBoundingBoxIn);
            BlockState iblockstate4 = (BlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a((IProperty)LadderBlock.field_176382_a, (Comparable)Direction.WEST);
            TileEntity tileentity = world.func_175625_s(new BlockPos(this.func_74865_a(2, 5), this.func_74862_a(1), this.func_74873_b(2, 5)));
            if (tileentity instanceof BrewingStandTileEntity) {
                int potionSlot = 1 + random.nextInt(3);
                for (j = 0; j < potionSlot; ++j) {
                    int potionType = random.nextInt(9);
                    ItemStack potion = null;
                    if (potionType < 6) {
                        potion = new ItemStack((IItemProvider)Items.field_151068_bn);
                        PotionUtils.func_185188_a((ItemStack)potion, (Potion)Potions.field_185240_l);
                    } else if (potionType < 7) {
                        potion = new ItemStack((IItemProvider)Items.field_151068_bn);
                        PotionUtils.func_185188_a((ItemStack)potion, (Potion)Potions.field_185219_B);
                    } else {
                        potion = new ItemStack((IItemProvider)Items.field_151068_bn);
                        PotionUtils.func_185188_a((ItemStack)potion, (Potion)Potions.field_185235_g);
                    }
                    ((BrewingStandTileEntity)tileentity).func_70299_a(j, potion);
                }
            }
            for (int i = 1; i <= 9; ++i) {
                this.func_175811_a(world, iblockstate4, 3, i, 3, structureBoundingBoxIn);
            }
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, structureBoundingBoxIn);
            this.createVillageDoor(world, structureBoundingBoxIn, random, 2, 1, 0, Direction.NORTH);
            if (this.func_175807_a((IBlockReader)world, 2, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a((IBlockReader)world, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(world, iblockstate1, 2, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a((IBlockReader)world, 2, -1, -1, structureBoundingBoxIn).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(world, Blocks.field_196658_i.func_176223_P(), 2, -1, -1, structureBoundingBoxIn);
                }
            }
            for (int k = 0; k < 9; ++k) {
                for (j = 0; j < 5; ++j) {
                    this.clearCurrentPositionBlocksUpwards(world, j, 12, k, structureBoundingBoxIn);
                    this.func_175808_b(world, iblockstate, j, -1, k, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(world, structureBoundingBoxIn, 2, 1, 2, 1, random);
            return true;
        }

        protected int chooseProfession(int villagersSpawnedIn, int currentVillagerProfession) {
            return 2;
        }
    }
}

