/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import com.mojang.datafixers.Dynamic;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.structure.VillagePieces;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.feature.UAFeatures;
import net.telepathicgrunt.ultraamplified.world.feature.structure.VillageConfigUA;
import net.telepathicgrunt.ultraamplified.world.feature.structure.VillagePastStyledPiecesUA;

public class VillageStructureUA
extends Structure<VillageConfigUA> {
    public VillageStructureUA(Function<Dynamic<?>, ? extends VillageConfigUA> p_i51427_1_) {
        super(p_i51427_1_);
    }

    public String func_143025_a() {
        return "ultra_amplified_dimension:village";
    }

    public int func_202367_b() {
        return 8;
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int maxDistance = UltraAmplified.UAConfig.villageSpawnrate.get();
        int minDistance = 8;
        if (maxDistance < 9) {
            minDistance = maxDistance - 1;
        }
        int k = x + maxDistance * spacingOffsetsX;
        int l = z + maxDistance * spacingOffsetsZ;
        int i1 = k < 0 ? k - maxDistance + 1 : k;
        int j1 = l < 0 ? l - maxDistance + 1 : l;
        int k1 = i1 / maxDistance;
        int l1 = j1 / maxDistance;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), k1, l1, 10387312);
        k1 *= maxDistance;
        l1 *= maxDistance;
        return new ChunkPos(k1 += random.nextInt(maxDistance - minDistance), l1 += random.nextInt(maxDistance - minDistance));
    }

    public boolean func_225558_a_(BiomeManager p_225558_1_, ChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ, Biome biome) {
        ChunkPos chunkpos = this.func_211744_a(chunkGen, rand, chunkPosX, chunkPosZ, 0, 0);
        return chunkPosX == chunkpos.field_77276_a && chunkPosZ == chunkpos.field_77275_b && UltraAmplified.UAConfig.villageSpawnrate.get() != 101 && chunkGen.func_202094_a(biome, UAFeatures.VILLAGE);
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            VillageConfigUA villageconfig = (VillageConfigUA)generator.func_202087_b(biomeIn, UAFeatures.VILLAGE);
            VillageConfig vanillaVillageConfig = new VillageConfig("village/plains/town_centers", 6);
            boolean genVanillaVillage = false;
            if (villageconfig.type == VillagePastStyledPiecesUA.Type.OAK) {
                genVanillaVillage = true;
            } else if (villageconfig.type == VillagePastStyledPiecesUA.Type.SANDSTONE) {
                vanillaVillageConfig = new VillageConfig("village/desert/town_centers", 6);
                genVanillaVillage = true;
            } else if (villageconfig.type == VillagePastStyledPiecesUA.Type.ACACIA) {
                vanillaVillageConfig = new VillageConfig("village/savanna/town_centers", 6);
                genVanillaVillage = true;
            } else if (villageconfig.type == VillagePastStyledPiecesUA.Type.SNOWYSPRUCE) {
                vanillaVillageConfig = new VillageConfig("village/snowy/town_centers", 6);
                genVanillaVillage = true;
            } else if (villageconfig.type == VillagePastStyledPiecesUA.Type.SPRUCE) {
                vanillaVillageConfig = new VillageConfig("village/taiga/town_centers", 6);
                genVanillaVillage = true;
            }
            if (genVanillaVillage) {
                BlockPos blockpos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
                VillagePieces.func_214838_a(generator, (TemplateManager)templateManagerIn, (BlockPos)blockpos, (List)this.field_75075_a, (SharedSeedRandom)this.field_214631_d, (VillageConfig)vanillaVillageConfig);
                this.func_202500_a();
            } else {
                List<VillagePastStyledPiecesUA.PieceWeightUA> list = VillagePastStyledPiecesUA.getStructureVillageWeightedPieceList((Random)this.field_214631_d, this.field_214631_d.nextInt(3));
                VillagePastStyledPiecesUA.Start villagepiecesua$start = new VillagePastStyledPiecesUA.Start(0, (Random)this.field_214631_d, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageconfig, biomeIn);
                this.field_75075_a.add(villagepiecesua$start);
                villagepiecesua$start.func_74861_a(villagepiecesua$start, this.field_75075_a, (Random)this.field_214631_d);
                List<StructurePiece> list1 = villagepiecesua$start.pendingRoads;
                List<StructurePiece> list2 = villagepiecesua$start.pendingHouses;
                while (!list1.isEmpty() || !list2.isEmpty()) {
                    if (list1.isEmpty()) {
                        int i = this.field_214631_d.nextInt(list2.size());
                        StructurePiece structurepiece = list2.remove(i);
                        structurepiece.func_74861_a((StructurePiece)villagepiecesua$start, this.field_75075_a, (Random)this.field_214631_d);
                        continue;
                    }
                    int j = this.field_214631_d.nextInt(list1.size());
                    StructurePiece structurepiece2 = list1.remove(j);
                    structurepiece2.func_74861_a((StructurePiece)villagepiecesua$start, this.field_75075_a, (Random)this.field_214631_d);
                }
            }
            this.func_202500_a();
        }
    }
}

