/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.generation;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.biome.UABiomes;

public enum BiomeGenHelper {
    instance;

    public static ForgeRegistry<Biome> BiomeRegistry;
    public static final int PLAINS;
    public static final int SWAMP;
    public static final int FOREST;
    public static final int DESERT;
    public static final int WOODED_ROCKY_FIELD;
    public static final int RELIC_FOREST;
    public static final int SNOWY_TUNDRA;
    public static final int ICED_TERRAIN;
    public static final int BAMBOO_JUNGLE;
    public static final int JUNGLE;
    public static final int JUNGLE_EDGE;
    public static final int BADLANDS;
    public static final int WOODED_BADLANDS;
    public static final int SANDLESS_BADLANDS;
    public static final int MUSHROOM_FIELDS;
    public static final int GIANT_TREE_TAIGA;
    public static final int DARK_FOREST;
    public static final int SAVANNA;
    public static final int TAIGA;
    public static final int SNOWY_TAIGA;
    public static final int WARM_OCEAN;
    public static final int LUKEWARM_OCEAN;
    public static final int OCEAN;
    public static final int COLD_OCEAN;
    public static final int FROZEN_OCEAN;
    public static final int DEEP_WARM_OCEAN;
    public static final int DEEP_LUKEWARM_OCEAN;
    public static final int DEEP_OCEAN;
    public static final int DEEP_COLD_OCEAN;
    public static final int DEEP_FROZEN_OCEAN;
    public static final int SUNFLOWER_PLAINS;
    public static final int NETHERLAND;
    public static final int END_FIELD;
    public static final int BARREN_END_FIELD;
    public static final int FROZEN_DESERT;
    public static final int STONE_PLAINS;
    public static final int VANILLA_OCEAN;
    public static final int VANILLA_DEEP_OCEAN;
    public static Set<Biome> frozenBiomes;
    public static Set<Biome> coldOceanBiomes;
    private static final Set<Biome> OCEAN_LIST;
    public static final Map<Pair<Integer, Integer>, Integer> biomesComboToEdge;

    public static void setBiomeEdgeMap() {
        biomesComboToEdge.clear();
        if (UltraAmplified.UAConfig.rockyField.get().booleanValue()) {
            biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)DESERT, (Object)SNOWY_TUNDRA), WOODED_ROCKY_FIELD);
        }
        if (UltraAmplified.UAConfig.plains.get().booleanValue()) {
            biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)SWAMP, (Object)DESERT), PLAINS);
            biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)SWAMP, (Object)SNOWY_TUNDRA), PLAINS);
            biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)SWAMP, (Object)SNOWY_TAIGA), PLAINS);
        }
        for (Biome biome : BiomeRegistry) {
            int biomeID = BiomeRegistry.getID((IForgeRegistryEntry)biome);
            if (UltraAmplified.UAConfig.savanna.get().booleanValue() && biomeID != NETHERLAND && biomeID != SAVANNA) {
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)NETHERLAND, (Object)biomeID), SAVANNA);
            }
            if (biomeID != END_FIELD && biomeID != BARREN_END_FIELD) {
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)biomeID, (Object)END_FIELD), BARREN_END_FIELD);
            }
            if (biomeID != JUNGLE && biomeID != BAMBOO_JUNGLE) {
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)JUNGLE, (Object)biomeID), JUNGLE_EDGE);
            }
            if (UltraAmplified.UAConfig.frozenDesert.get().booleanValue() && ((Biome)BiomeRegistry.getValue(biomeID)).func_201856_r() == Biome.Category.ICY && !BiomeGenHelper.isOcean(biomeID)) {
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)VANILLA_OCEAN, (Object)biomeID), FROZEN_DESERT);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)VANILLA_DEEP_OCEAN, (Object)biomeID), FROZEN_DESERT);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)WARM_OCEAN, (Object)biomeID), FROZEN_DESERT);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)LUKEWARM_OCEAN, (Object)biomeID), FROZEN_DESERT);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)OCEAN, (Object)biomeID), FROZEN_DESERT);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)COLD_OCEAN, (Object)biomeID), FROZEN_DESERT);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)FROZEN_OCEAN, (Object)biomeID), FROZEN_DESERT);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)DEEP_WARM_OCEAN, (Object)biomeID), FROZEN_DESERT);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)DEEP_LUKEWARM_OCEAN, (Object)biomeID), FROZEN_DESERT);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)DEEP_OCEAN, (Object)biomeID), FROZEN_DESERT);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)DEEP_COLD_OCEAN, (Object)biomeID), FROZEN_DESERT);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)DEEP_FROZEN_OCEAN, (Object)biomeID), FROZEN_DESERT);
            }
            if (UltraAmplified.UAConfig.stonePlains.get().booleanValue() && ((Biome)BiomeRegistry.getValue(biomeID)).func_201856_r() == Biome.Category.EXTREME_HILLS) {
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)VANILLA_OCEAN, (Object)biomeID), STONE_PLAINS);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)VANILLA_DEEP_OCEAN, (Object)biomeID), STONE_PLAINS);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)WARM_OCEAN, (Object)biomeID), STONE_PLAINS);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)LUKEWARM_OCEAN, (Object)biomeID), STONE_PLAINS);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)OCEAN, (Object)biomeID), STONE_PLAINS);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)COLD_OCEAN, (Object)biomeID), STONE_PLAINS);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)FROZEN_OCEAN, (Object)biomeID), STONE_PLAINS);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)DEEP_WARM_OCEAN, (Object)biomeID), STONE_PLAINS);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)DEEP_LUKEWARM_OCEAN, (Object)biomeID), STONE_PLAINS);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)DEEP_OCEAN, (Object)biomeID), STONE_PLAINS);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)DEEP_COLD_OCEAN, (Object)biomeID), STONE_PLAINS);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)DEEP_FROZEN_OCEAN, (Object)biomeID), STONE_PLAINS);
            }
            if (biomeID != WOODED_BADLANDS && biomeID != SANDLESS_BADLANDS) {
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)WOODED_BADLANDS, (Object)biomeID), BADLANDS);
                biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)SANDLESS_BADLANDS, (Object)biomeID), BADLANDS);
            }
            if (((Biome)BiomeRegistry.getValue(biomeID)).func_201856_r() == Biome.Category.TAIGA) continue;
            biomesComboToEdge.put((Pair<Integer, Integer>)new Pair((Object)GIANT_TREE_TAIGA, (Object)biomeID), TAIGA);
        }
    }

    public static boolean isOcean(Biome biomeIn) {
        return OCEAN_LIST.contains(biomeIn);
    }

    public static boolean isOcean(int biomeIn) {
        return biomeIn == VANILLA_OCEAN || biomeIn == VANILLA_DEEP_OCEAN || biomeIn == WARM_OCEAN || biomeIn == LUKEWARM_OCEAN || biomeIn == OCEAN || biomeIn == COLD_OCEAN || biomeIn == FROZEN_OCEAN || biomeIn == DEEP_WARM_OCEAN || biomeIn == DEEP_LUKEWARM_OCEAN || biomeIn == DEEP_OCEAN || biomeIn == DEEP_COLD_OCEAN || biomeIn == DEEP_FROZEN_OCEAN;
    }

    public static boolean isShallowOcean(int biomeIn) {
        return biomeIn == VANILLA_OCEAN || biomeIn == WARM_OCEAN || biomeIn == LUKEWARM_OCEAN || biomeIn == OCEAN || biomeIn == COLD_OCEAN || biomeIn == FROZEN_OCEAN;
    }

    public static boolean areUABiomesSimilar(int biome1ID, int biome2ID) {
        if (biome1ID == biome2ID) {
            return true;
        }
        Biome biome1 = (Biome)BiomeRegistry.getValue(biome1ID);
        Biome biome2 = (Biome)BiomeRegistry.getValue(biome2ID);
        if (biome1 != null && biome2 != null) {
            return biome1.func_201856_r() == biome2.func_201856_r();
        }
        return false;
    }

    static {
        BiomeRegistry = (ForgeRegistry)ForgeRegistries.BIOMES;
        PLAINS = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.PLAINS);
        SWAMP = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.SWAMP);
        FOREST = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.FOREST);
        DESERT = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.DESERT);
        WOODED_ROCKY_FIELD = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.WOODED_ROCKY_FIELD);
        RELIC_FOREST = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.RELIC_FOREST);
        SNOWY_TUNDRA = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.SNOWY_TUNDRA);
        ICED_TERRAIN = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.ICED_TERRAIN);
        BAMBOO_JUNGLE = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.BAMBOO_JUNGLE);
        JUNGLE = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.JUNGLE);
        JUNGLE_EDGE = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.JUNGLE_EDGE);
        BADLANDS = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.BADLANDS);
        WOODED_BADLANDS = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.WOODED_BADLANDS);
        SANDLESS_BADLANDS = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.SANDLESS_BADLANDS);
        MUSHROOM_FIELDS = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.MUSHROOM_FIELDS);
        GIANT_TREE_TAIGA = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.GIANT_TREE_TAIGA);
        DARK_FOREST = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.DARK_FOREST);
        SAVANNA = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.SAVANNA);
        TAIGA = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.TAIGA);
        SNOWY_TAIGA = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.SNOWY_TAIGA);
        WARM_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.WARM_OCEAN);
        LUKEWARM_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.LUKEWARM_OCEAN);
        OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.OCEAN);
        COLD_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.COLD_OCEAN);
        FROZEN_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.FROZEN_OCEAN);
        DEEP_WARM_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.DEEP_WARM_OCEAN);
        DEEP_LUKEWARM_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.DEEP_LUKEWARM_OCEAN);
        DEEP_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.DEEP_OCEAN);
        DEEP_COLD_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.DEEP_COLD_OCEAN);
        DEEP_FROZEN_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.DEEP_FROZEN_OCEAN);
        SUNFLOWER_PLAINS = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.SUNFLOWER_PLAINS);
        NETHERLAND = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.NETHERLAND);
        END_FIELD = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.END_FIELD);
        BARREN_END_FIELD = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.BARREN_END_FIELD);
        FROZEN_DESERT = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.FROZEN_DESERT);
        STONE_PLAINS = BiomeRegistry.getID((IForgeRegistryEntry)UABiomes.STONE_PLAINS);
        VANILLA_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)Biomes.field_76771_b);
        VANILLA_DEEP_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)Biomes.field_150575_M);
        frozenBiomes = ImmutableSet.of((Object)UABiomes.DEEP_FROZEN_OCEAN, (Object)UABiomes.FROZEN_OCEAN, (Object)UABiomes.ICE_SPIKES, (Object)UABiomes.FROZEN_DESERT, (Object)UABiomes.SNOWY_TAIGA, (Object)UABiomes.RELIC_SNOWY_TAIGA, (Object[])new Biome[]{UABiomes.SNOWY_ROCKY_TAIGA, UABiomes.SNOWY_TUNDRA});
        coldOceanBiomes = ImmutableSet.of((Object)UABiomes.DEEP_COLD_OCEAN, (Object)UABiomes.COLD_OCEAN);
        OCEAN_LIST = ImmutableSet.of((Object)UABiomes.WARM_OCEAN, (Object)UABiomes.LUKEWARM_OCEAN, (Object)UABiomes.OCEAN, (Object)UABiomes.COLD_OCEAN, (Object)UABiomes.FROZEN_OCEAN, (Object)UABiomes.DEEP_WARM_OCEAN, (Object[])new Biome[]{UABiomes.DEEP_LUKEWARM_OCEAN, UABiomes.DEEP_OCEAN, UABiomes.DEEP_COLD_OCEAN, UABiomes.DEEP_FROZEN_OCEAN});
        biomesComboToEdge = new HashMap<Pair<Integer, Integer>, Integer>();
    }
}

