/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.generation;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.feature.UAFeatures;

public abstract class UANoiseChunkGenerator<T extends GenerationSettings>
extends ChunkGenerator<T> {
    private static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    private static final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    private static final BlockState LAVA = Blocks.field_150353_l.func_176223_P();
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final float[] field_222561_h = (float[])Util.func_200696_a((Object)new float[13824], p_222557_0_ -> {
        for (int i = 0; i < 24; ++i) {
            for (int j = 0; j < 24; ++j) {
                for (int k = 0; k < 24; ++k) {
                    p_222557_0_[i * 24 * 24 + j * 24 + k] = (float)UANoiseChunkGenerator.func_222554_b(j - 12, k - 12, i - 12);
                }
            }
        }
    });
    private final int verticalNoiseGranularity;
    private final int horizontalNoiseGranularity;
    private final int noiseSizeX;
    private final int noiseSizeY;
    private final int noiseSizeZ;
    protected final SharedSeedRandom randomSeed;
    private final OctavesNoiseGenerator minNoise;
    private final OctavesNoiseGenerator maxNoise;
    private final OctavesNoiseGenerator mainNoise;
    private final INoiseGenerator surfaceDepthNoise;
    protected final BlockState defaultBlock;
    protected final BlockState defaultFluid;

    public UANoiseChunkGenerator(IWorld p_i49931_1_, BiomeProvider p_i49931_2_, int horizontalNoiseGranularityIn, int verticalNoiseGranularityIn, int p_i49931_5_, T p_i49931_6_) {
        super(p_i49931_1_, p_i49931_2_, p_i49931_6_);
        this.verticalNoiseGranularity = verticalNoiseGranularityIn;
        this.horizontalNoiseGranularity = horizontalNoiseGranularityIn;
        this.defaultBlock = STONE;
        this.defaultFluid = UltraAmplified.UAConfig.lavaOcean.get() != false ? LAVA : WATER;
        this.noiseSizeX = 16 / this.horizontalNoiseGranularity;
        this.noiseSizeY = p_i49931_5_ / this.verticalNoiseGranularity;
        this.noiseSizeZ = 16 / this.horizontalNoiseGranularity;
        this.randomSeed = new SharedSeedRandom(this.field_222541_b);
        this.minNoise = new OctavesNoiseGenerator(this.randomSeed, 15, 0);
        this.maxNoise = new OctavesNoiseGenerator(this.randomSeed, 15, 0);
        this.mainNoise = new OctavesNoiseGenerator(this.randomSeed, 7, 0);
        this.surfaceDepthNoise = new PerlinNoiseGenerator(this.randomSeed, 3, 0);
    }

    private double internalSetupPerlinNoiseGenerators(int x, int y, int z, double getCoordinateScale, double getHeightScale, double getMainCoordinateScale, double getMainHeightScale, double p_222552_10_) {
        double d0 = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        for (int i = 0; i < 16; ++i) {
            double limitX = OctavesNoiseGenerator.func_215461_a((double)((double)x * getCoordinateScale * d3));
            double limitY = OctavesNoiseGenerator.func_215461_a((double)((double)y * getHeightScale * d3));
            double limitZ = OctavesNoiseGenerator.func_215461_a((double)((double)z * getCoordinateScale * d3));
            double mainX = OctavesNoiseGenerator.func_215461_a((double)((double)x * getMainCoordinateScale * d3));
            double mainY = OctavesNoiseGenerator.func_215461_a((double)((double)y * getMainHeightScale * d3));
            double mainZ = OctavesNoiseGenerator.func_215461_a((double)((double)z * getMainCoordinateScale * d3));
            double d7 = (double)684.412f * d3;
            d0 += this.minNoise.func_215463_a(i).func_215456_a(limitX, limitY, limitZ, d7, (double)y * d7) / d3;
            d1 += this.maxNoise.func_215463_a(i).func_215456_a(limitX, limitY, limitZ, d7, (double)y * d7) / d3;
            if (i < 8) {
                d2 += this.mainNoise.func_215463_a(i).func_215456_a(mainX, mainY, mainZ, p_222552_10_ * d3, (double)y * p_222552_10_ * d3) / d3;
            }
            d3 /= 2.0;
        }
        return MathHelper.func_151238_b((double)(d0 / 512.0), (double)(d1 / 512.0), (double)((d2 / 10.0 + 1.0) / 2.0));
    }

    protected double[] func_222547_b(int p_222547_1_, int p_222547_2_) {
        double[] adouble = new double[this.noiseSizeY + 1];
        this.fillNoiseColumn(adouble, p_222547_1_, p_222547_2_);
        return adouble;
    }

    protected void setupPerlinNoiseGenerators(double[] areaArrayIn, int x, int z, double getCoordinateScale, double getHeightScale, double getMainCoordinateScale, double getMainHeightScale, double p_222546_8_, double p_222546_10_, int p_222546_12_, int p_222546_13_) {
        double[] localAreaArray = this.getBiomeNoiseColumn(x, z);
        double d0 = localAreaArray[0];
        double d1 = localAreaArray[1];
        double d2 = this.func_222551_g();
        double d3 = this.func_222553_h();
        for (int y = 0; y < this.noiseSizeY(); ++y) {
            double d4 = this.internalSetupPerlinNoiseGenerators(x, y, z, getCoordinateScale, getHeightScale, getMainCoordinateScale, getMainHeightScale, p_222546_10_);
            d4 -= this.func_222545_a(d0, d1, y);
            if ((double)y > d2) {
                d4 = MathHelper.func_151238_b((double)d4, (double)p_222546_13_, (double)(((double)y - d2) / (double)p_222546_12_));
            } else if ((double)y < d3) {
                d4 = MathHelper.func_151238_b((double)d4, (double)-30.0, (double)((d3 - (double)y) / (d3 - 1.0)));
            }
            areaArrayIn[y] = d4;
        }
    }

    protected abstract double[] getBiomeNoiseColumn(int var1, int var2);

    protected abstract double func_222545_a(double var1, double var3, int var5);

    protected double func_222551_g() {
        return this.noiseSizeY() - 4;
    }

    protected double func_222553_h() {
        return 0.0;
    }

    public int func_222529_a(int chunkX, int chunkZ, Heightmap.Type heightmapType) {
        int i = Math.floorDiv(chunkX, this.horizontalNoiseGranularity);
        int j = Math.floorDiv(chunkZ, this.horizontalNoiseGranularity);
        int k = Math.floorMod(chunkX, this.horizontalNoiseGranularity);
        int l = Math.floorMod(chunkZ, this.horizontalNoiseGranularity);
        double d0 = (double)k / (double)this.horizontalNoiseGranularity;
        double d1 = (double)l / (double)this.horizontalNoiseGranularity;
        double[][] adouble = new double[][]{this.func_222547_b(i, j), this.func_222547_b(i, j + 1), this.func_222547_b(i + 1, j), this.func_222547_b(i + 1, j + 1)};
        int seaLevel = UltraAmplified.UAConfig.seaLevel.get();
        for (int j1 = this.noiseSizeY - 1; j1 >= 0; --j1) {
            double d2 = adouble[0][j1];
            double d3 = adouble[1][j1];
            double d4 = adouble[2][j1];
            double d5 = adouble[3][j1];
            double d6 = adouble[0][j1 + 1];
            double d7 = adouble[1][j1 + 1];
            double d8 = adouble[2][j1 + 1];
            double d9 = adouble[3][j1 + 1];
            for (int k1 = this.verticalNoiseGranularity - 1; k1 >= 0; --k1) {
                double d10 = (double)k1 / (double)this.verticalNoiseGranularity;
                double d11 = MathHelper.func_219807_a((double)d10, (double)d0, (double)d1, (double)d2, (double)d6, (double)d4, (double)d8, (double)d3, (double)d7, (double)d5, (double)d9);
                int y = j1 * this.verticalNoiseGranularity + k1;
                if (!(d11 > 0.0) && y >= seaLevel) continue;
                BlockState blockstate = d11 > 0.0 ? this.defaultBlock : this.defaultFluid;
                if (!heightmapType.func_222684_d().test(blockstate)) continue;
                return y + 1;
            }
        }
        return 0;
    }

    protected abstract void fillNoiseColumn(double[] var1, int var2, int var3);

    public int noiseSizeY() {
        return this.noiseSizeY + 1;
    }

    public void func_225551_a_(WorldGenRegion region, IChunk chunk) {
        ChunkPos chunkpos = chunk.func_76632_l();
        int i = chunkpos.field_77276_a;
        int j = chunkpos.field_77275_b;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202422_a(i, j);
        ChunkPos chunkpos1 = chunk.func_76632_l();
        int k = chunkpos1.func_180334_c();
        int l = chunkpos1.func_180333_d();
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i1 = 0; i1 < 16; ++i1) {
            for (int j1 = 0; j1 < 16; ++j1) {
                int k1 = k + i1;
                int l1 = l + j1;
                int i2 = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, i1, j1) + 1;
                double d1 = this.surfaceDepthNoise.func_215460_a((double)k1 * 0.0625, (double)l1 * 0.0625, 0.0625, (double)i1 * 0.0625) * 10.0;
                region.func_226691_t_((BlockPos)blockpos$mutable.func_181079_c(k + i1, i2, l + j1)).func_206854_a((Random)sharedseedrandom, chunk, k1, l1, i2, d1, this.defaultBlock, this.defaultFluid, UltraAmplified.UAConfig.seaLevel.get().intValue(), this.field_222540_a.func_72905_C());
            }
        }
        this.makeBedrock(chunk, (Random)sharedseedrandom);
    }

    protected void makeBedrock(IChunk chunk, Random random) {
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
        int i = chunk.func_76632_l().func_180334_c();
        int j = chunk.func_76632_l().func_180333_d();
        GenerationSettings t = this.func_201496_a_();
        int k = t.func_214968_u();
        int l = t.func_214967_t();
        for (BlockPos blockpos : BlockPos.func_191531_b((int)i, (int)0, (int)j, (int)(i + 15), (int)0, (int)(j + 15))) {
            if (l > 0) {
                for (int i1 = l; i1 >= l - 4; --i1) {
                    if (i1 < l - random.nextInt(5)) continue;
                    chunk.func_177436_a((BlockPos)blockpos$Mutable.func_181079_c(blockpos.func_177958_n(), i1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
                }
            }
            if (k >= 256) continue;
            for (int j1 = k + 4; j1 >= k; --j1) {
                if (j1 > k + random.nextInt(5)) continue;
                chunk.func_177436_a((BlockPos)blockpos$Mutable.func_181079_c(blockpos.func_177958_n(), j1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
            }
        }
    }

    public void func_222537_b(IWorld world, IChunk chunk) {
        ObjectArrayList objectlist = new ObjectArrayList(10);
        ObjectArrayList objectlist1 = new ObjectArrayList(32);
        ChunkPos chunkpos = chunk.func_76632_l();
        int chunkX = chunkpos.field_77276_a;
        int chunkZ = chunkpos.field_77275_b;
        int coordinateX = chunkX << 4;
        int coordinateZ = chunkZ << 4;
        for (Structure<?> structure : UAFeatures.ILLAGER_STRUCTURES) {
            String s = structure.func_143025_a();
            LongIterator longiterator = chunk.func_201578_b(s).iterator();
            while (longiterator.hasNext()) {
                long j1 = longiterator.nextLong();
                ChunkPos chunkpos1 = new ChunkPos(j1);
                IChunk ichunk = world.func_212866_a_(chunkpos1.field_77276_a, chunkpos1.field_77275_b);
                StructureStart structurestart = ichunk.func_201585_a(s);
                if (structurestart == null || !structurestart.func_75069_d()) continue;
                for (StructurePiece structurepiece : structurestart.func_186161_c()) {
                    if (!structurepiece.func_214810_a(chunkpos, 12) || !(structurepiece instanceof AbstractVillagePiece)) continue;
                    AbstractVillagePiece abstractvillagepiece = (AbstractVillagePiece)structurepiece;
                    JigsawPattern.PlacementBehaviour jigsawpattern$placementbehaviour = abstractvillagepiece.func_214826_b().func_214854_c();
                    if (jigsawpattern$placementbehaviour == JigsawPattern.PlacementBehaviour.RIGID) {
                        objectlist.add((Object)abstractvillagepiece);
                    }
                    for (JigsawJunction jigsawjunction : abstractvillagepiece.func_214829_e()) {
                        int k1 = jigsawjunction.func_214895_a();
                        int l1 = jigsawjunction.func_214893_c();
                        if (k1 <= coordinateX - 12 || l1 <= coordinateZ - 12 || k1 >= coordinateX + 15 + 12 || l1 >= coordinateZ + 15 + 12) continue;
                        objectlist1.add((Object)jigsawjunction);
                    }
                }
            }
        }
        double[][][] adouble = new double[2][this.noiseSizeZ + 1][this.noiseSizeY + 1];
        for (int j5 = 0; j5 < this.noiseSizeZ + 1; ++j5) {
            adouble[0][j5] = new double[this.noiseSizeY + 1];
            this.fillNoiseColumn(adouble[0][j5], chunkX * this.noiseSizeX, chunkZ * this.noiseSizeZ + j5);
            adouble[1][j5] = new double[this.noiseSizeY + 1];
        }
        ChunkPrimer chunkprimer = (ChunkPrimer)chunk;
        Heightmap heightmap = chunkprimer.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = chunkprimer.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
        ObjectListIterator objectlistiterator = objectlist.iterator();
        ObjectListIterator objectlistiterator1 = objectlist1.iterator();
        for (int k5 = 0; k5 < this.noiseSizeX; ++k5) {
            for (int l5 = 0; l5 < this.noiseSizeZ + 1; ++l5) {
                this.fillNoiseColumn(adouble[1][l5], chunkX * this.noiseSizeX + k5 + 1, chunkZ * this.noiseSizeZ + l5);
            }
            for (int i6 = 0; i6 < this.noiseSizeZ; ++i6) {
                ChunkSection chunksection = chunkprimer.func_217332_a(15);
                chunksection.func_222635_a();
                for (int j6 = this.noiseSizeY - 1; j6 >= 0; --j6) {
                    double d16 = adouble[0][i6][j6];
                    double d17 = adouble[0][i6 + 1][j6];
                    double d18 = adouble[1][i6][j6];
                    double d0 = adouble[1][i6 + 1][j6];
                    double d1 = adouble[0][i6][j6 + 1];
                    double d2 = adouble[0][i6 + 1][j6 + 1];
                    double d3 = adouble[1][i6][j6 + 1];
                    double d4 = adouble[1][i6 + 1][j6 + 1];
                    for (int i2 = this.verticalNoiseGranularity - 1; i2 >= 0; --i2) {
                        int currentY = j6 * this.verticalNoiseGranularity + i2;
                        int y = currentY & 0xF;
                        int l2 = currentY >> 4;
                        if (chunksection.func_222632_g() >> 4 != l2) {
                            chunksection.func_222637_b();
                            chunksection = chunkprimer.func_217332_a(l2);
                            chunksection.func_222635_a();
                        }
                        double d5 = (double)i2 / (double)this.verticalNoiseGranularity;
                        double d6 = MathHelper.func_219803_d((double)d5, (double)d16, (double)d1);
                        double d7 = MathHelper.func_219803_d((double)d5, (double)d18, (double)d3);
                        double d8 = MathHelper.func_219803_d((double)d5, (double)d17, (double)d2);
                        double d9 = MathHelper.func_219803_d((double)d5, (double)d0, (double)d4);
                        for (int i3 = 0; i3 < this.horizontalNoiseGranularity; ++i3) {
                            int j3 = coordinateX + k5 * this.horizontalNoiseGranularity + i3;
                            int x = j3 & 0xF;
                            double d10 = (double)i3 / (double)this.horizontalNoiseGranularity;
                            double d11 = MathHelper.func_219803_d((double)d10, (double)d6, (double)d7);
                            double d12 = MathHelper.func_219803_d((double)d10, (double)d8, (double)d9);
                            for (int l3 = 0; l3 < this.horizontalNoiseGranularity; ++l3) {
                                int l4;
                                int k4;
                                int i4 = coordinateZ + i6 * this.horizontalNoiseGranularity + l3;
                                int z = i4 & 0xF;
                                double d13 = (double)l3 / (double)this.horizontalNoiseGranularity;
                                double d14 = MathHelper.func_219803_d((double)d13, (double)d11, (double)d12);
                                double d15 = MathHelper.func_151237_a((double)(d14 / 200.0), (double)-1.0, (double)1.0);
                                d15 = d15 / 2.0 - d15 * d15 * d15 / 24.0;
                                while (objectlistiterator.hasNext()) {
                                    AbstractVillagePiece abstractvillagepiece1 = (AbstractVillagePiece)objectlistiterator.next();
                                    MutableBoundingBox mutableboundingbox = abstractvillagepiece1.func_74874_b();
                                    k4 = Math.max(0, Math.max(mutableboundingbox.field_78897_a - j3, j3 - mutableboundingbox.field_78893_d));
                                    l4 = currentY - (mutableboundingbox.field_78895_b + abstractvillagepiece1.func_214830_d());
                                    int i5 = Math.max(0, Math.max(mutableboundingbox.field_78896_c - i4, i4 - mutableboundingbox.field_78892_f));
                                    d15 += UANoiseChunkGenerator.func_222556_a(k4, l4, i5) * 0.8;
                                }
                                objectlistiterator.back(objectlist.size());
                                while (objectlistiterator1.hasNext()) {
                                    JigsawJunction jigsawjunction1 = (JigsawJunction)objectlistiterator1.next();
                                    int k6 = j3 - jigsawjunction1.func_214895_a();
                                    k4 = currentY - jigsawjunction1.func_214896_b();
                                    l4 = i4 - jigsawjunction1.func_214893_c();
                                    d15 += UANoiseChunkGenerator.func_222556_a(k6, k4, l4) * 0.4;
                                }
                                objectlistiterator1.back(objectlist1.size());
                                BlockState blockstate = d15 > 0.0 && currentY <= UltraAmplified.UAConfig.yMaximum.get() ? this.defaultBlock : (currentY < UltraAmplified.UAConfig.seaLevel.get() ? this.defaultFluid : AIR);
                                if (blockstate == AIR) continue;
                                if (blockstate.func_185906_d() != 0) {
                                    blockpos$Mutable.func_181079_c(j3, currentY, i4);
                                    chunkprimer.func_201637_h((BlockPos)blockpos$Mutable);
                                }
                                chunksection.func_177484_a(x, y, z, blockstate, false);
                                heightmap.func_202270_a(x, currentY, z, blockstate);
                                heightmap1.func_202270_a(x, currentY, z, blockstate);
                            }
                        }
                    }
                }
                chunksection.func_222637_b();
            }
            double[][] adouble1 = adouble[0];
            adouble[0] = adouble[1];
            adouble[1] = adouble1;
        }
    }

    private static double func_222556_a(int p_222556_0_, int p_222556_1_, int p_222556_2_) {
        int i = p_222556_0_ + 12;
        int j = p_222556_1_ + 12;
        int k = p_222556_2_ + 12;
        if (i >= 0 && i < 24) {
            if (j >= 0 && j < 24) {
                return k >= 0 && k < 24 ? (double)field_222561_h[k * 24 * 24 + i * 24 + j] : 0.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    private static double func_222554_b(int p_222554_0_, int p_222554_1_, int p_222554_2_) {
        double d0 = p_222554_0_ * p_222554_0_ + p_222554_2_ * p_222554_2_;
        double d1 = (double)p_222554_1_ + 0.5;
        double d2 = d1 * d1;
        double d3 = Math.pow(Math.E, -(d2 / 16.0 + d0 / 16.0));
        double d4 = -d1 * MathHelper.func_181161_i((double)(d2 / 2.0 + d0 / 2.0)) / 2.0;
        return d4 * d3;
    }
}

