/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.generation.layers;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.biome.UABiomes;
import net.telepathicgrunt.ultraamplified.world.generation.BiomeGenHelper;
import net.telepathicgrunt.ultraamplified.world.generation.layers.AddOceansLayerUA;

@Mod.EventBusSubscriber(modid="ultra_amplified_dimension", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BiomeLayerSetupUA {
    public static List<BiomeManager.BiomeEntry> icyBiomesList;
    public static List<BiomeManager.BiomeEntry> coolBiomesList;
    public static List<BiomeManager.BiomeEntry> warmBiomesList;
    public static List<BiomeManager.BiomeEntry> hotBiomesList;
    public static List<BiomeManager.BiomeEntry> jungleBiomesList;
    public static List<BiomeManager.BiomeEntry> giantTreeTaigaBiomesList;
    public static List<BiomeManager.BiomeEntry> badlandsBiomesList;
    public static List<BiomeManager.BiomeEntry> oceanBiomesList;
    public static boolean noOcean;
    private static ForgeRegistry<Biome> BiomeRegistry;

    public BiomeLayerSetupUA() {
        BiomeLayerSetupUA.setupBiomeEntries();
        BiomeGenHelper.setBiomeEdgeMap();
        AddOceansLayerUA.syncOceanList();
        UABiomes.mapMBiomes();
    }

    private static void setupBiomeEntries() {
        BiomeLayerSetupUA.resetBiomeLists();
        BiomeLayerSetupUA.importModdedBiomes();
        BiomeLayerSetupUA.addUABiomeEntriesToLists();
        BiomeLayerSetupUA.fillSparceBiomeLists();
        BiomeLayerSetupUA.isUAOceanPresent();
    }

    private static void resetBiomeLists() {
        icyBiomesList = new ArrayList<BiomeManager.BiomeEntry>();
        coolBiomesList = new ArrayList<BiomeManager.BiomeEntry>();
        warmBiomesList = new ArrayList<BiomeManager.BiomeEntry>();
        hotBiomesList = new ArrayList<BiomeManager.BiomeEntry>();
        jungleBiomesList = new ArrayList<BiomeManager.BiomeEntry>();
        giantTreeTaigaBiomesList = new ArrayList<BiomeManager.BiomeEntry>();
        badlandsBiomesList = new ArrayList<BiomeManager.BiomeEntry>();
        oceanBiomesList = new ArrayList<BiomeManager.BiomeEntry>();
        noOcean = false;
    }

    private static void importModdedBiomes() {
        block14: {
            block13: {
                ArrayList<String> blacklistedMods = new ArrayList<String>();
                LinkedList<String> blacklistedTempList = new LinkedList<String>(Arrays.asList(UltraAmplified.UAConfig.blacklistedBiomeList.get().split(",")));
                for (int i = 0; i < blacklistedTempList.size(); ++i) {
                    blacklistedTempList.set(i, ((String)blacklistedTempList.get(i)).trim());
                }
                for (String entry : blacklistedTempList) {
                    if (!entry.contains(":*")) continue;
                    blacklistedMods.add(entry.split(":")[0]);
                }
                if (!UltraAmplified.UAConfig.importAllModdedBiomes.get().booleanValue()) break block13;
                for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
                    String namespace;
                    ResourceLocation rl = BiomeRegistry.getKey((IForgeRegistryEntry)biome);
                    if (rl == null || blacklistedMods.contains(namespace = rl.func_110624_b()) || UltraAmplified.UAConfig.blacklistedBiomeList.get().contains(rl.toString()) || namespace.equals("minecraft") || namespace.equals("ultra_amplified_dimension")) continue;
                    BiomeManager.BiomeEntry addedBiome = new BiomeManager.BiomeEntry(biome, 20);
                    float biomeTemperature = biome.func_185353_n();
                    if (biomeTemperature < 0.1f) {
                        icyBiomesList.add(addedBiome);
                        continue;
                    }
                    if (biomeTemperature >= 0.1f && biomeTemperature < 0.5f) {
                        coolBiomesList.add(addedBiome);
                        continue;
                    }
                    if (biomeTemperature >= 0.5f && biomeTemperature < 1.0f) {
                        warmBiomesList.add(addedBiome);
                        continue;
                    }
                    hotBiomesList.add(addedBiome);
                }
                break block14;
            }
            if (!UltraAmplified.UAConfig.importOverworldModdedBiomes.get().booleanValue()) break block14;
            block9: for (BiomeManager.BiomeType tempRange : BiomeManager.BiomeType.values()) {
                List biomesInTempRange = BiomeManager.getBiomes((BiomeManager.BiomeType)tempRange).stream().filter(biomeEntry -> !biomeEntry.biome.getRegistryName().func_110624_b().equals("minecraft")).map(biomeEntry -> biomeEntry.field_76292_a < 10 ? new BiomeManager.BiomeEntry(biomeEntry.biome, 10) : biomeEntry).collect(Collectors.toList());
                if (biomesInTempRange == null) continue;
                switch (tempRange) {
                    case ICY: {
                        icyBiomesList.addAll(biomesInTempRange);
                        continue block9;
                    }
                    case COOL: {
                        coolBiomesList.addAll(biomesInTempRange);
                        continue block9;
                    }
                    case WARM: {
                        warmBiomesList.addAll(biomesInTempRange);
                        continue block9;
                    }
                    case DESERT: {
                        hotBiomesList.addAll(biomesInTempRange);
                    }
                }
            }
        }
    }

    private static void addUABiomeEntriesToLists() {
        if (UltraAmplified.UAConfig.desert.get().booleanValue()) {
            hotBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.DESERT, 40));
        }
        if (UltraAmplified.UAConfig.savanna.get().booleanValue()) {
            hotBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.SAVANNA, 40));
        }
        if (UltraAmplified.UAConfig.plains.get().booleanValue()) {
            hotBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.PLAINS, 20));
        }
        if (UltraAmplified.UAConfig.netherland.get().booleanValue()) {
            hotBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.NETHERLAND, 30));
        }
        if (UltraAmplified.UAConfig.forest.get().booleanValue()) {
            warmBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.FOREST, 28));
        }
        if (UltraAmplified.UAConfig.darkForest.get().booleanValue()) {
            warmBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.DARK_FOREST, 28));
        }
        if (UltraAmplified.UAConfig.rockyField.get().booleanValue()) {
            warmBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.ROCKY_FIELD, 28));
        }
        if (UltraAmplified.UAConfig.plains.get().booleanValue()) {
            warmBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.PLAINS, 28));
        }
        if (UltraAmplified.UAConfig.birchForest.get().booleanValue()) {
            warmBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.BIRCH_FOREST, 28));
        }
        if (UltraAmplified.UAConfig.swamplands.get().booleanValue()) {
            warmBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.SWAMP, 28));
        }
        if (UltraAmplified.UAConfig.mushroom.get().booleanValue()) {
            warmBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.MUSHROOM_FIELDS, 8));
        }
        if (UltraAmplified.UAConfig.forest.get().booleanValue()) {
            coolBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.FOREST, 32));
        }
        if (UltraAmplified.UAConfig.rockyField.get().booleanValue()) {
            coolBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.ROCKY_FIELD, 32));
        }
        if (UltraAmplified.UAConfig.taiga.get().booleanValue()) {
            coolBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.TAIGA, 32));
        }
        if (UltraAmplified.UAConfig.plains.get().booleanValue()) {
            coolBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.PLAINS, 12));
        }
        if (UltraAmplified.UAConfig.stonePlains.get().booleanValue()) {
            coolBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.STONE_PLAINS, 17));
        }
        if (UltraAmplified.UAConfig.endField.get().booleanValue()) {
            coolBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.END_FIELD, 32));
        }
        if (UltraAmplified.UAConfig.mushroom.get().booleanValue()) {
            coolBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.MUSHROOM_FIELDS, 8));
        }
        if (UltraAmplified.UAConfig.snowyTundra.get().booleanValue()) {
            icyBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.SNOWY_TUNDRA, 45));
        } else {
            if (UltraAmplified.UAConfig.iceSpike.get().booleanValue()) {
                icyBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.ICE_SPIKES, 26));
            }
            if (UltraAmplified.UAConfig.icedTerrain.get().booleanValue()) {
                icyBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.ICED_TERRAIN, 26));
            }
        }
        if (UltraAmplified.UAConfig.icedTerrain.get().booleanValue()) {
            icyBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.ICED_TERRAIN, 17));
        }
        if (UltraAmplified.UAConfig.snowyTaiga.get().booleanValue()) {
            icyBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.SNOWY_TAIGA, 26));
        }
        if (UltraAmplified.UAConfig.frozenDesert.get().booleanValue()) {
            icyBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.FROZEN_DESERT, 6));
        }
        if (UltraAmplified.UAConfig.jungle.get().booleanValue()) {
            jungleBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.JUNGLE, 70));
        }
        if (UltraAmplified.UAConfig.bambooJungle.get().booleanValue()) {
            jungleBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.BAMBOO_JUNGLE, 30));
        }
        if (UltraAmplified.UAConfig.giantTreeTaiga.get().booleanValue()) {
            giantTreeTaigaBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.GIANT_TREE_TAIGA, 10));
        }
        if (UltraAmplified.UAConfig.badlands.get().booleanValue()) {
            badlandsBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.SANDLESS_BADLANDS, 20));
            badlandsBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.WOODED_BADLANDS, 10));
        } else if (UltraAmplified.UAConfig.spikyBadlands.get().booleanValue()) {
            badlandsBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.SPIKY_BADLANDS, 10));
            badlandsBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.DISSECTED_PLATEAU_BADLANDS, 10));
        }
        if (UltraAmplified.UAConfig.warmOcean.get().booleanValue()) {
            oceanBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.WARM_OCEAN, 10));
        }
        if (UltraAmplified.UAConfig.lukewarmOcean.get().booleanValue()) {
            oceanBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.LUKEWARM_OCEAN, 10));
        }
        if (UltraAmplified.UAConfig.ocean.get().booleanValue()) {
            oceanBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.OCEAN, 10));
        }
        if (UltraAmplified.UAConfig.coldOcean.get().booleanValue()) {
            oceanBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.COLD_OCEAN, 10));
        }
        if (UltraAmplified.UAConfig.frozenOcean.get().booleanValue()) {
            oceanBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.FROZEN_OCEAN, 10));
        }
    }

    private static void fillSparceBiomeLists() {
        ArrayList<List<BiomeManager.BiomeEntry>> listOfBiomeLists = new ArrayList<List<BiomeManager.BiomeEntry>>();
        listOfBiomeLists.add(badlandsBiomesList);
        listOfBiomeLists.add(jungleBiomesList);
        listOfBiomeLists.add(hotBiomesList);
        if (oceanBiomesList.size() == 0) {
            listOfBiomeLists.add(oceanBiomesList);
        }
        listOfBiomeLists.add(warmBiomesList);
        listOfBiomeLists.add(coolBiomesList);
        listOfBiomeLists.add(giantTreeTaigaBiomesList);
        listOfBiomeLists.add(icyBiomesList);
        for (int listIndex = 0; listIndex < listOfBiomeLists.size(); ++listIndex) {
            if (!((List)listOfBiomeLists.get(listIndex)).isEmpty()) continue;
            int direction = -1;
            int offsetIndex = 1;
            while (offsetIndex < listOfBiomeLists.size()) {
                int n = Ints.constrainToRange((int)(listIndex + offsetIndex * direction), (int)0, (int)(listOfBiomeLists.size() - 1));
                if (!((List)listOfBiomeLists.get(n)).isEmpty()) {
                    ((List)listOfBiomeLists.get(listIndex)).addAll(((List)listOfBiomeLists.get(n)).subList(0, Ints.constrainToRange((int)((List)listOfBiomeLists.get(n)).size(), (int)1, (int)4)));
                    break;
                }
                direction *= -1;
                if (n <= 0) continue;
                ++offsetIndex;
            }
            if (((List)listOfBiomeLists.get(listIndex)).size() != 0) continue;
            if (oceanBiomesList.size() == 0) {
                oceanBiomesList.add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            }
            for (List list : listOfBiomeLists) {
                list.addAll(oceanBiomesList);
            }
        }
    }

    private static void isUAOceanPresent() {
        if (!(UltraAmplified.UAConfig.ocean.get().booleanValue() || UltraAmplified.UAConfig.coldOcean.get().booleanValue() || UltraAmplified.UAConfig.frozenOcean.get().booleanValue() || UltraAmplified.UAConfig.lukewarmOcean.get().booleanValue() || UltraAmplified.UAConfig.warmOcean.get().booleanValue())) {
            noOcean = true;
        }
    }

    static {
        noOcean = false;
        BiomeRegistry = (ForgeRegistry)ForgeRegistries.BIOMES;
    }

    @Mod.EventBusSubscriber(modid="ultra_amplified_dimension")
    private static class ForgeEvents {
        private ForgeEvents() {
        }

        @SubscribeEvent
        public static void updateBiomeLayouts(ModConfig.Reloading event) {
            BiomeLayerSetupUA.setupBiomeEntries();
            BiomeGenHelper.setBiomeEdgeMap();
            AddOceansLayerUA.syncOceanList();
            UABiomes.mapMBiomes();
        }
    }
}

