/*
 * Decompiled with CFR 0.152.
 */
package net.TelepathicGrunt.UltraAmplified.World.Generation;

import java.lang.reflect.Field;
import jline.internal.Log;
import net.TelepathicGrunt.UltraAmplified.World.Generation.ChunkGeneratorSettingsUA;
import net.TelepathicGrunt.UltraAmplified.World.Generation.GenLayerBiomeUA;
import net.TelepathicGrunt.UltraAmplified.World.Generation.GenLayerHillsAndAmplifiedUA;
import net.TelepathicGrunt.UltraAmplified.World.WorldTypes.WorldTypeUA;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerAddIsland;
import net.minecraft.world.gen.layer.GenLayerAddMushroomIsland;
import net.minecraft.world.gen.layer.GenLayerAddSnow;
import net.minecraft.world.gen.layer.GenLayerBiomeEdge;
import net.minecraft.world.gen.layer.GenLayerDeepOcean;
import net.minecraft.world.gen.layer.GenLayerEdge;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerIsland;
import net.minecraft.world.gen.layer.GenLayerRemoveTooMuchOcean;
import net.minecraft.world.gen.layer.GenLayerRiverInit;
import net.minecraft.world.gen.layer.GenLayerRiverMix;
import net.minecraft.world.gen.layer.GenLayerShore;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class BiomeProviderUA
extends BiomeProvider {
    private ChunkGeneratorSettingsUA settings;

    public BiomeProviderUA(long seed, WorldType worldType, String options) {
        Field genBiomeField;
        if (!(worldType instanceof WorldTypeUA)) {
            throw new RuntimeException("Error: WorldType is not UltraAmplified... How did you get this error?!");
        }
        this.settings = new ChunkGeneratorSettingsUA();
        GenLayer[] agenlayer = this.initializeAllBiomeGenerators(seed, worldType, this.settings);
        agenlayer = this.getModdedBiomeGenerators(worldType, seed, agenlayer);
        try {
            genBiomeField = ReflectionHelper.findField(BiomeProvider.class, (String[])new String[]{"genBiomes", "field_76944_d"});
            genBiomeField.set((Object)this, agenlayer[0]);
        }
        catch (Exception e) {
            Log.warn((Object[])new Object[]{"BiomeProviderUA error with setting genBiome: " + e.getMessage()});
        }
        try {
            genBiomeField = ReflectionHelper.findField(BiomeProvider.class, (String[])new String[]{"biomeIndexLayer", "field_76945_e"});
            genBiomeField.set((Object)this, agenlayer[1]);
        }
        catch (Exception e) {
            Log.warn((Object[])new Object[]{"BiomeProviderUA error with setting biomeIndexLayer: " + e.getMessage()});
        }
    }

    public BiomeProviderUA(World world) {
        this(world.func_72905_C(), world.func_72912_H().func_76067_t(), world.func_72912_H().func_82571_y());
    }

    public GenLayer[] initializeAllBiomeGenerators(long seed, WorldType worldType, ChunkGeneratorSettingsUA p_180781_3_) {
        GenLayerIsland genlayer = new GenLayerIsland(1L);
        genlayer = new GenLayerFuzzyZoom(2000L, (GenLayer)genlayer);
        GenLayerAddIsland genlayeraddisland = new GenLayerAddIsland(1L, (GenLayer)genlayer);
        GenLayerZoom genlayerzoom = new GenLayerZoom(2001L, (GenLayer)genlayeraddisland);
        GenLayerAddIsland genlayeraddisland1 = new GenLayerAddIsland(2L, (GenLayer)genlayerzoom);
        genlayeraddisland1 = new GenLayerAddIsland(50L, (GenLayer)genlayeraddisland1);
        genlayeraddisland1 = new GenLayerAddIsland(70L, (GenLayer)genlayeraddisland1);
        GenLayerRemoveTooMuchOcean genlayerremovetoomuchocean = new GenLayerRemoveTooMuchOcean(2L, (GenLayer)genlayeraddisland1);
        GenLayerAddSnow genlayeraddsnow = new GenLayerAddSnow(2L, (GenLayer)genlayerremovetoomuchocean);
        GenLayerAddIsland genlayeraddisland2 = new GenLayerAddIsland(3L, (GenLayer)genlayeraddsnow);
        GenLayerEdge genlayeredge = new GenLayerEdge(2L, (GenLayer)genlayeraddisland2, GenLayerEdge.Mode.COOL_WARM);
        genlayeredge = new GenLayerEdge(2L, (GenLayer)genlayeredge, GenLayerEdge.Mode.HEAT_ICE);
        genlayeredge = new GenLayerEdge(3L, (GenLayer)genlayeredge, GenLayerEdge.Mode.SPECIAL);
        GenLayerZoom genlayerzoom1 = new GenLayerZoom(2002L, (GenLayer)genlayeredge);
        genlayerzoom1 = new GenLayerZoom(2003L, (GenLayer)genlayerzoom1);
        GenLayerAddIsland genlayeraddisland3 = new GenLayerAddIsland(4L, (GenLayer)genlayerzoom1);
        GenLayerAddMushroomIsland genlayeraddmushroomisland = new GenLayerAddMushroomIsland(5L, (GenLayer)genlayeraddisland3);
        GenLayerDeepOcean genlayerdeepocean = new GenLayerDeepOcean(4L, (GenLayer)genlayeraddmushroomisland);
        GenLayer genlayer4 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerdeepocean, (int)0);
        int i = p_180781_3_.biomeSize;
        int j = 4;
        GenLayer lvt_7_1_ = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayer4, (int)0);
        GenLayerRiverInit genlayerriverinit = new GenLayerRiverInit(100L, lvt_7_1_);
        GenLayerBiomeUA lvt_8_1_ = new GenLayerBiomeUA(200L, genlayer4, worldType, p_180781_3_);
        GenLayer genlayer6 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)lvt_8_1_, (int)2);
        GenLayerBiomeEdge genlayerbiomeedge = new GenLayerBiomeEdge(1000L, genlayer6);
        GenLayer lvt_9_1_ = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerriverinit, (int)2);
        GenLayerHillsAndAmplifiedUA genlayerhills = new GenLayerHillsAndAmplifiedUA(1000L, (GenLayer)genlayerbiomeedge, lvt_9_1_);
        GenLayer genlayer5 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerriverinit, (int)2);
        genlayer5 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayer5, (int)j);
        GenLayerSmooth genlayersmooth = new GenLayerSmooth(1000L, genlayer5);
        for (int k = 0; k < i; ++k) {
            genlayerhills = new GenLayerZoom((long)(1000 + k), (GenLayer)genlayerhills);
            if (k == 0) {
                genlayerhills = new GenLayerAddIsland(3L, (GenLayer)genlayerhills);
            }
            if (k != 1 && i != 1) continue;
            genlayerhills = new GenLayerShore(1000L, (GenLayer)genlayerhills);
        }
        GenLayerSmooth genlayersmooth1 = new GenLayerSmooth(1000L, (GenLayer)genlayerhills);
        GenLayerRiverMix genlayerrivermix = new GenLayerRiverMix(100L, (GenLayer)genlayersmooth1, (GenLayer)genlayersmooth);
        GenLayerVoronoiZoom genlayer3 = new GenLayerVoronoiZoom(10L, (GenLayer)genlayerrivermix);
        genlayerrivermix.func_75905_a(seed);
        genlayer3.func_75905_a(seed);
        return new GenLayer[]{genlayerrivermix, genlayer3, genlayerrivermix};
    }
}

