/*
 * Decompiled with CFR 0.152.
 */
package net.TelepathicGrunt.UltraAmplified.World.Generation;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.TelepathicGrunt.UltraAmplified.Config.UAConfig;
import net.TelepathicGrunt.UltraAmplified.World.Biome.BiomeInit;
import net.TelepathicGrunt.UltraAmplified.World.Generation.ChunkGeneratorSettingsUA;
import net.TelepathicGrunt.UltraAmplified.World.gen.feature.WorldGenDungeonsUA;
import net.TelepathicGrunt.UltraAmplified.World.gen.feature.WorldGenSlimeLakeUA;
import net.TelepathicGrunt.UltraAmplified.World.gen.structure.MapGenCaveCavity;
import net.TelepathicGrunt.UltraAmplified.World.gen.structure.MapGenMineshaftUA;
import net.TelepathicGrunt.UltraAmplified.World.gen.structure.MapGenRavineUA;
import net.TelepathicGrunt.UltraAmplified.World.gen.structure.MapGenScatteredFeatureUA;
import net.TelepathicGrunt.UltraAmplified.World.gen.structure.MapGenStrongholdUA;
import net.TelepathicGrunt.UltraAmplified.World.gen.structure.MapGenVillageUA;
import net.TelepathicGrunt.UltraAmplified.World.gen.structure.StructureOceanMonumentUA;
import net.TelepathicGrunt.UltraAmplified.World.gen.structure.WoodlandMansionUA;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenLakes;

public class ChunkGeneratorOverworldUA
implements IChunkGenerator {
    protected static final IBlockState STONE = Blocks.field_150348_b.func_176223_P();
    protected static final IBlockState END_STONE = Blocks.field_150377_bs.func_176223_P();
    protected static final IBlockState NETHERRACK = Blocks.field_150424_aL.func_176223_P();
    protected static final IBlockState ICE = Blocks.field_150432_aD.func_176223_P();
    protected static final IBlockState SNOW = Blocks.field_150433_aE.func_176223_P();
    private final Random rand;
    private final NoiseGeneratorOctaves minLimitPerlinNoise;
    private final NoiseGeneratorOctaves maxLimitPerlinNoise;
    private final NoiseGeneratorOctaves mainPerlinNoise;
    private final NoiseGeneratorPerlin surfaceNoise;
    public NoiseGeneratorOctaves scaleNoise;
    public NoiseGeneratorOctaves depthNoise;
    public NoiseGeneratorOctaves forestNoise;
    private final World worldObj;
    private final boolean mapFeaturesEnabled;
    private final WorldType terrainType;
    private final double[] heightMap;
    private final float[] biomeWeights;
    public ChunkGeneratorSettingsUA settings;
    private IBlockState oceanBlock = Blocks.field_150355_j.func_176223_P();
    private double[] depthBuffer = new double[256];
    private MapGenBase caveGenerator;
    private MapGenStrongholdUA strongholdGenerator;
    private MapGenVillageUA villageGenerator;
    private MapGenMineshaftUA mineshaftGenerator;
    private MapGenScatteredFeatureUA scatteredFeatureGenerator;
    private MapGenBase ravineGenerator;
    private StructureOceanMonumentUA oceanMonumentGenerator;
    private WoodlandMansionUA mansionGenerator;
    private Biome[] biomesForGeneration;
    double[] mainNoiseRegion;
    double[] minLimitRegion;
    double[] maxLimitRegion;
    double[] depthRegion;

    public ChunkGeneratorOverworldUA(World worldIn, long seed, boolean mapFeaturesEnabledIn, String generatorOptions) {
        this.worldObj = worldIn;
        this.mapFeaturesEnabled = mapFeaturesEnabledIn;
        this.terrainType = worldIn.func_72912_H().func_76067_t();
        this.rand = new Random(seed);
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.surfaceNoise = new NoiseGeneratorPerlin(this.rand, 4);
        this.scaleNoise = new NoiseGeneratorOctaves(this.rand, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.forestNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.heightMap = new double[825];
        this.biomeWeights = new float[25];
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                this.biomeWeights[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
        this.settings = new ChunkGeneratorSettingsUA();
        this.oceanBlock = UAConfig.biomeOptions.lavaOcean ? Blocks.field_150353_l.func_176223_P() : Blocks.field_150355_j.func_176223_P();
        worldIn.func_181544_b(UAConfig.biomeOptions.seaLevel);
        this.caveGenerator = new MapGenCaveCavity(this);
        this.strongholdGenerator = new MapGenStrongholdUA(this);
        this.villageGenerator = new MapGenVillageUA(this);
        this.mineshaftGenerator = new MapGenMineshaftUA(this);
        this.scatteredFeatureGenerator = new MapGenScatteredFeatureUA(this);
        this.ravineGenerator = new MapGenRavineUA(this);
        this.oceanMonumentGenerator = new StructureOceanMonumentUA(this);
        this.mansionGenerator = new WoodlandMansionUA(this);
    }

    public void setBlocksInChunk(int x, int z, ChunkPrimer primer) {
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, x * 4 - 2, z * 4 - 2, 10, 10);
        this.generateHeightmap(x * 4, 0, z * 4);
        for (int i = 0; i < 4; ++i) {
            int j = i * 5;
            int k = (i + 1) * 5;
            for (int l = 0; l < 4; ++l) {
                int i1 = (j + l) * 33;
                int j1 = (j + l + 1) * 33;
                int k1 = (k + l) * 33;
                int l1 = (k + l + 1) * 33;
                for (int i2 = 0; i2 < 32; ++i2) {
                    double d0 = 0.125;
                    double d1 = this.heightMap[i1 + i2];
                    double d2 = this.heightMap[j1 + i2];
                    double d3 = this.heightMap[k1 + i2];
                    double d4 = this.heightMap[l1 + i2];
                    double d5 = (this.heightMap[i1 + i2 + 1] - d1) * 0.125;
                    double d6 = (this.heightMap[j1 + i2 + 1] - d2) * 0.125;
                    double d7 = (this.heightMap[k1 + i2 + 1] - d3) * 0.125;
                    double d8 = (this.heightMap[l1 + i2 + 1] - d4) * 0.125;
                    for (int j2 = 0; j2 < 8; ++j2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        for (int k2 = 0; k2 < 4; ++k2) {
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * 0.25;
                            double lvt_45_1_ = d10 - d16;
                            for (int l2 = 0; l2 < 4; ++l2) {
                                double d;
                                Biome loc = this.worldObj.func_180494_b(new BlockPos(x * 16, 2, z * 16));
                                lvt_45_1_ += d16;
                                if (d > 0.0) {
                                    if (loc == BiomeInit.BiomeEnd) {
                                        primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, END_STONE);
                                        continue;
                                    }
                                    if (loc == BiomeInit.BiomeNether) {
                                        primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, NETHERRACK);
                                        continue;
                                    }
                                    if (loc == BiomeInit.BiomeIceMountain) {
                                        primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, ICE);
                                        continue;
                                    }
                                    primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, STONE);
                                    continue;
                                }
                                if (i2 * 8 + j2 >= UAConfig.biomeOptions.seaLevel) continue;
                                if (loc == BiomeInit.BiomeIceMountain || loc == BiomeInit.BiomeIceSpike) {
                                    primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, SNOW);
                                    continue;
                                }
                                primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, UAConfig.biomeOptions.lavaOcean ? Blocks.field_150353_l.func_176223_P() : Blocks.field_150355_j.func_176223_P());
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
        double d0 = 0.03125;
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(x * 16), (double)(z * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = biomesIn[j + i * 16];
                biome.func_180622_a(this.worldObj, this.rand, primer, x * 16 + i, z * 16 + j, this.depthBuffer[j + i * 16]);
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.setBlocksInChunk(x, z, chunkprimer);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.replaceBiomeBlocks(x, z, chunkprimer, this.biomesForGeneration);
        if (UAConfig.StructuresOptions.caveCavitySpawnrate != 0) {
            this.caveGenerator.func_186125_a(this.worldObj, x, z, chunkprimer);
        }
        if (UAConfig.StructuresOptions.ravineSpawnrate != 0) {
            this.ravineGenerator.func_186125_a(this.worldObj, x, z, chunkprimer);
        }
        if (this.mapFeaturesEnabled) {
            if (this.settings.useMineShafts) {
                this.mineshaftGenerator.func_186125_a(this.worldObj, x, z, chunkprimer);
            }
            if (this.settings.useVillages) {
                this.villageGenerator.func_186125_a(this.worldObj, x, z, chunkprimer);
            }
            if (this.settings.useStrongholds) {
                this.strongholdGenerator.func_186125_a(this.worldObj, x, z, chunkprimer);
            }
            if (this.settings.useTemples) {
                this.scatteredFeatureGenerator.func_186125_a(this.worldObj, x, z, chunkprimer);
            }
            if (this.settings.useMonuments) {
                this.oceanMonumentGenerator.func_186125_a(this.worldObj, x, z, chunkprimer);
            }
            if (this.settings.useMansions) {
                this.mansionGenerator.func_186125_a(this.worldObj, x, z, chunkprimer);
            }
        }
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void generateHeightmap(int p_185978_1_, int p_185978_2_, int p_185978_3_) {
        this.depthRegion = this.depthNoise.func_76305_a(this.depthRegion, p_185978_1_, p_185978_3_, 5, 5, (double)this.settings.depthNoiseScaleX, (double)this.settings.depthNoiseScaleZ, (double)this.settings.depthNoiseScaleExponent);
        float f = this.settings.coordinateScale;
        float f1 = this.settings.heightScale;
        this.mainNoiseRegion = this.mainPerlinNoise.func_76304_a(this.mainNoiseRegion, p_185978_1_, p_185978_2_, p_185978_3_, 5, 33, 5, (double)(f / this.settings.mainNoiseScaleX), 50.1 * (double)(f1 / this.settings.mainNoiseScaleY), (double)(f / this.settings.mainNoiseScaleZ));
        this.minLimitRegion = this.minLimitPerlinNoise.func_76304_a(this.minLimitRegion, p_185978_1_, p_185978_2_, p_185978_3_, 5, 33, 5, (double)f, (double)(f1 * f1), (double)f);
        this.maxLimitRegion = this.maxLimitPerlinNoise.func_76304_a(this.maxLimitRegion, p_185978_1_, p_185978_2_, p_185978_3_, 5, 33, 5, (double)f, (double)(f1 * f1), (double)f);
        int i = 0;
        int j = 0;
        for (int k = 0; k < 5; ++k) {
            for (int l = 0; l < 5; ++l) {
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                int i1 = 2;
                Biome biome = this.biomesForGeneration[k + 2 + (l + 2) * 10];
                for (int j1 = -2; j1 <= 2; ++j1) {
                    for (int k1 = -2; k1 <= 2; ++k1) {
                        Biome biome1 = this.biomesForGeneration[k + j1 + 2 + (l + k1 + 2) * 10];
                        float f5 = 0.0f;
                        float f6 = 0.0f;
                        f5 = 1.0f + (this.settings.biomeDepthOffset + 0.4f * this.settings.biomeDepthWeight) * 2.0f;
                        f6 = 1.0f + (this.settings.biomeScaleOffset + 0.3f * this.settings.biomeScaleWeight) * 12.0f;
                        float f7 = this.biomeWeights[j1 + 2 + (k1 + 2) * 5] / (f5 + 2.0f);
                        if (biome1.func_185355_j() > biome.func_185355_j()) {
                            f7 /= 2.0f;
                        }
                        f2 += f6 * f7;
                        f3 += f5 * f7;
                        f4 += f7;
                    }
                }
                f2 /= f4;
                f3 /= f4;
                f2 = f2 * 0.9f + 0.1f;
                f3 = (f3 * 4.0f - 1.0f) / 8.0f;
                double d7 = this.depthRegion[j] / 8000.0;
                if (d7 < 0.0) {
                    d7 = -d7 * 0.3;
                }
                if ((d7 = d7 * 3.0 - 2.0) < 0.0) {
                    if ((d7 /= 2.0) < -1.0) {
                        d7 = -1.0;
                    }
                    d7 /= 1.4;
                    d7 /= 2.0;
                } else {
                    if (d7 > 1.0) {
                        d7 = 1.0;
                    }
                    d7 /= 8.0;
                }
                ++j;
                double d8 = f3;
                double d9 = f2;
                d8 += d7 * 0.2;
                d8 = d8 * (double)this.settings.baseSize / 8.0;
                double d0 = (double)this.settings.baseSize + d8 * 4.0;
                for (int l1 = 0; l1 < 33; ++l1) {
                    double d1 = ((double)l1 - d0) * (double)this.settings.stretchY * 128.0 / 256.0 / d9;
                    if (d1 < 0.0) {
                        d1 *= 4.0;
                    }
                    double d2 = this.minLimitRegion[i] / (double)this.settings.lowerLimitScale;
                    double d3 = this.maxLimitRegion[i] / (double)this.settings.upperLimitScale;
                    double d4 = (this.mainNoiseRegion[i] / 10.0 + 1.0) / 2.0;
                    double d5 = MathHelper.func_151238_b((double)d2, (double)d3, (double)d4) - d1;
                    if (l1 > 29) {
                        double d6 = (float)(l1 - 29) / 3.0f;
                        d5 = d5 * (1.0 - d6) + -10.0 * d6;
                    }
                    this.heightMap[i] = d5;
                    ++i;
                }
            }
        }
    }

    public void func_185931_b(int x, int z) {
        int i2;
        int l2;
        int k3;
        int l22;
        int i22;
        BlockFalling.field_149832_M = false;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.worldObj.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.worldObj.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * k + (long)z * l ^ this.worldObj.func_72905_C());
        boolean flag = false;
        ChunkPos chunkpos = new ChunkPos(x, z);
        if (this.mapFeaturesEnabled) {
            if (this.settings.useMineShafts) {
                this.mineshaftGenerator.func_175794_a(this.worldObj, this.rand, chunkpos);
            }
            if (this.settings.useVillages) {
                flag = this.villageGenerator.func_175794_a(this.worldObj, this.rand, chunkpos);
            }
            if (this.settings.useStrongholds) {
                this.strongholdGenerator.func_175794_a(this.worldObj, this.rand, chunkpos);
            }
            if (this.settings.useTemples) {
                this.scatteredFeatureGenerator.func_175794_a(this.worldObj, this.rand, chunkpos);
            }
            if (this.settings.useMonuments) {
                this.oceanMonumentGenerator.func_175794_a(this.worldObj, this.rand, chunkpos);
            }
            if (this.settings.useMansions) {
                this.mansionGenerator.func_175794_a(this.worldObj, this.rand, chunkpos);
            }
        }
        if (biome != BiomeInit.BiomeDesert && biome != BiomeInit.BiomeDesertHills && !flag && this.settings.useWaterLakes && this.rand.nextInt(this.settings.waterLakeChance) == 0) {
            int i1 = this.rand.nextInt(16) + 8;
            int j1 = this.rand.nextInt(256);
            int k1 = this.rand.nextInt(16) + 8;
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.worldObj, this.rand, blockpos.func_177982_a(i1, j1, k1));
        }
        if (biome == BiomeInit.BiomeNether) {
            if (!flag && this.rand.nextInt(6) == 0) {
                i22 = this.rand.nextInt(16) + 8;
                l22 = this.rand.nextInt(this.rand.nextInt(248) + 8);
                k3 = this.rand.nextInt(16) + 8;
                if (l22 < this.worldObj.func_181545_F() || this.rand.nextInt(6) == 0) {
                    new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.worldObj, this.rand, blockpos.func_177982_a(i22, l22, k3));
                } else if (this.rand.nextInt(8) == 0) {
                    l22 = this.worldObj.func_175672_r(blockpos).func_177956_o();
                    new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.worldObj, this.rand, blockpos.func_177982_a(i22, l22, k3));
                }
            }
        } else if (!flag && this.settings.useLavaLakes && this.rand.nextInt(this.settings.lavaLakeChance) == 0) {
            i22 = this.rand.nextInt(16) + 8;
            l22 = this.rand.nextInt(this.rand.nextInt(248) + 8);
            k3 = this.rand.nextInt(16) + 8;
            if (l22 < this.worldObj.func_181545_F() || this.rand.nextInt(this.settings.lavaLakeChance) == 0) {
                new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.worldObj, this.rand, blockpos.func_177982_a(i22, l22, k3));
            }
        }
        if (!flag && this.settings.useSlimeLakes && this.rand.nextInt(8) == 0 && (l2 = this.worldObj.func_175672_r(blockpos).func_177956_o()) < 170) {
            i2 = this.rand.nextInt(16) + 8;
            k3 = this.rand.nextInt(16) + 8;
            new WorldGenSlimeLakeUA().generate(this.worldObj, this.rand, blockpos.func_177982_a(i2, l2 + 1, k3));
        }
        if (biome != BiomeInit.BiomeDesert && biome != BiomeInit.BiomeDesertHills && !flag && this.rand.nextInt(2) == 0 && (l2 = this.worldObj.func_175672_r(blockpos).func_177956_o()) < 170) {
            i2 = this.rand.nextInt(16) + 8;
            k3 = this.rand.nextInt(16) + 8;
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.worldObj, this.rand, blockpos.func_177982_a(i2, l2 + 1, k3));
        }
        for (int j2 = 0; j2 < this.settings.dungeonChance; ++j2) {
            int i3 = this.rand.nextInt(16) + 8;
            int l1 = this.rand.nextInt(16) + 8;
            int l3 = 1;
            l3 = this.rand.nextInt(100) < 4 ? this.rand.nextInt(10) + 75 : (this.rand.nextInt(75) == 0 ? this.rand.nextInt(150) : this.rand.nextInt(90) + 150);
            new WorldGenDungeonsUA().func_180709_b(this.worldObj, this.rand, blockpos.func_177982_a(i3, l3, l1));
        }
        biome.func_180624_a(this.worldObj, this.rand, new BlockPos(i, 0, j));
        WorldEntitySpawner.func_77191_a((World)this.worldObj, (Biome)biome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.rand);
        blockpos = blockpos.func_177982_a(8, 0, 8);
        for (int k2 = 0; k2 < 16; ++k2) {
            for (int j3 = 0; j3 < 16; ++j3) {
                BlockPos blockpos1 = this.worldObj.func_175725_q(blockpos.func_177982_a(k2, 0, j3));
                BlockPos blockpos2 = blockpos1.func_177977_b();
                if (this.worldObj.func_175675_v(blockpos2)) {
                    this.worldObj.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 2);
                }
                if (!this.worldObj.func_175708_f(blockpos1, true)) continue;
                this.worldObj.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 2);
            }
        }
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        boolean flag = false;
        if (this.settings.useMonuments && this.mapFeaturesEnabled && chunkIn.func_177416_w() < 3600L) {
            flag |= this.oceanMonumentGenerator.func_175794_a(this.worldObj, this.rand, new ChunkPos(x, z));
        }
        return flag;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.worldObj.func_180494_b(pos);
        if (this.mapFeaturesEnabled) {
            if (creatureType == EnumCreatureType.MONSTER && this.scatteredFeatureGenerator.isSwampHut(pos)) {
                return this.scatteredFeatureGenerator.getMonsters();
            }
            if (creatureType == EnumCreatureType.MONSTER && this.settings.useMonuments && this.oceanMonumentGenerator.func_175796_a(this.worldObj, pos)) {
                return this.oceanMonumentGenerator.getMonsters();
            }
        }
        return biome.func_76747_a(creatureType);
    }

    public boolean func_193414_a(World p_193414_1_, String p_193414_2_, BlockPos p_193414_3_) {
        if (!this.mapFeaturesEnabled) {
            return false;
        }
        if ("Stronghold".equals(p_193414_2_) && this.strongholdGenerator != null) {
            return this.strongholdGenerator.func_175795_b(p_193414_3_);
        }
        if ("Mansion".equals(p_193414_2_) && this.mansionGenerator != null) {
            return this.mansionGenerator.func_175795_b(p_193414_3_);
        }
        if ("Monument".equals(p_193414_2_) && this.oceanMonumentGenerator != null) {
            return this.oceanMonumentGenerator.func_175795_b(p_193414_3_);
        }
        if ("Village".equals(p_193414_2_) && this.villageGenerator != null) {
            return this.villageGenerator.func_175795_b(p_193414_3_);
        }
        if ("Mineshaft".equals(p_193414_2_) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_175795_b(p_193414_3_);
        }
        return "Temple".equals(p_193414_2_) && this.scatteredFeatureGenerator != null ? this.scatteredFeatureGenerator.func_175795_b(p_193414_3_) : false;
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean p_180513_4_) {
        if (!this.mapFeaturesEnabled) {
            return null;
        }
        if ("Stronghold".equals(structureName) && this.strongholdGenerator != null) {
            return this.strongholdGenerator.func_180706_b(worldIn, position, p_180513_4_);
        }
        if ("Mansion".equals(structureName) && this.mansionGenerator != null) {
            return this.mansionGenerator.func_180706_b(worldIn, position, p_180513_4_);
        }
        if ("Monument".equals(structureName) && this.oceanMonumentGenerator != null) {
            return this.oceanMonumentGenerator.func_180706_b(worldIn, position, p_180513_4_);
        }
        if ("Village".equals(structureName) && this.villageGenerator != null) {
            return this.villageGenerator.func_180706_b(worldIn, position, p_180513_4_);
        }
        if ("Mineshaft".equals(structureName) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_180706_b(worldIn, position, p_180513_4_);
        }
        return "Temple".equals(structureName) && this.scatteredFeatureGenerator != null ? this.scatteredFeatureGenerator.func_180706_b(worldIn, position, p_180513_4_) : null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
        if (this.mapFeaturesEnabled) {
            if (this.settings.useMineShafts) {
                this.mineshaftGenerator.func_186125_a(this.worldObj, x, z, null);
            }
            if (this.settings.useVillages) {
                this.villageGenerator.func_186125_a(this.worldObj, x, z, null);
            }
            if (this.settings.useStrongholds) {
                this.strongholdGenerator.func_186125_a(this.worldObj, x, z, null);
            }
            if (this.settings.useTemples) {
                this.scatteredFeatureGenerator.func_186125_a(this.worldObj, x, z, null);
            }
            if (this.settings.useMonuments) {
                this.oceanMonumentGenerator.func_186125_a(this.worldObj, x, z, null);
            }
            if (this.settings.useMansions) {
                this.mansionGenerator.func_186125_a(this.worldObj, x, z, null);
            }
        }
    }
}

