/*
 * Decompiled with CFR 0.152.
 */
package net.TelepathicGrunt.UltraAmplified.World.Generation;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.TelepathicGrunt.UltraAmplified.World.Biome.BiomeInit;
import net.TelepathicGrunt.UltraAmplified.World.Generation.ChunkGeneratorSettingsUA;
import net.minecraft.init.Biomes;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.BiomeManager;

public class GenLayerBiomeUA
extends GenLayer {
    private List<BiomeManager.BiomeEntry>[] biomes = new ArrayList[BiomeManager.BiomeType.values().length];
    private List<BiomeManager.BiomeEntry> oceanReplacedBiomes = new ArrayList<BiomeManager.BiomeEntry>();
    private List<BiomeManager.BiomeEntry> deepOceanReplacedBiomes = new ArrayList<BiomeManager.BiomeEntry>();
    private List<BiomeManager.BiomeEntry> jungleReplacedBiomes = new ArrayList<BiomeManager.BiomeEntry>();
    private List<BiomeManager.BiomeEntry> megaTaigaReplacedBiomes = new ArrayList<BiomeManager.BiomeEntry>();
    private List<BiomeManager.BiomeEntry> mesaReplacedBiomes = new ArrayList<BiomeManager.BiomeEntry>();
    private List<BiomeManager.BiomeEntry> mushroomReplacedBiomes = new ArrayList<BiomeManager.BiomeEntry>();

    public GenLayerBiomeUA(long p_i45560_1_, GenLayer p_i45560_3_, WorldType p_i45560_4_, ChunkGeneratorSettingsUA settings) {
        super(p_i45560_1_);
        int i;
        this.field_75909_a = p_i45560_3_;
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            ImmutableList biomesToAdd = BiomeManager.getBiomes((BiomeManager.BiomeType)type);
            int idx = type.ordinal();
            if (this.biomes[idx] == null) {
                this.biomes[idx] = new ArrayList<BiomeManager.BiomeEntry>();
            }
            if (biomesToAdd == null) continue;
            this.biomes[idx].addAll((Collection<BiomeManager.BiomeEntry>)biomesToAdd);
        }
        int desertIdx = BiomeManager.BiomeType.DESERT.ordinal();
        int warmIdx = BiomeManager.BiomeType.WARM.ordinal();
        int coolIdx = BiomeManager.BiomeType.COOL.ordinal();
        int icyIdx = BiomeManager.BiomeType.ICY.ordinal();
        for (i = 0; i < 6; ++i) {
            this.biomes[warmIdx].remove(0);
        }
        for (i = 0; i < 4; ++i) {
            this.biomes[coolIdx].remove(0);
        }
        for (i = 0; i < 2; ++i) {
            this.biomes[icyIdx].remove(0);
        }
        if (settings.desert) {
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BiomeDesert, 30));
        }
        if (settings.savanna) {
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BiomeSavanna, 20));
        }
        if (settings.plains) {
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BiomePlains, 10));
        }
        if (settings.bambooForest) {
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BiomeBambooForest, 10));
        }
        if (settings.forest) {
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BiomeForest, 10));
        }
        if (settings.roofedForest) {
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BiomeRoofedForest, 10));
        }
        if (settings.extremeHills) {
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BiomeExtremeHills, 10));
        }
        if (settings.plains) {
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BiomePlains, 10));
        }
        if (settings.birchForest) {
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BiomeBirchForest, 10));
        }
        if (settings.swamplands) {
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BiomeSwampland, 10));
        }
        if (settings.forest) {
            this.biomes[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BiomeForest, 10));
        }
        if (settings.extremeHills) {
            this.biomes[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BiomeExtremeHills, 10));
        }
        if (settings.taiga) {
            this.biomes[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BiomeTaiga, 10));
        }
        if (settings.plains) {
            this.biomes[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BiomePlains, 10));
        }
        if (settings.stoneBeach) {
            this.biomes[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BiomeStoneBeach, 10));
        }
        if (settings.iceFlats) {
            this.biomes[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BiomeIceFlats, 30));
        }
        if (settings.iceMountain) {
            this.biomes[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BiomeIceMountain, 20));
        }
        if (settings.coldTaiga) {
            this.biomes[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BiomeColdTaiga, 10));
        }
        if (settings.coldBeach) {
            this.biomes[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BiomeColdBeach, 10));
        }
        if (settings.bambooForest) {
            this.oceanReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.BiomeBambooForest, 10));
        }
        if (settings.iceSpike) {
            this.oceanReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.BiomeIceSpike, 10));
        }
        if (settings.end) {
            this.oceanReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.BiomeEnd, 10));
        }
        if (settings.mesaBryce) {
            this.deepOceanReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.BiomeMesaBryce, 20));
        }
        if (settings.nether) {
            this.deepOceanReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.BiomeNether, 10));
        }
        if (settings.jungle) {
            this.jungleReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.BiomeJungle, 10));
        }
        if (settings.megaTaiga) {
            this.megaTaigaReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.BiomeRedwoodTaiga, 10));
        }
        if (settings.mesa) {
            this.mesaReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.BiomeMesaRock, 20));
            this.mesaReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.BiomeMesaClearRock, 10));
        }
        if (settings.mushroom) {
            this.mushroomReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.BiomeMushroomIsland, 10));
        }
        List<BiomeManager.BiomeEntry> temporaryBiomeList = null;
        if (this.biomes[warmIdx].size() != 0) {
            temporaryBiomeList = this.biomes[warmIdx];
        }
        if (this.biomes[desertIdx].size() != 0 && temporaryBiomeList.size() < 5) {
            temporaryBiomeList = this.biomes[desertIdx];
        }
        if (this.biomes[coolIdx].size() != 0 && temporaryBiomeList.size() < 5) {
            temporaryBiomeList = this.biomes[coolIdx];
        }
        if (this.biomes[icyIdx].size() != 0 && temporaryBiomeList.size() < 5) {
            temporaryBiomeList = this.biomes[icyIdx];
        }
        if (this.jungleReplacedBiomes.size() != 0 && temporaryBiomeList.size() < 5) {
            temporaryBiomeList = this.jungleReplacedBiomes;
        }
        if (this.megaTaigaReplacedBiomes.size() != 0 && temporaryBiomeList.size() < 5) {
            temporaryBiomeList = this.megaTaigaReplacedBiomes;
        }
        if (this.mesaReplacedBiomes.size() != 0 && temporaryBiomeList.size() < 5) {
            temporaryBiomeList = this.mesaReplacedBiomes;
        }
        if (this.mushroomReplacedBiomes.size() != 0 && temporaryBiomeList.size() < 5) {
            temporaryBiomeList = this.mushroomReplacedBiomes;
        }
        if (this.deepOceanReplacedBiomes.size() != 0 && temporaryBiomeList.size() < 5) {
            temporaryBiomeList = this.deepOceanReplacedBiomes;
        }
        if (this.oceanReplacedBiomes.size() != 0 && temporaryBiomeList.size() < 5) {
            temporaryBiomeList = this.oceanReplacedBiomes;
        }
        if (temporaryBiomeList == null) {
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_150575_M, 10));
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry(Biomes.field_150575_M, 10));
            this.biomes[coolIdx].add(new BiomeManager.BiomeEntry(Biomes.field_150575_M, 10));
            this.biomes[icyIdx].add(new BiomeManager.BiomeEntry(Biomes.field_150575_M, 10));
            this.oceanReplacedBiomes.add(new BiomeManager.BiomeEntry(Biomes.field_150575_M, 10));
            this.deepOceanReplacedBiomes.add(new BiomeManager.BiomeEntry(Biomes.field_150575_M, 10));
            this.jungleReplacedBiomes.add(new BiomeManager.BiomeEntry(Biomes.field_150575_M, 10));
            this.megaTaigaReplacedBiomes.add(new BiomeManager.BiomeEntry(Biomes.field_150575_M, 10));
            this.mesaReplacedBiomes.add(new BiomeManager.BiomeEntry(Biomes.field_150575_M, 10));
            this.mushroomReplacedBiomes.add(new BiomeManager.BiomeEntry(Biomes.field_150575_M, 10));
        } else {
            if (this.biomes[warmIdx].size() == 0) {
                this.biomes[warmIdx] = temporaryBiomeList;
            }
            if (this.biomes[desertIdx].size() == 0) {
                this.biomes[desertIdx] = temporaryBiomeList;
            }
            if (this.biomes[coolIdx].size() == 0) {
                this.biomes[coolIdx] = temporaryBiomeList;
            }
            if (this.biomes[icyIdx].size() == 0) {
                this.biomes[icyIdx] = temporaryBiomeList;
            }
            if (this.oceanReplacedBiomes.size() == 0) {
                this.oceanReplacedBiomes = temporaryBiomeList;
            }
            if (this.deepOceanReplacedBiomes.size() == 0) {
                this.deepOceanReplacedBiomes = temporaryBiomeList;
            }
            if (this.jungleReplacedBiomes.size() == 0) {
                this.jungleReplacedBiomes = temporaryBiomeList;
            }
            if (this.megaTaigaReplacedBiomes.size() == 0) {
                this.megaTaigaReplacedBiomes = temporaryBiomeList;
            }
            if (this.mesaReplacedBiomes.size() == 0) {
                this.mesaReplacedBiomes = temporaryBiomeList;
            }
            if (this.mushroomReplacedBiomes.size() == 0) {
                this.mushroomReplacedBiomes = temporaryBiomeList;
            }
        }
    }

    public int[] func_75904_a(int areaX, int areaY, int areaWidth, int areaHeight) {
        int[] aint = this.field_75909_a.func_75904_a(areaX, areaY, areaWidth, areaHeight);
        int[] aint1 = IntCache.func_76445_a((int)(areaWidth * areaHeight));
        for (int i = 0; i < areaHeight; ++i) {
            for (int j = 0; j < areaWidth; ++j) {
                this.func_75903_a(j + areaX, i + areaY);
                int k = aint[j + i * areaWidth];
                int l = (k & 0xF00) >> 8;
                if ((k &= 0xFFFFF0FF) == Biome.func_185362_a((Biome)Biomes.field_76771_b)) {
                    aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedSpecialBiomeEntry(this.oceanReplacedBiomes).biome);
                    continue;
                }
                if (k == Biome.func_185362_a((Biome)Biomes.field_76776_l) || k == Biome.func_185362_a((Biome)Biomes.field_150575_M)) {
                    aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedSpecialBiomeEntry(this.deepOceanReplacedBiomes).biome);
                    continue;
                }
                if (k == 1) {
                    if (l > 0) {
                        aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedSpecialBiomeEntry(this.mesaReplacedBiomes).biome);
                        continue;
                    }
                    aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT).biome);
                    continue;
                }
                if (k == 2) {
                    if (l > 0) {
                        aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedSpecialBiomeEntry(this.jungleReplacedBiomes).biome);
                        continue;
                    }
                    aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM).biome);
                    continue;
                }
                if (k == 3) {
                    if (l > 0) {
                        aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedSpecialBiomeEntry(this.megaTaigaReplacedBiomes).biome);
                        continue;
                    }
                    aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL).biome);
                    continue;
                }
                aint1[j + i * areaWidth] = k == 4 ? Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY).biome) : Biome.func_185362_a((Biome)this.getWeightedSpecialBiomeEntry(this.mushroomReplacedBiomes).biome);
            }
        }
        return aint1;
    }

    protected BiomeManager.BiomeEntry getWeightedBiomeEntry(BiomeManager.BiomeType type) {
        List<BiomeManager.BiomeEntry> biomeList = this.biomes[type.ordinal()];
        int totalWeight = WeightedRandom.func_76272_a(biomeList);
        int weight = BiomeManager.isTypeListModded((BiomeManager.BiomeType)type) ? this.func_75902_a(totalWeight) : this.func_75902_a(totalWeight / 10) * 10;
        return (BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight);
    }

    protected BiomeManager.BiomeEntry getWeightedSpecialBiomeEntry(List<BiomeManager.BiomeEntry> list) {
        List<BiomeManager.BiomeEntry> biomeList = list;
        int totalWeight = WeightedRandom.func_76272_a(biomeList);
        int weight = list.size() != 0 ? this.func_75902_a(totalWeight) : this.func_75902_a(totalWeight / 10) * 10;
        return (BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight);
    }
}

