/*
 * Decompiled with CFR 0.152.
 */
package net.TelepathicGrunt.UltraAmplified.World.gen.structure;

import com.google.common.base.MoreObjects;
import java.util.Random;
import net.TelepathicGrunt.UltraAmplified.World.Generation.ChunkGeneratorOverworldUA;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;

public class MapGenCaveCavity
extends MapGenBase {
    protected static final IBlockState BLK_LAVA = Blocks.field_150353_l.func_176223_P();
    protected static final IBlockState BLK_AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState BLK_WATER = Blocks.field_150355_j.func_176223_P();
    protected static final IBlockState BLK_MAGMA = Blocks.field_189877_df.func_176223_P();
    protected static final IBlockState BLK_OBSIDIAN = Blocks.field_150343_Z.func_176223_P();
    protected static final IBlockState BLK_SANDSTONE = Blocks.field_150322_A.func_176223_P();
    protected static final IBlockState BLK_RED_SANDSTONE = Blocks.field_180395_cM.func_176223_P();
    private final ChunkGeneratorOverworldUA settings;

    public MapGenCaveCavity(ChunkGeneratorOverworldUA settingsIn) {
        this.settings = settingsIn;
    }

    protected void addRoom(long p_180703_1_, int p_180703_3_, int p_180703_4_, ChunkPrimer p_180703_5_, double p_180703_6_, double p_180703_8_, double p_180703_10_) {
        this.addTunnel(p_180703_1_, p_180703_3_, p_180703_4_, p_180703_5_, p_180703_6_, p_180703_8_, p_180703_10_, 1.0f + this.field_75038_b.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5);
    }

    protected void addTunnel(long seed, int chunkX, int chunkZ, ChunkPrimer chunkPrimer, double x, double y, double z, float firstUnknownFloat, float secondUnknownFloat, float thirdUnknownFloat, int firstUnknownInt, int secondUnknownInt, double unknownDouble) {
        boolean flag;
        double d0 = chunkX * 16 + 8;
        double d1 = chunkZ * 16 + 8;
        float f = 0.0f;
        float f1 = 0.0f;
        Random random = new Random(seed);
        if (secondUnknownInt <= 0) {
            int i = this.field_75040_a * 16 - 16;
            secondUnknownInt = i - random.nextInt(i / 4);
        }
        boolean flag2 = false;
        if (firstUnknownInt == -1) {
            firstUnknownInt = secondUnknownInt / 2;
            flag2 = true;
        }
        int j = random.nextInt(secondUnknownInt / 2) + secondUnknownInt / 4;
        boolean bl = flag = random.nextInt(6) == 0;
        while (firstUnknownInt < secondUnknownInt) {
            double d2 = 18.0 + (double)(MathHelper.func_76126_a((float)((float)firstUnknownInt * (float)Math.PI / (float)secondUnknownInt)) * firstUnknownFloat);
            double d3 = d2 * unknownDouble;
            float f2 = MathHelper.func_76134_b((float)thirdUnknownFloat);
            float f3 = ((float)random.nextInt(80) + MathHelper.func_76126_a((float)thirdUnknownFloat) - 40.0f) / 7.0f;
            x += (double)(MathHelper.func_76134_b((float)secondUnknownFloat) * f2);
            y += (double)f3;
            z += (double)(MathHelper.func_76126_a((float)secondUnknownFloat) * f2);
            thirdUnknownFloat = flag ? (thirdUnknownFloat *= 0.92f) : (thirdUnknownFloat *= 0.7f);
            thirdUnknownFloat += f1 * 0.1f;
            secondUnknownFloat += f * 0.1f;
            f1 *= 0.9f;
            f *= 0.75f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (!flag2 && firstUnknownInt == j && firstUnknownFloat > 1.0f && secondUnknownInt > 0) {
                this.addTunnel(random.nextLong(), chunkX, chunkZ, chunkPrimer, x, y, z, random.nextFloat() * 0.5f + 0.5f, secondUnknownFloat - 1.5707964f, thirdUnknownFloat / 3.0f, firstUnknownInt, secondUnknownInt, 1.0);
                this.addTunnel(random.nextLong(), chunkX, chunkZ, chunkPrimer, x, y, z, random.nextFloat() * 0.5f + 0.5f, secondUnknownFloat + 1.5707964f, thirdUnknownFloat / 3.0f, firstUnknownInt, secondUnknownInt, 1.0);
                return;
            }
            if (flag2 || random.nextInt(4) != 0) {
                double d4 = x - d0;
                double d5 = z - d1;
                double d6 = secondUnknownInt - firstUnknownInt;
                double d7 = firstUnknownFloat + 2.0f + 16.0f;
                if (d4 * d4 + d5 * d5 - d6 * d6 > d7 * d7) {
                    return;
                }
                if (x >= d0 - 16.0 - d2 * 2.0 && z >= d1 - 16.0 - d2 * 2.0 && x <= d0 + 16.0 + d2 * 2.0 && z <= d1 + 16.0 + d2 * 2.0) {
                    int k2 = MathHelper.func_76128_c((double)(x - d2)) - chunkX * 16 - 1;
                    int k = MathHelper.func_76128_c((double)(x + d2)) - chunkX * 16 + 1;
                    int l2 = MathHelper.func_76128_c((double)(y - d3)) - 1;
                    int l = MathHelper.func_76128_c((double)(y + d3)) + 1;
                    int i3 = MathHelper.func_76128_c((double)(z - d2)) - chunkZ * 16 - 1;
                    int i1 = MathHelper.func_76128_c((double)(z + d2)) - chunkZ * 16 + 1;
                    if (k2 < 0) {
                        k2 = 0;
                    }
                    if (k > 16) {
                        k = 16;
                    }
                    if (l2 < 1) {
                        l2 = 1;
                    }
                    if (l > 248) {
                        l = 248;
                    }
                    if (i3 < 0) {
                        i3 = 0;
                    }
                    if (i1 > 16) {
                        i1 = 16;
                    }
                    for (int j1 = k2; j1 < k; ++j1) {
                        for (int k1 = i3; k1 < i1; ++k1) {
                            for (int l1 = l + 1; l1 >= l2 - 1; --l1) {
                                if (l1 < 0 || l1 >= 256) continue;
                                IBlockState iblockstate = chunkPrimer.func_177856_a(j1, l1, k1);
                                if (l1 == l2 - 1 || j1 == k2 || j1 == k - 1 || k1 == i3 || k1 == i1 - 1) continue;
                                l1 = l2;
                            }
                        }
                    }
                    BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                    for (int xInChunk = k2; xInChunk < k; ++xInChunk) {
                        double d10 = ((double)(xInChunk + chunkX * 16) + 0.5 - x) / d2;
                        for (int zInChunk = i3; zInChunk < i1; ++zInChunk) {
                            double d8 = ((double)(zInChunk + chunkZ * 16) + 0.5 - z) / d2;
                            blockpos$mutableblockpos.func_181079_c(xInChunk + chunkX * 16, 0, zInChunk + chunkZ * 16);
                            boolean flag1 = false;
                            if (!(d10 * d10 + d8 * d8 < 1.0)) continue;
                            for (int j2 = l; j2 > l2; --j2) {
                                double d9 = ((double)(j2 - 1) + 0.5 - y) / d3;
                                if (!(d9 > -0.7) || !(d10 * d10 + d9 * d9 + d8 * d8 < 1.0)) continue;
                                IBlockState iblockstate1 = chunkPrimer.func_177856_a(xInChunk, j2, zInChunk);
                                IBlockState iblockstate2 = (IBlockState)MoreObjects.firstNonNull((Object)chunkPrimer.func_177856_a(xInChunk, j2 + 1, zInChunk), (Object)BLK_AIR);
                                if (iblockstate1.func_177230_c() == Blocks.field_150349_c || iblockstate1.func_177230_c() == Blocks.field_150391_bh) {
                                    flag1 = true;
                                }
                                if (!this.canReplaceBlock(iblockstate1, iblockstate2)) continue;
                                if (j2 - 1 < 10) {
                                    chunkPrimer.func_177855_a(xInChunk, j2, zInChunk, BLK_LAVA);
                                    continue;
                                }
                                chunkPrimer.func_177855_a(xInChunk, j2, zInChunk, BLK_AIR);
                                if (!flag1 || chunkPrimer.func_177856_a(xInChunk, j2 - 1, zInChunk).func_177230_c() != Blocks.field_150346_d) continue;
                                chunkPrimer.func_177855_a(xInChunk, j2 - 1, zInChunk, this.field_75039_c.func_180494_b((BlockPos)blockpos$mutableblockpos).field_76752_A.func_177230_c().func_176223_P());
                            }
                        }
                        if (flag2) break;
                    }
                }
            }
            ++firstUnknownInt;
        }
    }

    protected boolean canReplaceBlock(IBlockState p_175793_1_, IBlockState p_175793_2_) {
        if (p_175793_1_.func_177230_c() == Blocks.field_150348_b) {
            return true;
        }
        if (p_175793_1_.func_177230_c() == Blocks.field_150424_aL) {
            return true;
        }
        if (p_175793_1_.func_177230_c() == Blocks.field_150377_bs) {
            return true;
        }
        if (p_175793_1_.func_177230_c() == Blocks.field_150432_aD) {
            return true;
        }
        if (p_175793_1_.func_177230_c() == Blocks.field_150355_j) {
            return true;
        }
        if (p_175793_1_.func_177230_c() == Blocks.field_150353_l) {
            return true;
        }
        if (p_175793_1_.func_177230_c() == Blocks.field_150346_d) {
            return true;
        }
        if (p_175793_1_.func_177230_c() == Blocks.field_150433_aE) {
            return true;
        }
        if (p_175793_1_.func_177230_c() == Blocks.field_150405_ch) {
            return true;
        }
        if (p_175793_1_.func_177230_c() == Blocks.field_150406_ce) {
            return true;
        }
        if (p_175793_1_.func_177230_c() == Blocks.field_150349_c) {
            return true;
        }
        if (p_175793_1_.func_177230_c() == Blocks.field_150322_A) {
            return true;
        }
        if (p_175793_1_.func_177230_c() == Blocks.field_180395_cM) {
            return true;
        }
        if (p_175793_1_.func_177230_c() == Blocks.field_150391_bh) {
            return true;
        }
        if (p_175793_1_.func_177230_c() == Blocks.field_150431_aC) {
            return true;
        }
        return p_175793_1_.func_177230_c() == Blocks.field_150354_m || p_175793_1_.func_177230_c() == Blocks.field_150351_n;
    }

    protected void func_180701_a(World worldIn, int chunkX, int chunkZ, int p_180701_4_, int p_180701_5_, ChunkPrimer chunkPrimerIn) {
        if (this.field_75038_b.nextInt(700 - this.settings.settings.caveCavityCount) != 0) {
            return;
        }
        int i = this.field_75038_b.nextInt(5) + 5;
        for (int j = 0; j < i; ++j) {
            double x = chunkX * 16 + this.field_75038_b.nextInt(120);
            double y = this.field_75038_b.nextInt(this.field_75038_b.nextInt(15) + 5);
            double z = chunkZ * 16 + this.field_75038_b.nextInt(120);
            int k = 1;
            this.addRoom(this.field_75038_b.nextLong(), p_180701_4_, p_180701_5_, chunkPrimerIn, x, y, z);
            k += this.field_75038_b.nextInt(4);
            for (int l = 0; l < k; ++l) {
                float f = this.field_75038_b.nextFloat() * ((float)Math.PI * 2);
                float f1 = (this.field_75038_b.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float f2 = this.field_75038_b.nextFloat() * 2.0f + this.field_75038_b.nextFloat();
                if (this.field_75038_b.nextInt(10) == 0) {
                    f2 *= this.field_75038_b.nextFloat() * this.field_75038_b.nextFloat() * 3.0f + 1.0f;
                }
                this.addTunnel(this.field_75038_b.nextLong(), p_180701_4_, p_180701_5_, chunkPrimerIn, x, y, z, f2, f, f1, 0, 0, 1.0);
            }
        }
    }

    protected boolean isOceanBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ) {
        Block block = data.func_177856_a(x, y, z).func_177230_c();
        return block == Blocks.field_150358_i || block == Blocks.field_150355_j;
    }

    private boolean isExceptionBiome(Biome biome) {
        if (biome == Biomes.field_76787_r) {
            return true;
        }
        return biome == Biomes.field_76769_d;
    }

    private boolean isTopBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ) {
        Biome biome = this.field_75039_c.func_180494_b(new BlockPos(x + chunkX * 16, 0, z + chunkZ * 16));
        IBlockState state = data.func_177856_a(x, y, z);
        return this.isExceptionBiome(biome) ? state.func_177230_c() == Blocks.field_150349_c : state.func_177230_c() == biome.field_76752_A;
    }
}

