/*
 * Decompiled with CFR 0.152.
 */
package net.TelepathicGrunt.UltraAmplified.World.gen.structure;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.TelepathicGrunt.UltraAmplified.World.Biome.BiomeInit;
import net.TelepathicGrunt.UltraAmplified.World.Generation.ChunkGeneratorOverworldUA;
import net.TelepathicGrunt.UltraAmplified.World.gen.structure.StructureEndCityPiecesUA;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenEndCityUA
extends MapGenStructure {
    private final int citySpacing = 25;
    private final int minCitySeparation = 5;
    private ChunkGeneratorOverworldUA overworldProvider;
    public static final List<Biome> field_191072_a = Arrays.asList(BiomeInit.BiomeEnd);

    public MapGenEndCityUA(ChunkGeneratorOverworldUA chunky) {
        this.overworldProvider = chunky;
    }

    public String func_143025_a() {
        return "EndCity";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        boolean flag;
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            i = chunkX - 1;
        }
        if (chunkZ < 0) {
            j = chunkZ - 1;
        }
        int k = i / 25;
        int l = j / 25;
        Random random = this.field_75039_c.func_72843_D(k, l, 10387319);
        k *= 25;
        l *= 25;
        return (k += random.nextInt(17)) == i && (l += random.nextInt(17)) == j && (flag = this.field_75039_c.func_72959_q().func_76940_a(chunkX * 16 + 8, chunkZ * 16 + 8, 0, field_191072_a));
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.overworldProvider, this.field_75038_b, chunkX, chunkZ);
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        return MapGenEndCityUA.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)20, (int)11, (int)10387313, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    private static int getYPosForStructure(int p_191070_0_, int p_191070_1_, ChunkGeneratorOverworldUA p_191070_2_) {
        Random random = new Random(p_191070_0_ + p_191070_1_ * 10387313);
        Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        ChunkPrimer chunkprimer = new ChunkPrimer();
        p_191070_2_.setBlocksInChunk(p_191070_0_, p_191070_1_, chunkprimer);
        int i = 5;
        int j = 5;
        if (rotation == Rotation.CLOCKWISE_90) {
            i = -5;
        } else if (rotation == Rotation.CLOCKWISE_180) {
            i = -5;
            j = -5;
        } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
            j = -5;
        }
        int k = chunkprimer.func_186138_a(7, 7);
        int l = chunkprimer.func_186138_a(7, 7 + j);
        int i1 = chunkprimer.func_186138_a(7 + i, 7);
        int j1 = chunkprimer.func_186138_a(7 + i, 7 + j);
        int k1 = Math.min(Math.min(Math.min(k, l), Math.min(i1, j1)), 120);
        return k1;
    }

    public static class Start
    extends StructureStart {
        private boolean isSizeable;

        public Start() {
        }

        public Start(World worldIn, ChunkGeneratorOverworldUA chunkProvider, Random random, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            this.create(worldIn, chunkProvider, random, chunkX, chunkZ);
        }

        private void create(World worldIn, ChunkGeneratorOverworldUA chunkProvider, Random rnd, int chunkX, int chunkZ) {
            Random random = new Random(chunkX + chunkZ * 10387313);
            Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
            int i = MapGenEndCityUA.getYPosForStructure(chunkX, chunkZ, chunkProvider);
            if (i < 60) {
                this.isSizeable = false;
            } else {
                BlockPos blockpos = new BlockPos(chunkX * 16 + 8, i, chunkZ * 16 + 8);
                StructureEndCityPiecesUA.startHouseTower(worldIn.func_72860_G().func_186340_h(), blockpos, rotation, this.field_75075_a, rnd);
                this.func_75072_c();
                this.isSizeable = true;
            }
        }

        public boolean func_75069_d() {
            return this.isSizeable;
        }
    }
}

