/*
 * Decompiled with CFR 0.152.
 */
package net.TelepathicGrunt.UltraAmplified.World.gen.structure;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.TelepathicGrunt.UltraAmplified.World.Biome.BiomeInit;
import net.TelepathicGrunt.UltraAmplified.World.Generation.ChunkGeneratorOverworldUA;
import net.TelepathicGrunt.UltraAmplified.World.gen.structure.ComponentScatteredFeaturePiecesUA;
import net.TelepathicGrunt.UltraAmplified.World.gen.structure.StructureEndCityPiecesUA;
import net.TelepathicGrunt.UltraAmplified.World.gen.structure.StructureNetherBridgePiecesUA;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenScatteredFeatureUA
extends MapGenStructure {
    private static final List<Biome> BIOMELIST = Arrays.asList(BiomeInit.BiomeNether, BiomeInit.BiomeEnd, BiomeInit.BiomeDesert, BiomeInit.BiomeDesertHills, BiomeInit.BiomeJungle, BiomeInit.BiomeJungleEdge, BiomeInit.BiomeJungleEdgeM, BiomeInit.BiomeJungleHills, BiomeInit.BiomeJungleM, BiomeInit.BiomeSwampland, BiomeInit.BiomeSwamplandM, BiomeInit.BiomeIceFlats, BiomeInit.BiomeIceSpike, BiomeInit.BiomeColdTaiga);
    private final List<Biome.SpawnListEntry> monsters = Lists.newArrayList();
    private int maxDistanceBetweenScatteredFeatures;
    private int separation = 8;

    public MapGenScatteredFeatureUA(ChunkGeneratorOverworldUA settings) {
        this.maxDistanceBetweenScatteredFeatures = settings.settings.templeRarity;
        this.monsters.add(new Biome.SpawnListEntry(EntityWitch.class, 1, 1, 1));
    }

    public String func_143025_a() {
        return "Temple";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        boolean flag;
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        int k = chunkX / this.maxDistanceBetweenScatteredFeatures;
        int l = chunkZ / this.maxDistanceBetweenScatteredFeatures;
        Random random = this.field_75039_c.func_72843_D(k, l, 14357617);
        k *= this.maxDistanceBetweenScatteredFeatures;
        l *= this.maxDistanceBetweenScatteredFeatures;
        return (k += random.nextInt(this.maxDistanceBetweenScatteredFeatures - 8)) == i && (l += random.nextInt(this.maxDistanceBetweenScatteredFeatures - 8)) == j && (flag = this.field_75039_c.func_72959_q().func_76940_a(i * 16 + 8, j * 16 + 8, 0, BIOMELIST));
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        return MapGenScatteredFeatureUA.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)this.maxDistanceBetweenScatteredFeatures, (int)this.separation, (int)14357617, (boolean)false, (int)100, (boolean)findUnexplored);
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    public boolean isSwampHut(BlockPos p_175798_1_) {
        StructureStart structurestart = this.func_175797_c(p_175798_1_);
        if (structurestart != null && structurestart instanceof Start && !structurestart.func_186161_c().isEmpty()) {
            StructureComponent structurecomponent = (StructureComponent)structurestart.func_186161_c().get(0);
            return structurecomponent instanceof ComponentScatteredFeaturePiecesUA.SwampHut;
        }
        return false;
    }

    public List<Biome.SpawnListEntry> getMonsters() {
        return this.monsters;
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(World worldIn, Random random, int chunkX, int chunkZ) {
            this(worldIn, random, chunkX, chunkZ, worldIn.func_180494_b(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8)));
        }

        public Start(World worldIn, Random random, int chunkX, int chunkZ, Biome biomeIn) {
            super(chunkX, chunkZ);
            if (random.nextInt(4) < 3) {
                if (biomeIn != BiomeInit.BiomeJungle && biomeIn != BiomeInit.BiomeJungleEdge && biomeIn != BiomeInit.BiomeJungleEdgeM && biomeIn != BiomeInit.BiomeJungleHills && biomeIn != BiomeInit.BiomeJungleM) {
                    if (biomeIn == BiomeInit.BiomeSwampland || biomeIn == BiomeInit.BiomeSwamplandM) {
                        System.out.println("Witch Hut | " + chunkX * 16 + " " + chunkZ * 16);
                        ComponentScatteredFeaturePiecesUA.SwampHut componentscatteredfeaturepieces$swamphut = new ComponentScatteredFeaturePiecesUA.SwampHut(random, chunkX * 16, chunkZ * 16);
                        this.field_75075_a.add(componentscatteredfeaturepieces$swamphut);
                    } else if (biomeIn != BiomeInit.BiomeDesert && biomeIn != BiomeInit.BiomeDesertHills) {
                        if (biomeIn != BiomeInit.BiomeIceFlats && biomeIn != BiomeInit.BiomeColdTaiga && biomeIn != BiomeInit.BiomeIceSpike) {
                            if (biomeIn == BiomeInit.BiomeEnd) {
                                System.out.println("End City | " + chunkX * 16 + " " + chunkZ * 16);
                                this.createEndCity(worldIn, random, chunkX, chunkZ);
                            }
                        } else {
                            System.out.println("Igloo | " + chunkX * 16 + " " + chunkZ * 16);
                            ComponentScatteredFeaturePiecesUA.Igloo componentscatteredfeaturepieces$igloo = new ComponentScatteredFeaturePiecesUA.Igloo(random, chunkX * 16, chunkZ * 16);
                            this.field_75075_a.add(componentscatteredfeaturepieces$igloo);
                        }
                    } else {
                        System.out.println("Desert Temple | " + chunkX * 16 + " " + chunkZ * 16);
                        ComponentScatteredFeaturePiecesUA.DesertPyramid componentscatteredfeaturepieces$desertpyramid = new ComponentScatteredFeaturePiecesUA.DesertPyramid(random, chunkX * 16, chunkZ * 16);
                        this.field_75075_a.add(componentscatteredfeaturepieces$desertpyramid);
                    }
                } else {
                    System.out.println("Jungle Temple | " + chunkX * 16 + " " + chunkZ * 16);
                    ComponentScatteredFeaturePiecesUA.JunglePyramid componentscatteredfeaturepieces$junglepyramid = new ComponentScatteredFeaturePiecesUA.JunglePyramid(random, chunkX * 16, chunkZ * 16);
                    this.field_75075_a.add(componentscatteredfeaturepieces$junglepyramid);
                }
                this.func_75072_c();
                if (biomeIn == BiomeInit.BiomeNether) {
                    System.out.println("Nether Fortress | aboveground | " + chunkX * 16 + " " + chunkZ * 16);
                    StructureNetherBridgePiecesUA.Start structurenetherbridgepieces$start = new StructureNetherBridgePiecesUA.Start(random, (chunkX << 4) + 2, (chunkZ << 4) + 2);
                    this.field_75075_a.add(structurenetherbridgepieces$start);
                    structurenetherbridgepieces$start.func_74861_a(structurenetherbridgepieces$start, this.field_75075_a, random);
                    List<StructureComponent> list = structurenetherbridgepieces$start.pendingChildren;
                    while (!list.isEmpty()) {
                        int i = random.nextInt(list.size());
                        StructureComponent structurecomponent = list.remove(i);
                        structurecomponent.func_74861_a((StructureComponent)structurenetherbridgepieces$start, this.field_75075_a, random);
                    }
                    this.func_75072_c();
                    this.func_75070_a(worldIn, random, 65, 165);
                }
            } else {
                System.out.println("Nether Fortress | underground | " + chunkX * 16 + " " + chunkZ * 16);
                StructureNetherBridgePiecesUA.Start structurenetherbridgepieces$start = new StructureNetherBridgePiecesUA.Start(random, (chunkX << 4) + 2, (chunkZ << 4) + 2);
                this.field_75075_a.add(structurenetherbridgepieces$start);
                structurenetherbridgepieces$start.func_74861_a(structurenetherbridgepieces$start, this.field_75075_a, random);
                List<StructureComponent> list = structurenetherbridgepieces$start.pendingChildren;
                while (!list.isEmpty()) {
                    int i = random.nextInt(list.size());
                    StructureComponent structurecomponent = list.remove(i);
                    structurecomponent.func_74861_a((StructureComponent)structurenetherbridgepieces$start, this.field_75075_a, random);
                }
                this.func_75072_c();
                this.func_75070_a(worldIn, random, 20, 35);
            }
        }

        private void createEndCity(World worldIn, Random rnd, int chunkX, int chunkZ) {
            Random random = new Random(chunkX + chunkZ * 10387313);
            Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
            BlockPos blockpos = new BlockPos(chunkX * 16 + 8, 145, chunkZ * 16 + 8);
            StructureEndCityPiecesUA.startHouseTower(worldIn.func_72860_G().func_186340_h(), blockpos, rotation, this.field_75075_a, rnd);
            this.func_75072_c();
        }
    }
}

