/*
 * Decompiled with CFR 0.152.
 */
package net.TelepathicGrunt.UltraAmplified.World.gen.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.TelepathicGrunt.UltraAmplified.World.Generation.ChunkGeneratorOverworldUA;
import net.TelepathicGrunt.UltraAmplified.World.gen.structure.StructureStrongholdPiecesUA;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.common.BiomeManager;

public class MapGenStrongholdUA
extends MapGenStructure {
    private final List<Biome> allowedBiomes;
    private boolean ranBiomeCheck;
    private ChunkPos[] structureCoords;
    private float distance;
    private int spread;

    public MapGenStrongholdUA(ChunkGeneratorOverworldUA settings) {
        this.structureCoords = new ChunkPos[settings.settings.strongholdCount];
        this.distance = settings.settings.strongholdDistance;
        this.spread = settings.settings.strongholdSpread;
        this.allowedBiomes = Lists.newArrayList();
        for (Biome biome : Biome.field_185377_q) {
            if (biome == null || !(biome.func_185355_j() > 0.0f) || BiomeManager.strongHoldBiomesBlackList.contains(biome)) continue;
            this.allowedBiomes.add(biome);
        }
        for (Biome biome : BiomeManager.strongHoldBiomes) {
            if (this.allowedBiomes.contains(biome)) continue;
            this.allowedBiomes.add(biome);
        }
    }

    public String func_143025_a() {
        return "Stronghold";
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        if (!this.ranBiomeCheck) {
            this.generatePositions();
            this.ranBiomeCheck = true;
        }
        BlockPos blockpos = null;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(0, 0, 0);
        double d0 = Double.MAX_VALUE;
        for (ChunkPos chunkpos : this.structureCoords) {
            blockpos$mutableblockpos.func_181079_c((chunkpos.field_77276_a << 4) + 8, 32, (chunkpos.field_77275_b << 4) + 8);
            double d1 = blockpos$mutableblockpos.func_177951_i((Vec3i)pos);
            if (blockpos == null) {
                blockpos = new BlockPos((Vec3i)blockpos$mutableblockpos);
                d0 = d1;
                continue;
            }
            if (!(d1 < d0)) continue;
            blockpos = new BlockPos((Vec3i)blockpos$mutableblockpos);
            d0 = d1;
        }
        return blockpos;
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        if (!this.ranBiomeCheck) {
            this.generatePositions();
            this.ranBiomeCheck = true;
        }
        for (ChunkPos chunkpos : this.structureCoords) {
            if (chunkX != chunkpos.field_77276_a || chunkZ != chunkpos.field_77275_b) continue;
            return true;
        }
        return false;
    }

    private void generatePositions() {
        this.func_143027_a(this.field_75039_c);
        int i = 0;
        for (StructureStart structurestart : this.field_75053_d.values()) {
            if (i >= this.structureCoords.length) continue;
            this.structureCoords[i++] = new ChunkPos(structurestart.func_143019_e(), structurestart.func_143018_f());
        }
        Random random = new Random();
        random.setSeed(this.field_75039_c.func_72905_C());
        double d1 = random.nextDouble() * Math.PI * 2.0;
        int j = 0;
        int k = 0;
        int l = this.field_75053_d.size();
        if (l < this.structureCoords.length) {
            for (int i1 = 0; i1 < this.structureCoords.length; ++i1) {
                float f0 = 4.0f * this.distance + this.distance * (float)j * 6.0f + (random.nextFloat() - 0.5f) * this.distance * 2.5f;
                int j1 = (int)Math.round(Math.cos(d1) * (double)f0);
                int k1 = (int)Math.round(Math.sin(d1) * (double)f0);
                BlockPos blockpos = this.field_75039_c.func_72959_q().func_180630_a((j1 << 4) + 8, (k1 << 4) + 8, 112, this.allowedBiomes, random);
                if (blockpos != null) {
                    j1 = blockpos.func_177958_n() >> 4;
                    k1 = blockpos.func_177952_p() >> 4;
                }
                if (i1 >= l) {
                    this.structureCoords[i1] = new ChunkPos(j1, k1);
                }
                d1 += Math.PI * 2 / (double)this.spread;
                if (++k != this.spread) continue;
                k = 0;
                this.spread += 2 * this.spread / (++j + 1);
                this.spread = Math.min(this.spread, this.structureCoords.length - i1);
                d1 += random.nextDouble() * Math.PI * 2.0;
            }
        }
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        System.out.println("Stronghold | " + chunkX * 16 + " " + chunkZ * 16);
        Start mapgenstronghold$start = new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
        while (mapgenstronghold$start.func_186161_c().isEmpty() || ((StructureStrongholdPiecesUA.Stairs2)((Object)mapgenstronghold$start.func_186161_c().get((int)0))).strongholdPortalRoom == null) {
            mapgenstronghold$start = new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
        }
        return mapgenstronghold$start;
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(World worldIn, Random random, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            StructureStrongholdPiecesUA.prepareStructurePieces();
            StructureStrongholdPiecesUA.Stairs2 structurestrongholdpieces$stairs2 = new StructureStrongholdPiecesUA.Stairs2(0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2);
            this.field_75075_a.add(structurestrongholdpieces$stairs2);
            structurestrongholdpieces$stairs2.func_74861_a(structurestrongholdpieces$stairs2, this.field_75075_a, random);
            List<StructureComponent> list = structurestrongholdpieces$stairs2.pendingChildren;
            while (!list.isEmpty()) {
                int i = random.nextInt(list.size());
                StructureComponent structurecomponent = list.remove(i);
                structurecomponent.func_74861_a((StructureComponent)structurestrongholdpieces$stairs2, this.field_75075_a, random);
            }
            this.func_75072_c();
        }
    }
}

