/*
 * Decompiled with CFR 0.152.
 */
package net.TelepathicGrunt.UltraAmplified.World.gen.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.TelepathicGrunt.UltraAmplified.Config.UAConfig;
import net.TelepathicGrunt.UltraAmplified.World.gen.structure.MapGenMineshaftUA;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockEndRod;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class StructureMineshaftPiecesUA {
    public static void registerStructurePieces() {
        MapGenStructureIO.func_143031_a(Corridor.class, (String)"MSCorridor");
        MapGenStructureIO.func_143031_a(Cross.class, (String)"MSCrossing");
        MapGenStructureIO.func_143031_a(Room.class, (String)"MSRoom");
        MapGenStructureIO.func_143031_a(Stairs.class, (String)"MSStairs");
    }

    private static Peice func_189940_a(List<StructureComponent> p_189940_0_, Random p_189940_1_, int p_189940_2_, int p_189940_3_, int p_189940_4_, @Nullable EnumFacing p_189940_5_, int p_189940_6_, MapGenMineshaftUA.Type p_189940_7_) {
        int i = p_189940_1_.nextInt(100);
        if (i >= 80) {
            StructureBoundingBox structureboundingbox = Cross.findCrossing(p_189940_0_, p_189940_1_, p_189940_2_, p_189940_3_, p_189940_4_, p_189940_5_);
            if (structureboundingbox != null) {
                return new Cross(p_189940_6_, p_189940_1_, structureboundingbox, p_189940_5_, p_189940_7_);
            }
        } else if (i >= 70) {
            StructureBoundingBox structureboundingbox1 = Stairs.findStairs(p_189940_0_, p_189940_1_, p_189940_2_, p_189940_3_, p_189940_4_, p_189940_5_);
            if (structureboundingbox1 != null) {
                return new Stairs(p_189940_6_, p_189940_1_, structureboundingbox1, p_189940_5_, p_189940_7_);
            }
        } else {
            StructureBoundingBox structureboundingbox2 = Corridor.findCorridorSize(p_189940_0_, p_189940_1_, p_189940_2_, p_189940_3_, p_189940_4_, p_189940_5_);
            if (structureboundingbox2 != null) {
                return new Corridor(p_189940_6_, p_189940_1_, structureboundingbox2, p_189940_5_, p_189940_7_);
            }
        }
        return null;
    }

    private static Peice func_189938_b(StructureComponent p_189938_0_, List<StructureComponent> p_189938_1_, Random p_189938_2_, int p_189938_3_, int p_189938_4_, int p_189938_5_, EnumFacing p_189938_6_, int p_189938_7_) {
        if (p_189938_7_ > 8) {
            return null;
        }
        if (Math.abs(p_189938_3_ - p_189938_0_.func_74874_b().field_78897_a) <= 80 && Math.abs(p_189938_5_ - p_189938_0_.func_74874_b().field_78896_c) <= 80) {
            MapGenMineshaftUA.Type mapgenmineshaft$type = ((Peice)p_189938_0_).mineShaftType;
            Peice structuremineshaftpieces$peice = StructureMineshaftPiecesUA.func_189940_a(p_189938_1_, p_189938_2_, p_189938_3_, p_189938_4_, p_189938_5_, p_189938_6_, p_189938_7_ + 1, mapgenmineshaft$type);
            if (structuremineshaftpieces$peice != null) {
                p_189938_1_.add(structuremineshaftpieces$peice);
                structuremineshaftpieces$peice.func_74861_a(p_189938_0_, p_189938_1_, p_189938_2_);
            }
            return structuremineshaftpieces$peice;
        }
        return null;
    }

    public static class Stairs
    extends Peice {
        public Stairs() {
        }

        public Stairs(int p_i47136_1_, Random p_i47136_2_, StructureBoundingBox p_i47136_3_, EnumFacing p_i47136_4_, MapGenMineshaftUA.Type p_i47136_5_) {
            super(p_i47136_1_, p_i47136_5_);
            this.func_186164_a(p_i47136_4_);
            this.field_74887_e = p_i47136_3_;
        }

        public static StructureBoundingBox findStairs(List<StructureComponent> listIn, Random rand, int x, int y, int z, EnumFacing facing) {
            StructureBoundingBox structureboundingbox = new StructureBoundingBox(x, y - 5, z, x, y + 2, z);
            switch (facing) {
                default: {
                    structureboundingbox.field_78893_d = x + 2;
                    structureboundingbox.field_78896_c = z - 8;
                    break;
                }
                case SOUTH: {
                    structureboundingbox.field_78893_d = x + 2;
                    structureboundingbox.field_78892_f = z + 8;
                    break;
                }
                case WEST: {
                    structureboundingbox.field_78897_a = x - 8;
                    structureboundingbox.field_78892_f = z + 2;
                    break;
                }
                case EAST: {
                    structureboundingbox.field_78893_d = x + 8;
                    structureboundingbox.field_78892_f = z + 2;
                }
            }
            return StructureComponent.func_74883_a(listIn, (StructureBoundingBox)structureboundingbox) != null ? null : structureboundingbox;
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            int i = this.func_74877_c();
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                        break;
                    }
                    case SOUTH: {
                        StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                        break;
                    }
                    case WEST: {
                        StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.WEST, i);
                        break;
                    }
                    case EAST: {
                        StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.EAST, i);
                    }
                }
            }
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.func_74860_a(worldIn, structureBoundingBoxIn)) {
                return false;
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 0, 2, 7, 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 7, 2, 2, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            for (int i = 0; i < 5; ++i) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5 - i - (i < 4 ? 1 : 0), 2 + i, 2, 7 - i, 2 + i, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            return true;
        }
    }

    public static class Room
    extends Peice {
        private final List<StructureBoundingBox> roomsLinkedToTheRoom = Lists.newLinkedList();

        public Room() {
        }

        public Room(int p_i47137_1_, Random p_i47137_2_, int p_i47137_3_, int p_i47137_4_, MapGenMineshaftUA.Type p_i47137_5_) {
            super(p_i47137_1_, p_i47137_5_);
            this.mineShaftType = p_i47137_5_;
            if (p_i47137_2_.nextInt(5) < 3) {
                this.field_74887_e = new StructureBoundingBox(p_i47137_3_, 20, p_i47137_4_, p_i47137_3_ + 7 + p_i47137_2_.nextInt(6), 30, p_i47137_4_ + 7 + p_i47137_2_.nextInt(6));
            } else {
                int height = p_i47137_2_.nextInt(90);
                this.field_74887_e = new StructureBoundingBox(p_i47137_3_, 20, p_i47137_4_, p_i47137_3_ + 7 + p_i47137_2_.nextInt(6), 150 + height, p_i47137_4_ + 7 + p_i47137_2_.nextInt(6));
            }
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            int l;
            int i = this.func_74877_c();
            int k = this.field_74887_e.func_78882_c() - 3 - 1;
            if (k <= 0) {
                k = 1;
            }
            int j = 0;
            while (j < this.field_74887_e.func_78883_b() && (l = j + rand.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b()) {
                Peice structuremineshaftpieces$peice = StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a + l, this.field_74887_e.field_78895_b + rand.nextInt(k) + 1, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                if (structuremineshaftpieces$peice != null) {
                    StructureBoundingBox structureboundingbox = structuremineshaftpieces$peice.func_74874_b();
                    this.roomsLinkedToTheRoom.add(new StructureBoundingBox(structureboundingbox.field_78897_a, structureboundingbox.field_78895_b, this.field_74887_e.field_78896_c, structureboundingbox.field_78893_d, structureboundingbox.field_78894_e, this.field_74887_e.field_78896_c + 1));
                }
                j = l + 4;
            }
            int i1 = 0;
            while (i1 < this.field_74887_e.func_78883_b() && (l = i1 + rand.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b()) {
                Peice structuremineshaftpieces$peice1 = StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a + l, this.field_74887_e.field_78895_b + rand.nextInt(k) + 1, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                if (structuremineshaftpieces$peice1 != null) {
                    StructureBoundingBox structureboundingbox1 = structuremineshaftpieces$peice1.func_74874_b();
                    this.roomsLinkedToTheRoom.add(new StructureBoundingBox(structureboundingbox1.field_78897_a, structureboundingbox1.field_78895_b, this.field_74887_e.field_78892_f - 1, structureboundingbox1.field_78893_d, structureboundingbox1.field_78894_e, this.field_74887_e.field_78892_f));
                }
                i1 = l + 4;
            }
            int j1 = 0;
            while (j1 < this.field_74887_e.func_78880_d() && (l = j1 + rand.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d()) {
                Peice structuremineshaftpieces$peice2 = StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + rand.nextInt(k) + 1, this.field_74887_e.field_78896_c + l, EnumFacing.WEST, i);
                if (structuremineshaftpieces$peice2 != null) {
                    StructureBoundingBox structureboundingbox2 = structuremineshaftpieces$peice2.func_74874_b();
                    this.roomsLinkedToTheRoom.add(new StructureBoundingBox(this.field_74887_e.field_78897_a, structureboundingbox2.field_78895_b, structureboundingbox2.field_78896_c, this.field_74887_e.field_78897_a + 1, structureboundingbox2.field_78894_e, structureboundingbox2.field_78892_f));
                }
                j1 = l + 4;
            }
            int k1 = 0;
            while (k1 < this.field_74887_e.func_78880_d() && (l = k1 + rand.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d()) {
                Peice structurecomponent = StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + rand.nextInt(k) + 1, this.field_74887_e.field_78896_c + l, EnumFacing.EAST, i);
                if (structurecomponent != null) {
                    StructureBoundingBox structureboundingbox3 = structurecomponent.func_74874_b();
                    this.roomsLinkedToTheRoom.add(new StructureBoundingBox(this.field_74887_e.field_78893_d - 1, structureboundingbox3.field_78895_b, structureboundingbox3.field_78896_c, this.field_74887_e.field_78893_d, structureboundingbox3.field_78894_e, structureboundingbox3.field_78892_f));
                }
                k1 = l + 4;
            }
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            IBlockState flooring = this.mineShaftType == MapGenMineshaftUA.Type.HELL ? Blocks.field_150425_aM.func_176223_P() : Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT);
            if (this.field_74887_e.func_78882_c() > 100) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, this.field_74887_e.field_78897_a - 10, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 10, this.field_74887_e.field_78893_d + 10, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 10, flooring, Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, this.field_74887_e.field_78897_a - 10, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c - 10, this.field_74887_e.field_78893_d + 10, Math.min(this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78894_e), this.field_74887_e.field_78892_f + 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                for (StructureBoundingBox structureboundingbox : this.roomsLinkedToTheRoom) {
                    this.func_175804_a(worldIn, structureBoundingBoxIn, structureboundingbox.field_78897_a, structureboundingbox.field_78894_e - 2, structureboundingbox.field_78896_c, structureboundingbox.field_78893_d, structureboundingbox.field_78894_e, structureboundingbox.field_78892_f, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                }
                this.func_180777_a(worldIn, structureBoundingBoxIn, this.field_74887_e.field_78897_a - 10, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78896_c - 10, this.field_74887_e.field_78893_d + 10, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f + 10, Blocks.field_150350_a.func_176223_P(), false);
                return true;
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, flooring, Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, Math.min(this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78894_e), this.field_74887_e.field_78892_f + 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            for (StructureBoundingBox structureboundingbox : this.roomsLinkedToTheRoom) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, structureboundingbox.field_78897_a, structureboundingbox.field_78894_e - 2, structureboundingbox.field_78896_c, structureboundingbox.field_78893_d, structureboundingbox.field_78894_e, structureboundingbox.field_78892_f, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            this.func_180777_a(worldIn, structureBoundingBoxIn, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, Blocks.field_150350_a.func_176223_P(), false);
            return true;
        }

        public void func_181138_a(int x, int y, int z) {
            super.func_181138_a(x, y, z);
            for (StructureBoundingBox structureboundingbox : this.roomsLinkedToTheRoom) {
                structureboundingbox.func_78886_a(x, y, z);
            }
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            NBTTagList nbttaglist = new NBTTagList();
            for (StructureBoundingBox structureboundingbox : this.roomsLinkedToTheRoom) {
                nbttaglist.func_74742_a((NBTBase)structureboundingbox.func_151535_h());
            }
            tagCompound.func_74782_a("Entrances", (NBTBase)nbttaglist);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            NBTTagList nbttaglist = tagCompound.func_150295_c("Entrances", 11);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(nbttaglist.func_150306_c(i)));
            }
        }
    }

    static abstract class Peice
    extends StructureComponent {
        protected MapGenMineshaftUA.Type mineShaftType;

        public Peice() {
        }

        public Peice(int p_i47138_1_, MapGenMineshaftUA.Type p_i47138_2_) {
            super(p_i47138_1_);
            this.mineShaftType = p_i47138_2_;
        }

        protected void func_143012_a(NBTTagCompound tagCompound) {
            tagCompound.func_74768_a("MST", this.mineShaftType.ordinal());
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            this.mineShaftType = MapGenMineshaftUA.Type.byId(tagCompound.func_74762_e("MST"));
        }

        protected IBlockState func_189917_F_() {
            switch (this.mineShaftType) {
                case MESA: {
                    return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.DARK_OAK);
                }
                case ICEY: {
                    return Blocks.field_150432_aD.func_176223_P();
                }
                case COLDORBIRCH: {
                    return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.BIRCH);
                }
                case JUNGLE: {
                    return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.JUNGLE);
                }
                case TAIGA: {
                    return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE);
                }
                case DESERT: {
                    return Blocks.field_150322_A.func_176223_P();
                }
                case END: {
                    return Blocks.field_185767_cT.func_176223_P();
                }
                case HELL: {
                    return Blocks.field_150385_bj.func_176223_P();
                }
                case STONE: {
                    return Blocks.field_150348_b.func_176223_P();
                }
                case SAVANNA: {
                    return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.ACACIA);
                }
                case SWAMP: {
                    return Blocks.field_150349_c.func_176223_P();
                }
            }
            return Blocks.field_150344_f.func_176223_P();
        }

        protected IBlockState func_189919_b() {
            switch (this.mineShaftType) {
                case MESA: {
                    return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.DARK_OAK);
                }
                case ICEY: {
                    return Blocks.field_150432_aD.func_176223_P();
                }
                case COLDORBIRCH: {
                    return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.BIRCH);
                }
                case JUNGLE: {
                    return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.JUNGLE);
                }
                case TAIGA: {
                    return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE);
                }
                case DESERT: {
                    return Blocks.field_150322_A.func_176223_P();
                }
                case END: {
                    return Blocks.field_185767_cT.func_176223_P();
                }
                case HELL: {
                    return Blocks.field_150385_bj.func_176223_P();
                }
                case STONE: {
                    return Blocks.field_150348_b.func_176223_P();
                }
                case SAVANNA: {
                    return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.ACACIA);
                }
                case SWAMP: {
                    return Blocks.field_150349_c.func_176223_P();
                }
            }
            return Blocks.field_150344_f.func_176223_P();
        }

        protected boolean func_189918_a(World p_189918_1_, StructureBoundingBox p_189918_2_, int p_189918_3_, int p_189918_4_, int p_189918_5_, int p_189918_6_) {
            for (int i = p_189918_3_; i <= p_189918_4_; ++i) {
                if (this.func_175807_a(p_189918_1_, i, p_189918_5_ + 1, p_189918_6_, p_189918_2_).func_185904_a() != Material.field_151579_a) continue;
                return false;
            }
            return true;
        }
    }

    public static class Cross
    extends Peice {
        private EnumFacing corridorDirection;
        private boolean isMultipleFloors;

        public Cross() {
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("tf", this.isMultipleFloors);
            tagCompound.func_74768_a("D", this.corridorDirection.func_176736_b());
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.isMultipleFloors = tagCompound.func_74767_n("tf");
            this.corridorDirection = EnumFacing.func_176731_b((int)tagCompound.func_74762_e("D"));
        }

        public Cross(int p_i47139_1_, Random p_i47139_2_, StructureBoundingBox p_i47139_3_, @Nullable EnumFacing p_i47139_4_, MapGenMineshaftUA.Type p_i47139_5_) {
            super(p_i47139_1_, p_i47139_5_);
            this.corridorDirection = p_i47139_4_;
            this.field_74887_e = p_i47139_3_;
            this.isMultipleFloors = p_i47139_3_.func_78882_c() > 3;
        }

        public static StructureBoundingBox findCrossing(List<StructureComponent> listIn, Random rand, int x, int y, int z, EnumFacing facing) {
            StructureBoundingBox structureboundingbox = new StructureBoundingBox(x, y, z, x, y + 2, z);
            if (rand.nextInt(4) == 0) {
                structureboundingbox.field_78894_e += 4;
            }
            switch (facing) {
                default: {
                    structureboundingbox.field_78897_a = x - 1;
                    structureboundingbox.field_78893_d = x + 3;
                    structureboundingbox.field_78896_c = z - 4;
                    break;
                }
                case SOUTH: {
                    structureboundingbox.field_78897_a = x - 1;
                    structureboundingbox.field_78893_d = x + 3;
                    structureboundingbox.field_78892_f = z + 3 + 1;
                    break;
                }
                case WEST: {
                    structureboundingbox.field_78897_a = x - 4;
                    structureboundingbox.field_78896_c = z - 1;
                    structureboundingbox.field_78892_f = z + 3;
                    break;
                }
                case EAST: {
                    structureboundingbox.field_78893_d = x + 3 + 1;
                    structureboundingbox.field_78896_c = z - 1;
                    structureboundingbox.field_78892_f = z + 3;
                }
            }
            return StructureComponent.func_74883_a(listIn, (StructureBoundingBox)structureboundingbox) != null ? null : structureboundingbox;
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            int i = this.func_74877_c();
            switch (this.corridorDirection) {
                default: {
                    StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                    StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, i);
                    StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, i);
                    break;
                }
                case SOUTH: {
                    StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                    StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, i);
                    StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, i);
                    break;
                }
                case WEST: {
                    StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                    StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                    StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, i);
                    break;
                }
                case EAST: {
                    StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                    StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                    StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, i);
                }
            }
            if (this.isMultipleFloors) {
                if (rand.nextBoolean()) {
                    StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                }
                if (rand.nextBoolean()) {
                    StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, i);
                }
                if (rand.nextBoolean()) {
                    StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, i);
                }
                if (rand.nextBoolean()) {
                    StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                }
            }
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.func_74860_a(worldIn, structureBoundingBoxIn)) {
                return false;
            }
            IBlockState iblockstate = this.func_189917_F_();
            if (this.isMultipleFloors) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, this.field_74887_e.field_78897_a, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            } else {
                this.func_175804_a(worldIn, structureBoundingBoxIn, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            this.func_189923_b(worldIn, structureBoundingBoxIn, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78894_e);
            this.func_189923_b(worldIn, structureBoundingBoxIn, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78894_e);
            this.func_189923_b(worldIn, structureBoundingBoxIn, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78894_e);
            this.func_189923_b(worldIn, structureBoundingBoxIn, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78894_e);
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    if (this.func_175807_a(worldIn, i, this.field_74887_e.field_78895_b - 1, j, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a || this.func_189916_b(worldIn, i, this.field_74887_e.field_78895_b - 1, j, structureBoundingBoxIn) >= 8) continue;
                    this.func_175811_a(worldIn, iblockstate, i, this.field_74887_e.field_78895_b - 1, j, structureBoundingBoxIn);
                }
            }
            return true;
        }

        private void func_189923_b(World p_189923_1_, StructureBoundingBox p_189923_2_, int p_189923_3_, int p_189923_4_, int p_189923_5_, int p_189923_6_) {
            if (this.func_175807_a(p_189923_1_, p_189923_3_, p_189923_6_ + 1, p_189923_5_, p_189923_2_).func_185904_a() != Material.field_151579_a) {
                this.func_175804_a(p_189923_1_, p_189923_2_, p_189923_3_, p_189923_4_, p_189923_5_, p_189923_3_, p_189923_6_, p_189923_5_, this.func_189917_F_(), Blocks.field_150350_a.func_176223_P(), false);
            }
        }
    }

    public static class Corridor
    extends Peice {
        private boolean hasRails;
        private boolean hasSpiders;
        private boolean spawnerPlaced;
        private int sectionCount;

        public Corridor() {
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("hr", this.hasRails);
            tagCompound.func_74757_a("sc", this.hasSpiders);
            tagCompound.func_74757_a("hps", this.spawnerPlaced);
            tagCompound.func_74768_a("Num", this.sectionCount);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.hasRails = tagCompound.func_74767_n("hr");
            this.hasSpiders = tagCompound.func_74767_n("sc");
            this.spawnerPlaced = tagCompound.func_74767_n("hps");
            this.sectionCount = tagCompound.func_74762_e("Num");
        }

        public Corridor(int p_i47140_1_, Random p_i47140_2_, StructureBoundingBox p_i47140_3_, EnumFacing p_i47140_4_, MapGenMineshaftUA.Type p_i47140_5_) {
            super(p_i47140_1_, p_i47140_5_);
            this.func_186164_a(p_i47140_4_);
            this.field_74887_e = p_i47140_3_;
            this.hasRails = p_i47140_2_.nextInt(3) == 0;
            this.hasSpiders = !this.hasRails && p_i47140_2_.nextInt(23) == 0;
            this.sectionCount = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? p_i47140_3_.func_78880_d() / 5 : p_i47140_3_.func_78883_b() / 5;
        }

        public static StructureBoundingBox findCorridorSize(List<StructureComponent> p_175814_0_, Random rand, int x, int y, int z, EnumFacing facing) {
            int i;
            StructureBoundingBox structureboundingbox = new StructureBoundingBox(x, y, z, x, y + 2, z);
            for (i = rand.nextInt(3) + 2; i > 0; --i) {
                int j = i * 5;
                switch (facing) {
                    default: {
                        structureboundingbox.field_78893_d = x + 2;
                        structureboundingbox.field_78896_c = z - (j - 1);
                        break;
                    }
                    case SOUTH: {
                        structureboundingbox.field_78893_d = x + 2;
                        structureboundingbox.field_78892_f = z + (j - 1);
                        break;
                    }
                    case WEST: {
                        structureboundingbox.field_78897_a = x - (j - 1);
                        structureboundingbox.field_78892_f = z + 2;
                        break;
                    }
                    case EAST: {
                        structureboundingbox.field_78893_d = x + (j - 1);
                        structureboundingbox.field_78892_f = z + 2;
                    }
                }
                if (StructureComponent.func_74883_a(p_175814_0_, (StructureBoundingBox)structureboundingbox) == null) break;
            }
            return i > 0 ? structureboundingbox : null;
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            block24: {
                int i = this.func_74877_c();
                int j = rand.nextInt(4);
                EnumFacing enumfacing = this.func_186165_e();
                if (enumfacing != null) {
                    switch (enumfacing) {
                        default: {
                            if (j <= 1) {
                                StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, enumfacing, i);
                                break;
                            }
                            if (j == 2) {
                                StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, EnumFacing.WEST, i);
                                break;
                            }
                            StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, EnumFacing.EAST, i);
                            break;
                        }
                        case SOUTH: {
                            if (j <= 1) {
                                StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, enumfacing, i);
                                break;
                            }
                            if (j == 2) {
                                StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f - 3, EnumFacing.WEST, i);
                                break;
                            }
                            StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f - 3, EnumFacing.EAST, i);
                            break;
                        }
                        case WEST: {
                            if (j <= 1) {
                                StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, enumfacing, i);
                                break;
                            }
                            if (j == 2) {
                                StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                                break;
                            }
                            StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                            break;
                        }
                        case EAST: {
                            if (j <= 1) {
                                StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, enumfacing, i);
                                break;
                            }
                            if (j == 2) {
                                StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                                break;
                            }
                            StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                        }
                    }
                }
                if (i >= 8) break block24;
                if (enumfacing != EnumFacing.NORTH && enumfacing != EnumFacing.SOUTH) {
                    int i1 = this.field_74887_e.field_78897_a + 3;
                    while (i1 + 3 <= this.field_74887_e.field_78893_d) {
                        int j1 = rand.nextInt(5);
                        if (j1 == 0) {
                            StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, i1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i + 1);
                        } else if (j1 == 1) {
                            StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, i1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i + 1);
                        }
                        i1 += 5;
                    }
                } else {
                    int k = this.field_74887_e.field_78896_c + 3;
                    while (k + 3 <= this.field_74887_e.field_78892_f) {
                        int l = rand.nextInt(5);
                        if (l == 0) {
                            StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, k, EnumFacing.WEST, i + 1);
                        } else if (l == 1) {
                            StructureMineshaftPiecesUA.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, k, EnumFacing.EAST, i + 1);
                        }
                        k += 5;
                    }
                }
            }
        }

        protected boolean func_186167_a(World worldIn, StructureBoundingBox structurebb, Random randomIn, int x, int y, int z, ResourceLocation loot) {
            BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            if (structurebb.func_175898_b((Vec3i)blockpos) && worldIn.func_180495_p(blockpos).func_185904_a() == Material.field_151579_a) {
                IBlockState iblockstate = Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)(randomIn.nextBoolean() ? BlockRailBase.EnumRailDirection.NORTH_SOUTH : BlockRailBase.EnumRailDirection.EAST_WEST));
                this.func_175811_a(worldIn, iblockstate, x, y, z, structurebb);
                EntityMinecartChest entityminecartchest = new EntityMinecartChest(worldIn, (double)((float)blockpos.func_177958_n() + 0.5f), (double)((float)blockpos.func_177956_o() + 0.5f), (double)((float)blockpos.func_177952_p() + 0.5f));
                entityminecartchest.func_184289_a(loot, randomIn.nextLong());
                worldIn.func_72838_d((Entity)entityminecartchest);
                return true;
            }
            return false;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.func_74860_a(worldIn, structureBoundingBoxIn)) {
                return false;
            }
            boolean i = false;
            int j = 2;
            boolean k = false;
            int l = 2;
            int i1 = this.sectionCount * 5 - 1;
            IBlockState iblockstate = this.func_189917_F_();
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 2, 1, i1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_189914_a(worldIn, structureBoundingBoxIn, randomIn, 0.8f, 0, 2, 0, 2, 2, i1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false, 0);
            if (this.hasSpiders) {
                this.func_189914_a(worldIn, structureBoundingBoxIn, randomIn, 0.6f, 0, 0, 0, 2, 1, i1, Blocks.field_150321_G.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false, 8);
            }
            for (int j1 = 0; j1 < this.sectionCount; ++j1) {
                int k2;
                int k1 = 2 + j1 * 5;
                this.func_189921_a(worldIn, structureBoundingBoxIn, 0, 0, k1, 2, 2, randomIn);
                this.placeCobWeb(worldIn, structureBoundingBoxIn, randomIn, 0.1f, 0, 2, k1 - 1);
                this.placeCobWeb(worldIn, structureBoundingBoxIn, randomIn, 0.1f, 2, 2, k1 - 1);
                this.placeCobWeb(worldIn, structureBoundingBoxIn, randomIn, 0.1f, 0, 2, k1 + 1);
                this.placeCobWeb(worldIn, structureBoundingBoxIn, randomIn, 0.1f, 2, 2, k1 + 1);
                this.placeCobWeb(worldIn, structureBoundingBoxIn, randomIn, 0.05f, 0, 2, k1 - 2);
                this.placeCobWeb(worldIn, structureBoundingBoxIn, randomIn, 0.05f, 2, 2, k1 - 2);
                this.placeCobWeb(worldIn, structureBoundingBoxIn, randomIn, 0.05f, 0, 2, k1 + 2);
                this.placeCobWeb(worldIn, structureBoundingBoxIn, randomIn, 0.05f, 2, 2, k1 + 2);
                if (UAConfig.StructuresOptions.biomeBasedStructuresOptions.chestGeneration) {
                    if (randomIn.nextInt(50) == 0) {
                        this.func_186167_a(worldIn, structureBoundingBoxIn, randomIn, 2, 0, k1 - 1, LootTableList.field_186424_f);
                    }
                    if (randomIn.nextInt(50) == 0) {
                        this.func_186167_a(worldIn, structureBoundingBoxIn, randomIn, 0, 0, k1 + 1, LootTableList.field_186424_f);
                    }
                }
                if (!this.hasSpiders || this.spawnerPlaced) continue;
                int l1 = this.func_74862_a(0);
                int i2 = k1 - 1 + randomIn.nextInt(3);
                int j2 = this.func_74865_a(1, i2);
                BlockPos blockpos = new BlockPos(j2, l1, k2 = this.func_74873_b(1, i2));
                if (!structureBoundingBoxIn.func_175898_b((Vec3i)blockpos) || this.func_189916_b(worldIn, 1, 0, i2, structureBoundingBoxIn) >= 8) continue;
                this.spawnerPlaced = true;
                worldIn.func_180501_a(blockpos, Blocks.field_150474_ac.func_176223_P(), 2);
                TileEntity tileentity = worldIn.func_175625_s(blockpos);
                if (!(tileentity instanceof TileEntityMobSpawner)) continue;
                ((TileEntityMobSpawner)tileentity).func_145881_a().func_190894_a(EntityList.func_191306_a(EntityCaveSpider.class));
            }
            for (int l2 = 0; l2 <= 2; ++l2) {
                for (int i3 = 0; i3 <= i1; ++i3) {
                    int k3 = -1;
                    IBlockState iblockstate3 = this.func_175807_a(worldIn, l2, -1, i3, structureBoundingBoxIn);
                    if (iblockstate3.func_185904_a() != Material.field_151579_a) continue;
                    int l3 = -1;
                    this.func_175811_a(worldIn, iblockstate, l2, -1, i3, structureBoundingBoxIn);
                }
            }
            if (this.hasRails) {
                IBlockState iblockstate1 = Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH);
                for (int j3 = 0; j3 <= i1; ++j3) {
                    IBlockState iblockstate2 = this.func_175807_a(worldIn, 1, -1, j3, structureBoundingBoxIn);
                    if (worldIn.func_175623_d(new BlockPos(1, -1, j3))) continue;
                    float f = this.func_189916_b(worldIn, 1, 0, j3, structureBoundingBoxIn) > 8 ? 0.9f : 0.7f;
                    this.func_175809_a(worldIn, structureBoundingBoxIn, randomIn, f, 1, 0, j3, iblockstate1);
                }
            }
            return true;
        }

        private void func_189921_a(World worldIn, StructureBoundingBox boundingBox, int x, int p_189921_4_, int z, int y, int p_189921_7_, Random random) {
            if (this.func_189918_a(worldIn, boundingBox, x, p_189921_7_, y, z)) {
                IBlockState iblockstate = this.func_189917_F_();
                IBlockState iblockstate1 = this.func_189919_b();
                IBlockState iblockstate2 = Blocks.field_150350_a.func_176223_P();
                this.func_175804_a(worldIn, boundingBox, x, p_189921_4_, z, x, y - 1, z, iblockstate1, iblockstate2, false);
                this.func_175804_a(worldIn, boundingBox, p_189921_7_, p_189921_4_, z, p_189921_7_, y - 1, z, iblockstate1, iblockstate2, false);
                if (random.nextInt(4) == 0) {
                    this.func_175804_a(worldIn, boundingBox, x, y, z, x, y, z, iblockstate, iblockstate2, false);
                    this.func_175804_a(worldIn, boundingBox, p_189921_7_, y, z, p_189921_7_, y, z, iblockstate, iblockstate2, false);
                } else {
                    this.func_175804_a(worldIn, boundingBox, x, y, z, p_189921_7_, y, z, iblockstate, iblockstate2, false);
                    if (this.mineShaftType == MapGenMineshaftUA.Type.END) {
                        if (random.nextFloat() < 0.08f) {
                            this.func_175809_a(worldIn, boundingBox, random, 1.0f, x, y, z - 1, Blocks.field_185764_cQ.func_176223_P().func_177226_a((IProperty)BlockEndRod.field_176387_N, (Comparable)EnumFacing.SOUTH));
                            this.func_175809_a(worldIn, boundingBox, random, 1.0f, x, y, z + 1, Blocks.field_185764_cQ.func_176223_P().func_177226_a((IProperty)BlockEndRod.field_176387_N, (Comparable)EnumFacing.NORTH));
                        }
                        if (random.nextFloat() < 0.08f) {
                            this.func_175809_a(worldIn, boundingBox, random, 1.0f, x + 2, y, z - 1, Blocks.field_185764_cQ.func_176223_P().func_177226_a((IProperty)BlockEndRod.field_176387_N, (Comparable)EnumFacing.SOUTH));
                            this.func_175809_a(worldIn, boundingBox, random, 1.0f, x + 2, y, z + 1, Blocks.field_185764_cQ.func_176223_P().func_177226_a((IProperty)BlockEndRod.field_176387_N, (Comparable)EnumFacing.NORTH));
                        }
                    } else if (this.mineShaftType == MapGenMineshaftUA.Type.HELL) {
                        this.func_175809_a(worldIn, boundingBox, random, 0.15f, x + 1, y, z, Blocks.field_150426_aN.func_176223_P());
                    } else {
                        this.func_175809_a(worldIn, boundingBox, random, 0.08f, x + 1, y, z - 1, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH));
                        this.func_175809_a(worldIn, boundingBox, random, 0.08f, x + 1, y, z + 1, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.NORTH));
                    }
                }
            }
        }

        private void placeCobWeb(World p_189922_1_, StructureBoundingBox p_189922_2_, Random p_189922_3_, float p_189922_4_, int p_189922_5_, int p_189922_6_, int p_189922_7_) {
            if (this.func_189916_b(p_189922_1_, p_189922_5_, p_189922_6_, p_189922_7_, p_189922_2_) < 8) {
                this.func_175809_a(p_189922_1_, p_189922_2_, p_189922_3_, p_189922_4_, p_189922_5_, p_189922_6_, p_189922_7_, Blocks.field_150321_G.func_176223_P());
            }
        }
    }
}

