/*
 * Decompiled with CFR 0.152.
 */
package net.TelepathicGrunt.UltraAmplified.World.gen.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.TelepathicGrunt.UltraAmplified.Config.UAConfig;
import net.TelepathicGrunt.UltraAmplified.World.Biomes.BiomeDesertUA;
import net.TelepathicGrunt.UltraAmplified.World.Biomes.BiomeEndUA;
import net.TelepathicGrunt.UltraAmplified.World.Biomes.BiomeHellUA;
import net.TelepathicGrunt.UltraAmplified.World.Biomes.BiomeJungleUA;
import net.TelepathicGrunt.UltraAmplified.World.Biomes.BiomeMesaUA;
import net.TelepathicGrunt.UltraAmplified.World.Biomes.BiomeSavannaUA;
import net.TelepathicGrunt.UltraAmplified.World.Biomes.BiomeSnowUA;
import net.TelepathicGrunt.UltraAmplified.World.Biomes.BiomeStoneBeachUA;
import net.TelepathicGrunt.UltraAmplified.World.Biomes.BiomeTaigaUA;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockEndRod;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockRedSandstone;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class StructureVillagePiecesUA {
    public static void registerVillagePieces() {
        MapGenStructureIO.func_143031_a(House1.class, (String)"ViBH");
        MapGenStructureIO.func_143031_a(Field1.class, (String)"ViDF");
        MapGenStructureIO.func_143031_a(Field2.class, (String)"ViF");
        MapGenStructureIO.func_143031_a(Torch.class, (String)"ViL");
        MapGenStructureIO.func_143031_a(Hall.class, (String)"ViPH");
        MapGenStructureIO.func_143031_a(House4Garden.class, (String)"ViSH");
        MapGenStructureIO.func_143031_a(WoodHut.class, (String)"ViSmH");
        MapGenStructureIO.func_143031_a(Church.class, (String)"ViST");
        MapGenStructureIO.func_143031_a(House2.class, (String)"ViS");
        MapGenStructureIO.func_143031_a(Start.class, (String)"ViStart");
        MapGenStructureIO.func_143031_a(Path.class, (String)"ViSR");
        MapGenStructureIO.func_143031_a(House3.class, (String)"ViTRH");
        MapGenStructureIO.func_143031_a(Well.class, (String)"ViW");
    }

    public static List<PieceWeight> getStructureVillageWeightedPieceList(Random random, int size) {
        ArrayList list = Lists.newArrayList();
        list.add(new PieceWeight(House4Garden.class, 4, MathHelper.func_76136_a((Random)random, (int)(2 + size), (int)(4 + size * 2))));
        list.add(new PieceWeight(Church.class, 20, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(1 + size))));
        list.add(new PieceWeight(House1.class, 20, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(2 + size))));
        list.add(new PieceWeight(WoodHut.class, 3, MathHelper.func_76136_a((Random)random, (int)(2 + size), (int)(5 + size * 3))));
        list.add(new PieceWeight(Hall.class, 15, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(2 + size))));
        list.add(new PieceWeight(Field1.class, 3, MathHelper.func_76136_a((Random)random, (int)(1 + size), (int)(4 + size))));
        list.add(new PieceWeight(Field2.class, 3, MathHelper.func_76136_a((Random)random, (int)(2 + size), (int)(4 + size * 2))));
        list.add(new PieceWeight(House2.class, 15, MathHelper.func_76136_a((Random)random, (int)0, (int)(1 + size))));
        list.add(new PieceWeight(House3.class, 8, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(3 + size * 2))));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (((PieceWeight)iterator.next()).villagePiecesLimit != 0) continue;
            iterator.remove();
        }
        return list;
    }

    private static int updatePieceWeight(List<PieceWeight> p_75079_0_) {
        boolean flag = false;
        int i = 0;
        for (PieceWeight structurevillagepieces$pieceweight : p_75079_0_) {
            if (structurevillagepieces$pieceweight.villagePiecesLimit > 0 && structurevillagepieces$pieceweight.villagePiecesSpawned < structurevillagepieces$pieceweight.villagePiecesLimit) {
                flag = true;
            }
            i += structurevillagepieces$pieceweight.villagePieceWeight;
        }
        return flag ? i : -1;
    }

    private static Village findAndCreateComponentFactory(Start start, PieceWeight weight, List<StructureComponent> structureComponents, Random rand, int structureMinX, int structureMinY, int structureMinZ, EnumFacing facing, int componentType) {
        Class<? extends Village> oclass = weight.villagePieceClass;
        Village structurevillagepieces$village = null;
        if (oclass == House4Garden.class) {
            structurevillagepieces$village = House4Garden.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == Church.class) {
            structurevillagepieces$village = Church.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == House1.class) {
            structurevillagepieces$village = House1.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == WoodHut.class) {
            structurevillagepieces$village = WoodHut.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == Hall.class) {
            structurevillagepieces$village = Hall.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == Field1.class) {
            structurevillagepieces$village = Field1.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == Field2.class) {
            structurevillagepieces$village = Field2.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == House2.class) {
            structurevillagepieces$village = House2.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == House3.class) {
            structurevillagepieces$village = House3.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        }
        return structurevillagepieces$village;
    }

    private static Village generateComponent(Start start, List<StructureComponent> structureComponents, Random rand, int structureMinX, int structureMinY, int structureMinZ, EnumFacing facing, int componentType) {
        int i = StructureVillagePiecesUA.updatePieceWeight(start.structureVillageWeightedPieceList);
        if (i <= 0) {
            return null;
        }
        int j = 0;
        block0: while (j < 5) {
            ++j;
            int k = rand.nextInt(i);
            for (PieceWeight structurevillagepieces$pieceweight : start.structureVillageWeightedPieceList) {
                if ((k -= structurevillagepieces$pieceweight.villagePieceWeight) >= 0) continue;
                if (!structurevillagepieces$pieceweight.canSpawnMoreVillagePiecesOfType(componentType) || structurevillagepieces$pieceweight == start.structVillagePieceWeight && start.structureVillageWeightedPieceList.size() > 1) continue block0;
                Village structurevillagepieces$village = StructureVillagePiecesUA.findAndCreateComponentFactory(start, structurevillagepieces$pieceweight, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
                if (structurevillagepieces$village == null) continue;
                ++structurevillagepieces$pieceweight.villagePiecesSpawned;
                start.structVillagePieceWeight = structurevillagepieces$pieceweight;
                if (!structurevillagepieces$pieceweight.canSpawnMoreVillagePieces()) {
                    start.structureVillageWeightedPieceList.remove(structurevillagepieces$pieceweight);
                }
                return structurevillagepieces$village;
            }
        }
        StructureBoundingBox structureboundingbox = Torch.findPieceBox(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing);
        if (structureboundingbox != null) {
            return new Torch(start, componentType, rand, structureboundingbox, facing);
        }
        return null;
    }

    private static StructureComponent generateAndAddComponent(Start start, List<StructureComponent> structureComponents, Random rand, int structureMinX, int structureMinY, int structureMinZ, EnumFacing facing, int componentType) {
        if (componentType > 50) {
            return null;
        }
        if (Math.abs(structureMinX - start.func_74874_b().field_78897_a) <= 112 && Math.abs(structureMinZ - start.func_74874_b().field_78896_c) <= 112) {
            Village structurecomponent = StructureVillagePiecesUA.generateComponent(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType + 1);
            if (structurecomponent != null) {
                structureComponents.add(structurecomponent);
                start.pendingHouses.add(structurecomponent);
                return structurecomponent;
            }
            return null;
        }
        return null;
    }

    private static StructureComponent generateAndAddRoadPiece(Start start, List<StructureComponent> p_176069_1_, Random rand, int p_176069_3_, int p_176069_4_, int p_176069_5_, EnumFacing facing, int p_176069_7_) {
        if (p_176069_7_ > 3 + start.terrainType) {
            return null;
        }
        if (Math.abs(p_176069_3_ - start.func_74874_b().field_78897_a) <= 112 && Math.abs(p_176069_5_ - start.func_74874_b().field_78896_c) <= 112) {
            StructureBoundingBox structureboundingbox = Path.findPieceBox(start, p_176069_1_, rand, p_176069_3_, p_176069_4_, p_176069_5_, facing);
            if (structureboundingbox != null && structureboundingbox.field_78895_b > 10) {
                Path structurecomponent = new Path(start, p_176069_7_, rand, structureboundingbox, facing);
                p_176069_1_.add(structurecomponent);
                start.pendingRoads.add(structurecomponent);
                return structurecomponent;
            }
            return null;
        }
        return null;
    }

    public static class WoodHut
    extends Village {
        private boolean isTallHouse;
        private int tablePosition;

        public WoodHut() {
        }

        public WoodHut(Start start, int type, Random rand, StructureBoundingBox structurebb, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = structurebb;
            this.isTallHouse = rand.nextBoolean();
            this.tablePosition = rand.nextInt(3);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("T", this.tablePosition);
            tagCompound.func_74757_a("C", this.isTallHouse);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.tablePosition = tagCompound.func_74762_e("T");
            this.isTallHouse = tagCompound.func_74767_n("C");
        }

        public static WoodHut createPiece(Start start, List<StructureComponent> p_175853_1_, Random rand, int p_175853_3_, int p_175853_4_, int p_175853_5_, EnumFacing facing, int p_175853_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175853_3_, (int)p_175853_4_, (int)p_175853_5_, (int)0, (int)0, (int)0, (int)4, (int)6, (int)5, (EnumFacing)facing);
            return WoodHut.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175853_1_, (StructureBoundingBox)structureboundingbox) == null ? new WoodHut(start, p_175853_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P());
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176223_P());
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 3, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 3, 0, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 2, 0, 3, Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P(), false);
            if (this.isTallHouse) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 1, 2, 4, 3, iblockstate3, iblockstate3, false);
            } else {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 1, 2, 5, 3, iblockstate3, iblockstate3, false);
            }
            this.func_175811_a(worldIn, iblockstate3, 1, 4, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 2, 4, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 1, 4, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 2, 4, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 0, 4, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 0, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 0, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 3, 4, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 3, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 3, 4, 3, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 3, 0, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 0, 3, 3, 0, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 4, 0, 3, 4, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 4, 3, 3, 4, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 3, 3, iblockstate1, iblockstate1, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 1, 3, 3, 3, iblockstate1, iblockstate1, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 0, 2, 3, 0, iblockstate1, iblockstate1, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 4, 2, 3, 4, iblockstate1, iblockstate1, false);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 3, 2, 2, structureBoundingBoxIn);
            if (this.tablePosition > 0) {
                this.func_175811_a(worldIn, iblockstate4, this.tablePosition, 1, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150452_aw.func_176223_P(), this.tablePosition, 2, 3, structureBoundingBoxIn);
            }
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 2, 0, structureBoundingBoxIn);
            this.createVillageDoor(worldIn, structureBoundingBoxIn, randomIn, 1, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a(worldIn, 1, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 1, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, iblockstate2, 1, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a(worldIn, 1, -1, -1, structureBoundingBoxIn).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(worldIn, Blocks.field_150349_c.func_176223_P(), 1, -1, -1, structureBoundingBoxIn);
                }
            }
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.func_74871_b(worldIn, j, 6, i, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, j, -1, i, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(worldIn, structureBoundingBoxIn, 1, 1, 2, 1);
            return true;
        }
    }

    public static class Well
    extends Village {
        public Well() {
        }

        public Well(Start start, int type, Random rand, int x, int z) {
            super(start, type);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
            this.field_74887_e = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? new StructureBoundingBox(x, 64, z, x + 6 - 1, 78, z + 6 - 1) : new StructureBoundingBox(x, 64, z, x + 6 - 1, 78, z + 6 - 1);
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            StructureVillagePiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, this.func_74877_c());
            StructureVillagePiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, this.func_74877_c());
            StructureVillagePiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            StructureVillagePiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 3, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 4, 12, 4, iblockstate, Blocks.field_150358_i.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 12, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 3, 12, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 12, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 3, 12, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 13, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 14, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 13, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 14, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 13, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 14, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 13, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 14, 4, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 15, 1, 4, 15, 4, iblockstate, iblockstate, false);
            for (int i = 0; i <= 5; ++i) {
                for (int j = 0; j <= 5; ++j) {
                    if (j != 0 && j != 5 && i != 0 && i != 5) continue;
                    this.func_175811_a(worldIn, iblockstate, j, 11, i, structureBoundingBoxIn);
                    this.func_74871_b(worldIn, j, 12, i, structureBoundingBoxIn);
                }
            }
            return true;
        }
    }

    static abstract class Village
    extends StructureComponent {
        protected int averageGroundLvl = -1;
        private int villagersSpawned;
        protected int structureType;
        protected boolean isZombieInfested;

        public Village() {
        }

        protected Village(Start start, int type) {
            super(type);
            if (start != null) {
                this.structureType = start.structureType;
                this.isZombieInfested = start.isZombieInfested;
            }
        }

        protected void func_143012_a(NBTTagCompound tagCompound) {
            tagCompound.func_74768_a("HPos", this.averageGroundLvl);
            tagCompound.func_74768_a("VCount", this.villagersSpawned);
            tagCompound.func_74774_a("Type", (byte)this.structureType);
            tagCompound.func_74757_a("Zombie", this.isZombieInfested);
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            this.averageGroundLvl = tagCompound.func_74762_e("HPos");
            this.villagersSpawned = tagCompound.func_74762_e("VCount");
            this.structureType = tagCompound.func_74771_c("Type");
            if (tagCompound.func_74767_n("Desert")) {
                this.structureType = 1;
            }
            this.isZombieInfested = tagCompound.func_74767_n("Zombie");
        }

        @Nullable
        protected StructureComponent getNextComponentNN(Start start, List<StructureComponent> structureComponents, Random rand, int p_74891_4_, int p_74891_5_) {
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        return StructureVillagePiecesUA.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c + p_74891_5_, EnumFacing.WEST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return StructureVillagePiecesUA.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c + p_74891_5_, EnumFacing.WEST, this.func_74877_c());
                    }
                    case WEST: {
                        return StructureVillagePiecesUA.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74891_5_, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                    case EAST: 
                }
                return StructureVillagePiecesUA.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74891_5_, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            }
            return null;
        }

        @Nullable
        protected StructureComponent getNextComponentPP(Start start, List<StructureComponent> structureComponents, Random rand, int p_74894_4_, int p_74894_5_) {
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        return StructureVillagePiecesUA.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78896_c + p_74894_5_, EnumFacing.EAST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return StructureVillagePiecesUA.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78896_c + p_74894_5_, EnumFacing.EAST, this.func_74877_c());
                    }
                    case WEST: {
                        return StructureVillagePiecesUA.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74894_5_, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                    case EAST: 
                }
                return StructureVillagePiecesUA.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74894_5_, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            }
            return null;
        }

        protected int getAverageGroundLevel(World worldIn, StructureBoundingBox structurebb) {
            int i = 0;
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
                for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                    blockpos$mutableblockpos.func_181079_c(l, 64, k);
                    if (!structurebb.func_175898_b((Vec3i)blockpos$mutableblockpos)) continue;
                    i += Math.max(worldIn.func_175672_r((BlockPos)blockpos$mutableblockpos).func_177956_o(), worldIn.field_73011_w.func_76557_i() - 1);
                    ++j;
                }
            }
            if (j == 0) {
                return -1;
            }
            return i / j;
        }

        protected static boolean canVillageGoDeeper(StructureBoundingBox structurebb) {
            return structurebb != null && structurebb.field_78895_b > 10;
        }

        protected void spawnVillagers(World worldIn, StructureBoundingBox structurebb, int x, int y, int z, int count) {
            if (this.villagersSpawned < count) {
                int l;
                int k;
                int j;
                for (int i = this.villagersSpawned; i < count && structurebb.func_175898_b((Vec3i)new BlockPos(j = this.func_74865_a(x + i, z), k = this.func_74862_a(y), l = this.func_74873_b(x + i, z))); ++i) {
                    ++this.villagersSpawned;
                    if (this.isZombieInfested) {
                        EntityZombieVillager entityzombievillager = new EntityZombieVillager(worldIn);
                        entityzombievillager.func_70012_b((double)j + 0.5, (double)k, (double)l + 0.5, 0.0f, 0.0f);
                        entityzombievillager.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entityzombievillager)), (IEntityLivingData)null);
                        entityzombievillager.func_110163_bv();
                        worldIn.func_72838_d((Entity)entityzombievillager);
                        continue;
                    }
                    EntityVillager entityvillager = new EntityVillager(worldIn);
                    entityvillager.func_70012_b((double)j + 0.5, (double)k, (double)l + 0.5, 0.0f, 0.0f);
                    entityvillager.setProfession(this.chooseForgeProfession(i, entityvillager.getProfessionForge()));
                    entityvillager.func_190672_a(worldIn.func_175649_E(new BlockPos((Entity)entityvillager)), (IEntityLivingData)null, false);
                    worldIn.func_72838_d((Entity)entityvillager);
                }
            }
        }

        protected int chooseProfession(int villagersSpawnedIn, int currentVillagerProfession) {
            return currentVillagerProfession;
        }

        protected VillagerRegistry.VillagerProfession chooseForgeProfession(int count, VillagerRegistry.VillagerProfession prof) {
            return VillagerRegistry.getById((int)this.chooseProfession(count, VillagerRegistry.getId((VillagerRegistry.VillagerProfession)prof)));
        }

        protected IBlockState getBiomeSpecificBlockState(IBlockState blockstateIn) {
            if (this.structureType == 0) {
                if (blockstateIn.func_177230_c() == Blocks.field_150347_e && this.isZombieInfested) {
                    return Blocks.field_150341_Y.func_176223_P();
                }
            } else if (this.structureType == 1) {
                if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                    return Blocks.field_150322_A.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150347_e) {
                    return Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.DEFAULT);
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                    if (this.isZombieInfested) {
                        return Blocks.field_150341_Y.func_176223_P();
                    }
                    return Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH);
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150476_ad) {
                    return Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150446_ar) {
                    return Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150351_n) {
                    return Blocks.field_150322_A.func_176223_P();
                }
            } else if (this.structureType == 2) {
                if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                    return Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA).func_177226_a((IProperty)BlockLog.field_176299_a, blockstateIn.func_177229_b((IProperty)BlockLog.field_176299_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                    if (this.isZombieInfested) {
                        return Blocks.field_150341_Y.func_176223_P();
                    }
                    return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.ACACIA);
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150476_ad) {
                    return Blocks.field_150400_ck.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150347_e) {
                    return Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA).func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
                }
                if (blockstateIn.func_177230_c() == Blocks.field_180407_aO) {
                    return Blocks.field_180405_aT.func_176223_P();
                }
            } else if (this.structureType == 3) {
                if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                    return Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE).func_177226_a((IProperty)BlockLog.field_176299_a, blockstateIn.func_177229_b((IProperty)BlockLog.field_176299_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                    if (this.isZombieInfested) {
                        return Blocks.field_150341_Y.func_176223_P();
                    }
                    return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE);
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150476_ad) {
                    return Blocks.field_150485_bF.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150347_e) {
                    return Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.MOSSY);
                }
                if (blockstateIn.func_177230_c() == Blocks.field_180407_aO) {
                    return Blocks.field_180408_aP.func_176223_P();
                }
            } else if (this.structureType == 4) {
                if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                    return Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLog.field_176299_a, blockstateIn.func_177229_b((IProperty)BlockLog.field_176299_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                    if (this.isZombieInfested) {
                        return Blocks.field_150341_Y.func_176223_P();
                    }
                    return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.JUNGLE);
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150476_ad || blockstateIn.func_177230_c() == Blocks.field_150446_ar) {
                    return Blocks.field_150481_bH.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150347_e) {
                    return Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.MOSSY);
                }
                if (blockstateIn.func_177230_c() == Blocks.field_180407_aO) {
                    return Blocks.field_180403_aR.func_176223_P();
                }
            } else if (this.structureType == 5) {
                if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                    return Blocks.field_150348_b.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                    if (this.isZombieInfested) {
                        return Blocks.field_150341_Y.func_176223_P();
                    }
                    return Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE);
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150476_ad) {
                    return Blocks.field_150333_U.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150347_e) {
                    return Blocks.field_150348_b.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_180407_aO) {
                    return Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE);
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150351_n) {
                    return Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE);
                }
            } else if (this.structureType == 6) {
                if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                    return Blocks.field_185768_cU.func_176223_P().func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)EnumFacing.Axis.Y);
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                    if (this.isZombieInfested) {
                        return Blocks.field_150341_Y.func_176223_P();
                    }
                    return Blocks.field_185772_cY.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150476_ad || blockstateIn.func_177230_c() == Blocks.field_150446_ar) {
                    return Blocks.field_185769_cV.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150478_aa) {
                    return Blocks.field_185764_cQ.func_176223_P().func_177226_a((IProperty)BlockEndRod.field_176387_N, blockstateIn.func_177229_b((IProperty)BlockTorch.field_176596_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150347_e || blockstateIn.func_177230_c() == Blocks.field_150351_n) {
                    return Blocks.field_185767_cT.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_180407_aO) {
                    return Blocks.field_185771_cX.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150346_d) {
                    return Blocks.field_185768_cU.func_176223_P().func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)EnumFacing.Axis.Y);
                }
            } else if (this.structureType == 7) {
                if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                    return Blocks.field_150385_bj.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                    if (this.isZombieInfested) {
                        return Blocks.field_150341_Y.func_176223_P();
                    }
                    return Blocks.field_150385_bj.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150476_ad || blockstateIn.func_177230_c() == Blocks.field_150446_ar) {
                    return Blocks.field_150387_bl.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150347_e) {
                    return Blocks.field_150385_bj.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_180407_aO) {
                    return Blocks.field_150386_bk.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150346_d) {
                    return Blocks.field_150425_aM.func_176223_P();
                }
            } else if (this.structureType == 8) {
                if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                    return Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.RED);
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                    if (this.isZombieInfested) {
                        return Blocks.field_150341_Y.func_176223_P();
                    }
                    return Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.RED);
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150476_ad || blockstateIn.func_177230_c() == Blocks.field_150446_ar) {
                    return Blocks.field_180396_cN.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150347_e) {
                    return Blocks.field_180395_cM.func_176223_P().func_177226_a((IProperty)BlockRedSandstone.field_176336_a, (Comparable)BlockRedSandstone.EnumType.CHISELED);
                }
                if (blockstateIn.func_177230_c() == Blocks.field_180407_aO) {
                    return Blocks.field_180406_aS.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150351_n) {
                    return Blocks.field_180395_cM.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150346_d) {
                    return Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND);
                }
            } else if (this.structureType == 9) {
                if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                    return Blocks.field_150433_aE.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                    if (this.isZombieInfested) {
                        return Blocks.field_150341_Y.func_176223_P();
                    }
                    return Blocks.field_150433_aE.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150476_ad || blockstateIn.func_177230_c() == Blocks.field_150446_ar) {
                    return Blocks.field_150403_cj.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150347_e) {
                    return Blocks.field_150432_aD.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_180407_aO) {
                    return Blocks.field_150403_cj.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150351_n || blockstateIn.func_177230_c() == Blocks.field_150346_d) {
                    return Blocks.field_150432_aD.func_176223_P();
                }
            }
            return blockstateIn;
        }

        protected BlockDoor func_189925_i() {
            switch (this.structureType) {
                case 2: {
                    return Blocks.field_180410_as;
                }
                case 3: {
                    return Blocks.field_180414_ap;
                }
                case 4: {
                    return Blocks.field_180411_ar;
                }
            }
            return Blocks.field_180413_ao;
        }

        protected void createVillageDoor(World p_189927_1_, StructureBoundingBox p_189927_2_, Random p_189927_3_, int p_189927_4_, int p_189927_5_, int p_189927_6_, EnumFacing p_189927_7_) {
            this.func_189915_a(p_189927_1_, p_189927_2_, p_189927_3_, p_189927_4_, p_189927_5_, p_189927_6_, EnumFacing.NORTH, this.func_189925_i());
        }

        protected void func_189926_a(World p_189926_1_, EnumFacing p_189926_2_, int p_189926_3_, int p_189926_4_, int p_189926_5_, StructureBoundingBox p_189926_6_) {
            if (!this.isZombieInfested) {
                this.func_175811_a(p_189926_1_, this.getBiomeSpecificBlockState(Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)p_189926_2_)), p_189926_3_, p_189926_4_, p_189926_5_, p_189926_6_);
            }
        }

        protected void func_175808_b(World worldIn, IBlockState blockstateIn, int x, int y, int z, StructureBoundingBox boundingboxIn) {
            IBlockState iblockstate = this.getBiomeSpecificBlockState(blockstateIn);
            super.func_175808_b(worldIn, iblockstate, x, y, z, boundingboxIn);
        }

        protected void func_189924_a(int p_189924_1_) {
            this.structureType = p_189924_1_;
        }
    }

    public static class Torch
    extends Village {
        public Torch() {
        }

        public Torch(Start start, int p_i45568_2_, Random rand, StructureBoundingBox p_i45568_4_, EnumFacing facing) {
            super(start, p_i45568_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45568_4_;
        }

        public static StructureBoundingBox findPieceBox(Start start, List<StructureComponent> p_175856_1_, Random rand, int p_175856_3_, int p_175856_4_, int p_175856_5_, EnumFacing facing) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175856_3_, (int)p_175856_4_, (int)p_175856_5_, (int)0, (int)0, (int)0, (int)3, (int)4, (int)2, (EnumFacing)facing);
            return StructureComponent.func_74883_a(p_175856_1_, (StructureBoundingBox)structureboundingbox) != null ? null : structureboundingbox;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 2, 3, 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate, 1, 0, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 1, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150325_L.func_176203_a(EnumDyeColor.WHITE.func_176767_b()), 1, 3, 0, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.EAST, 2, 3, 0, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.NORTH, 1, 3, 1, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.WEST, 0, 3, 0, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.SOUTH, 1, 3, -1, structureBoundingBoxIn);
            return true;
        }
    }

    public static class Start
    extends Well {
        public BiomeProvider worldChunkMngr;
        public int terrainType;
        public PieceWeight structVillagePieceWeight;
        public List<PieceWeight> structureVillageWeightedPieceList;
        public List<StructureComponent> pendingHouses = Lists.newArrayList();
        public List<StructureComponent> pendingRoads = Lists.newArrayList();

        public Start() {
        }

        public Start(BiomeProvider chunkManagerIn, int p_i2104_2_, Random rand, int x, int z, List<PieceWeight> p_i2104_6_, int p_i2104_7_) {
            super(null, 0, rand, x, z);
            this.worldChunkMngr = chunkManagerIn;
            this.structureVillageWeightedPieceList = p_i2104_6_;
            this.terrainType = p_i2104_7_;
            this.isZombieInfested = rand.nextInt(6) == 0;
            Biome biome = chunkManagerIn.func_180300_a(new BlockPos(x, 0, z), Biomes.field_180279_ad);
            if (biome instanceof BiomeDesertUA) {
                System.out.println("Village | Desert | " + x + " " + z + " | Zombie: " + this.isZombieInfested);
                this.structureType = 1;
            } else if (biome instanceof BiomeSavannaUA) {
                System.out.println("Village | Savanna | " + x + " " + z + " | Zombie: " + this.isZombieInfested);
                this.structureType = 2;
            } else if (biome instanceof BiomeTaigaUA) {
                System.out.println("Village | Taiga | " + x + " " + z + " | Zombie: " + this.isZombieInfested);
                this.structureType = 3;
            } else if (biome instanceof BiomeSnowUA) {
                if (biome.func_185363_b() || biome.func_185355_j() > 0.5f) {
                    System.out.println("Village | Ice Spike | " + x + " " + z + " | Zombie: " + this.isZombieInfested);
                    this.structureType = 9;
                } else {
                    System.out.println("Village | Taiga | " + x + " " + z + " | Zombie: " + this.isZombieInfested);
                    this.structureType = 3;
                }
            } else if (biome instanceof BiomeJungleUA) {
                System.out.println("Village | Jungle | " + x + " " + z + " | Zombie: " + this.isZombieInfested);
                this.structureType = 4;
            } else if (biome instanceof BiomeStoneBeachUA) {
                System.out.println("Village | Stone | " + x + " " + z + " | Zombie: " + this.isZombieInfested);
                this.structureType = 5;
            } else if (biome instanceof BiomeEndUA) {
                System.out.println("Village | End | " + x + " " + z + " | Zombie: " + this.isZombieInfested);
                this.structureType = 6;
            } else if (biome instanceof BiomeHellUA) {
                System.out.println("Village | Nether | " + x + " " + z + " | Zombie: " + this.isZombieInfested);
                this.structureType = 7;
            } else if (biome instanceof BiomeMesaUA) {
                System.out.println("Village | Mesa | " + x + " " + z + " | Zombie: " + this.isZombieInfested);
                this.structureType = 8;
            } else {
                System.out.println("Village | Normal | " + x + " " + z + " | Zombie: " + this.isZombieInfested);
            }
            this.func_189924_a(this.structureType);
        }
    }

    public static abstract class Road
    extends Village {
        public Road() {
        }

        protected Road(Start start, int type) {
            super(start, type);
        }
    }

    public static class PieceWeight {
        public Class<? extends Village> villagePieceClass;
        public final int villagePieceWeight;
        public int villagePiecesSpawned;
        public int villagePiecesLimit;

        public PieceWeight(Class<? extends Village> p_i2098_1_, int p_i2098_2_, int p_i2098_3_) {
            this.villagePieceClass = p_i2098_1_;
            this.villagePieceWeight = p_i2098_2_;
            this.villagePiecesLimit = p_i2098_3_;
        }

        public boolean canSpawnMoreVillagePiecesOfType(int componentType) {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }

        public boolean canSpawnMoreVillagePieces() {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }
    }

    public static class Path
    extends Road {
        private int length;

        public Path() {
        }

        public Path(Start start, int p_i45562_2_, Random rand, StructureBoundingBox p_i45562_4_, EnumFacing facing) {
            super(start, p_i45562_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45562_4_;
            this.length = Math.max(p_i45562_4_.func_78883_b(), p_i45562_4_.func_78880_d());
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("Length", this.length);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.length = tagCompound.func_74762_e("Length");
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            boolean flag = false;
            for (int i = rand.nextInt(5); i < this.length - 8; i += 2 + rand.nextInt(5)) {
                StructureComponent structurecomponent = this.getNextComponentNN((Start)componentIn, listIn, rand, 0, i);
                if (structurecomponent == null) continue;
                i += Math.max(structurecomponent.func_74874_b().func_78883_b(), structurecomponent.func_74874_b().func_78880_d());
                flag = true;
            }
            for (int j = rand.nextInt(5); j < this.length - 8; j += 2 + rand.nextInt(5)) {
                StructureComponent structurecomponent1 = this.getNextComponentPP((Start)componentIn, listIn, rand, 0, j);
                if (structurecomponent1 == null) continue;
                j += Math.max(structurecomponent1.func_74874_b().func_78883_b(), structurecomponent1.func_74874_b().func_78880_d());
                flag = true;
            }
            EnumFacing enumfacing = this.func_186165_e();
            if (flag && rand.nextInt(3) > 0 && enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        StructureVillagePiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.WEST, this.func_74877_c());
                        break;
                    }
                    case SOUTH: {
                        StructureVillagePiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, EnumFacing.WEST, this.func_74877_c());
                        break;
                    }
                    case WEST: {
                        StructureVillagePiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                        break;
                    }
                    case EAST: {
                        StructureVillagePiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                }
            }
            if (flag && rand.nextInt(3) > 0 && enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        StructureVillagePiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.EAST, this.func_74877_c());
                        break;
                    }
                    case SOUTH: {
                        StructureVillagePiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, EnumFacing.EAST, this.func_74877_c());
                        break;
                    }
                    case WEST: {
                        StructureVillagePiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                        break;
                    }
                    case EAST: {
                        StructureVillagePiecesUA.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                }
            }
        }

        public static StructureBoundingBox findPieceBox(Start start, List<StructureComponent> p_175848_1_, Random rand, int p_175848_3_, int p_175848_4_, int p_175848_5_, EnumFacing facing) {
            for (int i = 7 * MathHelper.func_76136_a((Random)rand, (int)3, (int)5); i >= 7; i -= 7) {
                StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175848_3_, (int)p_175848_4_, (int)p_175848_5_, (int)0, (int)0, (int)0, (int)3, (int)3, (int)i, (EnumFacing)facing);
                if (StructureComponent.func_74883_a(p_175848_1_, (StructureBoundingBox)structureboundingbox) != null) continue;
                return structureboundingbox;
            }
            return null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_185774_da.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P());
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.field_150351_n.func_176223_P());
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P());
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                block1: for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    BlockPos blockpos = new BlockPos(i, 64, j);
                    if (!structureBoundingBoxIn.func_175898_b((Vec3i)blockpos)) continue;
                    if ((blockpos = worldIn.func_175672_r(blockpos).func_177977_b()).func_177956_o() < worldIn.func_181545_F()) {
                        blockpos = new BlockPos(blockpos.func_177958_n(), worldIn.func_181545_F() - 1, blockpos.func_177952_p());
                    }
                    while (blockpos.func_177956_o() >= worldIn.func_181545_F() - 1) {
                        IBlockState iblockstate4 = worldIn.func_180495_p(blockpos);
                        if (iblockstate4.func_177230_c() == Blocks.field_150349_c && worldIn.func_175623_d(blockpos.func_177984_a())) {
                            worldIn.func_180501_a(blockpos, iblockstate, 2);
                            continue block1;
                        }
                        if (iblockstate4.func_185904_a().func_76224_d()) {
                            worldIn.func_180501_a(blockpos, iblockstate1, 2);
                            continue block1;
                        }
                        if (iblockstate4.func_177230_c() == Blocks.field_150354_m || iblockstate4.func_177230_c() == Blocks.field_150322_A || iblockstate4.func_177230_c() == Blocks.field_180395_cM || iblockstate4.func_177230_c() == Blocks.field_150433_aE || iblockstate4.func_177230_c() == Blocks.field_150348_b || iblockstate4.func_177230_c() == Blocks.field_150424_aL || iblockstate4.func_177230_c() == Blocks.field_150377_bs || iblockstate4.func_177230_c() == Blocks.field_150406_ce) {
                            worldIn.func_180501_a(blockpos, iblockstate2, 2);
                            worldIn.func_180501_a(blockpos.func_177977_b(), iblockstate3, 2);
                            continue block1;
                        }
                        blockpos = blockpos.func_177977_b();
                    }
                }
            }
            return true;
        }
    }

    public static class House4Garden
    extends Village {
        private boolean isRoofAccessible;

        public House4Garden() {
        }

        public House4Garden(Start start, int p_i45566_2_, Random rand, StructureBoundingBox p_i45566_4_, EnumFacing facing) {
            super(start, p_i45566_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45566_4_;
            this.isRoofAccessible = rand.nextBoolean();
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("Terrace", this.isRoofAccessible);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.isRoofAccessible = tagCompound.func_74767_n("Terrace");
        }

        public static House4Garden createPiece(Start start, List<StructureComponent> p_175858_1_, Random rand, int p_175858_3_, int p_175858_4_, int p_175858_5_, EnumFacing facing, int p_175858_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175858_3_, (int)p_175858_4_, (int)p_175858_5_, (int)0, (int)0, (int)0, (int)5, (int)6, (int)5, (EnumFacing)facing);
            return StructureComponent.func_74883_a(p_175858_1_, (StructureBoundingBox)structureboundingbox) != null ? null : new House4Garden(start, p_175858_7_, rand, structureboundingbox, facing);
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P());
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176223_P());
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 4, 0, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 0, 4, 4, 4, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 1, 3, 4, 3, iblockstate1, iblockstate1, false);
            this.func_175811_a(worldIn, iblockstate, 0, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 0, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 0, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 0, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 0, 3, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 3, 4, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 3, 3, iblockstate1, iblockstate1, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 1, 4, 3, 3, iblockstate1, iblockstate1, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 4, 3, 3, 4, iblockstate1, iblockstate1, false);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 2, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 3, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 3, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 3, 1, 0, structureBoundingBoxIn);
            if (this.func_175807_a(worldIn, 2, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, iblockstate2, 2, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(worldIn, Blocks.field_150349_c.func_176223_P(), 2, -1, -1, structureBoundingBoxIn);
                }
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 3, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            if (this.isRoofAccessible) {
                this.func_175811_a(worldIn, iblockstate4, 0, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 1, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 2, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 3, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 4, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 0, 5, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 1, 5, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 2, 5, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 3, 5, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 4, 5, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 4, 5, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 4, 5, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 4, 5, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 0, 5, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 0, 5, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 0, 5, 3, structureBoundingBoxIn);
            }
            if (this.isRoofAccessible) {
                IBlockState iblockstate5 = Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.SOUTH);
                this.func_175811_a(worldIn, iblockstate5, 3, 1, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate5, 3, 2, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate5, 3, 3, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate5, 3, 4, 3, structureBoundingBoxIn);
            }
            this.func_189926_a(worldIn, EnumFacing.NORTH, 2, 3, 1, structureBoundingBoxIn);
            for (int j = 0; j < 5; ++j) {
                for (int i = 0; i < 5; ++i) {
                    this.func_74871_b(worldIn, i, 6, j, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, i, -1, j, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(worldIn, structureBoundingBoxIn, 1, 1, 2, 1);
            return true;
        }
    }

    public static class House3
    extends Village {
        public House3() {
        }

        public House3(Start start, int type, Random rand, StructureBoundingBox p_i45561_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45561_4_;
        }

        public static House3 createPiece(Start start, List<StructureComponent> p_175849_1_, Random rand, int p_175849_3_, int p_175849_4_, int p_175849_5_, EnumFacing facing, int p_175849_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175849_3_, (int)p_175849_4_, (int)p_175849_5_, (int)0, (int)0, (int)0, (int)9, (int)7, (int)12, (EnumFacing)facing);
            return House3.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175849_1_, (StructureBoundingBox)structureboundingbox) == null ? new House3(start, p_175849_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
            IBlockState iblockstate5 = this.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P());
            IBlockState iblockstate6 = this.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 0, 5, 8, 0, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 7, 0, 4, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 0, 3, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 0, 0, 8, 3, 10, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 7, 2, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 5, 2, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 0, 6, 2, 3, 10, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 0, 10, 7, 3, 10, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 0, 7, 3, 0, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 5, 2, 3, 5, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 1, 8, 4, 1, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 4, 3, 4, 4, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 2, 8, 5, 3, iblockstate5, iblockstate5, false);
            this.func_175811_a(worldIn, iblockstate5, 0, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 0, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 4, 4, structureBoundingBoxIn);
            IBlockState iblockstate7 = iblockstate1;
            IBlockState iblockstate8 = iblockstate2;
            IBlockState iblockstate9 = iblockstate4;
            IBlockState iblockstate10 = iblockstate3;
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.func_175811_a(worldIn, iblockstate7, j, 4 + i, i, structureBoundingBoxIn);
                    if (i <= -1 && j > 1 || i <= 0 && j > 3 || i <= 1 && j > 4 && j < 6) continue;
                    this.func_175811_a(worldIn, iblockstate8, j, 4 + i, 5 - i, structureBoundingBoxIn);
                }
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 4, 5, 3, 4, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 7, 4, 2, 7, 4, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 5, 4, 4, 5, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 5, 4, 6, 5, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 6, 3, 5, 6, 10, iblockstate5, iblockstate5, false);
            for (int k = 4; k >= 1; --k) {
                this.func_175811_a(worldIn, iblockstate5, k, 2 + k, 7 - k, structureBoundingBoxIn);
                for (int k1 = 8 - k; k1 <= 10; ++k1) {
                    this.func_175811_a(worldIn, iblockstate10, k, 2 + k, k1, structureBoundingBoxIn);
                }
            }
            this.func_175811_a(worldIn, iblockstate5, 6, 6, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 7, 5, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4, 6, 6, 4, structureBoundingBoxIn);
            for (int l = 6; l <= 8; ++l) {
                for (int l1 = 5; l1 <= 10; ++l1) {
                    this.func_175811_a(worldIn, iblockstate9, l, 12 - l, l1, structureBoundingBoxIn);
                }
            }
            this.func_175811_a(worldIn, iblockstate6, 0, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 4, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 5, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 6, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 8, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 8, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 8, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 8, 2, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 2, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 2, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 2, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 2, 2, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 4, 4, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 5, 4, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 6, 4, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 5, 5, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.NORTH, 2, 3, 1, structureBoundingBoxIn);
            this.createVillageDoor(worldIn, structureBoundingBoxIn, randomIn, 2, 1, 0, EnumFacing.NORTH);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, -1, 3, 2, -1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            if (this.func_175807_a(worldIn, 2, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, iblockstate7, 2, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(worldIn, Blocks.field_150349_c.func_176223_P(), 2, -1, -1, structureBoundingBoxIn);
                }
            }
            for (int i1 = 0; i1 < 5; ++i1) {
                for (int i2 = 0; i2 < 9; ++i2) {
                    this.func_74871_b(worldIn, i2, 7, i1, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, i2, -1, i1, structureBoundingBoxIn);
                }
            }
            for (int j1 = 5; j1 < 11; ++j1) {
                for (int j2 = 2; j2 < 9; ++j2) {
                    this.func_74871_b(worldIn, j2, 7, j1, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, j2, -1, j1, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(worldIn, structureBoundingBoxIn, 4, 1, 2, 2);
            return true;
        }
    }

    public static class House2
    extends Village {
        private boolean hasMadeChest;

        public House2() {
        }

        public House2(Start start, int type, Random rand, StructureBoundingBox p_i45563_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45563_4_;
        }

        public static House2 createPiece(Start start, List<StructureComponent> p_175855_1_, Random rand, int p_175855_3_, int p_175855_4_, int p_175855_5_, EnumFacing facing, int p_175855_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175855_3_, (int)p_175855_4_, (int)p_175855_5_, (int)0, (int)0, (int)0, (int)10, (int)6, (int)7, (EnumFacing)facing);
            return House2.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175855_1_, (StructureBoundingBox)structureboundingbox) == null ? new House2(start, p_175855_7_, rand, structureboundingbox, facing) : null;
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("Chest", this.hasMadeChest);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.hasMadeChest = tagCompound.func_74767_n("Chest");
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            IBlockState iblockstate = Blocks.field_150347_e.func_176223_P();
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P());
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate5 = this.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176223_P());
            IBlockState iblockstate6 = this.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 9, 4, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 9, 0, 6, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 0, 9, 4, 6, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 0, 9, 5, 6, Blocks.field_150333_U.func_176223_P(), Blocks.field_150333_U.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 1, 8, 5, 5, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 0, 2, 3, 0, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 4, 0, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 0, 3, 4, 0, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 6, 0, 4, 6, iblockstate5, iblockstate5, false);
            this.func_175811_a(worldIn, iblockstate3, 3, 3, 1, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 2, 3, 3, 2, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 3, 5, 3, 3, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 3, 5, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 6, 5, 3, 6, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 1, 0, 5, 3, 0, iblockstate6, iblockstate6, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 1, 0, 9, 3, 0, iblockstate6, iblockstate6, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 1, 4, 9, 4, 6, iblockstate, iblockstate, false);
            this.func_175811_a(worldIn, Blocks.field_150356_k.func_176223_P(), 7, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150356_k.func_176223_P(), 8, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), 9, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), 9, 2, 4, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 7, 2, 4, 8, 2, 5, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate, 6, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150460_al.func_176223_P(), 6, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150460_al.func_176223_P(), 6, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150334_T.func_176223_P(), 8, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 2, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150452_aw.func_176223_P(), 2, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 1, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 2, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate2, 1, 1, 4, structureBoundingBoxIn);
            if (!this.hasMadeChest && structureBoundingBoxIn.func_175898_b((Vec3i)new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(1), this.func_74873_b(5, 5)))) {
                this.hasMadeChest = true;
                if (UAConfig.StructuresOptions.biomeBasedStructuresOptions.chestGeneration) {
                    this.func_186167_a(worldIn, structureBoundingBoxIn, randomIn, 5, 1, 5, LootTableList.field_186423_e);
                }
            }
            for (int i = 6; i <= 8; ++i) {
                if (this.func_175807_a(worldIn, i, 0, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a || this.func_175807_a(worldIn, i, -1, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a) continue;
                this.func_175811_a(worldIn, iblockstate4, i, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a(worldIn, i, -1, -1, structureBoundingBoxIn).func_177230_c() != Blocks.field_185774_da) continue;
                this.func_175811_a(worldIn, Blocks.field_150349_c.func_176223_P(), i, -1, -1, structureBoundingBoxIn);
            }
            for (int k = 0; k < 7; ++k) {
                for (int j = 0; j < 10; ++j) {
                    this.func_74871_b(worldIn, j, 6, k, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, j, -1, k, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(worldIn, structureBoundingBoxIn, 7, 1, 1, 1);
            return true;
        }

        @Override
        protected int chooseProfession(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class House1
    extends Village {
        public House1() {
        }

        public House1(Start start, int type, Random rand, StructureBoundingBox p_i45571_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45571_4_;
        }

        public static House1 createPiece(Start start, List<StructureComponent> p_175850_1_, Random rand, int p_175850_3_, int p_175850_4_, int p_175850_5_, EnumFacing facing, int p_175850_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175850_3_, (int)p_175850_4_, (int)p_175850_5_, (int)0, (int)0, (int)0, (int)9, (int)9, (int)6, (EnumFacing)facing);
            return House1.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175850_1_, (StructureBoundingBox)structureboundingbox) == null ? new House1(start, p_175850_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 9 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P());
            IBlockState iblockstate5 = this.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate6 = this.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 7, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 8, 0, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 0, 8, 5, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 6, 1, 8, 6, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 7, 2, 8, 7, 3, iblockstate, iblockstate, false);
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.func_175811_a(worldIn, iblockstate1, j, 6 + i, i, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, iblockstate2, j, 6 + i, 5 - i, structureBoundingBoxIn);
                }
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 5, 8, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 1, 0, 8, 1, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 0, 7, 1, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 2, 0, 0, 4, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 2, 5, 0, 4, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 2, 5, 8, 4, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 2, 0, 8, 4, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 2, 1, 0, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 5, 7, 4, 5, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 2, 1, 8, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 0, 7, 4, 0, iblockstate4, iblockstate4, false);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 5, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 6, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 5, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 6, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 3, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 5, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 6, 2, 5, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 1, 7, 4, 1, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 4, 7, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 3, 4, 7, 3, 4, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate4, 7, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 7, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 6, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 5, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 3, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 6, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150452_aw.func_176223_P(), 6, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 4, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150452_aw.func_176223_P(), 4, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150462_ai.func_176223_P(), 7, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 2, 0, structureBoundingBoxIn);
            this.createVillageDoor(worldIn, structureBoundingBoxIn, randomIn, 1, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a(worldIn, 1, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 1, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, iblockstate5, 1, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a(worldIn, 1, -1, -1, structureBoundingBoxIn).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(worldIn, Blocks.field_150349_c.func_176223_P(), 1, -1, -1, structureBoundingBoxIn);
                }
            }
            for (int l = 0; l < 6; ++l) {
                for (int k = 0; k < 9; ++k) {
                    this.func_74871_b(worldIn, k, 9, l, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, k, -1, l, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(worldIn, structureBoundingBoxIn, 2, 1, 2, 1);
            return true;
        }

        @Override
        protected int chooseProfession(int villagersSpawnedIn, int currentVillagerProfession) {
            return 1;
        }
    }

    public static class Hall
    extends Village {
        public Hall() {
        }

        public Hall(Start start, int type, Random rand, StructureBoundingBox p_i45567_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45567_4_;
        }

        public static Hall createPiece(Start start, List<StructureComponent> p_175857_1_, Random rand, int p_175857_3_, int p_175857_4_, int p_175857_5_, EnumFacing facing, int p_175857_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175857_3_, (int)p_175857_4_, (int)p_175857_5_, (int)0, (int)0, (int)0, (int)9, (int)7, (int)11, (EnumFacing)facing);
            return Hall.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175857_1_, (StructureBoundingBox)structureboundingbox) == null ? new Hall(start, p_175857_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P());
            IBlockState iblockstate5 = this.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176223_P());
            IBlockState iblockstate6 = this.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 0, 6, 8, 0, 10, Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate, 6, 0, 6, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 6, 2, 1, 10, iblockstate6, iblockstate6, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 1, 6, 8, 1, 10, iblockstate6, iblockstate6, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 10, 7, 1, 10, iblockstate6, iblockstate6, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 7, 0, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 0, 3, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 0, 0, 8, 3, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 7, 1, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 5, 7, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 0, 7, 3, 0, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 5, 7, 3, 5, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 1, 8, 4, 1, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 4, 8, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 2, 8, 5, 3, iblockstate4, iblockstate4, false);
            this.func_175811_a(worldIn, iblockstate4, 0, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4, 0, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4, 8, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4, 8, 4, 3, structureBoundingBoxIn);
            IBlockState iblockstate7 = iblockstate1;
            IBlockState iblockstate8 = iblockstate2;
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.func_175811_a(worldIn, iblockstate7, j, 4 + i, i, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, iblockstate8, j, 4 + i, 5 - i, structureBoundingBoxIn);
                }
            }
            this.func_175811_a(worldIn, iblockstate5, 0, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 3, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 5, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 6, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 2, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150452_aw.func_176223_P(), 2, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4, 1, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate7, 2, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 1, 1, 3, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 0, 1, 7, 0, 3, Blocks.field_150334_T.func_176223_P(), Blocks.field_150334_T.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150334_T.func_176223_P(), 6, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150334_T.func_176223_P(), 6, 1, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.NORTH, 2, 3, 1, structureBoundingBoxIn);
            this.createVillageDoor(worldIn, structureBoundingBoxIn, randomIn, 2, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a(worldIn, 2, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, iblockstate7, 2, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(worldIn, Blocks.field_150349_c.func_176223_P(), 2, -1, -1, structureBoundingBoxIn);
                }
            }
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 6, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 6, 2, 5, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.SOUTH, 6, 3, 4, structureBoundingBoxIn);
            this.createVillageDoor(worldIn, structureBoundingBoxIn, randomIn, 6, 1, 5, EnumFacing.SOUTH);
            for (int k = 0; k < 5; ++k) {
                for (int l = 0; l < 9; ++l) {
                    this.func_74871_b(worldIn, l, 7, k, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, l, -1, k, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(worldIn, structureBoundingBoxIn, 4, 1, 2, 2);
            return true;
        }

        @Override
        protected int chooseProfession(int villagersSpawnedIn, int currentVillagerProfession) {
            return villagersSpawnedIn == 0 ? 4 : super.chooseProfession(villagersSpawnedIn, currentVillagerProfession);
        }
    }

    public static class Field2
    extends Village {
        private Block cropTypeA;
        private Block cropTypeB;

        public Field2() {
        }

        public Field2(Start start, int p_i45569_2_, Random rand, StructureBoundingBox p_i45569_4_, EnumFacing facing) {
            super(start, p_i45569_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45569_4_;
            this.cropTypeA = this.getRandomCropType(rand);
            this.cropTypeB = this.getRandomCropType(rand);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("CA", Block.field_149771_c.func_148757_b((Object)this.cropTypeA));
            tagCompound.func_74768_a("CB", Block.field_149771_c.func_148757_b((Object)this.cropTypeB));
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.cropTypeA = Block.func_149729_e((int)tagCompound.func_74762_e("CA"));
            this.cropTypeB = Block.func_149729_e((int)tagCompound.func_74762_e("CB"));
        }

        private Block getRandomCropType(Random rand) {
            switch (rand.nextInt(10)) {
                case 0: 
                case 1: {
                    return Blocks.field_150459_bM;
                }
                case 2: 
                case 3: {
                    return Blocks.field_150469_bN;
                }
                case 4: {
                    return Blocks.field_185773_cZ;
                }
            }
            return Blocks.field_150464_aj;
        }

        public static Field2 createPiece(Start start, List<StructureComponent> p_175852_1_, Random rand, int p_175852_3_, int p_175852_4_, int p_175852_5_, EnumFacing facing, int p_175852_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175852_3_, (int)p_175852_4_, (int)p_175852_5_, (int)0, (int)0, (int)0, (int)7, (int)4, (int)9, (EnumFacing)facing);
            return Field2.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175852_1_, (StructureBoundingBox)structureboundingbox) == null ? new Field2(start, p_175852_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 6, 4, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 2, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 0, 1, 5, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 0, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 0, 0, 6, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 5, 0, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 8, 5, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 0, 1, 3, 0, 7, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
            for (int i = 1; i <= 7; ++i) {
                int j = ((BlockCrops)this.cropTypeA).func_185526_g();
                int k = j / 3;
                this.func_175811_a(worldIn, this.cropTypeA.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)k, (int)j)), 1, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeA.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)k, (int)j)), 2, 1, i, structureBoundingBoxIn);
                int l = ((BlockCrops)this.cropTypeB).func_185526_g();
                int i1 = l / 3;
                this.func_175811_a(worldIn, this.cropTypeB.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)i1, (int)l)), 4, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeB.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)i1, (int)l)), 5, 1, i, structureBoundingBoxIn);
            }
            for (int j1 = 0; j1 < 9; ++j1) {
                for (int k1 = 0; k1 < 7; ++k1) {
                    this.func_74871_b(worldIn, k1, 4, j1, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, Blocks.field_150346_d.func_176223_P(), k1, -1, j1, structureBoundingBoxIn);
                }
            }
            return true;
        }
    }

    public static class Field1
    extends Village {
        private Block cropTypeA;
        private Block cropTypeB;
        private Block cropTypeC;
        private Block cropTypeD;

        public Field1() {
        }

        public Field1(Start start, int type, Random rand, StructureBoundingBox p_i45570_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45570_4_;
            this.cropTypeA = this.getRandomCropType(rand);
            this.cropTypeB = this.getRandomCropType(rand);
            this.cropTypeC = this.getRandomCropType(rand);
            this.cropTypeD = this.getRandomCropType(rand);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("CA", Block.field_149771_c.func_148757_b((Object)this.cropTypeA));
            tagCompound.func_74768_a("CB", Block.field_149771_c.func_148757_b((Object)this.cropTypeB));
            tagCompound.func_74768_a("CC", Block.field_149771_c.func_148757_b((Object)this.cropTypeC));
            tagCompound.func_74768_a("CD", Block.field_149771_c.func_148757_b((Object)this.cropTypeD));
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.cropTypeA = Block.func_149729_e((int)tagCompound.func_74762_e("CA"));
            this.cropTypeB = Block.func_149729_e((int)tagCompound.func_74762_e("CB"));
            this.cropTypeC = Block.func_149729_e((int)tagCompound.func_74762_e("CC"));
            this.cropTypeD = Block.func_149729_e((int)tagCompound.func_74762_e("CD"));
            if (!(this.cropTypeA instanceof BlockCrops)) {
                this.cropTypeA = Blocks.field_150464_aj;
            }
            if (!(this.cropTypeB instanceof BlockCrops)) {
                this.cropTypeB = Blocks.field_150459_bM;
            }
            if (!(this.cropTypeC instanceof BlockCrops)) {
                this.cropTypeC = Blocks.field_150469_bN;
            }
            if (!(this.cropTypeD instanceof BlockCrops)) {
                this.cropTypeD = Blocks.field_185773_cZ;
            }
        }

        private Block getRandomCropType(Random rand) {
            switch (rand.nextInt(10)) {
                case 0: 
                case 1: {
                    return Blocks.field_150459_bM;
                }
                case 2: 
                case 3: {
                    return Blocks.field_150469_bN;
                }
                case 4: {
                    return Blocks.field_185773_cZ;
                }
            }
            return Blocks.field_150464_aj;
        }

        public static Field1 createPiece(Start start, List<StructureComponent> p_175851_1_, Random rand, int p_175851_3_, int p_175851_4_, int p_175851_5_, EnumFacing facing, int p_175851_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175851_3_, (int)p_175851_4_, (int)p_175851_5_, (int)0, (int)0, (int)0, (int)13, (int)4, (int)9, (EnumFacing)facing);
            return Field1.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175851_1_, (StructureBoundingBox)structureboundingbox) == null ? new Field1(start, p_175851_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 12, 4, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 2, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 0, 1, 5, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 7, 0, 1, 8, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 10, 0, 1, 11, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 0, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 0, 0, 6, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 12, 0, 0, 12, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 11, 0, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 8, 11, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 0, 1, 3, 0, 7, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 0, 1, 9, 0, 7, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
            for (int i = 1; i <= 7; ++i) {
                int j = ((BlockCrops)this.cropTypeA).func_185526_g();
                int k = j / 3;
                this.func_175811_a(worldIn, this.cropTypeA.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)k, (int)j)), 1, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeA.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)k, (int)j)), 2, 1, i, structureBoundingBoxIn);
                int l = ((BlockCrops)this.cropTypeB).func_185526_g();
                int i1 = l / 3;
                this.func_175811_a(worldIn, this.cropTypeB.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)i1, (int)l)), 4, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeB.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)i1, (int)l)), 5, 1, i, structureBoundingBoxIn);
                int j1 = ((BlockCrops)this.cropTypeC).func_185526_g();
                int k1 = j1 / 3;
                this.func_175811_a(worldIn, this.cropTypeC.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)k1, (int)j1)), 7, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeC.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)k1, (int)j1)), 8, 1, i, structureBoundingBoxIn);
                int l1 = ((BlockCrops)this.cropTypeD).func_185526_g();
                int i2 = l1 / 3;
                this.func_175811_a(worldIn, this.cropTypeD.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)i2, (int)l1)), 10, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeD.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)i2, (int)l1)), 11, 1, i, structureBoundingBoxIn);
            }
            for (int j2 = 0; j2 < 9; ++j2) {
                for (int k2 = 0; k2 < 13; ++k2) {
                    this.func_74871_b(worldIn, k2, 4, j2, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, Blocks.field_150346_d.func_176223_P(), k2, -1, j2, structureBoundingBoxIn);
                }
            }
            return true;
        }
    }

    public static class Church
    extends Village {
        public Church() {
        }

        public Church(Start start, int type, Random rand, StructureBoundingBox p_i45564_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45564_4_;
        }

        public static Church createPiece(Start start, List<StructureComponent> p_175854_1_, Random rand, int p_175854_3_, int p_175854_4_, int p_175854_5_, EnumFacing facing, int p_175854_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175854_3_, (int)p_175854_4_, (int)p_175854_5_, (int)0, (int)0, (int)0, (int)5, (int)12, (int)9, (EnumFacing)facing);
            return Church.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175854_1_, (StructureBoundingBox)structureboundingbox) == null ? new Church(start, p_175854_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 12 - 1, 0);
            }
            IBlockState iblockstate = Blocks.field_150347_e.func_176223_P();
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 3, 3, 7, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 1, 3, 9, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 3, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 0, 3, 10, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 10, 3, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 1, 4, 10, 3, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 4, 0, 4, 7, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 0, 4, 4, 4, 7, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 8, 3, 4, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 4, 3, 10, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 5, 3, 5, 7, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 9, 0, 4, 9, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 0, 4, 4, 4, iblockstate, iblockstate, false);
            this.func_175811_a(worldIn, iblockstate, 0, 11, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 11, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 2, 11, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 2, 11, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 1, 1, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 1, 1, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 2, 1, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 3, 1, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 3, 1, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 2, 1, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 3, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate2, 1, 2, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 3, 2, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 6, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 7, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 6, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 7, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 6, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 7, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 6, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 7, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 3, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 3, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 3, 8, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.SOUTH, 2, 4, 7, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.EAST, 1, 4, 6, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.WEST, 3, 4, 6, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.NORTH, 2, 4, 5, structureBoundingBoxIn);
            IBlockState iblockstate4 = Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.WEST);
            for (int i = 1; i <= 9; ++i) {
                this.func_175811_a(worldIn, iblockstate4, 3, i, 3, structureBoundingBoxIn);
            }
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, structureBoundingBoxIn);
            this.createVillageDoor(worldIn, structureBoundingBoxIn, randomIn, 2, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a(worldIn, 2, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, iblockstate1, 2, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(worldIn, Blocks.field_150349_c.func_176223_P(), 2, -1, -1, structureBoundingBoxIn);
                }
            }
            for (int k = 0; k < 9; ++k) {
                for (int j = 0; j < 5; ++j) {
                    this.func_74871_b(worldIn, j, 12, k, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, j, -1, k, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(worldIn, structureBoundingBoxIn, 2, 1, 2, 1);
            return true;
        }

        @Override
        protected int chooseProfession(int villagersSpawnedIn, int currentVillagerProfession) {
            return 2;
        }
    }
}

