/*
 * Decompiled with CFR 0.152.
 */
package net.TelepathicGrunt.UltraAmplified.World.gen.structure;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.TelepathicGrunt.UltraAmplified.World.Biome.BiomeInit;
import net.TelepathicGrunt.UltraAmplified.World.Generation.ChunkGeneratorOverworldUA;
import net.TelepathicGrunt.UltraAmplified.World.gen.structure.WoodlandMansionPiecesUA;
import net.minecraft.init.Blocks;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class WoodlandMansionUA
extends MapGenStructure {
    private final int spacing;
    private int separation = 8;
    public static final List<Biome> acceptedBiomes = Arrays.asList(BiomeInit.BiomePlains, BiomeInit.BiomeBirchForestHillsM, BiomeInit.BiomeBirchForestM, BiomeInit.BiomeRoofedForest, BiomeInit.BiomeRoofedForestM, BiomeInit.BiomeSwampland, BiomeInit.BiomeSwamplandM);
    private final ChunkGeneratorOverworldUA provider;

    public WoodlandMansionUA(ChunkGeneratorOverworldUA provider) {
        this.provider = provider;
        this.spacing = provider.settings.mansionRarity;
    }

    public String func_143025_a() {
        return "Mansion";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        boolean flag;
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX = this.spacing - 1;
        }
        if (chunkZ < 0) {
            chunkZ = this.spacing - 1;
        }
        int k = chunkX / this.spacing;
        int l = chunkZ / this.spacing;
        Random random = this.field_75039_c.func_72843_D(k, l, 10387319);
        k *= this.spacing;
        l *= this.spacing;
        return (k += random.nextInt(this.spacing - 8)) == i && (l += random.nextInt(this.spacing - 8)) == j && (flag = this.field_75039_c.func_72959_q().func_76940_a(chunkX * 16 + 8, chunkZ * 16 + 8, 5, acceptedBiomes));
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        BiomeProvider biomeprovider = worldIn.func_72959_q();
        return biomeprovider.func_190944_c() && acceptedBiomes.contains(biomeprovider.func_190943_d()) ? null : WoodlandMansionUA.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)this.spacing, (int)this.separation, (int)10387319, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.provider, this.field_75038_b, chunkX, chunkZ);
    }

    public static class Start
    extends StructureStart {
        private boolean field_191093_c;

        public Start() {
        }

        public Start(World p_i47235_1_, ChunkGeneratorOverworldUA provider, Random p_i47235_3_, int p_i47235_4_, int p_i47235_5_) {
            super(p_i47235_4_, p_i47235_5_);
            this.create(p_i47235_1_, provider, p_i47235_3_, p_i47235_4_, p_i47235_5_);
        }

        private void create(World p_191092_1_, ChunkGeneratorOverworldUA provider, Random p_191092_3_, int chunkX, int chunkZ) {
            System.out.println("Woodland Mansion | " + chunkX * 16 + " " + chunkZ * 16);
            Rotation rotation = Rotation.values()[p_191092_3_.nextInt(Rotation.values().length)];
            ChunkPrimer chunkprimer = new ChunkPrimer();
            provider.setBlocksInChunk(chunkX, chunkZ, chunkprimer);
            int i = 5;
            int j = 5;
            if (rotation == Rotation.CLOCKWISE_90) {
                i = -5;
            } else if (rotation == Rotation.CLOCKWISE_180) {
                i = -5;
                j = -5;
            } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                j = -5;
            }
            int k = chunkprimer.func_186138_a(7, 7);
            int l = chunkprimer.func_186138_a(7, 7 + j);
            int i1 = chunkprimer.func_186138_a(7 + i, 7);
            int j1 = chunkprimer.func_186138_a(7 + i, 7 + j);
            int k1 = Math.min(Math.min(k, l), Math.min(i1, j1));
            k1 = Math.min(k1, 220);
            if (k1 < 60) {
                this.field_191093_c = false;
            } else {
                BlockPos blockpos = new BlockPos(chunkX * 16 + 8, k1 + 1, chunkZ * 16 + 8);
                LinkedList list = Lists.newLinkedList();
                WoodlandMansionPiecesUA.generateMansion(p_191092_1_.func_72860_G().func_186340_h(), blockpos, rotation, list, p_191092_3_);
                this.field_75075_a.addAll(list);
                this.func_75072_c();
                this.field_191093_c = true;
            }
        }

        public void func_75068_a(World worldIn, Random rand, StructureBoundingBox structurebb) {
            super.func_75068_a(worldIn, rand, structurebb);
            int i = this.field_75074_b.field_78895_b;
            for (int j = structurebb.field_78897_a; j <= structurebb.field_78893_d; ++j) {
                for (int k = structurebb.field_78896_c; k <= structurebb.field_78892_f; ++k) {
                    BlockPos blockpos1;
                    BlockPos blockpos = new BlockPos(j, i, k);
                    if (worldIn.func_175623_d(blockpos) || !this.field_75074_b.func_175898_b((Vec3i)blockpos)) continue;
                    boolean flag = false;
                    for (StructureComponent structurecomponent : this.field_75075_a) {
                        if (!structurecomponent.func_74874_b().func_175898_b((Vec3i)blockpos)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                    for (int l = i - 1; l > 1 && (worldIn.func_175623_d(blockpos1 = new BlockPos(j, l, k)) || worldIn.func_180495_p(blockpos1).func_185904_a().func_76224_d()); --l) {
                        worldIn.func_180501_a(blockpos1, Blocks.field_150347_e.func_176223_P(), 2);
                    }
                }
            }
        }

        public boolean func_75069_d() {
            return this.field_191093_c;
        }
    }
}

