/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.biome;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BlockWithContextConfig;
import net.minecraft.world.gen.feature.BlockWithContextFeature;
import net.minecraft.world.gen.feature.BushConfig;
import net.minecraft.world.gen.feature.BushFeature;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.ConfiguredRandomFeatureList;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.DoublePlantConfig;
import net.minecraft.world.gen.feature.DoublePlantFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.GrassFeature;
import net.minecraft.world.gen.feature.GrassFeatureConfig;
import net.minecraft.world.gen.feature.LakesConfig;
import net.minecraft.world.gen.feature.LakesFeature;
import net.minecraft.world.gen.feature.LiquidsConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.MultipleWithChanceRandomFeature;
import net.minecraft.world.gen.feature.OreFeature;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ScatteredPlantFeature;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.SphereReplaceFeature;
import net.minecraft.world.gen.feature.SpringFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.Structures;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.biome.BiomeInit;
import net.telepathicgrunt.ultraamplified.world.biome.BiomeUA;

@Mod.EventBusSubscriber(modid="ultra_amplified_mod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BiomeAddModdedFeatures {
    private static ForgeRegistry<Feature<?>> FeatureRegistry = (ForgeRegistry)ForgeRegistries.FEATURES;
    private static ForgeRegistry<EntityType<?>> EntityRegistry = (ForgeRegistry)ForgeRegistries.ENTITIES;
    private static ForgeRegistry<Block> BlockRegistry = (ForgeRegistry)ForgeRegistries.BLOCKS;
    private static ArrayList<Structure<?>> listOfVanillaStructures = new ArrayList<Structure<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(Structures.field_215143_a);
            this.add(Structures.field_215144_b);
            this.add(Structures.field_215145_c);
            this.add(Structures.field_215146_d);
            this.add(Structures.field_215147_e);
            this.add(Structures.field_215148_f);
            this.add(Structures.field_215149_g);
            this.add(Structures.field_215150_h);
            this.add(Structures.field_215151_i);
            this.add(Structures.field_215152_j);
            this.add(Structures.field_215153_k);
            this.add(Structures.field_215154_l);
            this.add(Structures.field_215155_m);
            this.add(Structures.field_215156_n);
            this.add(Structures.field_215157_o);
        }
    };
    private static ArrayList<Feature<?>> listOfVanillaStructureFeatures = new ArrayList<Feature<?>>(){
        private static final long serialVersionUID = 11L;
        {
            this.add(Feature.field_202329_g);
            this.add(Feature.field_214536_b);
            this.add(Feature.field_202337_o);
            this.add(Feature.field_202335_m);
            this.add(Feature.field_202331_i);
            this.add(Feature.field_204029_o);
            this.add(Feature.field_202332_j);
            this.add(Feature.field_202333_k);
            this.add(Feature.field_202334_l);
            this.add(Feature.field_202336_n);
            this.add(Feature.field_204292_r);
            this.add(Feature.field_202330_h);
            this.add(Feature.field_214549_o);
            this.add(Feature.field_204751_l);
            this.add(Feature.field_214550_p);
        }
    };
    private static ArrayList<EntityType<?>> listOfVanillaMobs = new ArrayList<EntityType<?>>(){
        private static final long serialVersionUID = 12L;
        {
            this.add(EntityType.field_200791_e);
            this.add(EntityType.field_200792_f);
            this.add(EntityType.field_220360_g);
            this.add(EntityType.field_200795_i);
            this.add(EntityType.field_203780_j);
            this.add(EntityType.field_200796_j);
            this.add(EntityType.field_200797_k);
            this.add(EntityType.field_200798_l);
            this.add(EntityType.field_205137_n);
            this.add(EntityType.field_204724_o);
            this.add(EntityType.field_200803_q);
            this.add(EntityType.field_200804_r);
            this.add(EntityType.field_220356_B);
            this.add(EntityType.field_200811_y);
            this.add(EntityType.field_200762_B);
            this.add(EntityType.field_200763_C);
            this.add(EntityType.field_200769_I);
            this.add(EntityType.field_200771_K);
            this.add(EntityType.field_200779_S);
            this.add(EntityType.field_200780_T);
            this.add(EntityType.field_200781_U);
            this.add(EntityType.field_220353_aa);
            this.add(EntityType.field_200783_W);
            this.add(EntityType.field_200784_X);
            this.add(EntityType.field_203779_Z);
            this.add(EntityType.field_200785_Y);
            this.add(EntityType.field_200786_Z);
            this.add(EntityType.field_200736_ab);
            this.add(EntityType.field_203778_ae);
            this.add(EntityType.field_200737_ac);
            this.add(EntityType.field_200741_ag);
            this.add(EntityType.field_200743_ai);
            this.add(EntityType.field_200748_an);
            this.add(EntityType.field_200749_ao);
            this.add(EntityType.field_200750_ap);
            this.add(EntityType.field_204262_at);
            this.add(EntityType.field_203099_aq);
            this.add(EntityType.field_200759_ay);
            this.add(EntityType.field_200722_aA);
            this.add(EntityType.field_200724_aC);
            this.add(EntityType.field_200725_aD);
            this.add(EntityType.field_200727_aF);
        }
    };
    private static Biome[] vanillaBiomesToCheck = new Biome[]{Biomes.field_76772_c, Biomes.field_76769_d, Biomes.field_76770_e, Biomes.field_76767_f, Biomes.field_76768_g, Biomes.field_76780_h, Biomes.field_76778_j, Biomes.field_76779_k, Biomes.field_76774_n, Biomes.field_76775_o, Biomes.field_76789_p, Biomes.field_76786_s, Biomes.field_76785_t, Biomes.field_76784_u, Biomes.field_222370_aw, Biomes.field_222371_ax, Biomes.field_76782_w, Biomes.field_76792_x, Biomes.field_150574_L, Biomes.field_150576_N, Biomes.field_150577_O, Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_150585_R, Biomes.field_150584_S, Biomes.field_150579_T, Biomes.field_150578_U, Biomes.field_150581_V, Biomes.field_150580_W, Biomes.field_150588_X, Biomes.field_150587_Y, Biomes.field_150589_Z, Biomes.field_150607_aa, Biomes.field_150608_ab, Biomes.field_185441_Q, Biomes.field_185442_R, Biomes.field_185443_S, Biomes.field_185444_T, Biomes.field_150590_f, Biomes.field_150599_m, Biomes.field_185445_W, Biomes.field_185446_X, Biomes.field_185447_Y, Biomes.field_185448_Z, Biomes.field_185429_aa, Biomes.field_185430_ab, Biomes.field_185431_ac, Biomes.field_185432_ad, Biomes.field_185433_ae, Biomes.field_185434_af, Biomes.field_185435_ag, Biomes.field_185436_ah, Biomes.field_185437_ai, Biomes.field_185438_aj, Biomes.field_185439_ak, Biomes.field_76776_l, Biomes.field_203616_V, Biomes.field_76771_b, Biomes.field_203615_U, Biomes.field_203614_T, Biomes.field_203620_Z, Biomes.field_203619_Y, Biomes.field_150575_M, Biomes.field_203618_X, Biomes.field_203617_W};
    private static List<String> blacklistedFeatureMods;
    private static List<String> blacklistedFeatureResourceLocations;

    private static void addModdedFeatureAndSpawns(Biome vanillaBiome, BiomeUA uaBiome) {
        Map.Entry structureEntry;
        block0: for (GenerationStage.Decoration decorationType : GenerationStage.Decoration.values()) {
            for (ConfiguredFeature feature : vanillaBiome.func_203607_a(decorationType)) {
                BushConfig bushConfig;
                if (uaBiome.func_203607_a(decorationType).contains(feature) || !(feature.field_222738_b instanceof DecoratedFeatureConfig)) continue block0;
                DecoratedFeatureConfig insideConfig = (DecoratedFeatureConfig)feature.field_222738_b;
                Feature insideFeature = insideConfig.field_214689_a.field_222737_a;
                ResourceLocation rl = FeatureRegistry.getKey((IForgeRegistryEntry)insideFeature);
                if (rl == null) continue;
                String namespace = rl.func_110624_b();
                if (ConfigUA.importModdedStructure && insideFeature instanceof Structure) {
                    if (blacklistedFeatureMods.contains(namespace) || ConfigUA.blacklistedStructureList.contains(rl.toString()) || listOfVanillaStructureFeatures.contains(insideFeature)) continue;
                    uaBiome.func_203611_a(decorationType, feature);
                    continue;
                }
                if (!ConfigUA.importModdedFeatures) continue;
                if (insideFeature instanceof OreFeature) {
                    OreFeatureConfig oreConfig = (OreFeatureConfig)insideConfig.field_214689_a.field_222738_b;
                    if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(oreConfig.field_202444_d.func_177230_c())) continue;
                    uaBiome.func_203611_a(decorationType, feature);
                    continue;
                }
                if (insideFeature instanceof BushFeature) {
                    bushConfig = (BushConfig)insideConfig.field_214689_a.field_222738_b;
                    if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(bushConfig.field_214686_a.func_177230_c())) continue;
                    uaBiome.func_203611_a(decorationType, feature);
                    continue;
                }
                if (insideFeature instanceof DoublePlantFeature) {
                    DoublePlantConfig doublePlantConfig = (DoublePlantConfig)insideConfig.field_214689_a.field_222738_b;
                    if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(doublePlantConfig.field_202435_a.func_177230_c())) continue;
                    uaBiome.func_203611_a(decorationType, feature);
                    continue;
                }
                if (insideFeature instanceof ScatteredPlantFeature) {
                    if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(((ScatteredPlantFeature)insideFeature).field_214623_a.func_177230_c())) continue;
                    uaBiome.func_203611_a(decorationType, feature);
                    continue;
                }
                if (insideFeature instanceof GrassFeature) {
                    bushConfig = (GrassFeatureConfig)insideConfig.field_214689_a.field_222738_b;
                    if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(bushConfig.field_214708_a.func_177230_c())) continue;
                    uaBiome.func_203611_a(decorationType, feature);
                    continue;
                }
                if (insideFeature instanceof LakesFeature) {
                    LakesConfig lakeConfig = (LakesConfig)insideConfig.field_214689_a.field_222738_b;
                    if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(lakeConfig.field_214713_a.func_177230_c())) continue;
                    uaBiome.func_203611_a(decorationType, feature);
                    continue;
                }
                if (insideFeature instanceof SpringFeature) {
                    LiquidsConfig springConfig = (LiquidsConfig)insideConfig.field_214689_a.field_222738_b;
                    if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(springConfig.field_214678_a.func_206883_i().func_177230_c())) continue;
                    uaBiome.func_203611_a(decorationType, feature);
                    continue;
                }
                if (insideFeature instanceof BlockWithContextFeature) {
                    BlockWithContextConfig sphereReplaceConfig = (BlockWithContextConfig)insideConfig.field_214689_a.field_222738_b;
                    if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(sphereReplaceConfig.field_206924_a.func_177230_c())) continue;
                    uaBiome.func_203611_a(decorationType, feature);
                    continue;
                }
                if (insideFeature instanceof MultipleWithChanceRandomFeature) {
                    MultipleRandomFeatureConfig randConfig = (MultipleRandomFeatureConfig)insideConfig.field_214689_a.field_222738_b;
                    insideFeature = ((ConfiguredRandomFeatureList)randConfig.field_202449_a.get((int)0)).field_214842_a;
                    rl = FeatureRegistry.getKey((IForgeRegistryEntry)insideFeature);
                    if (rl == null || (namespace = rl.func_110624_b()).equals("minecraft")) continue;
                    uaBiome.func_203611_a(decorationType, feature);
                    continue;
                }
                if (namespace.equals("minecraft")) continue;
                uaBiome.func_203611_a(decorationType, feature);
            }
        }
        Iterator iterator = vanillaBiome.field_201874_aj.entrySet().iterator();
        while (iterator.hasNext() && !uaBiome.field_201874_aj.containsKey(structureEntry = (Map.Entry)iterator.next())) {
            ResourceLocation rl = ((Structure)structureEntry.getKey()).getRegistryName();
            String namespace = rl.func_110624_b();
            if (blacklistedFeatureMods.contains(namespace) || ConfigUA.blacklistedStructureList.contains(rl.toString()) || !ConfigUA.importModdedStructure || listOfVanillaStructures.contains(structureEntry.getKey())) continue;
            uaBiome.addStructure(structureEntry);
        }
        block3: for (EntityClassification entityType : EntityClassification.values()) {
            for (Biome.SpawnListEntry spawnEntry : vanillaBiome.func_76747_a(entityType)) {
                if (uaBiome.func_76747_a(entityType).contains(spawnEntry)) continue block3;
                if (!ConfigUA.importModdedMobs || listOfVanillaMobs.contains(spawnEntry.field_200702_b)) continue;
                uaBiome.func_201866_a(entityType, spawnEntry);
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    private static void resetBiomesBackToDefault() {
        for (Biome uaBiome : BiomeInit.getBiomeArray()) {
            String namespace;
            ResourceLocation rl;
            for (GenerationStage.Decoration decorationType : GenerationStage.Decoration.values()) {
                for (int featureIndex = uaBiome.func_203607_a(decorationType).size() - 1; featureIndex >= 0 && ((ConfiguredFeature)uaBiome.func_203607_a((GenerationStage.Decoration)decorationType).get((int)featureIndex)).field_222738_b instanceof DecoratedFeatureConfig; --featureIndex) {
                    SphereReplaceConfig sphereReplaceConfig;
                    DecoratedFeatureConfig insideConfig = (DecoratedFeatureConfig)((ConfiguredFeature)uaBiome.func_203607_a((GenerationStage.Decoration)decorationType).get((int)featureIndex)).field_222738_b;
                    Feature insideFeature = insideConfig.field_214689_a.field_222737_a;
                    rl = FeatureRegistry.getKey((IForgeRegistryEntry)insideFeature);
                    if (rl == null) continue;
                    namespace = rl.func_110624_b();
                    if (insideFeature instanceof Structure) {
                        if (listOfVanillaStructureFeatures.contains(insideFeature) || namespace.equals("ultra_amplified_mod")) continue;
                        uaBiome.func_203607_a(decorationType).remove(featureIndex);
                        continue;
                    }
                    if (insideFeature instanceof OreFeature) {
                        OreFeatureConfig oreConfig = (OreFeatureConfig)insideConfig.field_214689_a.field_222738_b;
                        if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(oreConfig.field_202444_d.func_177230_c())) continue;
                        uaBiome.func_203607_a(decorationType).remove(featureIndex);
                        continue;
                    }
                    if (insideFeature instanceof BushFeature) {
                        BushConfig bushConfig = (BushConfig)insideConfig.field_214689_a.field_222738_b;
                        if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(bushConfig.field_214686_a.func_177230_c())) continue;
                        uaBiome.func_203607_a(decorationType).remove(featureIndex);
                        continue;
                    }
                    if (insideFeature instanceof DoublePlantFeature) {
                        DoublePlantConfig doublePlantConfig = (DoublePlantConfig)insideConfig.field_214689_a.field_222738_b;
                        if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(doublePlantConfig.field_202435_a.func_177230_c())) continue;
                        uaBiome.func_203607_a(decorationType).remove(featureIndex);
                        continue;
                    }
                    if (insideFeature instanceof ScatteredPlantFeature) {
                        if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(((ScatteredPlantFeature)insideFeature).field_214623_a.func_177230_c())) continue;
                        uaBiome.func_203607_a(decorationType).remove(featureIndex);
                        continue;
                    }
                    if (insideFeature instanceof GrassFeature) {
                        GrassFeatureConfig grassConfig = (GrassFeatureConfig)insideConfig.field_214689_a.field_222738_b;
                        if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(grassConfig.field_214708_a.func_177230_c())) continue;
                        uaBiome.func_203607_a(decorationType).remove(featureIndex);
                        continue;
                    }
                    if (insideFeature instanceof SphereReplaceFeature) {
                        sphereReplaceConfig = (SphereReplaceConfig)insideConfig.field_214689_a.field_222738_b;
                        if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(sphereReplaceConfig.field_214693_a.func_177230_c())) continue;
                        uaBiome.func_203607_a(decorationType).remove(featureIndex);
                        continue;
                    }
                    if (insideFeature instanceof BlockWithContextFeature) {
                        sphereReplaceConfig = (BlockWithContextConfig)insideConfig.field_214689_a.field_222738_b;
                        if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(sphereReplaceConfig.field_206924_a.func_177230_c())) continue;
                        uaBiome.func_203607_a(decorationType).remove(featureIndex);
                        continue;
                    }
                    if (insideFeature instanceof LakesFeature) {
                        LakesConfig lakeConfig = (LakesConfig)insideConfig.field_214689_a.field_222738_b;
                        if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(lakeConfig.field_214713_a.func_177230_c())) continue;
                        uaBiome.func_203607_a(decorationType).remove(featureIndex);
                        continue;
                    }
                    if (insideFeature instanceof SpringFeature) {
                        LiquidsConfig springConfig = (LiquidsConfig)insideConfig.field_214689_a.field_222738_b;
                        if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(springConfig.field_214678_a.func_206883_i().func_177230_c())) continue;
                        uaBiome.func_203607_a(decorationType).remove(featureIndex);
                        continue;
                    }
                    if (insideFeature instanceof MultipleWithChanceRandomFeature) {
                        MultipleRandomFeatureConfig randConfig = (MultipleRandomFeatureConfig)insideConfig.field_214689_a.field_222738_b;
                        insideFeature = ((ConfiguredRandomFeatureList)randConfig.field_202449_a.get((int)0)).field_214842_a;
                        rl = FeatureRegistry.getKey((IForgeRegistryEntry)insideFeature);
                        if (rl == null) continue;
                        namespace = rl.func_110624_b();
                        if (!ConfigUA.importModdedFeatures || namespace.equals("minecraft")) continue;
                        uaBiome.func_203607_a(decorationType).remove(featureIndex);
                        continue;
                    }
                    if (namespace.equals("minecraft") || namespace.equals("ultra_amplified_mod")) continue;
                    uaBiome.func_203607_a(decorationType).remove(featureIndex);
                }
            }
            ArrayList listOfStructureToRemove = new ArrayList();
            for (Map.Entry structureEntry : uaBiome.field_201874_aj.entrySet()) {
                String namespace2 = ((Structure)structureEntry.getKey()).getRegistryName().func_110624_b();
                if (listOfVanillaStructures.contains(structureEntry.getKey()) || namespace2.equals("ultra_amplified_mod")) continue;
                listOfStructureToRemove.add(structureEntry.getKey());
            }
            for (Structure structToRemove : listOfStructureToRemove) {
                uaBiome.field_201874_aj.remove(structToRemove);
            }
            for (Iterator entityType : EntityClassification.values()) {
                for (int spawnListIndex = uaBiome.func_76747_a(entityType).size() - 1; spawnListIndex >= 0; --spawnListIndex) {
                    EntityType entity = ((Biome.SpawnListEntry)uaBiome.func_76747_a(entityType).get((int)spawnListIndex)).field_200702_b;
                    rl = EntityRegistry.getKey((IForgeRegistryEntry)entity);
                    if (rl == null) continue;
                    namespace = rl.func_110624_b();
                    if (listOfVanillaMobs.contains(entity) || namespace.equals("ultra_amplified_mod")) continue;
                    uaBiome.func_76747_a(entityType).remove(spawnListIndex);
                }
            }
        }
    }

    private static boolean checkIfBlockIsAllowed(Block blockToCheck) {
        ResourceLocation rl = BlockRegistry.getKey((IForgeRegistryEntry)blockToCheck);
        if (rl == null) {
            return false;
        }
        String namespace = rl.func_110624_b();
        return !namespace.equals("minecraft") && !namespace.equals("ultra_amplified_mod");
    }

    @Mod.EventBusSubscriber(modid="ultra_amplified_mod")
    private static class ForgeEvents {
        private ForgeEvents() {
        }

        @SubscribeEvent
        public static void Load(WorldEvent.Load event) {
            if (FeatureRegistry == null) {
                throw new NullPointerException("Feature Registry not set");
            }
            if (EntityRegistry == null) {
                throw new NullPointerException("Entity Registry not set");
            }
            if (BlockRegistry == null) {
                throw new NullPointerException("Block Registry not set");
            }
            BiomeAddModdedFeatures.resetBiomesBackToDefault();
            blacklistedFeatureMods = new ArrayList();
            blacklistedFeatureResourceLocations = new LinkedList<String>(Arrays.asList(ConfigUA.blacklistedStructureList.split(",")));
            for (int i = 0; i < blacklistedFeatureResourceLocations.size(); ++i) {
                blacklistedFeatureResourceLocations.set(i, ((String)blacklistedFeatureResourceLocations.get(i)).trim());
            }
            for (String entry : blacklistedFeatureResourceLocations) {
                if (!entry.contains(":*")) continue;
                blacklistedFeatureMods.add(entry.split(":")[0]);
            }
            for (int biomeIndex = 0; biomeIndex < vanillaBiomesToCheck.length; ++biomeIndex) {
                BiomeAddModdedFeatures.addModdedFeatureAndSpawns(vanillaBiomesToCheck[biomeIndex], (BiomeUA)BiomeInit.getBiomeArray()[biomeIndex]);
            }
            BiomeAddModdedFeatures.addModdedFeatureAndSpawns(Biomes.field_201936_P, (BiomeUA)BiomeInit.END);
            BiomeAddModdedFeatures.addModdedFeatureAndSpawns(Biomes.field_201937_Q, (BiomeUA)BiomeInit.END);
            BiomeAddModdedFeatures.addModdedFeatureAndSpawns(Biomes.field_201938_R, (BiomeUA)BiomeInit.END);
            BiomeAddModdedFeatures.addModdedFeatureAndSpawns(Biomes.field_201939_S, (BiomeUA)BiomeInit.END);
            BiomeAddModdedFeatures.addModdedFeatureAndSpawns(Biomes.field_201939_S, (BiomeUA)BiomeInit.BARREN_END_FIELD);
        }
    }
}

