/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.biome.surfacebuilder;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;

public class OceanSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    private static final BlockState LAVA = Blocks.field_150353_l.func_176223_P();
    private static final BlockState[] DEAD_CORAL_ARRAY = new BlockState[]{Blocks.field_204408_jI.func_176223_P(), Blocks.field_204405_jF.func_176223_P(), Blocks.field_204406_jG.func_176223_P(), Blocks.field_204407_jH.func_176223_P(), Blocks.field_204404_jE.func_176223_P()};

    public OceanSurfaceBuilder(Function<Dynamic<?>, ? extends SurfaceBuilderConfig> p_i51310_1_) {
        super(p_i51310_1_);
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        this.buildSurface(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, config.func_204108_a(), config.func_204109_b(), config.func_204110_c(), seaLevel);
    }

    protected void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int xStart, int zStart, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, BlockState topBlock, BlockState middleBlock, BlockState bottomBlock, int seaLevel) {
        BlockState currentBlock;
        int y;
        BlockState liquid = ConfigUA.lavaOcean ? LAVA : WATER;
        int x = xStart & 0xF;
        int z = zStart & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        BlockState bottom = topBlock;
        BlockState middle = middleBlock;
        BlockState aboveBlock = middleBlock;
        BlockState above2Block = middleBlock;
        BlockState above3Block = middleBlock;
        BlockState above4Block = middleBlock;
        boolean useCoral = bottomBlock == DEAD_CORAL_ARRAY[0];
        for (y = 255; y >= seaLevel - 10; --y) {
            blockpos$mutableblockpos.func_181079_c(x, y, z);
            currentBlock = chunkIn.func_180495_p((BlockPos)blockpos$mutableblockpos);
            if (currentBlock.func_177230_c() != null) {
                if (currentBlock == defaultBlock) {
                    bottom = liquid;
                    chunkIn.func_177436_a((BlockPos)blockpos$mutableblockpos, bottom, false);
                    currentBlock = bottom;
                } else if (!aboveBlock.func_204520_s().func_206888_e() && currentBlock.func_185904_a() == Material.field_151579_a && y < 256) {
                    if (above2Block.func_185904_a() == Material.field_151579_a) {
                        bottom = topBlock;
                        chunkIn.func_177436_a(blockpos$mutableblockpos.func_177984_a(), bottom, false);
                    } else {
                        if (above3Block.func_185904_a() == Material.field_151579_a) {
                            bottom = AIR;
                            middle = AIR;
                        } else {
                            bottom = useCoral ? DEAD_CORAL_ARRAY[random.nextInt(DEAD_CORAL_ARRAY.length)] : bottomBlock;
                            middle = middleBlock;
                        }
                        chunkIn.func_177436_a(blockpos$mutableblockpos.func_177984_a(), bottom, false);
                        currentBlock = bottom;
                        if (!above2Block.func_204520_s().func_206888_e()) {
                            chunkIn.func_177436_a(blockpos$mutableblockpos.func_177981_b(2), middle, false);
                        }
                        if (!above3Block.func_204520_s().func_206888_e()) {
                            chunkIn.func_177436_a(blockpos$mutableblockpos.func_177981_b(3), middle, false);
                        }
                        if (!above4Block.func_204520_s().func_206888_e()) {
                            chunkIn.func_177436_a(blockpos$mutableblockpos.func_177981_b(4), middle, false);
                        }
                    }
                }
            }
            above4Block = above3Block;
            above3Block = above2Block;
            above2Block = aboveBlock;
            aboveBlock = currentBlock;
        }
        if (middleBlock == Blocks.field_150354_m.func_176223_P() || bottomBlock == Blocks.field_204408_jI.func_176223_P()) {
            blockpos$mutableblockpos.func_181079_c(x, 70, z);
            aboveBlock = chunkIn.func_180495_p((BlockPos)blockpos$mutableblockpos);
            above2Block = chunkIn.func_180495_p(blockpos$mutableblockpos.func_177984_a());
            for (y = 69; y >= 40; --y) {
                blockpos$mutableblockpos.func_181079_c(x, y, z);
                currentBlock = chunkIn.func_180495_p((BlockPos)blockpos$mutableblockpos);
                if (currentBlock.func_177230_c() != null && currentBlock.func_200132_m() && !above2Block.func_204520_s().func_206888_e() && aboveBlock.func_200132_m() && (middleBlock == Blocks.field_150354_m.func_176223_P() || random.nextFloat() < 0.8f)) {
                    chunkIn.func_177436_a(blockpos$mutableblockpos.func_177984_a(), middleBlock, false);
                    aboveBlock = middleBlock;
                }
                above2Block = aboveBlock;
                aboveBlock = currentBlock;
            }
        }
    }
}

