/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.telepathicgrunt.ultraamplified.blocks.BlocksInit;
import net.telepathicgrunt.ultraamplified.blocks.CactusBodyBlockUA;
import net.telepathicgrunt.ultraamplified.blocks.CactusCornerBlockUA;
import net.telepathicgrunt.ultraamplified.blocks.CactusMainBlockUA;

public class BetterCactus
extends Feature<NoFeatureConfig> {
    private final int height = 9;

    public BetterCactus(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> p_212245_2_, Random rand, BlockPos position, NoFeatureConfig p_212245_5_) {
        BlockPos blockpos = position.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
        if (worldIn.func_175623_d(blockpos) && worldIn.func_180495_p(blockpos.func_177977_b()) == Blocks.field_150354_m.func_176223_P()) {
            int maxHeight = 9 + rand.nextInt(2);
            int frontSideHeight = 2 + rand.nextInt(maxHeight - 4);
            int backSideHeight = 2 + rand.nextInt(maxHeight - 4);
            Direction cactusFacing = Direction.func_176731_b((int)rand.nextInt(4));
            for (int currentHeight = 0; currentHeight < maxHeight && worldIn.func_175623_d(blockpos.func_177981_b(currentHeight)); ++currentHeight) {
                if (blockpos.func_177981_b(currentHeight).func_177956_o() <= 254 && (currentHeight == frontSideHeight || currentHeight == backSideHeight)) {
                    if (frontSideHeight == backSideHeight) {
                        worldIn.func_180501_a(blockpos.func_177981_b(currentHeight), (BlockState)BlocksInit.CACTUSBODYBLOCKUA.func_176223_P().func_206870_a((IProperty)CactusBodyBlockUA.FACING, (Comparable)cactusFacing), 18);
                    } else {
                        worldIn.func_180501_a(blockpos.func_177981_b(currentHeight), (BlockState)BlocksInit.CACTUSCORNERBLOCKUA.func_176223_P().func_206870_a((IProperty)CactusCornerBlockUA.FACING, (Comparable)(currentHeight == frontSideHeight ? cactusFacing.func_176734_d() : cactusFacing)), 18);
                    }
                    if (currentHeight == frontSideHeight) {
                        this.createBranch(worldIn, rand, blockpos.func_177981_b(currentHeight), cactusFacing, rand.nextInt(maxHeight - frontSideHeight - 2) + 2);
                    }
                    if (currentHeight != backSideHeight) continue;
                    this.createBranch(worldIn, rand, blockpos.func_177981_b(currentHeight), cactusFacing.func_176734_d(), rand.nextInt(maxHeight - backSideHeight - 2) + 2);
                    continue;
                }
                worldIn.func_180501_a(blockpos.func_177981_b(currentHeight), (BlockState)BlocksInit.CACTUSMAINBLOCKUA.func_176223_P().func_206870_a((IProperty)CactusMainBlockUA.FACING, (Comparable)Direction.UP), 18);
            }
        }
        return true;
    }

    private void createBranch(IWorld worldIn, Random rand, BlockPos position, Direction branchDirection, int maxHeightUp) {
        if (!worldIn.func_175623_d(position = position.func_177972_a(branchDirection))) {
            return;
        }
        worldIn.func_180501_a(position, (BlockState)BlocksInit.CACTUSMAINBLOCKUA.func_176223_P().func_206870_a((IProperty)CactusMainBlockUA.FACING, (Comparable)branchDirection), 18);
        position = position.func_177972_a(branchDirection);
        if (!worldIn.func_175623_d(position)) {
            return;
        }
        worldIn.func_180501_a(position, (BlockState)BlocksInit.CACTUSCORNERBLOCKUA.func_176223_P().func_206870_a((IProperty)CactusCornerBlockUA.FACING, (Comparable)branchDirection), 18);
        for (int currentHeight = 1; currentHeight < maxHeightUp && position.func_177981_b(currentHeight).func_177956_o() <= 255; ++currentHeight) {
            if (!worldIn.func_175623_d(position.func_177981_b(currentHeight))) {
                return;
            }
            worldIn.func_180501_a(position.func_177981_b(currentHeight), (BlockState)BlocksInit.CACTUSMAINBLOCKUA.func_176223_P().func_206870_a((IProperty)CactusMainBlockUA.FACING, (Comparable)Direction.UP), 18);
        }
    }
}

