/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class BlueIceWaterfall
extends Feature<NoFeatureConfig> {
    private static final BlockState BLUE_ICE = Blocks.field_205164_gk.func_176223_P();
    private static final BlockState SNOW_BLOCK = Blocks.field_196604_cC.func_176223_P();
    private static final BlockState SNOW = Blocks.field_150433_aE.func_176223_P();
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final Set<Block> acceptableBlocks = Stream.of(Blocks.field_150432_aD, Blocks.field_196604_cC, Blocks.field_150403_cj).collect(Collectors.toCollection(HashSet::new));

    public BlueIceWaterfall(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, NoFeatureConfig fluidConfig) {
        if (!acceptableBlocks.contains(worldIn.func_180495_p(position.func_177984_a()).func_177230_c())) {
            return false;
        }
        if (!acceptableBlocks.contains(worldIn.func_180495_p(position.func_177977_b()).func_177230_c())) {
            return false;
        }
        int numberOfSolidSides = 0;
        Direction emptySpot = Direction.NORTH;
        for (Direction face : Direction.Plane.HORIZONTAL) {
            if (acceptableBlocks.contains(worldIn.func_180495_p(position.func_177972_a(face)).func_177230_c())) {
                ++numberOfSolidSides;
                continue;
            }
            emptySpot = face;
        }
        if (numberOfSolidSides == 3) {
            worldIn.func_180501_a(position, BLUE_ICE, 2);
            BlockPos curPos = position.func_177972_a(emptySpot);
            worldIn.func_180501_a(curPos, BLUE_ICE, 2);
            int ledges = 0;
            while (true) {
                if (curPos.func_177956_o() <= 1) {
                    return false;
                }
                if (worldIn.func_180495_p(curPos.func_177977_b()).func_185904_a() == Material.field_151579_a || worldIn.func_180495_p(curPos.func_177977_b()) == BLUE_ICE || worldIn.func_180495_p(curPos.func_177977_b()) == SNOW_BLOCK) {
                    curPos = curPos.func_177977_b();
                    worldIn.func_180501_a(curPos, BLUE_ICE, 2);
                    continue;
                }
                if (ledges >= 2) break;
                boolean spotFound = false;
                for (Direction face : Direction.Plane.HORIZONTAL) {
                    if (worldIn.func_180495_p(curPos.func_177972_a(face)).func_185904_a() != Material.field_151579_a && worldIn.func_180495_p(curPos.func_177972_a(face)) != BLUE_ICE || worldIn.func_180495_p(curPos.func_177977_b().func_177972_a(face)).func_185904_a() != Material.field_151579_a && worldIn.func_180495_p(curPos.func_177977_b().func_177972_a(face)) != BLUE_ICE) continue;
                    curPos = curPos.func_177972_a(emptySpot);
                    worldIn.func_180501_a(curPos, BLUE_ICE, 2);
                    curPos = curPos.func_177977_b();
                    worldIn.func_180501_a(curPos, BLUE_ICE, 2);
                    ++ledges;
                    spotFound = true;
                    if (curPos.func_177956_o() > 1) break;
                    return false;
                }
                if (!spotFound) break;
            }
            int width = rand.nextInt(2) + 2;
            for (int y = curPos.func_177956_o() - 1; y < curPos.func_177956_o() + 1; ++y) {
                block4: for (int x = -width; x <= width; ++x) {
                    for (int z = -width; z <= width; ++z) {
                        if (x * x + z * z > width * width) continue;
                        if (y <= 1 || y >= 255) continue block4;
                        BlockPos blockpos = new BlockPos(x + curPos.func_177958_n(), y, z + curPos.func_177952_p());
                        BlockState block = worldIn.func_180495_p(blockpos);
                        if (block != Blocks.field_150432_aD.func_176223_P() && block != SNOW_BLOCK) continue;
                        worldIn.func_180501_a(blockpos, BLUE_ICE, 2);
                    }
                }
                ++width;
            }
            for (int x = -width; x <= width; ++x) {
                for (int z = -width; z <= width; ++z) {
                    BlockPos blockpos;
                    BlockState block;
                    if (x * x + z * z > width * width || (block = worldIn.func_180495_p(blockpos = new BlockPos(x + curPos.func_177958_n(), curPos.func_177956_o() + 1, z + curPos.func_177952_p()))) != SNOW) continue;
                    worldIn.func_180501_a(blockpos, AIR, 2);
                }
            }
        }
        return true;
    }
}

