/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.generation.BiomeGenHelper;

public class ContainLiquidForOceans
extends Feature<NoFeatureConfig> {
    private static final BlockState ICE = Blocks.field_150432_aD.func_176223_P();
    private static final BlockState[] DEAD_CORAL_ARRAY = new BlockState[]{Blocks.field_204408_jI.func_176223_P(), Blocks.field_204405_jF.func_176223_P(), Blocks.field_204406_jG.func_176223_P(), Blocks.field_204407_jH.func_176223_P(), Blocks.field_204404_jE.func_176223_P()};

    public ContainLiquidForOceans(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> chunkSettings, Random random, BlockPos pos, NoFeatureConfig configBlock) {
        int z;
        int x;
        pos.func_177979_c(pos.func_177956_o());
        Biome oceanBiome = null;
        boolean bordersOcean = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(pos);
        block0: for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                oceanBiome = worldIn.func_180494_b(blockpos$mutableblockpos.func_177982_a(x, 0, z));
                if (!BiomeGenHelper.isOcean(oceanBiome)) continue;
                bordersOcean = true;
                x = 16;
                continue block0;
            }
        }
        if (!bordersOcean) {
            return false;
        }
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                boolean useCoralTop = oceanBiome.func_203944_q().func_204108_a() == DEAD_CORAL_ARRAY[0];
                boolean useCoralBottom = oceanBiome.func_203944_q().func_204108_a() == DEAD_CORAL_ARRAY[0];
                for (int y = 256; y > ConfigUA.seaLevel - 10; --y) {
                    BlockState blockAbove;
                    blockpos$mutableblockpos.func_181079_c(pos.func_177958_n() + x, 0, pos.func_177952_p() + z);
                    BlockState currentblock = worldIn.func_180495_p(blockpos$mutableblockpos.func_177981_b(y));
                    while (currentblock.func_204520_s().func_206888_e() && y > 10) {
                        currentblock = worldIn.func_180495_p(blockpos$mutableblockpos.func_177981_b(--y));
                    }
                    if (y == 10) continue;
                    blockpos$mutableblockpos.func_181079_c(pos.func_177958_n() + x, y, pos.func_177952_p() + z);
                    boolean notContainedFlag = false;
                    for (Direction face : Direction.Plane.HORIZONTAL) {
                        currentblock = worldIn.func_180495_p(blockpos$mutableblockpos.func_177972_a(face));
                        if (currentblock == ICE || currentblock.func_200132_m() || !currentblock.func_204520_s().func_206888_e()) continue;
                        notContainedFlag = true;
                    }
                    if (notContainedFlag) {
                        if (y < 256) {
                            blockAbove = worldIn.func_180495_p(blockpos$mutableblockpos.func_177984_a());
                            if (blockAbove.func_200132_m() || !blockAbove.func_204520_s().func_206888_e()) {
                                worldIn.func_180501_a((BlockPos)blockpos$mutableblockpos, oceanBiome.func_203944_q().func_204109_b(), 2);
                                continue;
                            }
                            if (useCoralTop) {
                                worldIn.func_180501_a((BlockPos)blockpos$mutableblockpos, DEAD_CORAL_ARRAY[random.nextInt(DEAD_CORAL_ARRAY.length)], 2);
                                continue;
                            }
                            worldIn.func_180501_a((BlockPos)blockpos$mutableblockpos, oceanBiome.func_203944_q().func_204108_a(), 2);
                            continue;
                        }
                        if (useCoralTop) {
                            worldIn.func_180501_a((BlockPos)blockpos$mutableblockpos, DEAD_CORAL_ARRAY[random.nextInt(DEAD_CORAL_ARRAY.length)], 2);
                            continue;
                        }
                        worldIn.func_180501_a((BlockPos)blockpos$mutableblockpos, oceanBiome.func_203944_q().func_204108_a(), 2);
                        continue;
                    }
                    blockAbove = worldIn.func_180495_p(blockpos$mutableblockpos.func_177984_a());
                    if (blockAbove != oceanBiome.func_203944_q().func_204109_b()) continue;
                    if (useCoralBottom) {
                        worldIn.func_180501_a(blockpos$mutableblockpos.func_177984_a(), DEAD_CORAL_ARRAY[random.nextInt(DEAD_CORAL_ARRAY.length)], 2);
                        continue;
                    }
                    worldIn.func_180501_a(blockpos$mutableblockpos.func_177984_a(), ((SurfaceBuilderConfig)oceanBiome.func_203944_q()).func_204110_c(), 2);
                }
            }
        }
        return true;
    }
}

