/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.common.DungeonHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DungeonsBadlands
extends Feature<NoFeatureConfig> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();
    private static final BlockState RED_TERRACOTTA = Blocks.field_196721_fC.func_176223_P();
    private static final BlockState ORANGE_TERRACOTTA = Blocks.field_196778_fp.func_176223_P();
    private static final BlockState CUT_RED_SANDSTONE = Blocks.field_196799_hB.func_176223_P();

    public DungeonsBadlands(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, NoFeatureConfig p_212245_5_) {
        int j = rand.nextInt(2) + 2;
        int xMin = -j - 1;
        int xMax = j + 1;
        int k1 = rand.nextInt(2) + 2;
        int zMin = -k1 - 1;
        int zMax = k1 + 1;
        int j2 = 0;
        int ceilingOpenings = 0;
        for (int k2 = xMin; k2 <= xMax; ++k2) {
            for (int l2 = -1; l2 <= 4; ++l2) {
                for (int i3 = zMin; i3 <= zMax; ++i3) {
                    BlockPos blockpos = position.func_177982_a(k2, l2, i3);
                    Material material = worldIn.func_180495_p(blockpos).func_185904_a();
                    boolean flag = material.func_76220_a();
                    if (l2 == -1 && !flag) {
                        return false;
                    }
                    if (l2 == 4 && !flag) {
                        ++ceilingOpenings;
                    }
                    if (k2 != xMin && k2 != xMax && i3 != zMin && i3 != zMax || l2 != 0 || !worldIn.func_175623_d(blockpos) || !worldIn.func_175623_d(blockpos.func_177984_a())) continue;
                    ++j2;
                }
            }
        }
        if (j2 >= 1 && j2 <= 14 && ceilingOpenings < 14) {
            for (int xOffset = xMin; xOffset <= xMax; ++xOffset) {
                for (int y = 4; y >= -1; --y) {
                    for (int zOffset = zMin; zOffset <= zMax; ++zOffset) {
                        BlockPos blockpos1 = position.func_177982_a(xOffset, y, zOffset);
                        if (xOffset != xMin && zOffset != zMin && xOffset != xMax && zOffset != zMax && y != -1 && y != 5) {
                            if (y == 4) {
                                if (rand.nextInt(4) == 0) {
                                    worldIn.func_180501_a(blockpos1, CUT_RED_SANDSTONE, 2);
                                    continue;
                                }
                                worldIn.func_180501_a(blockpos1, ORANGE_TERRACOTTA, 2);
                                continue;
                            }
                            if (worldIn.func_180495_p(blockpos1).func_177230_c() == Blocks.field_150486_ae || worldIn.func_180495_p(blockpos1).func_177230_c() == Blocks.field_150474_ac) continue;
                            worldIn.func_180501_a(blockpos1, CAVE_AIR, 2);
                            continue;
                        }
                        if (blockpos1.func_177956_o() >= 0 && !worldIn.func_180495_p(blockpos1.func_177977_b()).func_185904_a().func_76220_a()) {
                            worldIn.func_180501_a(blockpos1, CAVE_AIR, 2);
                            continue;
                        }
                        if (!worldIn.func_180495_p(blockpos1).func_185904_a().func_76220_a() || worldIn.func_180495_p(blockpos1).func_177230_c() == Blocks.field_150486_ae || worldIn.func_180495_p(blockpos1).func_177230_c() == Blocks.field_150474_ac) continue;
                        if (y == -1 && rand.nextInt(4) != 0) {
                            worldIn.func_180501_a(blockpos1, RED_TERRACOTTA, 2);
                            continue;
                        }
                        if (rand.nextInt(2) == 0) {
                            worldIn.func_180501_a(blockpos1, ORANGE_TERRACOTTA, 2);
                            continue;
                        }
                        worldIn.func_180501_a(blockpos1, CUT_RED_SANDSTONE, 2);
                    }
                }
            }
            block6: for (int l3 = 0; l3 < 2; ++l3) {
                for (int j4 = 0; j4 < 3; ++j4) {
                    int j5;
                    int i5;
                    int l4 = position.func_177958_n() + rand.nextInt(j * 2 + 1) - j;
                    BlockPos blockpos2 = new BlockPos(l4, i5 = position.func_177956_o(), j5 = position.func_177952_p() + rand.nextInt(k1 * 2 + 1) - k1);
                    if (!worldIn.func_175623_d(blockpos2)) continue;
                    int j3 = 0;
                    for (Direction Direction2 : Direction.Plane.HORIZONTAL) {
                        if (!worldIn.func_180495_p(blockpos2.func_177972_a(Direction2)).func_185904_a().func_76220_a()) continue;
                        ++j3;
                    }
                    if (j3 != true) continue;
                    worldIn.func_180501_a(blockpos2, StructurePiece.func_197528_a((IBlockReader)worldIn, (BlockPos)blockpos2, (BlockState)Blocks.field_150486_ae.func_176223_P()), 2);
                    LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)blockpos2, (ResourceLocation)LootTables.field_186422_d);
                    continue block6;
                }
            }
            worldIn.func_180501_a(position, Blocks.field_150474_ac.func_176223_P(), 2);
            TileEntity tileentity = worldIn.func_175625_s(position);
            if (tileentity instanceof MobSpawnerTileEntity) {
                ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(this.pickMobSpawner(worldIn, rand, position));
            } else {
                LOGGER.error("Failed to fetch mob spawner entity at ({}, {}, {})", new Object[]{position.func_177958_n(), position.func_177956_o(), position.func_177952_p()});
            }
            return true;
        }
        return false;
    }

    private EntityType<?> pickMobSpawner(IWorld worldIn, Random rand, BlockPos position) {
        int roll = rand.nextInt(100);
        if (roll < 48) {
            return EntityType.field_200763_C;
        }
        if (roll < 73) {
            return this.pickRandomDungeonMob(rand);
        }
        if (roll < 98) {
            return this.pickRandomDungeonMob(rand);
        }
        if (roll == 98) {
            return EntityType.field_200797_k;
        }
        return EntityType.field_200764_D;
    }

    private EntityType<?> pickRandomDungeonMob(Random p_201043_1_) {
        return DungeonHooks.getRandomDungeonMob((Random)p_201043_1_);
    }
}

