/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.storage.loot.LootTables;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;

public class MarkedTreasureChest
extends Feature<NoFeatureConfig> {
    private static final BlockState RED_SAND = Blocks.field_196611_F.func_176223_P();

    public MarkedTreasureChest(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> chunkSettings, Random random, BlockPos blockpos, NoFeatureConfig config) {
        if (!ConfigUA.chestGeneration) {
            return false;
        }
        if (!worldIn.func_180495_p(blockpos).func_200132_m() || worldIn.func_180495_p(blockpos.func_177984_a()).func_204520_s().func_206888_e()) {
            return false;
        }
        for (Direction face : Direction.values()) {
            if (face == Direction.UP || worldIn.func_180495_p(blockpos.func_177977_b().func_177972_a(face)).func_200132_m()) continue;
            return false;
        }
        int size = 5;
        for (int x = -size; x <= size; ++x) {
            for (int z = -size; z <= size; ++z) {
                int absx = Math.abs(x);
                int absz = Math.abs(z);
                if (absx == size && absz == size || !((double)random.nextFloat() < 0.85) || Math.abs(absx - absz) >= 2) continue;
                worldIn.func_180501_a(blockpos.func_177982_a(x, 0, z), RED_SAND, 2);
            }
        }
        worldIn.func_180501_a(blockpos.func_177977_b(), StructurePiece.func_197528_a((IBlockReader)worldIn, (BlockPos)blockpos.func_177977_b(), (BlockState)Blocks.field_150486_ae.func_176223_P()), 2);
        if (random.nextFloat() < 0.5f) {
            LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)random, (BlockPos)blockpos.func_177977_b(), (ResourceLocation)LootTables.field_204312_r);
        } else {
            LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)random, (BlockPos)blockpos.func_177977_b(), (ResourceLocation)LootTables.field_186421_c);
        }
        return true;
    }
}

