/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;

public class SunShrine
extends Feature<NoFeatureConfig> {
    protected static final Set<BlockState> acceptableBlocks = Stream.of(Blocks.field_150346_d.func_176223_P(), Blocks.field_196658_i.func_176223_P(), Blocks.field_196661_l.func_176223_P(), Blocks.field_196660_k.func_176223_P(), Blocks.field_150354_m.func_176223_P(), Blocks.field_150322_A.func_176223_P(), Blocks.field_185774_da.func_176223_P()).collect(Collectors.toCollection(HashSet::new));

    public SunShrine(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, NoFeatureConfig p_212245_5_) {
        if (!ConfigUA.miniStructureGeneration || position.func_177956_o() > 248) {
            return false;
        }
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                if (Math.abs(x * z) <= 2 || Math.abs(x * z) >= 8 || acceptableBlocks.contains(worldIn.func_180495_p(position.func_177979_c(1).func_177985_f(x).func_177964_d(z)))) continue;
                return false;
            }
        }
        TemplateManager templatemanager = ((ServerWorld)worldIn.func_201672_e()).func_217485_w().func_186340_h();
        Template template = templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_mod:sunshrine"));
        if (template == null) {
            UltraAmplified.LOGGER.warn("sunshrine NTB does not exist!");
            return false;
        }
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a((ChunkPos)null);
        template.func_186253_b(worldIn, position.func_177977_b().func_177964_d(3).func_177985_f(3), placementsettings);
        return true;
    }
}

