/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.placement;

import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.placement.Placement;
import net.telepathicgrunt.ultraamplified.world.feature.config.PercentageAndFrequencyConfig;

public class ChanceOnAllSurfaces
extends Placement<PercentageAndFrequencyConfig> {
    private final BlockState SAND = Blocks.field_150354_m.func_176223_P();
    private final BlockState SOULSAND = Blocks.field_150425_aM.func_176223_P();

    public ChanceOnAllSurfaces(Function<Dynamic<?>, ? extends PercentageAndFrequencyConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public Stream<BlockPos> getPositions(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, PercentageAndFrequencyConfig pfConfig, BlockPos pos) {
        int lowestHeight = 40;
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        block0: for (int i = 0; i < pfConfig.frequency; ++i) {
            int height = 255;
            while (height > lowestHeight) {
                int x = random.nextInt(16);
                int z = random.nextInt(16);
                while (height > lowestHeight && !worldIn.func_175623_d(pos.func_177982_a(x, height, z))) {
                    --height;
                }
                while (height > lowestHeight) {
                    BlockState currentBlock = worldIn.func_180495_p(pos.func_177982_a(x, height, z));
                    if (worldIn.func_180494_b(pos.func_177982_a(x, height, z)).func_203944_q().func_204108_a() == currentBlock || currentBlock == this.SAND || currentBlock == this.SOULSAND) break;
                    --height;
                }
                if (height <= lowestHeight) continue block0;
                if (!(random.nextFloat() < pfConfig.percentage)) continue;
                blockPosList.add(pos.func_177982_a(x, height, z));
            }
        }
        return IntStream.range(0, blockPosList.size()).mapToObj(p_215051_3_ -> (BlockPos)blockPosList.remove(0)).filter(Objects::nonNull);
    }
}

