/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.entity.EntityType;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.PillagerOutpostPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.feature.FeatureUA;

public class PillagerOutpostUA
extends Structure<NoFeatureConfig> {
    private static final List<Biome.SpawnListEntry> field_214558_a = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry(EntityType.field_220350_aJ, 1, 1, 1)});

    public PillagerOutpostUA(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i51470_1_) {
        super(p_i51470_1_);
    }

    public String func_143025_a() {
        return "ultra_amplified_mod:pillager_outpost";
    }

    public int func_202367_b() {
        return 3;
    }

    public List<Biome.SpawnListEntry> func_202279_e() {
        return field_214558_a;
    }

    public boolean func_202372_a(ChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ) {
        ((SharedSeedRandom)rand).func_202425_c(chunkGen.func_202089_c(), chunkPosX, chunkPosZ);
        Biome biome = chunkGen.func_202090_b().func_222364_a(new BlockPos((chunkPosX << 4) + 9, 0, (chunkPosZ << 4) + 9));
        if (ConfigUA.pillageOutpostRarity != 101 && chunkGen.func_202094_a(biome, FeatureUA.PILLAGER_OUTPOST_UA) && (double)rand.nextFloat() < 1.0 / ((double)(ConfigUA.pillageOutpostRarity - 1) * 4.5 + 1.0)) {
            for (int k = chunkPosX - 3; k <= chunkPosX + 3; ++k) {
                for (int l = chunkPosZ - 3; l <= chunkPosZ + 3; ++l) {
                    if (!FeatureUA.VILLAGE_UA.func_202372_a(chunkGen, rand, k, l)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    protected int getSeedModifier() {
        return 165745296;
    }

    public static class Start
    extends MarginedStructureStart {
        public Start(Structure<?> p_i50497_1_, int p_i50497_2_, int p_i50497_3_, Biome p_i50497_4_, MutableBoundingBox p_i50497_5_, int p_i50497_6_, long p_i50497_7_) {
            super(p_i50497_1_, p_i50497_2_, p_i50497_3_, p_i50497_4_, p_i50497_5_, p_i50497_6_, p_i50497_7_);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            int offsetX = 7;
            int offsetZ = 7;
            int x = (chunkX << 4) + offsetX;
            int z = (chunkZ << 4) + offsetZ;
            int i1 = generator.func_222531_c(x, z, Heightmap.Type.WORLD_SURFACE_WG);
            int j1 = generator.func_222531_c(x, z + 1, Heightmap.Type.WORLD_SURFACE_WG);
            int k1 = generator.func_222531_c(x + 1, z, Heightmap.Type.WORLD_SURFACE_WG);
            int l1 = generator.func_222531_c(x + 1, z + 1, Heightmap.Type.WORLD_SURFACE_WG);
            int y = Math.max(Math.max(i1, j1), Math.max(k1, l1));
            if (y >= 70 && y <= 200) {
                BlockPos blockpos = new BlockPos(chunkX * 16, y, chunkZ * 16);
                PillagerOutpostPieces.func_215139_a(generator, (TemplateManager)templateManagerIn, (BlockPos)blockpos, (List)this.field_75075_a, (SharedSeedRandom)this.field_214631_d);
                this.func_202500_a();
            }
        }
    }
}

