/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Blocks;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.WoodlandMansionPieces;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.feature.FeatureUA;

public class WoodlandMansionUA
extends Structure<NoFeatureConfig> {
    public WoodlandMansionUA(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i51427_1_) {
        super(p_i51427_1_);
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int maxSpacing = ConfigUA.mansionSpawnrate;
        int minSpacing = (int)((double)maxSpacing * 0.75);
        if (maxSpacing < 10) {
            minSpacing = maxSpacing - 1;
        }
        int k = x + maxSpacing * spacingOffsetsX;
        int l = z + maxSpacing * spacingOffsetsZ;
        int i1 = k < 0 ? k - maxSpacing + 1 : k;
        int j1 = l < 0 ? l - maxSpacing + 1 : l;
        int k1 = i1 / maxSpacing;
        int l1 = j1 / maxSpacing;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), k1, l1, 10387319);
        k1 *= maxSpacing;
        l1 *= maxSpacing;
        return new ChunkPos(k1 += (random.nextInt(maxSpacing - minSpacing) + random.nextInt(maxSpacing - minSpacing)) / 2, l1 += (random.nextInt(maxSpacing - minSpacing) + random.nextInt(maxSpacing - minSpacing)) / 2);
    }

    public boolean func_202372_a(ChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ) {
        ChunkPos chunkpos = this.func_211744_a(chunkGen, rand, chunkPosX, chunkPosZ, 0, 0);
        if (ConfigUA.mansionSpawnrate != 101 && chunkPosX == chunkpos.field_77276_a && chunkPosZ == chunkpos.field_77275_b) {
            for (Biome biome : chunkGen.func_202090_b().func_201538_a(chunkPosX * 16 + 9, chunkPosZ * 16 + 9, 32)) {
                if (chunkGen.func_202094_a(biome, FeatureUA.WOODLAND_MANSION_UA)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean isEnabledIn(IWorld worldIn) {
        return worldIn.func_72912_H().func_76089_r();
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return "ultra_amplified_mod:woodland_mansion";
    }

    public int func_202367_b() {
        return 8;
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> p_i50437_1_, int p_i50437_2_, int p_i50437_3_, Biome p_i50437_4_, MutableBoundingBox p_i50437_5_, int p_i50437_6_, long p_i50437_7_) {
            super(p_i50437_1_, p_i50437_2_, p_i50437_3_, p_i50437_4_, p_i50437_5_, p_i50437_6_, p_i50437_7_);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            int i = 5;
            int j = 5;
            if (rotation == Rotation.CLOCKWISE_90) {
                i = -5;
            } else if (rotation == Rotation.CLOCKWISE_180) {
                i = -5;
                j = -5;
            } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                j = -5;
            }
            int k = (chunkX << 4) + 7;
            int l = (chunkZ << 4) + 7;
            int i1 = generator.func_222531_c(k, l, Heightmap.Type.WORLD_SURFACE_WG);
            int j1 = generator.func_222531_c(k, l + j, Heightmap.Type.WORLD_SURFACE_WG);
            int k1 = generator.func_222531_c(k + i, l, Heightmap.Type.WORLD_SURFACE_WG);
            int l1 = generator.func_222531_c(k + i, l + j, Heightmap.Type.WORLD_SURFACE_WG);
            int y = Math.min(Math.min(i1, j1), Math.min(k1, l1));
            y = Math.min(y, 220);
            if (y >= 70) {
                BlockPos blockpos = new BlockPos(chunkX * 16 + 8, y + 1, chunkZ * 16 + 8);
                LinkedList list = Lists.newLinkedList();
                WoodlandMansionPieces.func_191152_a((TemplateManager)templateManagerIn, (BlockPos)blockpos, (Rotation)rotation, (List)list, (Random)this.field_214631_d);
                this.field_75075_a.addAll(list);
                this.func_202500_a();
            }
        }

        public void func_75068_a(IWorld worldIn, Random rand, MutableBoundingBox structurebb, ChunkPos p_75068_4_) {
            super.func_75068_a(worldIn, rand, structurebb, p_75068_4_);
            int i = this.field_75074_b.field_78895_b;
            for (int j = structurebb.field_78897_a; j <= structurebb.field_78893_d; ++j) {
                for (int k = structurebb.field_78896_c; k <= structurebb.field_78892_f; ++k) {
                    BlockPos blockpos1;
                    BlockPos blockpos = new BlockPos(j, i, k);
                    if (worldIn.func_175623_d(blockpos) || !this.field_75074_b.func_175898_b((Vec3i)blockpos)) continue;
                    boolean flag = false;
                    for (StructurePiece structurepiece : this.field_75075_a) {
                        if (!structurepiece.func_74874_b().func_175898_b((Vec3i)blockpos)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                    for (int l = i - 1; l > 1 && (worldIn.func_175623_d(blockpos1 = new BlockPos(j, l, k)) || worldIn.func_180495_p(blockpos1).func_185904_a().func_76224_d()); --l) {
                        worldIn.func_180501_a(blockpos1, Blocks.field_150347_e.func_176223_P(), 2);
                    }
                }
            }
        }
    }
}

