/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.generation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.telepathicgrunt.ultraamplified.world.biome.BiomeInit;

public enum BiomeGenHelper {
    instance;

    public static ForgeRegistry<Biome> BiomeRegistry;
    public static final int PLAINS;
    public static final int SWAMP;
    public static final int FOREST;
    public static final int DESERT;
    public static final int WOODED_MOUNTAINS;
    public static final int WOODED_HILLS;
    public static final int SNOWY_TUNDRA;
    public static final int ICE_MOUNTAINS;
    public static final int BAMBOO_JUNGLE;
    public static final int JUNGLE;
    public static final int JUNGLE_EDGE;
    public static final int BADLANDS;
    public static final int WOODED_BADLANDS_PLATEAU;
    public static final int BADLANDS_PLATEAU;
    public static final int MUSHROOM_FIELDS;
    public static final int GIANT_TREE_TAIGA;
    public static final int DARK_FOREST;
    public static final int SAVANNA;
    public static final int TAIGA;
    public static final int SNOWY_TAIGA;
    public static final int WARM_OCEAN;
    public static final int LUKEWARM_OCEAN;
    public static final int OCEAN;
    public static final int COLD_OCEAN;
    public static final int FROZEN_OCEAN;
    public static final int DEEP_WARM_OCEAN;
    public static final int DEEP_LUKEWARM_OCEAN;
    public static final int DEEP_OCEAN;
    public static final int DEEP_COLD_OCEAN;
    public static final int DEEP_FROZEN_OCEAN;
    public static final int SUNFLOWER_PLAINS;
    public static final int NETHER;
    public static final int END;
    public static final int BARREN_END_FIELD;
    public static final int SNOWY_BEACH;
    public static final int STONE_BEACH;
    public static final int VANILLA_OCEAN;
    public static final int VANILLA_DEEP_OCEAN;
    private static final Biome[] OCEAN_VALUES;
    private static final Set<Biome> OCEAN_LIST;

    public static boolean isOcean(Biome biomeIn) {
        return OCEAN_LIST.contains(biomeIn);
    }

    public static boolean isOcean(int biomeIn) {
        return biomeIn == VANILLA_OCEAN || biomeIn == VANILLA_DEEP_OCEAN || biomeIn == WARM_OCEAN || biomeIn == LUKEWARM_OCEAN || biomeIn == OCEAN || biomeIn == COLD_OCEAN || biomeIn == FROZEN_OCEAN || biomeIn == DEEP_WARM_OCEAN || biomeIn == DEEP_LUKEWARM_OCEAN || biomeIn == DEEP_OCEAN || biomeIn == DEEP_COLD_OCEAN || biomeIn == DEEP_FROZEN_OCEAN;
    }

    public static boolean isShallowOcean(int biomeIn) {
        return biomeIn == VANILLA_OCEAN || biomeIn == WARM_OCEAN || biomeIn == LUKEWARM_OCEAN || biomeIn == OCEAN || biomeIn == COLD_OCEAN || biomeIn == FROZEN_OCEAN;
    }

    public static boolean areUABiomesSimilar(int biome1ID, int biome2ID) {
        if (biome1ID == biome2ID) {
            return true;
        }
        Biome biome1 = (Biome)BiomeRegistry.getValue(biome1ID);
        Biome biome2 = (Biome)BiomeRegistry.getValue(biome2ID);
        if (biome1 != null && biome2 != null) {
            if (biome1 != BiomeInit.WOODED_BADLANDS_PLATEAU && biome1 != BiomeInit.BADLANDS_PLATEAU) {
                if (biome1.func_201856_r() != Biome.Category.NONE && biome2.func_201856_r() != Biome.Category.NONE && biome1.func_201856_r() == biome2.func_201856_r()) {
                    return true;
                }
                return biome1 == biome2;
            }
            return biome2 == BiomeInit.WOODED_BADLANDS_PLATEAU || biome2 == BiomeInit.BADLANDS_PLATEAU;
        }
        return false;
    }

    static {
        BiomeRegistry = (ForgeRegistry)ForgeRegistries.BIOMES;
        PLAINS = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.PLAINS);
        SWAMP = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.SWAMP);
        FOREST = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.FOREST);
        DESERT = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.DESERT);
        WOODED_MOUNTAINS = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.WOODED_MOUNTAINS);
        WOODED_HILLS = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.WOODED_HILLS);
        SNOWY_TUNDRA = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.SNOWY_TUNDRA);
        ICE_MOUNTAINS = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.ICE_MOUNTAIN);
        BAMBOO_JUNGLE = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.BAMBOO_JUNGLE);
        JUNGLE = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.JUNGLE);
        JUNGLE_EDGE = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.JUNGLE_EDGE);
        BADLANDS = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.BADLANDS);
        WOODED_BADLANDS_PLATEAU = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.WOODED_BADLANDS_PLATEAU);
        BADLANDS_PLATEAU = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.BADLANDS_PLATEAU);
        MUSHROOM_FIELDS = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.MUSHROOM_FIELDS);
        GIANT_TREE_TAIGA = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.GIANT_TREE_TAIGA);
        DARK_FOREST = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.DARK_FOREST);
        SAVANNA = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.SAVANNA);
        TAIGA = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.TAIGA);
        SNOWY_TAIGA = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.SNOWY_TAIGA);
        WARM_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.WARM_OCEAN);
        LUKEWARM_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.LUKEWARM_OCEAN);
        OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.OCEAN);
        COLD_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.COLD_OCEAN);
        FROZEN_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.FROZEN_OCEAN);
        DEEP_WARM_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.DEEP_WARM_OCEAN);
        DEEP_LUKEWARM_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.DEEP_LUKEWARM_OCEAN);
        DEEP_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.DEEP_OCEAN);
        DEEP_COLD_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.DEEP_COLD_OCEAN);
        DEEP_FROZEN_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.DEEP_FROZEN_OCEAN);
        SUNFLOWER_PLAINS = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.SUNFLOWER_PLAINS);
        NETHER = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.NETHER);
        END = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.END);
        BARREN_END_FIELD = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.BARREN_END_FIELD);
        SNOWY_BEACH = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.SNOWY_BEACH);
        STONE_BEACH = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.STONE_SHORE);
        VANILLA_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)Biomes.field_76771_b);
        VANILLA_DEEP_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)Biomes.field_150575_M);
        OCEAN_VALUES = new Biome[]{BiomeInit.WARM_OCEAN, BiomeInit.LUKEWARM_OCEAN, BiomeInit.OCEAN, BiomeInit.COLD_OCEAN, BiomeInit.FROZEN_OCEAN, BiomeInit.DEEP_WARM_OCEAN, BiomeInit.DEEP_LUKEWARM_OCEAN, BiomeInit.DEEP_OCEAN, BiomeInit.DEEP_COLD_OCEAN, BiomeInit.DEEP_FROZEN_OCEAN};
        OCEAN_LIST = new HashSet<Biome>(Arrays.asList(OCEAN_VALUES));
    }
}

