/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.generation.layers;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.traits.IC0Transformer;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.biome.BiomeInit;
import net.telepathicgrunt.ultraamplified.world.generation.BiomeGenHelper;

@Mod.EventBusSubscriber(modid="ultra_amplified_mod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BiomeLayerUA
implements IC0Transformer {
    private static List<BiomeManager.BiomeEntry>[] biomeListsByTemperature;
    private static List<BiomeManager.BiomeEntry> jungleReplacedBiomes;
    private static List<BiomeManager.BiomeEntry> megaTaigaReplacedBiomes;
    private static List<BiomeManager.BiomeEntry> mesaReplacedBiomes;
    private static List<BiomeManager.BiomeEntry> oceanReplacedBiomes;
    private static boolean noOcean;
    private static ForgeRegistry<Biome> BiomeRegistry;

    public BiomeLayerUA() {
        BiomeLayerUA.setupBiomeEntries();
    }

    private static void setupBiomeEntries() {
        biomeListsByTemperature = new ArrayList[BiomeManager.BiomeType.values().length];
        jungleReplacedBiomes = new ArrayList<BiomeManager.BiomeEntry>();
        megaTaigaReplacedBiomes = new ArrayList<BiomeManager.BiomeEntry>();
        mesaReplacedBiomes = new ArrayList<BiomeManager.BiomeEntry>();
        oceanReplacedBiomes = new ArrayList<BiomeManager.BiomeEntry>();
        noOcean = false;
        ArrayList<String> blacklistedMods = new ArrayList<String>();
        LinkedList<String> blacklistedResourceLocations = new LinkedList<String>(Arrays.asList(ConfigUA.blacklistedBiomeList.split(",")));
        for (int i = 0; i < blacklistedResourceLocations.size(); ++i) {
            blacklistedResourceLocations.set(i, ((String)blacklistedResourceLocations.get(i)).trim());
        }
        for (String entry : blacklistedResourceLocations) {
            if (!entry.contains(":*")) continue;
            blacklistedMods.add(entry.split(":")[0]);
        }
        int desertIdx = BiomeManager.BiomeType.DESERT.ordinal();
        int warmIdx = BiomeManager.BiomeType.WARM.ordinal();
        int coolIdx = BiomeManager.BiomeType.COOL.ordinal();
        int icyIdx = BiomeManager.BiomeType.ICY.ordinal();
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            int idx = type.ordinal();
            if (biomeListsByTemperature[idx] != null) continue;
            BiomeLayerUA.biomeListsByTemperature[idx] = new ArrayList<BiomeManager.BiomeEntry>();
        }
        int index = 0;
        if (ConfigUA.importAllModdedBiomes) {
            for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
                String namespace;
                ResourceLocation rl = BiomeRegistry.getKey((IForgeRegistryEntry)biome);
                if (rl == null || blacklistedMods.contains(namespace = rl.func_110624_b()) || ConfigUA.blacklistedBiomeList.contains(rl.toString()) || namespace.equals("minecraft") || namespace.equals("ultra_amplified_mod")) continue;
                BiomeManager.BiomeEntry addedBiome = new BiomeManager.BiomeEntry(biome, 20);
                float biomeTemperature = biome.func_185353_n();
                index = biomeTemperature < 0.1f ? icyIdx : (biomeTemperature >= 0.1f && biomeTemperature < 0.5f ? coolIdx : (biomeTemperature >= 0.5f && biomeTemperature < 1.0f ? warmIdx : desertIdx));
                biomeListsByTemperature[index].add(addedBiome);
            }
        } else if (ConfigUA.importModdedBiomes) {
            for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
                ImmutableList biomesToAdd = BiomeManager.getBiomes((BiomeManager.BiomeType)type);
                int idx = type.ordinal();
                if (!ConfigUA.importModdedBiomes || biomesToAdd == null) continue;
                biomeListsByTemperature[idx].addAll((Collection<BiomeManager.BiomeEntry>)biomesToAdd);
            }
        }
        for (int tempIndex = 0; tempIndex < biomeListsByTemperature.length; ++tempIndex) {
            for (int biomeIndex = biomeListsByTemperature[tempIndex].size() - 1; biomeIndex >= 0; --biomeIndex) {
                String namespace;
                ResourceLocation rl = BiomeRegistry.getKey((IForgeRegistryEntry)BiomeLayerUA.biomeListsByTemperature[tempIndex].get((int)biomeIndex).biome);
                if (rl == null || !(namespace = rl.func_110624_b()).equals("minecraft") && !namespace.equals("ultra_amplified_mod")) continue;
                biomeListsByTemperature[tempIndex].remove(biomeListsByTemperature[tempIndex].get(biomeIndex));
            }
        }
        for (int indexOfList = 0; indexOfList < biomeListsByTemperature.length; ++indexOfList) {
            for (int indexOfEntry = 0; indexOfEntry < biomeListsByTemperature[indexOfList].size(); ++indexOfEntry) {
                if (BiomeLayerUA.biomeListsByTemperature[indexOfList].get((int)indexOfEntry).field_76292_a >= 10) continue;
                BiomeManager.BiomeEntry biomeEntry = biomeListsByTemperature[indexOfList].get(indexOfEntry);
                biomeListsByTemperature[indexOfList].remove(indexOfEntry);
                if (biomeEntry.field_76292_a <= 0) {
                    biomeListsByTemperature[indexOfList].add(indexOfEntry, new BiomeManager.BiomeEntry(biomeEntry.biome, 10));
                    continue;
                }
                biomeListsByTemperature[indexOfList].add(indexOfEntry, new BiomeManager.BiomeEntry(biomeEntry.biome, biomeEntry.field_76292_a * 10));
            }
        }
        if (ConfigUA.desert) {
            biomeListsByTemperature[desertIdx].add(new BiomeManager.BiomeEntry(BiomeInit.DESERT, 40));
        }
        if (ConfigUA.savanna) {
            biomeListsByTemperature[desertIdx].add(new BiomeManager.BiomeEntry(BiomeInit.SAVANNA, 40));
        }
        if (ConfigUA.plains) {
            biomeListsByTemperature[desertIdx].add(new BiomeManager.BiomeEntry(BiomeInit.PLAINS, 20));
        }
        if (ConfigUA.nether) {
            biomeListsByTemperature[desertIdx].add(new BiomeManager.BiomeEntry(BiomeInit.NETHER, 26));
        }
        if (ConfigUA.mushroom) {
            biomeListsByTemperature[desertIdx].add(new BiomeManager.BiomeEntry(BiomeInit.MUSHROOM_FIELDS, 10));
        }
        if (ConfigUA.forest) {
            biomeListsByTemperature[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.FOREST, 26));
        }
        if (ConfigUA.darkForest) {
            biomeListsByTemperature[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.DARK_FOREST, 26));
        }
        if (ConfigUA.mountains) {
            biomeListsByTemperature[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.MOUNTAINS, 26));
        }
        if (ConfigUA.plains) {
            biomeListsByTemperature[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.PLAINS, 26));
        }
        if (ConfigUA.birchForest) {
            biomeListsByTemperature[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BIRCH_FOREST, 26));
        }
        if (ConfigUA.swamplands) {
            biomeListsByTemperature[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.SWAMP, 26));
        }
        if (ConfigUA.mushroom) {
            biomeListsByTemperature[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.MUSHROOM_FIELDS, 10));
        }
        if (ConfigUA.forest) {
            biomeListsByTemperature[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.FOREST, 30));
        }
        if (ConfigUA.mountains) {
            biomeListsByTemperature[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.MOUNTAINS, 30));
        }
        if (ConfigUA.taiga) {
            biomeListsByTemperature[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.TAIGA, 30));
        }
        if (ConfigUA.plains) {
            biomeListsByTemperature[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.PLAINS, 13));
        }
        if (ConfigUA.stoneBeach) {
            biomeListsByTemperature[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.STONE_SHORE, 10));
        }
        if (ConfigUA.end) {
            biomeListsByTemperature[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.END, 20));
        }
        if (ConfigUA.mushroom) {
            biomeListsByTemperature[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.MUSHROOM_FIELDS, 10));
        }
        if (ConfigUA.snowyTundra) {
            biomeListsByTemperature[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.SNOWY_TUNDRA, 45));
        } else {
            if (ConfigUA.iceSpike) {
                biomeListsByTemperature[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.ICE_SPIKES, 26));
            }
            if (ConfigUA.iceMountain) {
                biomeListsByTemperature[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.ICE_MOUNTAIN, 26));
            }
        }
        if (ConfigUA.iceMountain) {
            biomeListsByTemperature[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.ICE_MOUNTAIN, 17));
        }
        if (ConfigUA.snowyTaiga) {
            biomeListsByTemperature[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.SNOWY_TAIGA, 26));
        }
        if (ConfigUA.coldBeach) {
            biomeListsByTemperature[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.SNOWY_BEACH, 10));
        }
        if (ConfigUA.mushroom) {
            biomeListsByTemperature[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.MUSHROOM_FIELDS, 10));
        }
        if (ConfigUA.jungle) {
            jungleReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.JUNGLE, 70));
        }
        if (ConfigUA.bambooJungle) {
            jungleReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.BAMBOO_JUNGLE, 30));
        }
        if (ConfigUA.giantTreeTaiga) {
            megaTaigaReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.GIANT_TREE_TAIGA, 10));
        }
        if (ConfigUA.badlands) {
            mesaReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.BADLANDS_PLATEAU, 20));
            mesaReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.WOODED_BADLANDS_PLATEAU, 10));
        } else if (ConfigUA.erodedBadlands) {
            mesaReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.ERODED_BADLANDS, 10));
        }
        ArrayList<BiomeManager.BiomeEntry> temporaryBiomeList = new ArrayList<BiomeManager.BiomeEntry>();
        for (List<BiomeManager.BiomeEntry> biomeList : biomeListsByTemperature) {
            for (BiomeManager.BiomeEntry biomeEntry : biomeList) {
                boolean alreadyInTemp = false;
                for (BiomeManager.BiomeEntry tempBiomeEntry : temporaryBiomeList) {
                    if (tempBiomeEntry.biome != biomeEntry.biome) continue;
                    alreadyInTemp = true;
                }
                if (alreadyInTemp) continue;
                temporaryBiomeList.add(biomeEntry);
            }
        }
        if (jungleReplacedBiomes.size() != 0) {
            temporaryBiomeList.addAll(jungleReplacedBiomes);
        }
        if (megaTaigaReplacedBiomes.size() != 0) {
            temporaryBiomeList.addAll(megaTaigaReplacedBiomes);
        }
        if (mesaReplacedBiomes.size() != 0) {
            temporaryBiomeList.addAll(mesaReplacedBiomes);
        }
        oceanReplacedBiomes.addAll(temporaryBiomeList);
        while (temporaryBiomeList.size() > 6) {
            temporaryBiomeList.remove(temporaryBiomeList.size() - 1);
        }
        if (temporaryBiomeList.size() == 0) {
            biomeListsByTemperature[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            biomeListsByTemperature[warmIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            biomeListsByTemperature[coolIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            biomeListsByTemperature[icyIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            jungleReplacedBiomes.add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            megaTaigaReplacedBiomes.add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            mesaReplacedBiomes.add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            oceanReplacedBiomes.add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
        } else {
            if (biomeListsByTemperature[desertIdx].size() == 0 || temporaryBiomeList.size() < 6) {
                BiomeLayerUA.biomeListsByTemperature[desertIdx] = temporaryBiomeList;
            }
            if (biomeListsByTemperature[warmIdx].size() == 0 || temporaryBiomeList.size() < 6) {
                BiomeLayerUA.biomeListsByTemperature[warmIdx] = temporaryBiomeList;
            }
            if (biomeListsByTemperature[coolIdx].size() == 0 || temporaryBiomeList.size() < 6) {
                BiomeLayerUA.biomeListsByTemperature[coolIdx] = temporaryBiomeList;
            }
            if (biomeListsByTemperature[icyIdx].size() == 0 || temporaryBiomeList.size() < 6) {
                BiomeLayerUA.biomeListsByTemperature[icyIdx] = temporaryBiomeList;
            }
            if (jungleReplacedBiomes.size() == 0 || temporaryBiomeList.size() < 6) {
                jungleReplacedBiomes = temporaryBiomeList;
            }
            if (megaTaigaReplacedBiomes.size() == 0 || temporaryBiomeList.size() < 6) {
                megaTaigaReplacedBiomes = temporaryBiomeList;
            }
            if (mesaReplacedBiomes.size() == 0 || temporaryBiomeList.size() < 6) {
                mesaReplacedBiomes = temporaryBiomeList;
            }
        }
        if (!(ConfigUA.ocean || ConfigUA.coldOcean || ConfigUA.frozenOcean || ConfigUA.lukewarmOcean || ConfigUA.warmOcean)) {
            noOcean = true;
        }
    }

    public int func_202726_a(INoiseRandom context, int value) {
        int i = (value & 0xF00) >> 8;
        if (!BiomeGenHelper.isOcean(value &= 0xFFFFF0FF) && value != BiomeGenHelper.MUSHROOM_FIELDS) {
            switch (value) {
                case 1: {
                    if (i > 0) {
                        return BiomeRegistry.getID((IForgeRegistryEntry)this.getWeightedSpecialBiomeEntry(BiomeLayerUA.mesaReplacedBiomes, (INoiseRandom)context).biome);
                    }
                    return BiomeRegistry.getID((IForgeRegistryEntry)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (INoiseRandom)context).biome);
                }
                case 2: {
                    if (i > 0) {
                        return BiomeRegistry.getID((IForgeRegistryEntry)this.getWeightedSpecialBiomeEntry(BiomeLayerUA.jungleReplacedBiomes, (INoiseRandom)context).biome);
                    }
                    return BiomeRegistry.getID((IForgeRegistryEntry)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (INoiseRandom)context).biome);
                }
                case 3: {
                    if (i > 0) {
                        return BiomeRegistry.getID((IForgeRegistryEntry)this.getWeightedSpecialBiomeEntry(BiomeLayerUA.megaTaigaReplacedBiomes, (INoiseRandom)context).biome);
                    }
                    return BiomeRegistry.getID((IForgeRegistryEntry)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (INoiseRandom)context).biome);
                }
                case 4: {
                    return BiomeRegistry.getID((IForgeRegistryEntry)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY, (INoiseRandom)context).biome);
                }
            }
            if (noOcean) {
                return BiomeRegistry.getID((IForgeRegistryEntry)this.getWeightedSpecialBiomeEntry(BiomeLayerUA.oceanReplacedBiomes, (INoiseRandom)context).biome);
            }
            return value;
        }
        if (noOcean) {
            return BiomeRegistry.getID((IForgeRegistryEntry)this.getWeightedSpecialBiomeEntry(BiomeLayerUA.oceanReplacedBiomes, (INoiseRandom)context).biome);
        }
        return value;
    }

    protected BiomeManager.BiomeEntry getWeightedBiomeEntry(BiomeManager.BiomeType type, INoiseRandom context) {
        List<BiomeManager.BiomeEntry> biomeList = biomeListsByTemperature[type.ordinal()];
        int totalWeight = WeightedRandom.func_76272_a(biomeList);
        int weight = context.func_202696_a(totalWeight);
        return (BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight);
    }

    protected BiomeManager.BiomeEntry getWeightedSpecialBiomeEntry(List<BiomeManager.BiomeEntry> list, INoiseRandom context) {
        List<BiomeManager.BiomeEntry> biomeList = list;
        int totalWeight = WeightedRandom.func_76272_a(biomeList);
        int weight = context.func_202696_a(totalWeight);
        return (BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight);
    }

    static {
        noOcean = false;
        BiomeRegistry = (ForgeRegistry)ForgeRegistries.BIOMES;
    }

    @Mod.EventBusSubscriber(modid="ultra_amplified_mod")
    private static class ForgeEvents {
        private ForgeEvents() {
        }

        @SubscribeEvent
        public static void Load(WorldEvent.Load event) {
            BiomeLayerUA.setupBiomeEntries();
        }
    }
}

