/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.block;

import com.google.common.base.Strings;
import com.mrcrayfish.vehicle.block.BlockRotatedObject;
import com.mrcrayfish.vehicle.entity.EngineTier;
import com.mrcrayfish.vehicle.entity.WheelType;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.tileentity.VehicleCrateTileEntity;
import com.mrcrayfish.vehicle.util.Bounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockVehicleCrate
extends BlockRotatedObject {
    public static final List<ResourceLocation> REGISTERED_CRATES = new ArrayList<ResourceLocation>();
    private static final AxisAlignedBB PANEL = new Bounds(0, 0, 0, 16, 2, 16).toAABB();

    public BlockVehicleCrate() {
        super(AbstractBlock.Properties.func_200952_a((Material)Material.field_151573_f, (DyeColor)DyeColor.LIGHT_GRAY).func_200948_a(1.5f, 5.0f).func_208770_d());
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197868_b();
    }

    public boolean func_196260_a(BlockState state, IWorldReader reader, BlockPos pos) {
        return this.isBelowBlockTopSolid(reader, pos) && this.canOpen(reader, pos);
    }

    private boolean canOpen(IWorldReader reader, BlockPos pos) {
        for (Direction side : Direction.Plane.HORIZONTAL) {
            BlockPos adjacentPos = pos.func_177972_a(side);
            BlockState state = reader.func_180495_p(adjacentPos);
            if (state.isAir((IBlockReader)reader, pos) || state.func_185904_a().func_76222_j() && !this.isBelowBlockTopSolid(reader, adjacentPos)) continue;
            return false;
        }
        return true;
    }

    private boolean isBelowBlockTopSolid(IWorldReader reader, BlockPos pos) {
        return reader.func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)reader, pos.func_177977_b(), Direction.UP);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        if (result.func_216354_b() == Direction.UP && playerEntity.func_184586_b(hand).func_77973_b() == ModItems.WRENCH.get()) {
            this.openCrate(world, pos, state, (LivingEntity)playerEntity);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity livingEntity, ItemStack stack) {
        if (livingEntity instanceof PlayerEntity && ((PlayerEntity)livingEntity).func_184812_l_()) {
            this.openCrate(world, pos, state, livingEntity);
        }
    }

    private void openCrate(World world, BlockPos pos, BlockState state, LivingEntity placer) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof VehicleCrateTileEntity && this.canOpen((IWorldReader)world, pos)) {
            if (world.field_72995_K) {
                this.spawnCrateOpeningParticles((ClientWorld)world, pos, state);
            } else {
                ((VehicleCrateTileEntity)tileEntity).open(placer.func_110124_au());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnCrateOpeningParticles(ClientWorld world, BlockPos pos, BlockState state) {
        double y = 0.875;
        DiggingParticle.Factory factory = new DiggingParticle.Factory();
        for (int j = 0; j < 4; ++j) {
            for (int l = 0; l < 4; ++l) {
                double x = ((double)j + 0.5) / 4.0;
                double z = ((double)l + 0.5) / 4.0;
                Minecraft.func_71410_x().field_71452_i.func_78873_a(factory.func_199234_a(new BlockParticleData(ParticleTypes.field_197611_d, state), world, (double)pos.func_177958_n() + x, (double)pos.func_177956_o() + y, (double)pos.func_177952_p() + z, x - 0.5, y - 0.5, z - 0.5));
            }
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new VehicleCrateTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader reader, List<ITextComponent> list, ITooltipFlag advanced) {
        CompoundNBT blockEntityTag;
        String vehicle = "vehicle";
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b("BlockEntityTag", 10) && !Strings.isNullOrEmpty((String)(vehicle = (blockEntityTag = tagCompound.func_74775_l("BlockEntityTag")).func_74779_i("Vehicle")))) {
            vehicle = I18n.func_135052_a((String)("entity.vehicle." + vehicle.split(":")[1]), (Object[])new Object[0]);
            list.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + vehicle));
        }
    }

    public static ItemStack create(ResourceLocation entityId, int color, @Nullable EngineTier engineTier, @Nullable WheelType wheelType, int wheelColor) {
        CompoundNBT blockEntityTag = new CompoundNBT();
        blockEntityTag.func_74778_a("Vehicle", entityId.toString());
        blockEntityTag.func_74768_a("Color", color);
        if (engineTier != null) {
            blockEntityTag.func_74768_a("EngineTier", engineTier.ordinal());
        }
        if (wheelType != null) {
            blockEntityTag.func_74768_a("WheelType", wheelType.ordinal());
            if (wheelColor != -1) {
                blockEntityTag.func_74768_a("WheelColor", wheelColor);
            }
        }
        CompoundNBT itemTag = new CompoundNBT();
        itemTag.func_218657_a("BlockEntityTag", (INBT)blockEntityTag);
        ItemStack stack = new ItemStack((IItemProvider)ModBlocks.VEHICLE_CRATE.get());
        stack.func_77982_d(itemTag);
        return stack;
    }

    public static void registerVehicle(ResourceLocation id) {
        if (!REGISTERED_CRATES.contains(id)) {
            REGISTERED_CRATES.add(id);
            Collections.sort(REGISTERED_CRATES);
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        TileEntity tileEntity;
        if (!world.field_72995_K && !player.func_184812_l_() && (tileEntity = world.func_175625_s(pos)) instanceof VehicleCrateTileEntity) {
            ItemStack drop = new ItemStack((IItemProvider)Item.func_150898_a((Block)this));
            CompoundNBT tileEntityTag = new CompoundNBT();
            tileEntity.func_189515_b(tileEntityTag);
            tileEntityTag.func_82580_o("x");
            tileEntityTag.func_82580_o("y");
            tileEntityTag.func_82580_o("z");
            tileEntityTag.func_82580_o("id");
            CompoundNBT compound = new CompoundNBT();
            compound.func_218657_a("BlockEntityTag", (INBT)tileEntityTag);
            drop.func_77982_d(compound);
            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop));
            return world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }
}

