/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.vehicle;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.vehicle.DuneBuggyEntity;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3f;

public class RenderDuneBuggy
extends AbstractRenderVehicle<DuneBuggyEntity> {
    @Override
    public void render(DuneBuggyEntity entity, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, float partialTicks, int light) {
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.DUNE_BUGGY_BODY.getModel(), matrixStack, renderTypeBuffer, light);
        float wheelAngle = entity.prevRenderWheelAngle + (entity.renderWheelAngle - entity.prevRenderWheelAngle) * partialTicks;
        double wheelScale = 1.0;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 0.1953125);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-22.5f));
        float wheelAngleNormal = wheelAngle / 45.0f;
        float turnRotation = wheelAngleNormal * 15.0f;
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(turnRotation));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(22.5f));
        matrixStack.func_227861_a_(0.0, 0.0, -0.2);
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.DUNE_BUGGY_HANDLES.getModel(), matrixStack, renderTypeBuffer, light);
        if (entity.hasWheels()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, -0.355, 0.33);
            float frontWheelSpin = entity.prevFrontWheelRotation + (entity.frontWheelRotation - entity.prevFrontWheelRotation) * partialTicks;
            if (entity.isMoving()) {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-frontWheelSpin));
            }
            matrixStack.func_227862_a_((float)wheelScale, (float)wheelScale, (float)wheelScale);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            IBakedModel wheelModel = RenderUtil.getWheelModel(entity);
            RenderUtil.renderColoredModel(wheelModel, ItemCameraTransforms.TransformType.NONE, false, matrixStack, renderTypeBuffer, entity.getWheelColor(), light, OverlayTexture.field_229196_a_);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    @Override
    public void applyPlayerModel(DuneBuggyEntity entity, PlayerEntity player, PlayerModel model, float partialTicks) {
        float wheelAngle = entity.prevRenderWheelAngle + (entity.renderWheelAngle - entity.prevRenderWheelAngle) * partialTicks;
        float wheelAngleNormal = wheelAngle / 45.0f;
        float turnRotation = wheelAngleNormal * 8.0f;
        model.field_178723_h.field_78795_f = (float)Math.toRadians(-50.0f - turnRotation);
        model.field_178724_i.field_78795_f = (float)Math.toRadians(-50.0f + turnRotation);
        model.field_178721_j.field_78795_f = (float)Math.toRadians(-65.0);
        model.field_178721_j.field_78796_g = (float)Math.toRadians(30.0);
        model.field_178722_k.field_78795_f = (float)Math.toRadians(-65.0);
        model.field_178722_k.field_78796_g = (float)Math.toRadians(-30.0);
    }
}

