/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.item;

import com.mrcrayfish.vehicle.util.CommonUtils;
import java.text.DecimalFormat;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class JerryCanItem
extends Item {
    private final DecimalFormat FUEL_FORMAT = new DecimalFormat("0.#%");
    private final int capacity;
    private final int fillRate;

    public JerryCanItem(int capacity, int fillRate, Item.Properties properties) {
        super(properties);
        this.capacity = capacity;
        this.fillRate = fillRate;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            tooltip.addAll(Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent(this.func_77658_a() + ".info"), 150).stream().map(text -> new StringTextComponent(text.getString())).collect(Collectors.toList()));
        } else {
            String currentFuel = TextFormatting.RESET + this.FUEL_FORMAT.format((float)this.getCurrentFuel(stack) / (float)this.getCapacity(stack));
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.AQUA + TextFormatting.BOLD.toString() + I18n.func_135052_a((String)(this.func_77658_a() + ".fuel"), (Object[])new Object[]{currentFuel})));
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + I18n.func_135052_a((String)"vehicle.info_help", (Object[])new Object[0])));
        }
    }

    public int getCurrentFuel(ItemStack stack) {
        CompoundNBT compound;
        if (!stack.func_190926_b() && stack.func_77973_b() == this && (compound = stack.func_77978_p()) != null) {
            return compound.func_74762_e("Fuel");
        }
        return 0;
    }

    public boolean isFull(ItemStack stack) {
        return this.getCurrentFuel(stack) == this.getCapacity(stack);
    }

    public int fill(ItemStack stack, int fuel) {
        int capacity = this.getCapacity(stack);
        int currentFuel = this.getCurrentFuel(stack);
        int newFuel = Math.min(currentFuel + fuel, capacity);
        CompoundNBT compound = CommonUtils.getOrCreateStackTag(stack);
        compound.func_74768_a("Fuel", newFuel);
        return Math.max(0, currentFuel + fuel - capacity);
    }

    public int drain(ItemStack stack, int maxAmount) {
        int currentFuel = this.getCurrentFuel(stack);
        int remainingFuel = Math.max(0, currentFuel - maxAmount);
        CompoundNBT compound = CommonUtils.getOrCreateStackTag(stack);
        compound.func_74768_a("Fuel", remainingFuel);
        return currentFuel - remainingFuel;
    }

    public static void setCurrentFuel(ItemStack stack, int fuel) {
        CompoundNBT compound = CommonUtils.getOrCreateStackTag(stack);
        compound.func_74768_a("Fuel", fuel);
    }

    public int getCapacity(ItemStack stack) {
        CompoundNBT compound;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof JerryCanItem && (compound = stack.func_77978_p()) != null && compound.func_150297_b("Capacity", 3)) {
            int capacity = compound.func_74762_e("Capacity");
            return capacity > 0 ? capacity : this.capacity;
        }
        return this.capacity;
    }

    public int getFillRate(ItemStack stack) {
        CompoundNBT compound;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof JerryCanItem && (compound = stack.func_77978_p()) != null && compound.func_150297_b("FillRate", 3)) {
            int fillRate = compound.func_74762_e("FillRate");
            return fillRate > 0 ? fillRate : this.fillRate;
        }
        return this.fillRate;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        if (compound != null && compound.func_150297_b("Fuel", 3)) {
            float fuel = compound.func_74762_e("Fuel");
            return fuel < (float)this.capacity;
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        if (compound != null && compound.func_150297_b("Fuel", 3)) {
            double fuel = compound.func_74762_e("Fuel");
            return 1.0 - fuel / (double)this.capacity;
        }
        return 1.0;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }
}

