/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.tileentity;

import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.crafting.FluidExtractorRecipe;
import com.mrcrayfish.vehicle.crafting.RecipeType;
import com.mrcrayfish.vehicle.init.ModTileEntities;
import com.mrcrayfish.vehicle.inventory.container.FluidExtractorContainer;
import com.mrcrayfish.vehicle.tileentity.TileFluidHandlerSynced;
import com.mrcrayfish.vehicle.util.InventoryUtil;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.INameable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidExtractorTileEntity
extends TileFluidHandlerSynced
implements IInventory,
ITickableTileEntity,
INamedContainerProvider,
INameable {
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)7, (Object)ItemStack.field_190927_a);
    private static final int SLOT_FUEL_SOURCE = 0;
    public static final int SLOT_FLUID_SOURCE = 1;
    private FluidExtractorRecipe currentRecipe = null;
    private int remainingFuel;
    private int fuelMaxProgress;
    private int extractionProgress;
    private int capacity;
    private String customName;
    protected final IIntArray fluidExtractorData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return FluidExtractorTileEntity.this.extractionProgress;
                }
                case 1: {
                    return FluidExtractorTileEntity.this.remainingFuel;
                }
                case 2: {
                    return FluidExtractorTileEntity.this.fuelMaxProgress;
                }
                case 3: {
                    return FluidExtractorTileEntity.this.tank.getFluid().getFluid().getRegistryName().hashCode();
                }
                case 4: {
                    return FluidExtractorTileEntity.this.tank.getFluidAmount();
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    FluidExtractorTileEntity.this.extractionProgress = value;
                    break;
                }
                case 1: {
                    FluidExtractorTileEntity.this.remainingFuel = value;
                    break;
                }
                case 2: {
                    FluidExtractorTileEntity.this.fuelMaxProgress = value;
                    break;
                }
                case 3: {
                    FluidExtractorTileEntity.this.updateFluid(FluidExtractorTileEntity.this.tank, value);
                    break;
                }
                case 4: {
                    if (FluidExtractorTileEntity.this.tank.isEmpty() && FluidExtractorTileEntity.this.tank.getFluid().getRawFluid() == Fluids.field_204541_a) break;
                    FluidExtractorTileEntity.this.tank.getFluid().setAmount(value);
                }
            }
        }

        public int func_221478_a() {
            return 5;
        }
    };
    private final LazyOptional<?> itemHandler = LazyOptional.of(this::createUnSidedHandler);

    public FluidExtractorTileEntity() {
        super((TileEntityType)ModTileEntities.FLUID_EXTRACTOR.get(), (Integer)Config.SERVER.extractorCapacity.get(), stack -> true);
        this.capacity = (Integer)Config.SERVER.extractorCapacity.get();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack source = this.func_70301_a(1);
            ItemStack fuel = this.func_70301_a(0);
            if (this.currentRecipe == null && !source.func_190926_b()) {
                this.currentRecipe = this.getRecipe().orElse(null);
            } else if (source.func_190926_b()) {
                this.currentRecipe = null;
                this.extractionProgress = 0;
            }
            this.updateFuel(source, fuel);
            if (this.remainingFuel > 0 && this.canFillWithFluid(source)) {
                if (this.extractionProgress++ == (Integer)Config.SERVER.extractorExtractTime.get()) {
                    this.tank.fill(this.currentRecipe.getResult().createStack(), IFluidHandler.FluidAction.EXECUTE);
                    this.extractionProgress = 0;
                    this.shrinkItem(1);
                    this.currentRecipe = null;
                }
            } else {
                this.extractionProgress = 0;
            }
            if (this.remainingFuel > 0) {
                --this.remainingFuel;
                this.updateFuel(source, fuel);
            }
        }
    }

    private void updateFuel(ItemStack source, ItemStack fuel) {
        if (!fuel.func_190926_b() && this.remainingFuel == 0 && this.canFillWithFluid(source)) {
            this.remainingFuel = this.fuelMaxProgress = ForgeHooks.getBurnTime((ItemStack)fuel);
            this.shrinkItem(0);
        }
    }

    private boolean canFillWithFluid(ItemStack stack) {
        return this.currentRecipe != null && this.currentRecipe.getIngredient().func_77973_b() == stack.func_77973_b() && this.tank.getFluidAmount() < this.tank.getCapacity() && (this.tank.isEmpty() || this.tank.getFluid().getFluid() == this.currentRecipe.getResult().getFluid()) && this.tank.getFluidAmount() + this.currentRecipe.getResult().getAmount() <= this.tank.getCapacity();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canExtract() {
        ItemStack ingredient = this.func_70301_a(1);
        if (!ingredient.func_190926_b()) {
            if (this.currentRecipe == null) {
                this.currentRecipe = this.getRecipe().orElse(null);
            }
        } else {
            this.currentRecipe = null;
        }
        return this.canFillWithFluid(ingredient) && this.remainingFuel >= 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluidExtractorRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public FluidStack getFluidStackTank() {
        return this.tank.getFluid();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int func_70302_i_() {
        return 2;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (!stack.func_190926_b()) {
            this.func_70296_d();
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return ForgeHooks.getBurnTime((ItemStack)stack) > 0;
        }
        if (index == 1) {
            return this.isValidIngredient(stack);
        }
        return false;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public int getExtractionProgress() {
        return this.fluidExtractorData.func_221476_a(0);
    }

    public int getRemainingFuel() {
        return this.fluidExtractorData.func_221476_a(1);
    }

    public int getFuelMaxProgress() {
        return this.fluidExtractorData.func_221476_a(2);
    }

    public int getFluidLevel() {
        return this.fluidExtractorData.func_221476_a(4);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150297_b("ExtractionProgress", 3)) {
            this.extractionProgress = compound.func_74762_e("ExtractionProgress");
        }
        if (compound.func_150297_b("RemainingFuel", 3)) {
            this.remainingFuel = compound.func_74762_e("RemainingFuel");
        }
        if (compound.func_150297_b("FuelMaxProgress", 3)) {
            this.fuelMaxProgress = compound.func_74762_e("FuelMaxProgress");
        }
        if (compound.func_150297_b("Items", 9)) {
            this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.inventory);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("ExtractionProgress", this.extractionProgress);
        compound.func_74768_a("RemainingFuel", this.remainingFuel);
        compound.func_74768_a("FuelMaxProgress", this.fuelMaxProgress);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventory);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public ITextComponent func_200200_C_() {
        return this.func_145748_c_();
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new StringTextComponent(this.customName) : new TranslationTextComponent("container.fluid_extractor");
    }

    private void shrinkItem(int index) {
        ItemStack stack = this.func_70301_a(index);
        stack.func_190918_g(1);
        if (stack.func_190926_b()) {
            this.func_70299_a(index, ItemStack.field_190927_a);
        }
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new FluidExtractorContainer(windowId, (IInventory)playerInventory, this);
    }

    public IIntArray getFluidExtractorData() {
        return this.fluidExtractorData;
    }

    public void updateFluid(FluidTank tank, int fluidHash) {
        Optional<Fluid> optional = ForgeRegistries.FLUIDS.getValues().stream().filter(fluid -> fluid.getRegistryName().hashCode() == fluidHash).findFirst();
        optional.ifPresent(fluid -> tank.setFluid(new FluidStack(fluid, tank.getFluidAmount())));
    }

    public Optional<FluidExtractorRecipe> getRecipe() {
        return this.field_145850_b.func_199532_z().func_215371_a(RecipeType.FLUID_EXTRACTOR, (IInventory)this, this.field_145850_b);
    }

    public boolean isValidIngredient(ItemStack ingredient) {
        List recipes = this.field_145850_b.func_199532_z().func_199510_b().stream().filter(recipe -> recipe.func_222127_g() == RecipeType.FLUID_EXTRACTOR).map(recipe -> (FluidExtractorRecipe)recipe).collect(Collectors.toList());
        return recipes.stream().anyMatch(recipe -> InventoryUtil.areItemStacksEqualIgnoreCount(ingredient, recipe.getIngredient()));
    }

    @Nonnull
    protected IItemHandler createUnSidedHandler() {
        return new InvWrapper((IInventory)this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

