/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames;

import astrotibs.villagenames.advancements.ModTriggers;
import astrotibs.villagenames.block.ModBlocksVN;
import astrotibs.villagenames.client.renderer.entity.RenderVillagerModern;
import astrotibs.villagenames.client.renderer.entity.RenderZombieVillagerModern;
import astrotibs.villagenames.command.CommandBanner;
import astrotibs.villagenames.command.CommandName;
import astrotibs.villagenames.config.ConfigInit;
import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.config.village.VillageGeneratorConfigHandler;
import astrotibs.villagenames.handler.ChestLootHandler;
import astrotibs.villagenames.handler.DevVersionWarning;
import astrotibs.villagenames.handler.EntityMonitorHandler;
import astrotibs.villagenames.handler.ReputationHandler;
import astrotibs.villagenames.handler.ServerCleanExpired;
import astrotibs.villagenames.handler.ServerTrackerStarter;
import astrotibs.villagenames.handler.VersionChecker;
import astrotibs.villagenames.handler.VillagerTradeHandler;
import astrotibs.villagenames.init.InventoryRender;
import astrotibs.villagenames.item.ModItems;
import astrotibs.villagenames.nbt.NBTUpdater;
import astrotibs.villagenames.network.MessageModernVillagerSkin;
import astrotibs.villagenames.network.MessageVillageGuard;
import astrotibs.villagenames.network.MessageZombieVillagerProfession;
import astrotibs.villagenames.network.NetworkHelper;
import astrotibs.villagenames.proxy.CommonProxy;
import astrotibs.villagenames.utility.LogHelper;
import astrotibs.villagenames.village.MapGenVillageVN;
import astrotibs.villagenames.village.StructureCreationHandlers;
import astrotibs.villagenames.village.StructureVillageVN;
import astrotibs.villagenames.village.biomestructures.DesertStructures;
import astrotibs.villagenames.village.biomestructures.PlainsStructures;
import astrotibs.villagenames.village.biomestructures.SavannaStructures;
import astrotibs.villagenames.village.biomestructures.SnowyStructures;
import astrotibs.villagenames.village.biomestructures.TaigaStructures;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="villagenames", name="Village Names", version="4.1.0", guiFactory="astrotibs.villagenames.config.gui.VNGuiFactory", acceptedMinecraftVersions="[1.12.2]")
public final class VillageNames {
    @SidedProxy(clientSide="astrotibs.villagenames.proxy.ClientProxy", serverSide="astrotibs.villagenames.proxy.ServerProxy")
    public static CommonProxy PROXY;
    public static SimpleNetworkWrapper VNNetworkWrapper;
    public static File configDirectory;
    @Mod.Instance(value="villagenames")
    public static VillageNames instance;
    public static String currentConfigFolder;
    public static String[] oldConfigFolders;
    public static VersionChecker versionChecker;
    public static boolean haveWarnedVersionOutOfDate;
    public static boolean devVersionWarned;
    public static int numberStructuresArchaeologist;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configDirectory = new File(event.getModConfigurationDirectory(), currentConfigFolder);
        ConfigInit.init(configDirectory);
        for (String oldConfigFolder : oldConfigFolders) {
            if (!new File(event.getModConfigurationDirectory(), oldConfigFolder).exists()) continue;
            LogHelper.warn("ATTENTION! The old configuration folder " + oldConfigFolder + " will NOT BE USED in this version of " + "Village Names" + "! A new " + currentConfigFolder + " folder has been created. Old config values HAVE NOT BEEN COPIED OVER.");
            LogHelper.warn("Remove the " + oldConfigFolder + " folder (save a backup!) to prevent this message in the future.");
            break;
        }
        ModItems.init();
        ModBlocksVN.init();
        if (VillageGeneratorConfigHandler.newVillageGenerator) {
            MapGenStructureIO.func_143034_b(MapGenVillageVN.Start.class, (String)"MapGenVillageVN");
            MapGenStructureIO.func_143031_a(StructureVillageVN.PathVN.class, (String)"VNPath");
            MapGenStructureIO.func_143031_a(StructureVillageVN.DecorTorch.class, (String)"VNDecTor");
            MapGenStructureIO.func_143031_a(PlainsStructures.PlainsFountain01.class, (String)"VNPlF01");
            MapGenStructureIO.func_143031_a(PlainsStructures.PlainsMeetingPoint1.class, (String)"VNPlMP1");
            MapGenStructureIO.func_143031_a(PlainsStructures.PlainsMeetingPoint2.class, (String)"VNPlMP2");
            MapGenStructureIO.func_143031_a(PlainsStructures.PlainsMeetingPoint3.class, (String)"VNPlMP3");
            MapGenStructureIO.func_143031_a(DesertStructures.DesertMeetingPoint1.class, (String)"VNDeMP1");
            MapGenStructureIO.func_143031_a(DesertStructures.DesertMeetingPoint2.class, (String)"VNDeMP2");
            MapGenStructureIO.func_143031_a(DesertStructures.DesertMeetingPoint3.class, (String)"VNDeMP3");
            MapGenStructureIO.func_143031_a(TaigaStructures.TaigaMeetingPoint1.class, (String)"VNTaMP1");
            MapGenStructureIO.func_143031_a(TaigaStructures.TaigaMeetingPoint2.class, (String)"VNTaMP2");
            MapGenStructureIO.func_143031_a(SavannaStructures.SavannaMeetingPoint1.class, (String)"VNSaMP1");
            MapGenStructureIO.func_143031_a(SavannaStructures.SavannaMeetingPoint2.class, (String)"VNSaMP2");
            MapGenStructureIO.func_143031_a(SavannaStructures.SavannaMeetingPoint3.class, (String)"VNSaMP3");
            MapGenStructureIO.func_143031_a(SavannaStructures.SavannaMeetingPoint4.class, (String)"VNSaMP4");
            MapGenStructureIO.func_143031_a(SnowyStructures.SnowyMeetingPoint1.class, (String)"VNSnMP1");
            MapGenStructureIO.func_143031_a(SnowyStructures.SnowyMeetingPoint2.class, (String)"VNSnMP2");
            MapGenStructureIO.func_143031_a(SnowyStructures.SnowyMeetingPoint3.class, (String)"VNSnMP3");
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsAccessory1.class, "VNPlAcc1", new StructureCreationHandlers.PlainsAccessory1_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsAnimalPen1.class, "VNPlAnP1", new StructureCreationHandlers.PlainsAnimalPen1_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsAnimalPen2.class, "VNPlAnP2", new StructureCreationHandlers.PlainsAnimalPen2_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsAnimalPen3.class, "VNPlAnP3", new StructureCreationHandlers.PlainsAnimalPen3_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsArmorerHouse1.class, "VNPlArm1", new StructureCreationHandlers.PlainsArmorerHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsBigHouse1.class, "VNPlBiH1", new StructureCreationHandlers.PlainsBigHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsButcherShop1.class, "VNPlBut1", new StructureCreationHandlers.PlainsButcherShop1_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsButcherShop2.class, "VNPlBut2", new StructureCreationHandlers.PlainsButcherShop2_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsCartographer1.class, "VNPlCar1", new StructureCreationHandlers.PlainsCartographer1_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsFisherCottage1.class, "VNPlFis1", new StructureCreationHandlers.PlainsFisherCottage1_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsFletcherHouse1.class, "VNPlFle1", new StructureCreationHandlers.PlainsFletcherHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsLargeFarm1.class, "VNPlLFa1", new StructureCreationHandlers.PlainsLargeFarm1_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsLibrary1.class, "VNPlLib1", new StructureCreationHandlers.PlainsLibrary1_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsLibrary2.class, "VNPlLib2", new StructureCreationHandlers.PlainsLibrary2_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsMasonsHouse1.class, "VNPlMas1", new StructureCreationHandlers.PlainsMasonsHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsMediumHouse1.class, "VNPlMeH1", new StructureCreationHandlers.PlainsMediumHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsMediumHouse2.class, "VNPlMeH2", new StructureCreationHandlers.PlainsMediumHouse2_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsMeetingPoint4.class, "VNPlMeP4", new StructureCreationHandlers.PlainsMeetingPoint4_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsMeetingPoint5.class, "VNPlMeP5", new StructureCreationHandlers.PlainsMeetingPoint5_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsShepherdsHouse1.class, "VNPlShe1", new StructureCreationHandlers.PlainsShepherdsHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsSmallFarm1.class, "VNPlSFa1", new StructureCreationHandlers.PlainsSmallFarm1_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsSmallHouse1.class, "VNPlSmH1", new StructureCreationHandlers.PlainsSmallHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsSmallHouse2.class, "VNPlSmH2", new StructureCreationHandlers.PlainsSmallHouse2_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsSmallHouse3.class, "VNPlSmH3", new StructureCreationHandlers.PlainsSmallHouse3_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsSmallHouse4.class, "VNPlSmH4", new StructureCreationHandlers.PlainsSmallHouse4_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsSmallHouse5.class, "VNPlSmH5", new StructureCreationHandlers.PlainsSmallHouse5_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsSmallHouse6.class, "VNPlSmH6", new StructureCreationHandlers.PlainsSmallHouse6_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsSmallHouse7.class, "VNPlSmH7", new StructureCreationHandlers.PlainsSmallHouse7_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsSmallHouse8.class, "VNPlSmH8", new StructureCreationHandlers.PlainsSmallHouse8_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsStable1.class, "VNPlSta1", new StructureCreationHandlers.PlainsStable1_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsStable2.class, "VNPlSta2", new StructureCreationHandlers.PlainsStable2_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsTannery1.class, "VNPlTan2", new StructureCreationHandlers.PlainsTannery1_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsTemple3.class, "VNPlTem3", new StructureCreationHandlers.PlainsTemple3_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsTemple4.class, "VNPlTem4", new StructureCreationHandlers.PlainsTemple4_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsToolSmith1.class, "VNPlTSm1", new StructureCreationHandlers.PlainsToolSmith1_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsWeaponsmith1.class, "VNPlWSm1", new StructureCreationHandlers.PlainsWeaponsmith1_Handler());
            VillageNames.registerVillageComponentBuilding(PlainsStructures.PlainsStreetDecor1.class, "VNPlStD1", new StructureCreationHandlers.PlainsStreetDecor1_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertAnimalPen1.class, "VNDeAnP1", new StructureCreationHandlers.DesertAnimalPen1_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertAnimalPen2.class, "VNDeAnP2", new StructureCreationHandlers.DesertAnimalPen2_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertArmorer1.class, "VNDeArm1", new StructureCreationHandlers.DesertArmorer1_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertButcherShop1.class, "VNDeBut1", new StructureCreationHandlers.DesertButcherShop1_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertCartographerHouse1.class, "VNDeCar1", new StructureCreationHandlers.DesertCartographerHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertFarm1.class, "VNDeFar1", new StructureCreationHandlers.DesertFarm1_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertFarm2.class, "VNDeFar2", new StructureCreationHandlers.DesertFarm2_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertFisher1.class, "VNDeFis1", new StructureCreationHandlers.DesertFisher1_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertFletcherHouse1.class, "VNDeFle1", new StructureCreationHandlers.DesertFletcherHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertLargeFarm1.class, "VNDeLFa1", new StructureCreationHandlers.DesertLargeFarm1_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertLibrary1.class, "VNDeLib1", new StructureCreationHandlers.DesertLibrary1_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertMason1.class, "VNDeMas1", new StructureCreationHandlers.DesertMason1_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertMediumHouse1.class, "VNDeMeH1", new StructureCreationHandlers.DesertMediumHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertMediumHouse2.class, "VNDeMeH2", new StructureCreationHandlers.DesertMediumHouse2_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertShepherdHouse1.class, "VNDeShe1", new StructureCreationHandlers.DesertShepherdHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertSmallHouse1.class, "VNDeSmH1", new StructureCreationHandlers.DesertSmallHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertSmallHouse2.class, "VNDeSmH2", new StructureCreationHandlers.DesertSmallHouse2_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertSmallHouse3.class, "VNDeSmH3", new StructureCreationHandlers.DesertSmallHouse3_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertSmallHouse4.class, "VNDeSmH4", new StructureCreationHandlers.DesertSmallHouse4_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertSmallHouse5.class, "VNDeSmH5", new StructureCreationHandlers.DesertSmallHouse5_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertSmallHouse6.class, "VNDeSmH6", new StructureCreationHandlers.DesertSmallHouse6_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertSmallHouse7.class, "VNDeSmH7", new StructureCreationHandlers.DesertSmallHouse7_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertSmallHouse8.class, "VNDeSmH8", new StructureCreationHandlers.DesertSmallHouse8_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertTannery1.class, "VNDeTan1", new StructureCreationHandlers.DesertTannery1_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertTemple1.class, "VNDeTem1", new StructureCreationHandlers.DesertTemple1_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertTemple2.class, "VNDeTem2", new StructureCreationHandlers.DesertTemple2_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertToolSmith1.class, "VNDeTSm1", new StructureCreationHandlers.DesertToolSmith1_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertWeaponsmith1.class, "VNDeWSm1", new StructureCreationHandlers.DesertWeaponsmith1_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertStreetDecor1.class, "VNDeStD1", new StructureCreationHandlers.SavannaStreetDecor1_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertStreetSubstitute1.class, "VNDeStS1", new StructureCreationHandlers.DesertStreetSubstitute1_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertStreetSubstitute2.class, "VNDeStS2", new StructureCreationHandlers.DesertStreetSubstitute2_Handler());
            VillageNames.registerVillageComponentBuilding(DesertStructures.DesertStreetSubstitute3.class, "VNDeStS3", new StructureCreationHandlers.DesertStreetSubstitute3_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaAnimalPen1.class, "VNTaAnP1", new StructureCreationHandlers.TaigaAnimalPen1_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaArmorer2.class, "VNTaArm2", new StructureCreationHandlers.TaigaArmorer2_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaArmorerHouse1.class, "VNTaArm1", new StructureCreationHandlers.TaigaArmorerHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaButcherShop1.class, "VNTaBut1", new StructureCreationHandlers.TaigaButcherShop1_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaCartographerHouse1.class, "VNTaCar1", new StructureCreationHandlers.TaigaCartographerHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaFisherCottage1.class, "VNTaFis1", new StructureCreationHandlers.TaigaFisherCottage1_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaFletcherHouse1.class, "VNTaFle1", new StructureCreationHandlers.TaigaFletcherHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaLargeFarm1.class, "VNTaLFa1", new StructureCreationHandlers.TaigaLargeFarm1_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaLargeFarm2.class, "VNTaLFa2", new StructureCreationHandlers.TaigaLargeFarm2_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaLibrary1.class, "VNTaLib1", new StructureCreationHandlers.TaigaLibrary1_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaMasonsHouse1.class, "VNTaMas1", new StructureCreationHandlers.TaigaMasonsHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaMediumHouse1.class, "VNTaMeH1", new StructureCreationHandlers.TaigaMediumHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaMediumHouse2.class, "VNTaMeH2", new StructureCreationHandlers.TaigaMediumHouse2_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaMediumHouse3.class, "VNTaMeH3", new StructureCreationHandlers.TaigaMediumHouse3_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaMediumHouse4.class, "VNTaMeH4", new StructureCreationHandlers.TaigaMediumHouse4_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaShepherdsHouse1.class, "VNTaShe1", new StructureCreationHandlers.TaigaShepherdsHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaSmallFarm1.class, "VNTaSFa1", new StructureCreationHandlers.TaigaSmallFarm1_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaSmallHouse1.class, "VNTaSmH1", new StructureCreationHandlers.TaigaSmallHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaSmallHouse2.class, "VNTaSmH2", new StructureCreationHandlers.TaigaSmallHouse2_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaSmallHouse3.class, "VNTaSmH3", new StructureCreationHandlers.TaigaSmallHouse3_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaSmallHouse4.class, "VNTaSmH4", new StructureCreationHandlers.TaigaSmallHouse4_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaSmallHouse5.class, "VNTaSmH5", new StructureCreationHandlers.TaigaSmallHouse5_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaTannery1.class, "VNTaTan1", new StructureCreationHandlers.TaigaTannery1_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaTemple1.class, "VNTaTem1", new StructureCreationHandlers.TaigaTemple1_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaToolSmith1.class, "VNTaTSm1", new StructureCreationHandlers.TaigaToolSmith1_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaWeaponsmith1.class, "VNTaWSm1", new StructureCreationHandlers.TaigaWeaponsmith1_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaWeaponsmith2.class, "VNTaWSm2", new StructureCreationHandlers.TaigaWeaponsmith2_Handler());
            VillageNames.registerVillageComponentBuilding(TaigaStructures.TaigaStreetDecor1.class, "VNTaStD1", new StructureCreationHandlers.TaigaStreetDecor1_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaAnimalPen1.class, "VNSaAnP1", new StructureCreationHandlers.SavannaAnimalPen1_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaAnimalPen2.class, "VNSaAnP2", new StructureCreationHandlers.SavannaAnimalPen2_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaAnimalPen3.class, "VNSaAnP3", new StructureCreationHandlers.SavannaAnimalPen3_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaArmorer1.class, "VNSaArm1", new StructureCreationHandlers.SavannaArmorer1_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaButchersShop1.class, "VNSaBut1", new StructureCreationHandlers.SavannaButchersShop1_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaButchersShop2.class, "VNSaBut2", new StructureCreationHandlers.SavannaButchersShop2_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaCartographer1.class, "VNSaCar1", new StructureCreationHandlers.SavannaCartographer1_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaFisherCottage1.class, "VNSaFis1", new StructureCreationHandlers.SavannaFisherCottage1_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaFletcherHouse1.class, "VNSaFle1", new StructureCreationHandlers.SavannaFletcherHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaLargeFarm1.class, "VNSaLFa1", new StructureCreationHandlers.SavannaLargeFarm1_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaLargeFarm2.class, "VNSaLFa2", new StructureCreationHandlers.SavannaLargeFarm2_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaLibrary1.class, "VNSaLib1", new StructureCreationHandlers.SavannaLibrary1_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaMason1.class, "VNSaMas1", new StructureCreationHandlers.SavannaMason1_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaMediumHouse1.class, "VNSaMeH1", new StructureCreationHandlers.SavannaMediumHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaMediumHouse2.class, "VNSaMeH2", new StructureCreationHandlers.SavannaMediumHouse2_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaShepherd1.class, "VNSaShe1", new StructureCreationHandlers.SavannaShepherd1_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaSmallFarm.class, "VNSaSmFa", new StructureCreationHandlers.SavannaSmallFarm_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaSmallHouse1.class, "VNSaSmH1", new StructureCreationHandlers.SavannaSmallHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaSmallHouse2.class, "VNSaSmH2", new StructureCreationHandlers.SavannaSmallHouse2_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaSmallHouse3.class, "VNSaSmH3", new StructureCreationHandlers.SavannaSmallHouse3_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaSmallHouse4.class, "VNSaSmH4", new StructureCreationHandlers.SavannaSmallHouse4_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaSmallHouse5.class, "VNSaSmH5", new StructureCreationHandlers.SavannaSmallHouse5_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaSmallHouse6.class, "VNSaSmH6", new StructureCreationHandlers.SavannaSmallHouse6_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaSmallHouse7.class, "VNSaSmH7", new StructureCreationHandlers.SavannaSmallHouse7_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaSmallHouse8.class, "VNSaSmH8", new StructureCreationHandlers.SavannaSmallHouse8_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaTannery1.class, "VNSaTsn1", new StructureCreationHandlers.SavannaTannery1_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaTemple1.class, "VNSaTem1", new StructureCreationHandlers.SavannaTemple1_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaTemple2.class, "VNSaTem2", new StructureCreationHandlers.SavannaTemple2_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaToolSmith1.class, "VNSaTSm1", new StructureCreationHandlers.SavannaToolSmith1_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaWeaponsmith1.class, "VNSaWSm1", new StructureCreationHandlers.SavannaWeaponsmith1_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaWeaponsmith2.class, "VNSaWSm2", new StructureCreationHandlers.SavannaWeaponsmith2_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaStreetDecor1.class, "VNSaStD1", new StructureCreationHandlers.SavannaStreetDecor1_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaStreetSubstitute1.class, "VNSaStS1", new StructureCreationHandlers.SavannaStreetSubstitute1_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaStreetSubstitute2.class, "VNSaStS2", new StructureCreationHandlers.SavannaStreetSubstitute2_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaStreetSubstitute3.class, "VNSaStS3", new StructureCreationHandlers.SavannaStreetSubstitute3_Handler());
            VillageNames.registerVillageComponentBuilding(SavannaStructures.SavannaStreetSubstitute4.class, "VNSaStS4", new StructureCreationHandlers.SavannaStreetSubstitute4_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyAnimalPen1.class, "VNSnAnP1", new StructureCreationHandlers.SnowyAnimalPen1_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyAnimalPen2.class, "VNSnAnP2", new StructureCreationHandlers.SnowyAnimalPen2_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyArmorerHouse1.class, "VNSnArH1", new StructureCreationHandlers.SnowyArmorerHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyArmorerHouse2.class, "VNSnArH2", new StructureCreationHandlers.SnowyArmorerHouse2_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyButchersShop1.class, "VNSnBut1", new StructureCreationHandlers.SnowyButchersShop1_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyButchersShop2.class, "VNSnBut2", new StructureCreationHandlers.SnowyButchersShop2_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyCartographerHouse1.class, "VNSnCar1", new StructureCreationHandlers.SnowyCartographerHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyFarm1.class, "VNSnFar1", new StructureCreationHandlers.SnowyFarm1_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyFarm2.class, "VNSnFar2", new StructureCreationHandlers.SnowyFarm2_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyFisherCottage.class, "VNSnFisC", new StructureCreationHandlers.SnowyFisherCottage_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyFletcherHouse1.class, "VNSnFle1", new StructureCreationHandlers.SnowyFletcherHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyLibrary1.class, "VNSnLib1", new StructureCreationHandlers.SnowyLibrary1_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyMasonsHouse1.class, "VNSnMas1", new StructureCreationHandlers.SnowyMasonsHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyMasonsHouse2.class, "VNSnMas2", new StructureCreationHandlers.SnowyMasonsHouse2_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyMediumHouse1.class, "VNSnMeH1", new StructureCreationHandlers.SnowyMediumHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyMediumHouse2.class, "VNSnMeH2", new StructureCreationHandlers.SnowyMediumHouse2_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyMediumHouse3.class, "VNSnMeH3", new StructureCreationHandlers.SnowyMediumHouse3_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyShepherdsHouse1.class, "VNSnShe1", new StructureCreationHandlers.SnowyShepherdsHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowySmallHouse1.class, "VNSnSmH1", new StructureCreationHandlers.SnowySmallHouse1_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowySmallHouse2.class, "VNSnSmH2", new StructureCreationHandlers.SnowySmallHouse2_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowySmallHouse3.class, "VNSnSmH3", new StructureCreationHandlers.SnowySmallHouse3_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowySmallHouse4.class, "VNSnSmH4", new StructureCreationHandlers.SnowySmallHouse4_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowySmallHouse5.class, "VNSnSmH5", new StructureCreationHandlers.SnowySmallHouse5_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowySmallHouse6.class, "VNSnSmH6", new StructureCreationHandlers.SnowySmallHouse6_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowySmallHouse7.class, "VNSnSmH7", new StructureCreationHandlers.SnowySmallHouse7_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowySmallHouse8.class, "VNSnSmH8", new StructureCreationHandlers.SnowySmallHouse8_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyTannery1.class, "VNSnTan1", new StructureCreationHandlers.SnowyTannery1_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyTemple1.class, "VNSnTem1", new StructureCreationHandlers.SnowyTemple1_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyToolSmith1.class, "VNSnTSm1", new StructureCreationHandlers.SnowyToolSmith1_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyWeaponSmith1.class, "VNSnWSm1", new StructureCreationHandlers.SnowyWeaponSmith1_Handler());
            VillageNames.registerVillageComponentBuilding(SnowyStructures.SnowyStreetDecor1.class, "VNSnStD1", new StructureCreationHandlers.SnowyStreetDecor1_Handler());
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)new MapGenVillageVN());
            ChestLootHandler.modernVillageChests();
            LogHelper.info("Registered new Village generator");
        }
        MinecraftForge.EVENT_BUS.register((Object)new NBTUpdater());
        MinecraftForge.EVENT_BUS.register((Object)new ServerTrackerStarter());
        MinecraftForge.EVENT_BUS.register((Object)new EntityMonitorHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ServerCleanExpired());
        MinecraftForge.EVENT_BUS.register((Object)new ReputationHandler());
        if (GeneralConfig.versionChecker) {
            MinecraftForge.EVENT_BUS.register((Object)versionChecker);
        }
        if ("4.1.0".contains("DEV")) {
            MinecraftForge.EVENT_BUS.register((Object)new DevVersionWarning());
        }
        VNNetworkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("vnChannel");
        int messageID = 0;
        VNNetworkWrapper.registerMessage(NetworkHelper.ZombieVillagerProfessionHandler.class, MessageZombieVillagerProfession.class, messageID++, Side.CLIENT);
        VNNetworkWrapper.registerMessage(NetworkHelper.VillageGuardHandler.class, MessageVillageGuard.class, messageID++, Side.CLIENT);
        VNNetworkWrapper.registerMessage(NetworkHelper.ModernVillagerSkinHandler.class, MessageModernVillagerSkin.class, messageID++, Side.CLIENT);
        event.getModMetadata().autogenerated = false;
        event.getModMetadata().name = TextFormatting.GOLD + "Village Names";
        event.getModMetadata().version = TextFormatting.YELLOW + "4.1.0";
        event.getModMetadata().credits = TextFormatting.AQUA + "Thanks to Pahimar, MineMaarten, and Jabelar for their tutorials; to Darian Stephens for playtesting; and to whrrgarbl for her help and support.";
        event.getModMetadata().authorList.clear();
        event.getModMetadata().authorList.add(TextFormatting.BLUE + "AstroTibs");
        event.getModMetadata().url = "https://www.curseforge.com/minecraft/mc-mods/village-names";
        event.getModMetadata().description = TextFormatting.GREEN + "Generates random names for villages, villagers, and other structures and entities.";
        event.getModMetadata().logoFile = "assets/villagenames/vn_banner.png";
        if (GeneralConfig.treasureTrades) {
            VillagerRegistry.VillagerProfession professionLibrarian = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation("minecraft:librarian"));
            VillagerRegistry.VillagerCareer careerLibrarian = professionLibrarian.getCareer(0);
            VillagerRegistry.VillagerCareer careerCartographer = professionLibrarian.getCareer(1);
            if (GeneralConfig.treasureTrades && !GeneralConfig.modernVillagerTrades) {
                for (int i = 0; i < 3; ++i) {
                    EntityVillager.ITradeList[] iTradeListArray = new EntityVillager.ITradeList[1];
                    iTradeListArray[0] = new VillagerTradeHandler().new VillagerTradeHandler.LibrarianVN();
                    careerLibrarian.addTrade(i + 7, iTradeListArray);
                    EntityVillager.ITradeList[] iTradeListArray2 = new EntityVillager.ITradeList[1];
                    iTradeListArray2[0] = new VillagerTradeHandler().new VillagerTradeHandler.CartographerVN();
                    careerCartographer.addTrade(i + 4, iTradeListArray2);
                }
            }
        }
        if (GeneralConfig.modernVillagerTrades) {
            VillagerRegistry.VillagerProfession profBlacksmith = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation("minecraft:smith"));
            VillagerRegistry.VillagerCareer carMason = new VillagerRegistry.VillagerCareer(profBlacksmith, "mason");
            EntityVillager.ITradeList[] iTradeListArray = new EntityVillager.ITradeList[1];
            iTradeListArray[0] = new VillagerTradeHandler().new VillagerTradeHandler.MasonNovice();
            carMason.addTrade(1, iTradeListArray);
            EntityVillager.ITradeList[] iTradeListArray3 = new EntityVillager.ITradeList[1];
            iTradeListArray3[0] = new VillagerTradeHandler().new VillagerTradeHandler.MasonApprentice();
            carMason.addTrade(2, iTradeListArray3);
            EntityVillager.ITradeList[] iTradeListArray4 = new EntityVillager.ITradeList[1];
            iTradeListArray4[0] = new VillagerTradeHandler().new VillagerTradeHandler.MasonJourneyman();
            carMason.addTrade(3, iTradeListArray4);
            EntityVillager.ITradeList[] iTradeListArray5 = new EntityVillager.ITradeList[1];
            iTradeListArray5[0] = new VillagerTradeHandler().new VillagerTradeHandler.MasonExpert();
            carMason.addTrade(4, iTradeListArray5);
            EntityVillager.ITradeList[] iTradeListArray6 = new EntityVillager.ITradeList[1];
            iTradeListArray6[0] = new VillagerTradeHandler().new VillagerTradeHandler.MasonMaster();
            carMason.addTrade(5, iTradeListArray6);
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (event.getSide() == Side.CLIENT) {
            InventoryRender.init();
        }
        ModTriggers.registerTriggers();
        Blocks.field_150433_aE.func_149675_a(false);
        PROXY.init(event);
        if (event.getSide() == Side.CLIENT && GeneralConfig.modernVillagerSkins) {
            Minecraft.func_71410_x().func_175598_ae().field_78729_o.remove(EntityVillager.class);
            Minecraft.func_71410_x().func_175598_ae().field_78729_o.put(EntityVillager.class, new RenderVillagerModern(Minecraft.func_71410_x().func_175598_ae()));
            Minecraft.func_71410_x().func_175598_ae().field_78729_o.remove(EntityZombieVillager.class);
            Minecraft.func_71410_x().func_175598_ae().field_78729_o.put(EntityZombieVillager.class, new RenderZombieVillagerModern(Minecraft.func_71410_x().func_175598_ae()));
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandName());
        event.registerServerCommand((ICommand)new CommandBanner());
    }

    public static void registerVillageComponentBuilding(Class structureClass, String structureShorthand, VillagerRegistry.IVillageCreationHandler handlerClass) {
        VillagerRegistry.instance().registerVillageCreationHandler(handlerClass);
        MapGenStructureIO.func_143031_a((Class)structureClass, (String)structureShorthand);
    }

    static {
        currentConfigFolder = "VillageNames4";
        oldConfigFolders = new String[]{"VillageNames3", "VillageNames"};
        versionChecker = new VersionChecker();
        haveWarnedVersionOutOfDate = false;
        devVersionWarned = false;
        numberStructuresArchaeologist = 7;
    }
}

