/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.client.renderer.entity;

import astrotibs.villagenames.capabilities.IModularSkin;
import astrotibs.villagenames.capabilities.ModularSkinProvider;
import astrotibs.villagenames.client.model.ModelVillagerModern;
import astrotibs.villagenames.config.GeneralConfig;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderVillagerModern
extends RenderLiving<EntityVillager> {
    static final String VAD = "textures/entity/villager/";
    static final String MIDLC = "villagenames".toLowerCase();
    private static final ResourceLocation villagerBaseSkin = new ResourceLocation(MIDLC, "textures/entity/villager/villager.png");
    private static final ResourceLocation villagerTypeDesert = new ResourceLocation(MIDLC, "textures/entity/villager/type/desert.png");
    private static final ResourceLocation villagerTypeJungle = new ResourceLocation(MIDLC, "textures/entity/villager/type/jungle.png");
    private static final ResourceLocation villagerTypePlains = new ResourceLocation(MIDLC, "textures/entity/villager/type/plains.png");
    private static final ResourceLocation villagerTypeSavanna = new ResourceLocation(MIDLC, "textures/entity/villager/type/savanna.png");
    private static final ResourceLocation villagerTypeSnow = new ResourceLocation(MIDLC, "textures/entity/villager/type/snow.png");
    private static final ResourceLocation villagerTypeSwamp = new ResourceLocation(MIDLC, "textures/entity/villager/type/swamp.png");
    private static final ResourceLocation villagerTypeTaiga = new ResourceLocation(MIDLC, "textures/entity/villager/type/taiga.png");
    private static final ResourceLocation villagerTypeForest = new ResourceLocation(MIDLC, "textures/entity/villager/type/forest.png");
    private static final ResourceLocation villagerTypeAquatic = new ResourceLocation(MIDLC, "textures/entity/villager/type/aquatic.png");
    private static final ResourceLocation villagerTypeHighland = new ResourceLocation(MIDLC, "textures/entity/villager/type/highland.png");
    private static final ResourceLocation villagerTypeMushroom = new ResourceLocation(MIDLC, "textures/entity/villager/type/mushroom.png");
    private static final ResourceLocation villagerTypeMagical = new ResourceLocation(MIDLC, "textures/entity/villager/type/magical.png");
    private static final ResourceLocation villagerTypeNether = new ResourceLocation(MIDLC, "textures/entity/villager/type/nether.png");
    private static final ResourceLocation villagerTypeEnd = new ResourceLocation(MIDLC, "textures/entity/villager/type/end.png");
    private static final ResourceLocation villagerProfessionArmorer = new ResourceLocation(MIDLC, "textures/entity/villager/profession/armorer.png");
    private static final ResourceLocation villagerProfessionButcher = new ResourceLocation(MIDLC, "textures/entity/villager/profession/butcher.png");
    private static final ResourceLocation villagerProfessionCartographer = new ResourceLocation(MIDLC, "textures/entity/villager/profession/cartographer.png");
    private static final ResourceLocation villagerProfessionCleric = new ResourceLocation(MIDLC, "textures/entity/villager/profession/cleric.png");
    private static final ResourceLocation villagerProfessionFarmer = new ResourceLocation(MIDLC, "textures/entity/villager/profession/farmer.png");
    private static final ResourceLocation villagerProfessionFisherman = new ResourceLocation(MIDLC, "textures/entity/villager/profession/fisherman.png");
    private static final ResourceLocation villagerProfessionFletcher = new ResourceLocation(MIDLC, "textures/entity/villager/profession/fletcher.png");
    private static final ResourceLocation villagerProfessionLeatherworker = new ResourceLocation(MIDLC, "textures/entity/villager/profession/leatherworker.png");
    private static final ResourceLocation villagerProfessionLibrarian = new ResourceLocation(MIDLC, "textures/entity/villager/profession/librarian.png");
    private static final ResourceLocation villagerProfessionMason = new ResourceLocation(MIDLC, "textures/entity/villager/profession/mason.png");
    private static final ResourceLocation villagerProfessionNitwit = new ResourceLocation(MIDLC, "textures/entity/villager/profession/nitwit.png");
    private static final ResourceLocation villagerProfessionShepherd = new ResourceLocation(MIDLC, "textures/entity/villager/profession/shepherd.png");
    private static final ResourceLocation villagerProfessionToolsmith = new ResourceLocation(MIDLC, "textures/entity/villager/profession/toolsmith.png");
    private static final ResourceLocation villagerProfessionWeaponsmith = new ResourceLocation(MIDLC, "textures/entity/villager/profession/weaponsmith.png");
    private static final ResourceLocation villagerProfessionLevelStone = new ResourceLocation(MIDLC, "textures/entity/villager/profession_level/stone.png");
    private static final ResourceLocation villagerProfessionLevelIron = new ResourceLocation(MIDLC, "textures/entity/villager/profession_level/iron.png");
    private static final ResourceLocation villagerProfessionLevelGold = new ResourceLocation(MIDLC, "textures/entity/villager/profession_level/gold.png");
    private static final ResourceLocation villagerProfessionLevelEmerald = new ResourceLocation(MIDLC, "textures/entity/villager/profession_level/emerald.png");
    private static final ResourceLocation villagerProfessionLevelDiamond = new ResourceLocation(MIDLC, "textures/entity/villager/profession_level/diamond.png");
    private static final ResourceLocation defaultOldNitwit = new ResourceLocation("textures/entity/villager/villager.png");
    private static final ResourceLocation defaultOldFarmer = new ResourceLocation("textures/entity/villager/farmer.png");
    private static final ResourceLocation defaultOldLibrarian = new ResourceLocation("textures/entity/villager/librarian.png");
    private static final ResourceLocation defaultOldPriest = new ResourceLocation("textures/entity/villager/priest.png");
    private static final ResourceLocation defaultOldSmith = new ResourceLocation("textures/entity/villager/smith.png");
    private static final ResourceLocation defaultOldButcher = new ResourceLocation("textures/entity/villager/butcher.png");
    private static final ResourceLocation villageSkinToneLight3 = new ResourceLocation(MIDLC, "textures/entity/villager/skintone/l3.png");
    private static final ResourceLocation villageSkinToneLight2 = new ResourceLocation(MIDLC, "textures/entity/villager/skintone/l2.png");
    private static final ResourceLocation villageSkinToneLight1 = new ResourceLocation(MIDLC, "textures/entity/villager/skintone/l1.png");
    private static final ResourceLocation villageSkinToneMedium = new ResourceLocation(MIDLC, "textures/entity/villager/skintone/m0.png");
    private static final ResourceLocation villageSkinToneDark1 = new ResourceLocation(MIDLC, "textures/entity/villager/skintone/d1.png");
    private static final ResourceLocation villageSkinToneDark2 = new ResourceLocation(MIDLC, "textures/entity/villager/skintone/d2.png");
    private static final ResourceLocation villageSkinToneDark3 = new ResourceLocation(MIDLC, "textures/entity/villager/skintone/d3.png");
    private static final ResourceLocation villageSkinToneDark4 = new ResourceLocation(MIDLC, "textures/entity/villager/skintone/d4.png");

    public RenderVillagerModern(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelVillagerModern(0.0f), 0.5f);
        this.func_177094_a(new LayerVillagerBiomeType(this));
        this.func_177094_a(new LayerVillagerProfession(this));
        this.func_177094_a(new LayerVillagerProfessionLevel(this));
    }

    protected ResourceLocation getEntityTexture(EntityVillager villager) {
        int indexofmodprof = GeneralConfig.professionID_a.indexOf(villager.getProfessionForge().getRegistryName().toString());
        if (GeneralConfig.modernVillagerSkins && villager.func_70946_n() >= 0 && (villager.func_70946_n() <= 5 || indexofmodprof > -1 && !GeneralConfig.careerAsset_a.get(indexofmodprof).equals(""))) {
            if (GeneralConfig.villagerSkinTones) {
                switch (((IModularSkin)villager.getCapability(ModularSkinProvider.MODULAR_SKIN, null)).getSkinTone()) {
                    case 3: {
                        return villageSkinToneLight3;
                    }
                    case 2: {
                        return villageSkinToneLight2;
                    }
                    case 1: {
                        return villageSkinToneLight1;
                    }
                    default: {
                        return villageSkinToneMedium;
                    }
                    case -1: {
                        return villageSkinToneDark1;
                    }
                    case -2: {
                        return villageSkinToneDark2;
                    }
                    case -3: {
                        return villageSkinToneDark3;
                    }
                    case -4: 
                }
                return villageSkinToneDark4;
            }
            return villagerBaseSkin;
        }
        switch (villager.func_70946_n()) {
            case 0: {
                return defaultOldFarmer;
            }
            case 1: {
                return defaultOldLibrarian;
            }
            case 2: {
                return defaultOldPriest;
            }
            case 3: {
                return defaultOldSmith;
            }
            case 4: {
                return defaultOldButcher;
            }
        }
        return villager.getProfessionForge().getSkin();
    }

    protected void preRenderCallback(EntityVillager entitylivingbaseIn, float partialTickTime) {
        float f = 0.9375f;
        if (entitylivingbaseIn.func_70874_b() < 0) {
            f = (float)((double)f * 0.5);
            this.field_76989_e = 0.25f;
        } else {
            this.field_76989_e = 0.5f;
        }
        GlStateManager.func_179152_a((float)f, (float)f, (float)f);
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerVillagerProfessionLevel
    implements LayerRenderer<EntityVillager> {
        private final RenderVillagerModern villagerLayerRenderer;
        private final ModelVillagerModern villagerLayerModel = new ModelVillagerModern(0.3f);

        public LayerVillagerProfessionLevel(RenderVillagerModern villagerRenderIn) {
            this.villagerLayerRenderer = villagerRenderIn;
        }

        public void doRenderLayer(EntityVillager villager, float p_177141_2_, float p_177141_3_, float partialTicks, float p_177141_5_, float p_177141_6_, float p_177141_7_, float scale) {
            if (!(villager.func_70946_n() < 0 || villager.func_70946_n() > 5 && GeneralConfig.professionID_a.indexOf(villager.getProfessionForge().getRegistryName().toString()) == -1 || villager.func_82150_aj())) {
                if (GeneralConfig.modernVillagerSkins) {
                    int profLevel;
                    int n = profLevel = villager.func_70631_g_() ? 0 : ((IModularSkin)villager.getCapability(ModularSkinProvider.MODULAR_SKIN, null)).getProfessionLevel();
                    if (profLevel >= 5) {
                        this.villagerLayerRenderer.func_110776_a(villagerProfessionLevelDiamond);
                    }
                    switch (profLevel) {
                        case 1: {
                            this.villagerLayerRenderer.func_110776_a(villagerProfessionLevelStone);
                            break;
                        }
                        case 2: {
                            this.villagerLayerRenderer.func_110776_a(villagerProfessionLevelIron);
                            break;
                        }
                        case 3: {
                            this.villagerLayerRenderer.func_110776_a(villagerProfessionLevelGold);
                            break;
                        }
                        case 4: {
                            this.villagerLayerRenderer.func_110776_a(villagerProfessionLevelEmerald);
                        }
                    }
                }
                this.villagerLayerRenderer.func_177087_b().func_78088_a((Entity)villager, p_177141_2_, p_177141_3_, p_177141_5_, p_177141_6_, p_177141_7_, scale);
                this.villagerLayerModel.func_78088_a((Entity)villager, p_177141_2_, p_177141_3_, p_177141_5_, p_177141_6_, p_177141_7_, scale);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerVillagerProfession
    implements LayerRenderer<EntityVillager> {
        private final RenderVillagerModern villagerLayerRenderer;
        private final ModelVillagerModern villagerLayerModel = new ModelVillagerModern(0.2f);

        public LayerVillagerProfession(RenderVillagerModern villagerRenderIn) {
            this.villagerLayerRenderer = villagerRenderIn;
        }

        public void doRenderLayer(EntityVillager villager, float p_177141_2_, float p_177141_3_, float partialTicks, float p_177141_5_, float p_177141_6_, float p_177141_7_, float scale) {
            if (villager.func_70946_n() >= 0 && !villager.func_82150_aj() && !villager.func_70631_g_()) {
                String villagerForgeProfessionRegistryName = villager.getProfessionForge().getRegistryName().toString();
                if (villager.func_70946_n() <= 5 && villagerForgeProfessionRegistryName.length() >= 10 && villagerForgeProfessionRegistryName.substring(0, 10).equals("minecraft:")) {
                    if (GeneralConfig.modernVillagerSkins) {
                        int career = ((IModularSkin)villager.getCapability(ModularSkinProvider.MODULAR_SKIN, null)).getCareer();
                        block0 : switch (villager.func_70946_n()) {
                            case 0: {
                                switch (career) {
                                    default: {
                                        this.villagerLayerRenderer.func_110776_a(villagerProfessionFarmer);
                                        break block0;
                                    }
                                    case 2: {
                                        this.villagerLayerRenderer.func_110776_a(villagerProfessionFisherman);
                                        break block0;
                                    }
                                    case 3: {
                                        this.villagerLayerRenderer.func_110776_a(villagerProfessionShepherd);
                                        break block0;
                                    }
                                    case 4: 
                                }
                                this.villagerLayerRenderer.func_110776_a(villagerProfessionFletcher);
                                break;
                            }
                            case 1: {
                                switch (career) {
                                    default: {
                                        this.villagerLayerRenderer.func_110776_a(villagerProfessionLibrarian);
                                        break block0;
                                    }
                                    case 2: 
                                }
                                this.villagerLayerRenderer.func_110776_a(villagerProfessionCartographer);
                                break;
                            }
                            case 2: {
                                switch (career) {
                                    default: 
                                }
                                this.villagerLayerRenderer.func_110776_a(villagerProfessionCleric);
                                break;
                            }
                            case 3: {
                                switch (career) {
                                    case 1: {
                                        this.villagerLayerRenderer.func_110776_a(villagerProfessionArmorer);
                                        break block0;
                                    }
                                    case 2: {
                                        this.villagerLayerRenderer.func_110776_a(villagerProfessionWeaponsmith);
                                        break block0;
                                    }
                                    default: {
                                        this.villagerLayerRenderer.func_110776_a(villagerProfessionToolsmith);
                                        break block0;
                                    }
                                    case 4: 
                                }
                                this.villagerLayerRenderer.func_110776_a(villagerProfessionMason);
                                break;
                            }
                            case 4: {
                                switch (career) {
                                    default: {
                                        this.villagerLayerRenderer.func_110776_a(villagerProfessionButcher);
                                        break block0;
                                    }
                                    case 2: 
                                }
                                this.villagerLayerRenderer.func_110776_a(villagerProfessionLeatherworker);
                                break;
                            }
                            case 5: {
                                switch (career) {
                                    default: 
                                }
                                this.villagerLayerRenderer.func_110776_a(villagerProfessionNitwit);
                                break;
                            }
                        }
                    }
                } else {
                    int indexofmodprof = GeneralConfig.professionID_a.indexOf(villager.getProfessionForge().getRegistryName().toString());
                    if (indexofmodprof > -1 && !GeneralConfig.careerAsset_a.get(indexofmodprof).equals("")) {
                        String profRootName = GeneralConfig.careerAsset_a.get(indexofmodprof);
                        ResourceLocation modCareerSkin = new ResourceLocation(MIDLC, "textures/entity/villager/profession/" + profRootName + ".png");
                        this.villagerLayerRenderer.func_110776_a(modCareerSkin);
                    }
                }
                this.villagerLayerRenderer.func_177087_b().func_78088_a((Entity)villager, p_177141_2_, p_177141_3_, p_177141_5_, p_177141_6_, p_177141_7_, scale);
                this.villagerLayerModel.func_78088_a((Entity)villager, p_177141_2_, p_177141_3_, p_177141_5_, p_177141_6_, p_177141_7_, scale);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerVillagerBiomeType
    implements LayerRenderer<EntityVillager> {
        private final RenderVillagerModern villagerLayerRenderer;
        private final ModelVillagerModern villagerLayerModel = new ModelVillagerModern(0.1f);

        public LayerVillagerBiomeType(RenderVillagerModern villagerRenderIn) {
            this.villagerLayerRenderer = villagerRenderIn;
        }

        public void doRenderLayer(EntityVillager villager, float p_177141_2_, float p_177141_3_, float partialTicks, float p_177141_5_, float p_177141_6_, float p_177141_7_, float scale) {
            if (!(villager.func_70946_n() < 0 || villager.func_70946_n() > 5 && GeneralConfig.professionID_a.indexOf(villager.getProfessionForge().getRegistryName().toString()) == -1 || villager.func_82150_aj())) {
                if (GeneralConfig.modernVillagerSkins) {
                    switch (((IModularSkin)villager.getCapability(ModularSkinProvider.MODULAR_SKIN, null)).getBiomeType()) {
                        case 11: {
                            this.villagerLayerRenderer.func_110776_a(villagerTypeSnow);
                            break;
                        }
                        case 9: {
                            this.villagerLayerRenderer.func_110776_a(villagerTypeSavanna);
                            break;
                        }
                        case 8: {
                            this.villagerLayerRenderer.func_110776_a(villagerTypeDesert);
                            break;
                        }
                        case 3: {
                            this.villagerLayerRenderer.func_110776_a(villagerTypeForest);
                            break;
                        }
                        case 7: {
                            this.villagerLayerRenderer.func_110776_a(villagerTypeTaiga);
                            break;
                        }
                        case 6: {
                            this.villagerLayerRenderer.func_110776_a(villagerTypeSwamp);
                            break;
                        }
                        case 5: {
                            this.villagerLayerRenderer.func_110776_a(villagerTypeJungle);
                            break;
                        }
                        case 4: {
                            this.villagerLayerRenderer.func_110776_a(villagerTypeAquatic);
                            break;
                        }
                        case 2: {
                            this.villagerLayerRenderer.func_110776_a(villagerTypeHighland);
                            break;
                        }
                        case 10: {
                            this.villagerLayerRenderer.func_110776_a(villagerTypeMushroom);
                            break;
                        }
                        case 1: {
                            this.villagerLayerRenderer.func_110776_a(villagerTypeMagical);
                            break;
                        }
                        case 13: {
                            this.villagerLayerRenderer.func_110776_a(villagerTypeNether);
                            break;
                        }
                        case 12: {
                            this.villagerLayerRenderer.func_110776_a(villagerTypeEnd);
                            break;
                        }
                        default: {
                            this.villagerLayerRenderer.func_110776_a(villagerTypePlains);
                        }
                    }
                }
                this.villagerLayerModel.func_178686_a(this.villagerLayerRenderer.func_177087_b());
                this.villagerLayerModel.func_78088_a((Entity)villager, p_177141_2_, p_177141_3_, p_177141_5_, p_177141_6_, p_177141_7_, scale);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

