/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.tracker;

import astrotibs.villagenames.capabilities.IModularSkin;
import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.name.NameGenerator;
import astrotibs.villagenames.tracker.ServerInfoTracker;
import astrotibs.villagenames.utility.FunctionsVN;
import astrotibs.villagenames.utility.LogHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;

public class EventTracker {
    private final Vec3i eventPos;
    private final String customName;
    private final Object extraInfo;
    private int tickWhenAdded;
    private final int entityID;
    static final String PMTMUnloc = "Traveling Merchant";
    static final String PMTMUnlocModern = "Traveling Merchant";
    static final String PMShUnloc = "Sheepman";
    static final String PMShUnlocModern = "Sheepman";
    static final String PMSSUnloc = "Sheepman Smith";

    public Vec3i getPosition() {
        return this.eventPos;
    }

    public String getCustomName() {
        return this.customName;
    }

    public Object getExtraInfo() {
        return this.extraInfo;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public void setBirthTick(int tick) {
        this.tickWhenAdded = tick;
    }

    public int getBirthTick() {
        return this.tickWhenAdded;
    }

    public void expireNow() {
        this.tickWhenAdded = -1;
    }

    private EventTracker(int entityID, Vec3i pos, String customName, Object extraInfo) {
        this.entityID = entityID;
        this.customName = customName;
        this.eventPos = pos;
        this.extraInfo = extraInfo;
        this.tickWhenAdded = 0;
    }

    public EventTracker(EntityVillager villager, IModularSkin ims) {
        this(villager.func_145782_y(), new Vec3i(villager.field_70165_t, villager.field_70163_u + 0.5, villager.field_70161_v), villager.func_95999_t(), new Object[]{villager.func_70946_n(), ims.getCareer(), villager.func_70631_g_(), GeneralConfig.modernVillagerSkins ? ims.getBiomeType() : -1, GeneralConfig.modernVillagerSkins ? ims.getProfessionLevel() : -1, GeneralConfig.modernVillagerSkins && GeneralConfig.villagerSkinTones ? ims.getSkinTone() : -99});
    }

    public EventTracker(EntityLiving guard) {
        this(guard.func_145782_y(), new Vec3i(guard.field_70165_t, guard.field_70163_u + 0.5, guard.field_70161_v), guard.func_95999_t(), new Object[0]);
    }

    public EventTracker(EntityZombieVillager zombievillager, IModularSkin ims) {
        this(zombievillager.func_145782_y(), new Vec3i(zombievillager.field_70165_t, zombievillager.field_70163_u + 0.5, zombievillager.field_70161_v), zombievillager.func_95999_t(), new Object[]{ims.getProfession(), ims.getCareer(), zombievillager.func_70631_g_(), GeneralConfig.modernVillagerSkins ? ims.getBiomeType() : -1, GeneralConfig.modernVillagerSkins ? ims.getProfessionLevel() : -1, GeneralConfig.villagerSkinTones ? ims.getSkinTone() : -99});
    }

    public void updateZombie(EntityJoinWorldEvent event, IModularSkin ims) {
        EntityZombie zombievillager = (EntityZombie)event.getEntity();
        if (GeneralConfig.debugMessages) {
            LogHelper.info("EventTracker.updateZombie called with this.getCustomName(): " + this.getCustomName() + ", this.getObject(): " + this.getExtraInfo());
        }
        Object[] extraInfo = (Object[])this.getExtraInfo();
        int profession = (Integer)extraInfo[0];
        int career = (Integer)extraInfo[1];
        boolean isBaby = (Boolean)extraInfo[2];
        int biomeType = (Integer)extraInfo[3];
        int professionLevel = (Integer)extraInfo[4];
        int skinTone = (Integer)extraInfo[5];
        String customName = this.getCustomName();
        if (!(customName.equals("") || customName.equals(null) || customName.equals("Traveling Merchant") || customName.equals("Traveling Merchant") || customName.equals("Sheepman") || customName.equals("Sheepman") || customName.equals(PMSSUnloc))) {
            zombievillager.func_96094_a(this.getCustomName());
            zombievillager.func_110163_bv();
        }
        zombievillager.func_82227_f(isBaby);
        if (customName.equals(PMSSUnloc)) {
            ims.setProfession(3);
        } else if (profession >= 0) {
            ims.setProfession(profession);
        } else {
            ims.setProfession(-1);
        }
        if (career > 0) {
            ims.setCareer(career);
        } else {
            ims.setCareer(0);
        }
        if (ims.getBiomeType() < 0) {
            ims.setBiomeType(FunctionsVN.returnBiomeTypeForEntityLocation((EntityLiving)zombievillager));
        } else {
            ims.setBiomeType(biomeType);
        }
        if (ims.getSkinTone() == -99) {
            ims.setSkinTone(FunctionsVN.returnSkinToneForEntityLocation((EntityLiving)zombievillager));
        } else {
            ims.setSkinTone(skinTone);
        }
        ims.setProfessionLevel(professionLevel);
        zombievillager.func_98053_h(false);
        if (zombievillager.func_190630_a(EntityEquipmentSlot.MAINHAND)) {
            zombievillager.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_190931_a));
        }
        if (zombievillager.func_190630_a(EntityEquipmentSlot.OFFHAND)) {
            zombievillager.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_190931_a));
        }
        if (zombievillager.func_190630_a(EntityEquipmentSlot.CHEST)) {
            zombievillager.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(Items.field_190931_a));
        }
        if (zombievillager.func_190630_a(EntityEquipmentSlot.FEET)) {
            zombievillager.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(Items.field_190931_a));
        }
        if (zombievillager.func_190630_a(EntityEquipmentSlot.HEAD)) {
            zombievillager.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_190931_a));
        }
        if (zombievillager.func_190630_a(EntityEquipmentSlot.LEGS)) {
            zombievillager.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(Items.field_190931_a));
        }
    }

    public void updateGuard(LivingEvent.LivingUpdateEvent event, IModularSkin ims) {
        EntityLiving guard = (EntityLiving)event.getEntity();
        NBTTagCompound compound = new NBTTagCompound();
        guard.func_70014_b(compound);
        int targetAge = compound.func_74762_e("Age");
        if (GeneralConfig.debugMessages) {
            LogHelper.info("EventTracker.updateGuard called with this.getCustomName(): " + this.getCustomName() + ", this.getObject(): " + this.getExtraInfo());
        }
        Object[] extraInfo = (Object[])this.getExtraInfo();
        String customName = this.getCustomName();
        if (!customName.equals("") && !customName.equals(null)) {
            for (int i = ServerInfoTracker.EventType.GUARD.getTracker().size() - 1; i >= 0; --i) {
                if (ServerInfoTracker.EventType.GUARD.getTracker().get((int)i).customName != customName) continue;
                ServerInfoTracker.EventType.GUARD.getTracker().remove(i);
            }
            if (customName.indexOf("(") != -1) {
                customName = customName.substring(0, customName.indexOf("(")).trim();
            }
            if (GeneralConfig.addJobToName && (!(guard instanceof EntityVillager) || targetAge >= 0)) {
                customName = customName + " " + NameGenerator.getCareerTag(guard.getClass().toString().substring(6), 0, "", 0, "witcheryGuard");
                customName = customName.trim();
            }
            guard.func_96094_a(customName);
            guard.func_110163_bv();
        }
    }

    public void updateVillager(EntityVillager villager, IModularSkin ims) {
        if (GeneralConfig.debugMessages) {
            LogHelper.info("EventTracker.updateVillager called with this.getCustomName(): " + this.getCustomName());
        }
        Object[] extraInfo = (Object[])this.getExtraInfo();
        int profession = (Integer)extraInfo[0];
        int career = (Integer)extraInfo[1];
        boolean isBaby = (Boolean)extraInfo[2];
        int biomeType = (Integer)extraInfo[3];
        int professionLevel = (Integer)extraInfo[4];
        int skinTone = (Integer)extraInfo[5];
        String customName = this.getCustomName();
        if (!(customName.equals("") || customName.equals(null) || customName.equals("Traveling Merchant") || customName.equals("Traveling Merchant") || customName.equals("Sheepman") || customName.equals("Sheepman") || customName.equals(PMSSUnloc))) {
            villager.func_96094_a(this.getCustomName());
        }
        villager.func_70873_a(isBaby ? -24000 : 0);
        if (customName.equals(PMSSUnloc)) {
            villager.func_70938_b(3);
        } else {
            villager.func_70938_b(profession);
        }
        if (career > 0) {
            ims.setCareer(career);
        } else {
            ims.setCareer(0);
        }
        if (ims.getBiomeType() < 0) {
            ims.setBiomeType(FunctionsVN.returnBiomeTypeForEntityLocation((EntityLiving)villager));
        } else {
            ims.setBiomeType(biomeType);
        }
        if (ims.getSkinTone() == -99) {
            ims.setSkinTone(FunctionsVN.returnSkinToneForEntityLocation((EntityLiving)villager));
        } else {
            ims.setSkinTone(skinTone);
        }
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("Entity ID = ");
        r.append(this.getEntityID());
        r.append(", Position = ");
        if (this.getPosition() == null) {
            r.append("NULL");
        } else {
            r.append(this.getPosition().toString());
        }
        r.append(", Tick of Birth = ");
        r.append(this.getBirthTick());
        r.append(", Custom Name = ");
        r.append(this.getCustomName());
        r.append(", Extra Info = ");
        if (this.getExtraInfo() == null) {
            r.append("NULL");
        } else {
            r.append(this.getExtraInfo().getClass().getName());
            r.append(":");
            r.append(this.getExtraInfo().toString());
        }
        return r.toString();
    }
}

