/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.village.biomestructures;

import astrotibs.villagenames.banner.BannerGenerator;
import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.config.village.VillageGeneratorConfigHandler;
import astrotibs.villagenames.handler.ChestLootHandler;
import astrotibs.villagenames.integration.ModObjects;
import astrotibs.villagenames.utility.FunctionsVN;
import astrotibs.villagenames.utility.LogHelper;
import astrotibs.villagenames.village.StructureVillageVN;
import astrotibs.villagenames.village.biomestructures.BlueprintData;
import astrotibs.villagenames.village.chestloot.ChestGenHooks;
import astrotibs.villagenames.village.chestloot.WeightedRandomChestContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class SnowyStructures {
    public static ArrayList<BlueprintData> getRandomSnowyDecorBlueprint(FunctionsVN.MaterialType materialType, boolean disallowModSubs, Biome biome, EnumFacing coordBaseMode, Random random) {
        int decorCount = 3;
        return SnowyStructures.getSnowyDecorBlueprint(random.nextInt(decorCount), materialType, disallowModSubs, biome, coordBaseMode, random);
    }

    public static ArrayList<BlueprintData> getSnowyDecorBlueprint(int decorType, FunctionsVN.MaterialType materialType, boolean disallowModSubs, Biome biome, EnumFacing coordBaseMode, Random random) {
        ArrayList<BlueprintData> blueprint = new ArrayList<BlueprintData>();
        IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), materialType, biome, disallowModSubs);
        IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
        boolean genericBoolean = false;
        int decorOrientation = random.nextInt(4);
        switch (decorType) {
            case 2: {
                int lanternX;
                int n = decorOrientation == 3 ? -1 : (lanternX = decorOrientation == 1 ? 1 : 0);
                int lanternZ = decorOrientation == 0 ? -1 : (decorOrientation == 2 ? 1 : 0);
                BlueprintData.addPlaceBlock(blueprint, lanternX, 3, lanternZ, biomeFenceState);
                BlueprintData.addPlaceBlock(blueprint, lanternX, 2, lanternZ, biomeHangingLanternState);
                int n2 = decorOrientation == 3 ? 1 : (lanternX = decorOrientation == 1 ? -1 : 0);
                lanternZ = decorOrientation == 0 ? 1 : (decorOrientation == 2 ? -1 : 0);
                BlueprintData.addPlaceBlock(blueprint, lanternX, 3, lanternZ, biomeFenceState);
                BlueprintData.addPlaceBlock(blueprint, lanternX, 2, lanternZ, biomeHangingLanternState);
            }
            case 1: {
                int lanternX;
                int n = decorOrientation == 0 ? -1 : (lanternX = decorOrientation == 2 ? 1 : 0);
                int lanternZ = decorOrientation == 3 ? -1 : (decorOrientation == 1 ? 1 : 0);
                BlueprintData.addPlaceBlock(blueprint, lanternX, 3, lanternZ, biomeFenceState);
                BlueprintData.addPlaceBlock(blueprint, lanternX, 2, lanternZ, biomeHangingLanternState);
            }
            case 0: {
                int lanternX;
                int n = decorOrientation == 0 ? 1 : (lanternX = decorOrientation == 2 ? -1 : 0);
                int lanternZ = decorOrientation == 3 ? 1 : (decorOrientation == 1 ? -1 : 0);
                BlueprintData.addPlaceBlock(blueprint, lanternX, 3, lanternZ, biomeFenceState);
                BlueprintData.addPlaceBlock(blueprint, lanternX, 2, lanternZ, biomeHangingLanternState);
                BlueprintData.addFillWithBlocks(blueprint, 0, 0, 0, 0, 3, 0, biomeFenceState);
            }
        }
        return blueprint;
    }

    public static class SnowyStreetDecor1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        public static final int STRUCTURE_WIDTH = 3;
        public static final int STRUCTURE_DEPTH = 7;
        public static final int STRUCTURE_HEIGHT = 4;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowyStreetDecor1() {
        }

        public SnowyStreetDecor1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyStreetDecor1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)3, (int)4, (int)7, (EnumFacing)coordBaseMode);
            return SnowyStreetDecor1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyStreetDecor1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            int[][] decorUVW = new int[][]{{1, 0, 1}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int decorDepth;
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                uvw[2] = decorDepth = ((Integer)FunctionsVN.weightedRandom(new int[]{-2, -1, 0, 1, 2, 3, 5}, new double[]{10.0, 3.0, 4.0, 4.0, 3.0, 3.0, 1.0}, randomFromXYZ)).intValue();
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                if (decorDepth < 0) {
                    int nonairSurrounding = 0;
                    int decorY = this.func_74862_a(decorHeightY);
                    for (int i = 0; i < 8; ++i) {
                        int z;
                        int[][] surroundpos = new int[][]{{0, 0}, {0, 1}, {0, 2}, {1, 2}, {2, 2}, {2, 1}, {2, 0}, {1, 0}};
                        int u = surroundpos[i][0];
                        int w = surroundpos[i][0];
                        int x = this.func_74865_a(u, w);
                        BlockPos pos = new BlockPos(x, decorY, z = this.func_74873_b(u, w));
                        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a || ++nonairSurrounding < 4) continue;
                        ++decorHeightY;
                        break;
                    }
                }
                this.func_175808_b(world, biomeFillerState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
                this.func_74871_b(world, uvw[0], decorHeightY + 1, uvw[2], structureBB);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, true);
                for (BlueprintData b : decorBlueprint) {
                    this.func_175811_a(world, b.getBlockState(), uvw[0] + b.getUPos(), decorHeightY + b.getVPos(), uvw[2] + b.getWPos(), structureBB);
                    if ((b.getfillFlag() & 1) != 0) {
                        this.func_175808_b(world, b.getBlockState(), uvw[0] + b.getUPos(), decorHeightY + b.getVPos() - 1, uvw[2] + b.getWPos(), structureBB);
                    }
                    if ((b.getfillFlag() & 2) == 0) continue;
                    this.func_74871_b(world, uvw[0] + b.getUPos(), decorHeightY + b.getVPos() + 1, uvw[2] + b.getWPos(), structureBB);
                }
                if (world.func_180495_p(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(decorHeightY - 1), this.func_74873_b(uvw[0], uvw[2]))).func_185915_l() && decorDepth >= 0) continue;
                this.func_175811_a(world, biomeGrassState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SnowyWeaponSmith1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 6;
        private static final int DECREASE_MAX_U = 1;
        private int averageGroundLevel = -1;

        public SnowyWeaponSmith1() {
        }

        public SnowyWeaponSmith1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyWeaponSmith1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyWeaponSmith1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyWeaponSmith1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 6 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 6), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 1 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 1)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState dioriteBlockState = Blocks.field_150348_b.func_176203_a(3);
            Block dioriteStairsBlock = ModObjects.chooseModDioriteStairsBlock();
            IBlockState dioriteWallState = ModObjects.chooseModDioriteWallState();
            if (dioriteStairsBlock == null || dioriteWallState == null) {
                dioriteBlockState = Blocks.field_150347_e.func_176203_a(0);
                dioriteStairsBlock = Blocks.field_150446_ar;
                dioriteWallState = Blocks.field_150463_bK.func_176223_P();
            }
            for (int[] uuvvww : new int[][]{{6, 1, 1, 9, 1, 2}, {6, 1, 3, 9, 2, 3}, {6, 3, 3, 7, 3, 3}, {6, 4, 3, 6, 4, 4}, {9, 2, 4, 9, 2, 4}, {6, 1, 4, 9, 1, 4}, {5, 2, 4, 5, 5, 5}, {6, 1, 5, 9, 4, 5}, {2, 1, 4, 4, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], dioriteBlockState, dioriteBlockState, false);
            }
            for (int[] uvwo : new int[][]{{7, 1, 0, 3}, {8, 1, 0, 3}, {7, 4, 3, 1}, {6, 5, 3, 1}, {6, 5, 4, 1}}) {
                this.func_175811_a(world, dioriteStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{6, 1, 0, 6, 1, 0}, {9, 1, 0, 9, 1, 0}, {9, 2, 0, 9, 2, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], dioriteWallState, dioriteWallState, false);
            }
            for (int[] uvwo : new int[][]{{9, 3, 0, -1}, {6, 2, 1, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 1, 1, 5, 3, 1}, {1, 1, 6, 8, 3, 6}, {1, 1, 2, 1, 1, 5}, {1, 3, 2, 1, 3, 5}, {1, 5, 2, 1, 5, 5}, {1, 6, 3, 1, 6, 4}, {5, 1, 2, 5, 5, 3}, {5, 6, 3, 5, 6, 4}, {2, 1, 3, 2, 1, 3}, {3, 1, 2, 3, 1, 2}, {4, 1, 3, 4, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(4 + (this.func_186165_e().func_176736_b() % 2 != 0 ? 4 : 0)), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogHorizAcrossState = biomeLogHorAcrossState;
            if (biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 1);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 1);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 2, 2, 1, 2, 5}, {1, 4, 2, 1, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAcrossState, biomeStrippedLogHorizAcrossState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeStrippedLogHorizAlongState = biomeLogHorAlongState;
            if (biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
                }
            }
            for (int[] uuvvww : new int[][]{{6, 5, 5, 7, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAlongState, biomeStrippedLogHorizAlongState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 3, 0, 6, 3, 0}, {0, 2, 0, 0, 2, 0}, {2, 2, 0, 2, 2, 0}, {4, 2, 0, 4, 2, 0}, {6, 2, 0, 6, 2, 0}, {0, 4, 1, 6, 5, 1}, {0, 6, 2, 6, 6, 2}, {0, 7, 3, 6, 7, 4}, {0, 6, 5, 6, 6, 5}, {0, 5, 6, 7, 5, 6}, {0, 4, 6, 9, 4, 6}, {0, 3, 7, 9, 3, 7}, {0, 2, 7, 0, 2, 7}, {2, 2, 7, 2, 2, 7}, {4, 2, 7, 4, 2, 7}, {6, 2, 7, 6, 2, 7}, {8, 2, 7, 8, 2, 7}, {2, 1, 2, 2, 1, 2}, {3, 1, 3, 3, 1, 3}, {4, 1, 2, 4, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 4, 0}, {2, 4, 0}, {4, 4, 0}, {6, 4, 0}, {0, 4, 7}, {2, 4, 7}, {4, 4, 7}, {6, 4, 7}, {8, 4, 7}, {7, 6, 5}, {9, 5, 5}, {9, 5, 6}}) {
                this.func_175811_a(world, biomeWoodSlabBottomState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 2, 0}, {3, 2, 0}, {5, 2, 0}, {1, 2, 7}, {3, 2, 7}, {5, 2, 7}, {7, 2, 7}, {9, 2, 7}, {9, 3, 6}, {6, 5, 2}, {6, 6, 3}, {6, 6, 4}, {0, 5, 2}, {0, 6, 3}, {0, 6, 4}, {0, 5, 5}}) {
                this.func_175811_a(world, biomeWoodSlabTopState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{8, 5, 5, 1}, {8, 5, 6, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvwo : new int[][]{{3, 5, 2}, {3, 5, 5}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{8, 2, 1, 2, 0}, {3, 2, 5, 2, 0}}) {
                IBlockState biomeGrindstoneState = ModObjects.chooseModGrindstone(uvwo[3], this.func_186165_e(), uvwo[4] == 1);
                this.func_175811_a(world, biomeGrindstoneState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            int chestU = 2;
            int chestV = 2;
            int chestW = 2;
            int chestO = 1;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_weaponsmith");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{5, 2, 2, 1, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{7, 2, 4, 8, 2, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150353_l.func_176223_P(), Blocks.field_150353_l.func_176223_P(), false);
            }
            for (int[] uuvvww : new int[][]{{9, 3, 2, 9, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 0, 0}, {0, 1, 1, 0}, {0, 1, 2, 0}, {0, 1, 3, 0}, {0, 1, 4, 0}, {0, 1, 5, 0}, {0, 1, 6, 0}, {0, 1, 7, 0}, {0, 1, 8, 0}, {1, 1, 0, 0}, {1, 1, 7, 0}, {1, 1, 8, 0}, {2, 1, 0, 0}, {2, 1, 7, 0}, {2, 1, 8, 0}, {3, 1, 0, 0}, {3, 1, 7, 0}, {3, 1, 8, 0}, {4, 1, 7, 0}, {4, 1, 8, 0}, {5, 1, 0, 0}, {5, 1, 7, 0}, {5, 1, 8, 0}, {6, 1, 7, 0}, {6, 1, 8, 0}, {7, 1, 7, 0}, {7, 1, 8, 0}, {8, 1, 7, 0}, {8, 1, 8, 0}, {9, 1, 6, 0}, {9, 1, 7, 0}, {9, 1, 8, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvw : new int[][]{{7, 1, -1}, {8, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3;
                int v = 2;
                int w = 4;
                int s = random.nextInt(15);
                if (s <= 2) {
                    u = 2;
                    w = s + 3;
                } else if (s <= 5) {
                    u = 3;
                    w = s - 1;
                } else if (s <= 9) {
                    u = 4;
                    w = s - 4;
                } else if (s <= 12) {
                    u = s - 4;
                    w = 2;
                } else if (s <= 14) {
                    u = s - 7;
                    w = 1;
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class SnowyToolSmith1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 1;
        private int averageGroundLevel = -1;

        public SnowyToolSmith1() {
        }

        public SnowyToolSmith1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyToolSmith1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyToolSmith1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyToolSmith1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 1 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 1)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (String)new int[][]{{1, 1, 1, 1, 4, 1}, {2, 1, 1, 2, 1, 1}, {2, 5, 1, 2, 6, 1}, {3, 1, 1, 3, 4, 1}, {2, 1, 6, 4, 3, 6}, {5, 1, 6, 5, 4, 6}, {1, 1, 6, 1, 4, 6}, {2, 5, 6, 4, 6, 6}, {3, 7, 6, 3, 7, 6}, {1, 1, 2, 1, 3, 5}, {3, 1, 2, 3, 3, 3}, {4, 1, 3, 5, 3, 3}, {5, 1, 4, 5, 3, 5}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(4 + (this.func_186165_e().func_176736_b() % 2 != 0 ? 4 : 0)), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogHorizAcrossState = biomeLogHorAcrossState;
            if (biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 1);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 1);
                }
            }
            for (int[] uuvvww : new int[][]{{4, 4, 3, 4, 4, 3}, {1, 4, 2, 1, 4, 2}, {1, 4, 4, 1, 4, 4}, {3, 4, 2, 3, 4, 2}, {5, 4, 4, 5, 4, 4}, {3, 4, 6, 3, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAcrossState, biomeStrippedLogHorizAcrossState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeStrippedLogHorizAlongState = biomeLogHorAlongState;
            if (biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 4, 1, 2, 4, 1}, {2, 4, 6, 2, 4, 6}, {4, 4, 6, 4, 4, 6}, {1, 4, 3, 1, 4, 3}, {1, 4, 5, 1, 4, 5}, {3, 4, 3, 3, 4, 3}, {5, 4, 5, 5, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAlongState, biomeStrippedLogHorizAlongState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 3, 0, 0, 4, 7}, {1, 5, 0, 1, 6, 7}, {2, 7, 0, 2, 7, 7}, {3, 7, 4, 4, 7, 5}, {4, 7, 6, 4, 7, 7}, {3, 8, 5, 3, 8, 7}, {3, 5, 0, 3, 6, 3}, {4, 5, 3, 5, 6, 3}, {5, 5, 4, 5, 6, 7}, {4, 3, 0, 4, 4, 2}, {5, 3, 2, 6, 4, 2}, {6, 3, 3, 6, 4, 7}, {2, 1, 2, 2, 1, 3}, {2, 1, 4, 4, 1, 5}, {4, 2, 4, 4, 2, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 5, 0}, {0, 5, 1}, {0, 5, 2}, {0, 5, 3}, {0, 5, 4}, {0, 5, 5}, {0, 5, 6}, {0, 5, 7}, {1, 7, 0}, {1, 7, 1}, {1, 7, 2}, {1, 7, 3}, {1, 7, 4}, {1, 7, 5}, {1, 7, 6}, {1, 7, 7}, {3, 7, 0}, {3, 7, 1}, {5, 7, 3}, {5, 7, 4}, {5, 7, 5}, {5, 7, 6}, {5, 7, 7}, {4, 5, 0}, {6, 5, 2}, {6, 5, 3}, {6, 5, 4}, {6, 5, 5}, {6, 5, 6}, {6, 5, 7}}) {
                this.func_175811_a(world, biomeWoodSlabBottomState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{3, 7, 7}}) {
                this.func_175811_a(world, biomeWoodSlabTopState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 1, 0, 0}, {2, 1, 0, 3}, {3, 1, 0, 1}, {3, 7, 2, 1}, {3, 7, 3, 1}, {4, 7, 3, 3}, {4, 5, 1, 1}, {4, 5, 2, 1}, {5, 5, 2, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvwo : new int[][]{{2, 6, 5}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
            for (int[] uvwo : new int[][]{{4, 3, 4}}) {
                this.func_175811_a(world, biomeSittingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState smithingTableBlockState = ModObjects.chooseModSmithingTable(3, this.func_186165_e());
            for (int[] uvw : new int[][]{{4, 2, 5}}) {
                this.func_175811_a(world, smithingTableBlockState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{2, 2, 1, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 0, 0}, {0, 1, 1, 0}, {0, 1, 2, 0}, {0, 1, 3, 0}, {0, 1, 4, 0}, {0, 1, 5, 0}, {0, 1, 6, 0}, {0, 1, 7, 0}, {1, 1, 7, 0}, {2, 1, 7, 0}, {3, 1, 7, 0}, {4, 1, 1, 0}, {4, 1, 2, 0}, {5, 1, 0, 0}, {5, 1, 1, 0}, {5, 1, 2, 0}, {5, 1, 7, 0}, {6, 1, 0, 0}, {6, 1, 1, 0}, {6, 1, 2, 0}, {6, 1, 3, 0}, {6, 1, 4, 0}, {6, 1, 5, 0}, {6, 1, 6, 0}, {6, 1, 7, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 1, -1}, {2, 1, -1}, {3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 2;
                int v = 2;
                int w = 5;
                int s = random.nextInt(6);
                if (s <= 3) {
                    u = 2;
                    w = s + 2;
                } else {
                    u = 3;
                    w = s;
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 3, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class SnowyTemple1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 15;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowyTemple1() {
        }

        public SnowyTemple1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyTemple1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)15, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyTemple1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyTemple1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeLogVertState;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeStrippedWoodOrLogOrLogVerticState = biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedWoodState(biomeLogVertState, 0);
            if (biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150364_r || biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (String)new int[][]{{1, 1, 1, 1, 3, 1}, {2, 1, 1, 2, 5, 1}, {3, 4, 1, 3, 6, 1}, {4, 1, 1, 4, 5, 1}, {5, 1, 1, 5, 3, 1}, {1, 1, 7, 1, 3, 7}, {2, 1, 7, 4, 5, 7}, {3, 6, 7, 3, 6, 7}, {5, 1, 7, 5, 3, 7}, {1, 1, 2, 1, 1, 6}, {5, 1, 2, 5, 1, 6}, {2, 6, 3, 2, 11, 3}, {4, 6, 3, 4, 11, 3}, {2, 6, 5, 2, 11, 5}, {4, 6, 5, 4, 11, 5}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedWoodOrLogOrLogVerticState, biomeStrippedWoodOrLogOrLogVerticState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(4 + (this.func_186165_e().func_176736_b() % 2 != 0 ? 4 : 0)), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogHorizAcrossState = biomeLogHorAcrossState;
            if (biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 1);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 1);
                }
            }
            for (int[] uuvvww : new int[][]{{3, 1, 1, 3, 1, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAcrossState, biomeStrippedLogHorizAcrossState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 2, 0, 0, 3, 8}, {1, 4, 0, 1, 5, 8}, {2, 6, 0, 2, 6, 2}, {2, 6, 4, 2, 6, 4}, {2, 6, 6, 2, 6, 8}, {3, 7, 0, 3, 7, 8}, {4, 6, 0, 4, 6, 2}, {4, 6, 4, 4, 6, 4}, {4, 6, 6, 4, 6, 8}, {5, 4, 0, 5, 5, 8}, {6, 2, 0, 6, 3, 8}, {1, 11, 2, 5, 11, 2}, {1, 11, 3, 1, 11, 5}, {5, 11, 3, 5, 11, 5}, {1, 11, 6, 5, 11, 6}, {2, 12, 3, 4, 12, 5}, {3, 13, 4, 3, 13, 4}, {2, 1, 2, 4, 1, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 2, 2, 1}, {1, 2, 3, 1}, {1, 2, 4, 1}, {1, 2, 5, 1}, {1, 2, 6, 1}, {5, 2, 2, 0}, {5, 2, 3, 0}, {5, 2, 4, 0}, {5, 2, 5, 0}, {5, 2, 6, 0}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{3, 4, 0, 2}, {3, 8, 4, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 6, 2, 3, 6, 2}, {3, 6, 6, 3, 6, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvwo : new int[][]{{3, 5, 2}, {3, 5, 6}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 2, 6}}) {
                this.func_175811_a(world, Blocks.field_150382_bo.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 2, 1, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeSnowState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150433_aE.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 0, 2, 1, 0}, {5, 1, 0, 5, 1, 0}, {1, 1, 9, 2, 1, 9}, {2, 1, 8, 4, 2, 8}, {3, 3, 8, 3, 3, 8}, {4, 1, 9, 4, 1, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSnowState, biomeSnowState, false);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 0, 2}, {0, 1, 1, 0}, {0, 1, 2, 0}, {0, 1, 3, 0}, {0, 1, 4, 0}, {0, 1, 5, 0}, {0, 1, 6, 0}, {0, 1, 7, 0}, {0, 1, 8, 0}, {0, 1, 9, 0}, {1, 1, 0, 4}, {1, 1, 8, 6}, {1, 2, 9, 0}, {2, 2, 0, 4}, {2, 3, 8, 0}, {2, 2, 9, 1}, {3, 1, 9, 3}, {4, 1, 0, 5}, {4, 2, 9, 0}, {5, 1, 8, 5}, {5, 1, 9, 1}, {6, 1, 0, 4}, {6, 1, 1, 3}, {6, 1, 2, 0}, {6, 1, 3, 0}, {6, 1, 4, 0}, {6, 1, 5, 0}, {6, 1, 8, 3}, {6, 1, 9, 0}, {0, 4, 0, 2}, {0, 4, 1, 0}, {0, 4, 2, 0}, {0, 4, 3, 0}, {0, 4, 4, 0}, {0, 4, 5, 0}, {0, 4, 6, 0}, {0, 4, 7, 0}, {0, 4, 8, 0}, {1, 6, 0, 0}, {1, 6, 1, 2}, {1, 6, 5, 2}, {1, 6, 6, 2}, {1, 6, 7, 2}, {1, 6, 8, 2}, {2, 7, 0, 1}, {2, 7, 1, 4}, {2, 7, 2, 2}, {2, 7, 7, 0}, {2, 7, 8, 0}, {3, 8, 0, 1}, {3, 8, 1, 0}, {4, 7, 0, 0}, {4, 7, 1, 1}, {4, 7, 2, 0}, {4, 7, 7, 3}, {4, 7, 8, 1}, {5, 6, 0, 0}, {5, 6, 1, 0}, {5, 6, 3, 0}, {5, 6, 4, 2}, {5, 6, 7, 1}, {5, 6, 8, 2}, {6, 4, 0, 0}, {6, 4, 1, 0}, {6, 4, 2, 0}, {6, 4, 3, 0}, {6, 4, 4, 0}, {6, 4, 5, 3}, {6, 4, 6, 1}, {6, 4, 7, 0}, {6, 4, 8, 0}, {1, 12, 2, 0}, {1, 12, 3, 0}, {1, 12, 4, 0}, {1, 12, 5, 0}, {1, 12, 6, 0}, {2, 12, 2, 0}, {2, 13, 3, 0}, {2, 13, 4, 0}, {2, 13, 5, 0}, {2, 12, 6, 0}, {3, 12, 2, 0}, {3, 13, 3, 0}, {3, 14, 4, 0}, {3, 13, 5, 0}, {3, 12, 6, 0}, {4, 12, 2, 0}, {4, 13, 3, 0}, {4, 13, 4, 0}, {4, 13, 5, 0}, {4, 12, 6, 0}, {5, 12, 2, 0}, {5, 12, 3, 0}, {5, 12, 4, 0}, {5, 12, 5, 0}, {5, 12, 6, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3;
                int v = 2;
                int w = 6;
                while (u == 4 && (w == 3 || w == 6)) {
                    u = 2 + random.nextInt(3);
                    w = 2 + random.nextInt(5);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 2, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 2;
        }
    }

    public static class SnowyTannery1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 10;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowyTannery1() {
        }

        public SnowyTannery1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyTannery1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)10, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyTannery1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyTannery1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (String)new int[][]{{1, 2, 1, 1, 3, 1}, {2, 1, 1, 2, 1, 1}, {2, 3, 1, 2, 5, 1}, {3, 1, 1, 3, 2, 1}, {3, 5, 1, 3, 5, 1}, {4, 1, 1, 4, 1, 1}, {5, 1, 1, 5, 2, 1}, {5, 5, 1, 5, 5, 1}, {6, 1, 1, 6, 1, 1}, {6, 3, 1, 6, 5, 1}, {7, 2, 1, 7, 3, 1}, {1, 1, 6, 1, 3, 6}, {2, 1, 6, 2, 3, 6}, {2, 5, 6, 2, 5, 6}, {3, 1, 6, 3, 2, 6}, {3, 6, 6, 3, 6, 6}, {4, 1, 6, 4, 3, 6}, {4, 5, 6, 4, 7, 6}, {5, 1, 6, 5, 2, 6}, {5, 6, 6, 5, 6, 6}, {6, 1, 6, 6, 3, 6}, {6, 5, 6, 6, 5, 6}, {7, 1, 6, 7, 3, 6}, {1, 1, 2, 1, 3, 5}, {7, 1, 2, 7, 3, 5}, {2, 1, 2, 2, 1, 5}, {3, 1, 2, 5, 1, 2}, {6, 1, 2, 6, 1, 5}, {4, 2, 5, 4, 2, 5}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeStrippedLogHorizAlongState = biomeLogHorAlongState;
            if (biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 1, 1, 1, 1, 1}, {2, 2, 1, 2, 2, 1}, {3, 3, 1, 3, 3, 1}, {3, 4, 1, 5, 4, 1}, {4, 5, 1, 4, 5, 1}, {3, 6, 1, 5, 6, 1}, {4, 7, 1, 4, 7, 1}, {5, 3, 1, 5, 3, 1}, {6, 2, 1, 6, 2, 1}, {7, 1, 1, 7, 1, 1}, {3, 3, 6, 3, 3, 6}, {5, 3, 6, 5, 3, 6}, {2, 4, 6, 2, 4, 6}, {4, 4, 6, 4, 4, 6}, {6, 4, 6, 6, 4, 6}, {3, 5, 6, 3, 5, 6}, {5, 5, 6, 5, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAlongState, biomeStrippedLogHorizAlongState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 2, 1, 0, 2, 2}, {0, 2, 5, 0, 2, 6}, {0, 3, 0, 0, 3, 7}, {1, 4, 0, 1, 5, 7}, {2, 6, 0, 2, 6, 7}, {3, 7, 0, 3, 7, 7}, {4, 8, 0, 4, 8, 7}, {5, 7, 0, 5, 7, 7}, {6, 6, 0, 6, 6, 7}, {7, 4, 0, 7, 5, 7}, {8, 3, 0, 8, 3, 7}, {8, 2, 1, 8, 2, 2}, {8, 2, 5, 8, 2, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 4, 0}, {2, 7, 0}, {3, 8, 0}, {5, 8, 0}, {6, 7, 0}, {8, 4, 0}, {0, 4, 7}, {2, 7, 7}, {3, 8, 7}, {5, 8, 7}, {6, 7, 7}, {8, 4, 7}}) {
                this.func_175811_a(world, biomeWoodSlabBottomState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 2, 0}, {0, 2, 3}, {0, 2, 4}, {0, 2, 7}, {2, 5, 0}, {6, 5, 0}, {8, 2, 0}, {8, 2, 3}, {8, 2, 4}, {8, 2, 7}}) {
                this.func_175811_a(world, biomeWoodSlabTopState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 4, 6}, {5, 4, 6}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] nArray : new int[][]{{4, 1, 0, 3}, {2, 2, 4, 1}, {2, 2, 5, 1}, {3, 8, 3, 3}, {3, 8, 4, 0}, {3, 8, 5, 2}, {5, 8, 3, 3}, {5, 8, 4, 1}, {5, 8, 5, 2}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(nArray[3] % 4 + nArray[3] / 4 * 4), nArray[0], nArray[1], nArray[2], structureBB);
            }
            for (int[] nArray : new int[][]{{4, 5, 2, 0}, {4, 5, 5, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(nArray[3])), nArray[0], nArray[1], nArray[2], structureBB);
            }
            IBlockState dioriteBlockState = Blocks.field_150348_b.func_176203_a(3);
            Block dioriteStairsBlock = ModObjects.chooseModDioriteStairsBlock();
            IBlockState dioriteWallState = ModObjects.chooseModDioriteWallState();
            if (dioriteStairsBlock == null || dioriteWallState == null) {
                dioriteBlockState = Blocks.field_150347_e.func_176203_a(0);
                dioriteStairsBlock = Blocks.field_150446_ar;
                dioriteWallState = Blocks.field_150463_bK.func_176223_P();
            }
            for (int[] uuvvww : new int[][]{{3, 1, 3, 5, 1, 5}, {4, 8, 4, 4, 8, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], dioriteBlockState, dioriteBlockState, false);
            }
            for (int[] uuvvww : new int[][]{{4, 3, 4, 4, 7, 4}, {4, 9, 4, 4, 9, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], dioriteWallState, dioriteWallState, false);
            }
            for (int[] uvwo : new int[][]{{4, 2, 4, 2}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            IBlockState iBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 5, 0, 4, 5, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], iBlockState, iBlockState, false);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvwo : new int[][]{{4, 4, 0}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            int chestU = 6;
            int chestV = 2;
            int chestW = 5;
            int chestO = 2;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_tannery");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (Object uuvvww : (ChestGenHooks)new int[][]{{2, 2, 2}, {6, 2, 2}}) {
                this.func_175811_a(world, Blocks.field_150383_bp.func_176203_a(3), (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 2, 1, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeSnowState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150433_aE.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 0, 0, 1, 0}, {0, 1, 4, 0, 1, 4}, {5, 1, 0, 5, 1, 0}, {6, 1, 0, 6, 2, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSnowState, biomeSnowState, false);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 1, 4}, {0, 1, 2, 0}, {0, 1, 3, 3}, {0, 1, 5, 3}, {0, 1, 6, 0}, {0, 1, 7, 0}, {1, 1, 0, 4}, {1, 1, 7, 0}, {2, 1, 0, 0}, {2, 1, 7, 0}, {3, 1, 0, 4}, {5, 1, 7, 0}, {6, 1, 7, 0}, {7, 1, 0, 5}, {7, 1, 7, 0}, {8, 1, 0, 0}, {8, 1, 1, 0}, {8, 1, 2, 0}, {8, 1, 3, 0}, {8, 1, 4, 0}, {8, 1, 5, 0}, {8, 1, 6, 0}, {8, 1, 7, 0}, {0, 4, 1, 7}, {0, 4, 2, 0}, {0, 4, 4, 3}, {1, 6, 0, 2}, {2, 7, 2, 3}, {7, 6, 1, 3}, {7, 6, 2, 7}, {7, 6, 3, 1}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvwg : new int[][]{{3, 1, 7, 0}, {4, 1, 7, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{4, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 4;
                int v = 2;
                int w = 4;
                while (u == 4 && (w == 4 || w == 5)) {
                    u = 3 + random.nextInt(3);
                    w = 2 + random.nextInt(4);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 4, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 4;
        }
    }

    public static class SnowySmallHouse8
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowySmallHouse8() {
        }

        public SnowySmallHouse8(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowySmallHouse8 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowySmallHouse8.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowySmallHouse8(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uvwm : new int[][]{{2, 0, 0}, {1, 0, 1}, {2, 0, 1}, {3, 0, 1}, {1, 0, 2}, {2, 0, 2}, {3, 0, 2}, {1, 0, 3}, {2, 0, 3}, {3, 0, 3}}) {
                this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor4 : 8), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 1, 2, 1, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            for (int[] uvwo : new int[][]{{1, 2, 2, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeSnowState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150433_aE.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 0, 3, 3, 0}, {1, 1, 4, 3, 3, 4}, {2, 3, 4, 2, 3, 4}, {2, 1, 5, 2, 2, 5}, {0, 1, 1, 0, 2, 3}, {4, 1, 1, 4, 2, 3}, {1, 3, 1, 3, 3, 3}, {2, 4, 1, 2, 4, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSnowState, biomeSnowState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 1, 1, 2}, {1, 1, 3, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{3, 1, 2, 2, GeneralConfig.useVillageColors ? this.townColor3 : 0}}) {
                boolean[] blArray = new boolean[]{false, true};
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean isHead = blArray[i];
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{2, 1, 0, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{2, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{2, 1, 2, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SnowySmallHouse7
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowySmallHouse7() {
        }

        public SnowySmallHouse7(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowySmallHouse7 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowySmallHouse7.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowySmallHouse7(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (String)new int[][]{{1, 1, 1, 2, 3, 1}, {3, 1, 1, 3, 1, 1}, {4, 1, 1, 5, 3, 1}, {2, 4, 1, 4, 4, 1}, {3, 5, 1, 3, 5, 1}, {1, 1, 4, 1, 3, 4}, {2, 1, 4, 2, 2, 4}, {2, 4, 4, 2, 4, 4}, {3, 1, 4, 3, 1, 4}, {3, 5, 4, 3, 5, 4}, {4, 1, 4, 4, 2, 4}, {4, 4, 4, 4, 4, 4}, {5, 1, 4, 5, 3, 4}, {1, 1, 2, 1, 3, 3}, {5, 1, 2, 5, 3, 3}, {2, 1, 2, 4, 1, 3}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeStrippedLogHorizAlongState = biomeLogHorAlongState;
            if (biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
                }
            }
            for (int[] uuvvww : new int[][]{{3, 2, 4, 3, 2, 4}, {2, 3, 4, 2, 3, 4}, {4, 3, 4, 4, 3, 4}, {3, 4, 4, 3, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAlongState, biomeStrippedLogHorizAlongState, false);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvwo : new int[][]{{3, 5, 3}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 0, 1, 1, 0}, {5, 1, 0, 5, 1, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
            for (int[] uvwo : new int[][]{{1, 2, 0}, {5, 2, 0}}) {
                this.func_175811_a(world, biomeSittingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 3, 0, 0, 3, 5}, {1, 4, 0, 1, 4, 5}, {2, 5, 0, 2, 5, 5}, {3, 6, 0, 3, 6, 5}, {4, 5, 0, 4, 5, 5}, {5, 4, 0, 5, 4, 5}, {6, 3, 0, 6, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 4, 0}, {0, 4, 2}, {0, 4, 3}, {0, 4, 5}, {1, 5, 0}, {1, 5, 2}, {1, 5, 3}, {1, 5, 5}, {2, 6, 0}, {2, 6, 2}, {2, 6, 3}, {2, 6, 5}, {3, 7, 0}, {3, 7, 2}, {3, 7, 3}, {3, 7, 5}, {4, 6, 0}, {4, 6, 2}, {4, 6, 3}, {4, 6, 5}, {5, 5, 0}, {5, 5, 2}, {5, 5, 3}, {5, 5, 5}, {6, 4, 0}, {6, 4, 2}, {6, 4, 3}, {6, 4, 5}}) {
                this.func_175811_a(world, biomeWoodSlabBottomState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 2, 0}, {0, 2, 2}, {0, 2, 3}, {0, 2, 5}, {6, 2, 0}, {6, 2, 2}, {6, 2, 3}, {6, 2, 5}}) {
                this.func_175811_a(world, biomeWoodSlabTopState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 1, 0, 0}, {3, 1, 0, 3}, {4, 1, 0, 1}, {4, 2, 2, 0}, {4, 2, 3, 0}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 2, 0}, {0, 1, 3, 0}, {0, 1, 4, 0}, {0, 1, 5, 0}, {1, 1, 5, 0}, {2, 1, 5, 0}, {4, 1, 5, 0}, {5, 1, 5, 0}, {6, 1, 2, 0}, {6, 1, 3, 0}, {6, 1, 4, 0}, {6, 1, 5, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{2, 2, 2, 2, GeneralConfig.useVillageColors ? this.townColor3 : 0}}) {
                boolean[] blArray = new boolean[]{false, true};
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean isHead = blArray[i];
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uvw : new int[][]{{3, 3, 4}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 2, 1, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{2, 1, -1}, {3, 1, -1}, {4, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 2, 2, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SnowySmallHouse6
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 10;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowySmallHouse6() {
        }

        public SnowySmallHouse6(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowySmallHouse6 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)10, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowySmallHouse6.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowySmallHouse6(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (String)new int[][]{{1, 1, 1, 1, 3, 2}, {2, 5, 1, 2, 5, 1}, {3, 6, 1, 3, 6, 1}, {4, 5, 1, 4, 5, 1}, {5, 1, 1, 5, 3, 2}, {1, 1, 4, 1, 3, 5}, {2, 1, 5, 2, 2, 5}, {2, 4, 5, 2, 5, 5}, {3, 1, 5, 3, 1, 5}, {3, 6, 5, 3, 6, 5}, {4, 1, 5, 4, 2, 5}, {4, 4, 5, 4, 5, 5}, {5, 1, 4, 5, 3, 5}, {3, 1, 1, 3, 1, 2}, {1, 1, 3, 2, 1, 3}, {4, 1, 3, 5, 1, 3}, {3, 1, 4, 3, 1, 4}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(4 + (this.func_186165_e().func_176736_b() % 2 != 0 ? 4 : 0)), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogHorizAcrossState = biomeLogHorAcrossState;
            if (biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 1);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 1);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 2, 3, 1, 3, 3}, {5, 2, 3, 5, 3, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAcrossState, biomeStrippedLogHorizAcrossState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeStrippedLogHorizAlongState = biomeLogHorAlongState;
            if (biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 1, 1, 2, 4, 1}, {3, 4, 1, 3, 5, 1}, {4, 1, 1, 4, 4, 1}, {3, 2, 5, 3, 2, 5}, {2, 3, 5, 2, 3, 5}, {4, 3, 5, 4, 3, 5}, {3, 4, 5, 3, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAlongState, biomeStrippedLogHorizAlongState, false);
            }
            for (int[] uvwo : new int[][]{{3, 5, 2, 0}, {3, 5, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvwo : new int[][]{{3, 6, 0}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 2, 0, 0, 3, 6}, {1, 4, 0, 1, 5, 6}, {2, 6, 0, 2, 6, 1}, {2, 6, 3, 2, 6, 6}, {3, 7, 0, 3, 7, 6}, {4, 6, 0, 4, 6, 6}, {5, 4, 0, 5, 5, 6}, {6, 2, 0, 6, 3, 6}, {2, 1, 2, 2, 1, 2}, {2, 1, 4, 2, 1, 4}, {3, 1, 3, 3, 1, 3}, {4, 1, 2, 4, 1, 2}, {4, 1, 4, 4, 1, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 1, 0, 0}, {3, 1, 0, 3}, {4, 1, 0, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 0, 0}, {0, 1, 1, 0}, {0, 1, 2, 0}, {0, 1, 3, 0}, {0, 1, 4, 0}, {0, 1, 5, 0}, {0, 1, 6, 0}, {1, 1, 0, 0}, {1, 1, 6, 0}, {2, 1, 6, 0}, {4, 1, 6, 0}, {5, 1, 0, 0}, {5, 1, 6, 0}, {6, 1, 0, 0}, {6, 1, 2, 0}, {6, 1, 3, 0}, {6, 1, 4, 0}, {6, 1, 5, 0}, {6, 1, 6, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvwg : new int[][]{{3, 1, 6, 0}, {6, 1, 1, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{4, 2, 3, 2, GeneralConfig.useVillageColors ? this.townColor : 11}}) {
                for (boolean bl : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (bl ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (bl ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), bl), uvwoc[4]);
                }
            }
            int chestU = 2;
            int chestV = 2;
            int chestW = 4;
            int chestO = 2;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (int[] uvw : new int[][]{{3, 3, 5}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 6, 2, 2, 6, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uvwo : new int[][]{{2, 2, 2, 1}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            IBlockState iBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 3, 2, 2, 5, 2}, {2, 7, 2, 2, 8, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], iBlockState, iBlockState, false);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 2, 1, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{2, 1, -1}, {3, 1, -1}, {4, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 2, 3, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SnowySmallHouse5
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowySmallHouse5() {
        }

        public SnowySmallHouse5(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowySmallHouse5 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowySmallHouse5.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowySmallHouse5(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeSnowState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150433_aE.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 3, 0, 2, 3, 0}, {2, 3, 5, 2, 3, 5}, {0, 1, 1, 0, 2, 4}, {0, 3, 2, 0, 3, 3}, {4, 1, 1, 4, 2, 4}, {4, 3, 2, 4, 3, 3}, {2, 4, 4, 2, 4, 4}, {1, 4, 2, 3, 4, 3}, {2, 4, 1, 2, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSnowState, biomeSnowState, false);
            }
            IBlockState biomeBlueIceBlockState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModBlueIceBlockState(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 6, 2, 2, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeBlueIceBlockState, biomeBlueIceBlockState, false);
            }
            for (int[] uvwo : new int[][]{{2, 3, 1, 0}, {2, 2, 5, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 0, 1, 2, 0}, {1, 3, 1, 1, 3, 1}, {3, 1, 0, 3, 2, 0}, {3, 3, 1, 3, 3, 1}, {1, 1, 5, 1, 2, 5}, {1, 3, 4, 1, 3, 4}, {3, 1, 5, 3, 2, 5}, {3, 3, 4, 3, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeBlueIceBlockState, biomeBlueIceBlockState, false);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 5, 0}, {0, 1, 6, 0}, {1, 1, 6, 0}, {4, 1, 5, 0}, {4, 1, 6, 0}, {3, 1, 6, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{1, 1, 3, 2, GeneralConfig.useVillageColors ? this.townColor2 : 14}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            int chestU = 3;
            int chestV = 1;
            int chestW = 4;
            int chestO = 2;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{2, 1, 0, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{2, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{2, 1, 2, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SnowySmallHouse4
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowySmallHouse4() {
        }

        public SnowySmallHouse4(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowySmallHouse4 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowySmallHouse4.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowySmallHouse4(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeSnowState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150433_aE.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 2, 1, 1, 2}, {2, 1, 1, 4, 3, 1}, {5, 1, 2, 5, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSnowState, biomeSnowState, false);
            }
            for (int[] uvwo : new int[][]{{2, 2, 2, 0}, {4, 2, 2, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvwo : new int[][]{{3, 2, 6}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 1, 7, 3, 1, 7}, {3, 2, 7, 3, 2, 7}, {2, 3, 2, 2, 3, 4}, {2, 1, 5, 2, 2, 6}, {1, 1, 2, 1, 2, 4}, {0, 1, 3, 0, 1, 3}, {4, 3, 2, 4, 3, 4}, {4, 1, 5, 4, 2, 6}, {5, 1, 1, 5, 2, 4}, {3, 3, 1, 3, 3, 1}, {3, 3, 2, 3, 4, 4}, {3, 3, 5, 3, 3, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSnowState, biomeSnowState, false);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 0, 0}, {0, 1, 1, 0}, {0, 1, 2, 5}, {0, 1, 4, 4}, {0, 1, 5, 0}, {0, 1, 6, 0}, {0, 1, 7, 0}, {1, 1, 0, 0}, {1, 1, 5, 6}, {1, 1, 6, 3}, {1, 1, 7, 0}, {2, 1, 0, 3}, {2, 4, 3, 2}, {2, 4, 4, 0}, {2, 3, 5, 0}, {2, 3, 6, 0}, {3, 4, 6, 0}, {3, 3, 7, 0}, {4, 4, 1, 0}, {4, 3, 5, 0}, {4, 3, 6, 0}, {4, 1, 7, 0}, {5, 1, 0, 0}, {5, 2, 1, 1}, {5, 3, 2, 0}, {5, 3, 3, 0}, {5, 3, 4, 0}, {5, 1, 5, 0}, {5, 1, 6, 5}, {5, 1, 7, 0}, {6, 1, 0, 0}, {6, 1, 1, 0}, {6, 1, 2, 0}, {6, 1, 3, 4}, {6, 1, 4, 0}, {6, 1, 5, 0}, {6, 1, 6, 0}, {6, 1, 7, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 1, 2, 0}, {4, 1, 4, 0}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{4, 1, 3, 3}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            for (int[] uvwoc : new int[][]{{2, 1, 3, 2, GeneralConfig.useVillageColors ? this.townColor3 : 0}}) {
                boolean[] blArray = new boolean[]{false, true};
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean isHead = blArray[i];
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 1, 4, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SnowySmallHouse3
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 1;
        private int averageGroundLevel = -1;

        public SnowySmallHouse3() {
        }

        public SnowySmallHouse3(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowySmallHouse3 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowySmallHouse3.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowySmallHouse3(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeLogVertState;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 1 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 1)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeStrippedWoodOrLogOrLogVerticState = biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedWoodState(biomeLogVertState, 0);
            if (biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150364_r || biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (String)new int[][]{{1, 1, 2, 1, 3, 2}, {4, 1, 2, 4, 3, 2}, {2, 4, 2, 3, 5, 2}, {1, 1, 5, 4, 2, 5}, {2, 3, 5, 3, 4, 5}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedWoodOrLogOrLogVerticState, biomeStrippedWoodOrLogOrLogVerticState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeStrippedLogHorizAlongState = biomeLogHorAlongState;
            if (biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 1, 2, 3, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAlongState, biomeStrippedLogHorizAlongState, false);
            }
            for (int[] uvwo : new int[][]{{2, 4, 3, 0}, {3, 4, 3, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 1, 0, 2, 6}, {1, 4, 1, 1, 4, 6}, {2, 5, 3, 3, 5, 6}, {4, 4, 1, 4, 4, 6}, {5, 1, 1, 5, 2, 6}, {1, 1, 3, 1, 3, 4}, {1, 3, 5, 1, 3, 6}, {4, 1, 3, 4, 1, 4}, {4, 3, 3, 4, 3, 4}, {4, 3, 5, 4, 3, 6}, {2, 1, 3, 3, 1, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 6, 1}, {2, 6, 2}, {2, 6, 3}, {2, 6, 4}, {2, 6, 5}, {2, 6, 6}, {3, 6, 1}, {3, 6, 2}, {3, 6, 3}, {3, 6, 4}, {3, 6, 5}, {3, 6, 6}}) {
                this.func_175811_a(world, biomeWoodSlabBottomState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 1, 1, 3}, {3, 1, 1, 3}, {0, 3, 1, 0}, {1, 3, 1, 5}, {1, 5, 1, 0}, {2, 5, 1, 5}, {3, 5, 1, 4}, {4, 5, 1, 1}, {4, 3, 1, 4}, {5, 3, 1, 1}, {0, 3, 2, 0}, {1, 5, 2, 0}, {4, 5, 2, 1}, {5, 3, 2, 1}, {0, 3, 5, 0}, {1, 5, 5, 0}, {4, 5, 5, 1}, {5, 3, 5, 1}, {0, 3, 6, 0}, {1, 5, 6, 0}, {2, 5, 6, 5}, {3, 5, 6, 4}, {4, 5, 6, 1}, {5, 3, 6, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 0, 1, 4, 0}, {4, 4, 0, 4, 4, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvwo : new int[][]{{1, 3, 0}, {4, 3, 0}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeSnowState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150433_aE.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 1, 0, 5, 1, 0}, {4, 1, 1, 6, 1, 1}, {6, 1, 2, 6, 2, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSnowState, biomeSnowState, false);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{4, 2, 1, 3}, {5, 2, 0, 3}, {6, 2, 1, 0}, {6, 3, 2, 0}, {0, 3, 3, 0}, {0, 3, 4, 0}, {1, 5, 3, 0}, {1, 5, 4, 0}, {4, 5, 3, 0}, {4, 5, 4, 3}, {5, 3, 3, 3}, {5, 3, 4, 1}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{2, 2, 3, 2, GeneralConfig.useVillageColors ? this.townColor : 11}}) {
                boolean[] blArray = new boolean[]{false, true};
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean isHead = blArray[i];
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uvwo : new int[][]{{4, 2, 3, 3}, {4, 2, 4, 3}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{2, 2, 2, 2, 1, 1}, {3, 2, 2, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{1, 1, -1}, {2, 1, -1}, {3, 1, -1}, {4, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 2, 4, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SnowySmallHouse2
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowySmallHouse2() {
        }

        public SnowySmallHouse2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowySmallHouse2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowySmallHouse2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowySmallHouse2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeLogVertState;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeStrippedWoodOrLogOrLogVerticState = biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedWoodState(biomeLogVertState, 0);
            if (biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150364_r || biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (String)new int[][]{{1, 1, 1, 2, 3, 1}, {4, 1, 1, 5, 3, 1}, {2, 4, 1, 4, 5, 1}, {3, 6, 1, 3, 6, 1}, {1, 1, 5, 5, 3, 5}, {2, 4, 5, 4, 5, 5}, {3, 6, 5, 3, 6, 5}, {1, 1, 2, 1, 3, 4}, {5, 1, 2, 5, 3, 4}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedWoodOrLogOrLogVerticState, biomeStrippedWoodOrLogOrLogVerticState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(4 + (this.func_186165_e().func_176736_b() % 2 != 0 ? 4 : 0)), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogHorizAcrossState = biomeLogHorAcrossState;
            if (biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 1);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 1);
                }
            }
            for (int[] uuvvww : new int[][]{{3, 1, 1, 3, 1, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAcrossState, biomeStrippedLogHorizAcrossState, false);
            }
            for (int[] uvwo : new int[][]{{3, 4, 0, 2}, {3, 5, 2, 0}, {3, 5, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 3, 0, 0, 3, 6}, {0, 2, 1, 0, 2, 1}, {0, 2, 3, 0, 2, 3}, {0, 2, 5, 0, 2, 5}, {1, 4, 0, 1, 5, 6}, {2, 6, 0, 2, 6, 3}, {2, 6, 5, 2, 6, 6}, {3, 7, 0, 3, 7, 6}, {4, 6, 0, 4, 6, 6}, {5, 4, 0, 5, 5, 6}, {6, 2, 1, 6, 2, 1}, {6, 2, 3, 6, 2, 3}, {6, 2, 5, 6, 2, 5}, {6, 3, 0, 6, 3, 6}, {2, 1, 2, 4, 1, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 4, 0}, {0, 4, 2}, {0, 4, 4}, {0, 4, 6}, {1, 6, 3}, {5, 6, 3}, {6, 4, 0}, {6, 4, 2}, {6, 4, 4}, {6, 4, 6}}) {
                this.func_175811_a(world, biomeWoodSlabBottomState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 2, 0}, {0, 2, 2}, {0, 2, 4}, {0, 2, 6}, {6, 2, 0}, {6, 2, 2}, {6, 2, 4}, {6, 2, 6}, {2, 5, 0}, {3, 6, 0}, {4, 5, 0}, {2, 5, 6}, {3, 6, 6}, {4, 5, 6}}) {
                this.func_175811_a(world, biomeWoodSlabTopState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 1, 0, 0}, {3, 1, 0, 3}, {4, 1, 0, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 0, 0}, {0, 1, 1, 0}, {0, 1, 2, 0}, {0, 1, 3, 0}, {0, 1, 4, 0}, {0, 1, 5, 0}, {0, 1, 6, 0}, {1, 1, 0, 0}, {1, 1, 6, 0}, {2, 1, 6, 0}, {3, 1, 6, 0}, {4, 1, 6, 0}, {5, 1, 0, 0}, {5, 1, 6, 0}, {6, 1, 0, 0}, {6, 1, 1, 0}, {6, 1, 2, 0}, {6, 1, 3, 0}, {6, 1, 4, 0}, {6, 1, 5, 0}, {6, 1, 6, 0}, {0, 4, 1, 0}, {0, 4, 3, 0}, {0, 4, 5, 0}, {1, 6, 0, 0}, {1, 6, 1, 0}, {1, 6, 2, 0}, {1, 6, 5, 0}, {1, 6, 6, 0}, {2, 7, 0, 0}, {2, 7, 1, 0}, {2, 7, 2, 0}, {2, 7, 3, 0}, {2, 7, 5, 0}, {2, 7, 6, 0}, {3, 8, 0, 0}, {3, 8, 1, 0}, {3, 8, 2, 0}, {3, 8, 3, 0}, {3, 8, 4, 0}, {3, 8, 5, 0}, {3, 8, 6, 0}, {4, 7, 0, 0}, {4, 7, 1, 0}, {4, 7, 2, 0}, {4, 7, 3, 0}, {4, 7, 4, 0}, {4, 7, 5, 0}, {4, 7, 6, 0}, {5, 6, 0, 0}, {5, 6, 1, 0}, {5, 6, 2, 0}, {5, 6, 4, 0}, {5, 6, 5, 0}, {5, 6, 6, 0}, {6, 4, 1, 0}, {6, 4, 3, 0}, {6, 4, 5, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{4, 2, 3, 2, GeneralConfig.useVillageColors ? this.townColor : 11}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uvw : new int[][]{{1, 4, 3}, {3, 4, 5}, {5, 4, 3}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 3, 2, 1, 3}, {2, 6, 4, 2, 6, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uvwo : new int[][]{{2, 2, 4, 2}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 3, 4, 2, 5, 4}, {2, 7, 4, 2, 8, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 2, 1, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{2, 1, -1}, {3, 1, -1}, {4, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 2, 3, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SnowySmallHouse1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowySmallHouse1() {
        }

        public SnowySmallHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowySmallHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowySmallHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowySmallHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (String)new int[][]{{2, 1, 4, 2, 1, 4}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            for (Object uvwo : (String)new int[][]{{2, 2, 4, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta((int)uvwo[3])), (int)uvwo[0], (int)uvwo[1], (int)uvwo[2], structureBB);
            }
            IBlockState biomePackedIceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150403_cj.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 1, 4, 3, 1}, {2, 1, 5, 4, 3, 5}, {1, 1, 2, 1, 3, 4}, {5, 1, 2, 5, 3, 4}, {2, 4, 2, 4, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePackedIceState, biomePackedIceState, false);
            }
            IBlockState biomeSnowState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150433_aE.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 1, 1, 5, 1, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSnowState, biomeSnowState, false);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 1, 2}, {0, 1, 2, 4}, {0, 1, 3, 0}, {0, 1, 4, 0}, {0, 1, 5, 0}, {1, 1, 0, 0}, {1, 1, 1, 4}, {1, 1, 5, 0}, {2, 1, 0, 1}, {4, 1, 0, 5}, {5, 1, 0, 2}, {5, 2, 1, 1}, {5, 1, 5, 0}, {6, 1, 0, 0}, {6, 1, 1, 4}, {6, 1, 2, 0}, {6, 1, 3, 0}, {6, 1, 4, 0}, {6, 1, 5, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvwg : new int[][]{{0, 1, 0, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{4, 1, 4, 1, GeneralConfig.useVillageColors ? this.townColor : 11}}) {
                boolean[] blArray = new boolean[]{false, true};
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean isHead = blArray[i];
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uvw : new int[][]{{1, 2, 3}, {5, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 1, 3, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SnowyShepherdsHouse1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 5;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowyShepherdsHouse1() {
        }

        public SnowyShepherdsHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyShepherdsHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyShepherdsHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyShepherdsHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 5 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 5), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (String)new int[][]{{0, 1, 0, 5, 1, 0}, {0, 1, 0, 0, 1, 3}, {6, 1, 1, 6, 3, 3}, {7, 1, 1, 7, 1, 1}, {8, 1, 1, 8, 3, 3}, {1, 1, 4, 5, 3, 4}, {1, 1, 7, 8, 3, 7}, {7, 4, 7, 7, 4, 7}, {1, 1, 5, 1, 4, 6}, {8, 1, 2, 8, 3, 6}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(4 + (this.func_186165_e().func_176736_b() % 2 != 0 ? 4 : 0)), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogHorizAcrossState = biomeLogHorAcrossState;
            if (biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 1);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 1);
                }
            }
            for (int[] uuvvww : new int[][]{{7, 4, 1, 7, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAcrossState, biomeStrippedLogHorizAcrossState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 2, 0, 5, 3, 0}, {6, 4, 0, 6, 4, 8}, {7, 5, 0, 7, 5, 8}, {8, 4, 0, 8, 4, 8}, {9, 2, 0, 9, 3, 8}, {0, 2, 3, 0, 3, 3}, {0, 4, 4, 5, 4, 4}, {0, 5, 5, 6, 5, 6}, {0, 4, 7, 5, 4, 7}, {0, 2, 8, 5, 3, 8}, {2, 1, 5, 7, 1, 6}, {6, 1, 4, 7, 1, 4}, {7, 1, 2, 7, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{5, 4, 0}, {5, 4, 1}, {5, 4, 2}, {5, 4, 3}, {4, 4, 3}, {3, 4, 3}, {2, 4, 3}, {1, 4, 3}, {0, 4, 3}, {6, 5, 0}, {8, 5, 0}, {6, 5, 8}, {8, 5, 8}, {9, 4, 0}, {5, 4, 8}, {9, 4, 8}, {0, 5, 4}, {0, 5, 7}, {0, 4, 8}}) {
                this.func_175811_a(world, biomeWoodSlabBottomState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{7, 1, 0, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 2, 0, 0, 2, 2}, {1, 2, 0, 4, 2, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 1, 5, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{8, 1, 0, 0}, {9, 1, 0, 0}, {9, 1, 1, 0}, {9, 1, 2, 0}, {9, 1, 3, 0}, {9, 1, 4, 0}, {9, 1, 5, 0}, {9, 1, 6, 0}, {9, 1, 7, 0}, {9, 1, 8, 0}, {0, 1, 8, 0}, {1, 1, 8, 0}, {2, 1, 8, 0}, {3, 1, 8, 0}, {4, 1, 8, 0}, {5, 1, 8, 0}, {6, 1, 8, 0}, {7, 1, 8, 0}, {0, 1, 4, 0}, {0, 1, 5, 0}, {0, 1, 6, 0}, {0, 1, 7, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvwg : new int[][]{{8, 1, 8, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{7, 3, 5, 3}, {3, 3, 6, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvwo : new int[][]{{7, 4, 0}, {5, 3, 2}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
            for (int[] uvwo : new int[][]{{0, 3, 0}}) {
                this.func_175811_a(world, biomeSittingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            int chestU = 7;
            int chestV = 2;
            int chestW = 6;
            int chestO = 2;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_shepherd");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            IBlockState loomState = ModObjects.chooseModLoom(1, this.func_186165_e());
            for (int[] uvw : new int[][]{{2, 2, 5}, {2, 2, 6}}) {
                this.func_175811_a(world, loomState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 2, 4, 2, 1, 0}, {7, 2, 1, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{6, 1, -1}, {7, 1, -1}, {8, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3;
                int v = 2;
                int w = 6;
                int s = random.nextInt(13);
                if (s <= 3) {
                    u = s + 3;
                    w = 6;
                } else if (s <= 8) {
                    u = s - 1;
                    w = 5;
                } else if (s <= 10) {
                    u = s - 3;
                    w = 4;
                } else if (s <= 12) {
                    u = 7;
                    w = s - 9;
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 3, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
                for (int[] uvw : new int[][]{{2, 3, 1}}) {
                    EntitySheep animal = new EntitySheep(world);
                    IEntityLivingData ientitylivingdata = animal.func_180482_a(world.func_175649_E(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2]))), null);
                    animal.func_70012_b((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)animal);
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SnowyMediumHouse3
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowyMediumHouse3() {
        }

        public SnowyMediumHouse3(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyMediumHouse3 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyMediumHouse3.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyMediumHouse3(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomePackedIceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150403_cj.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 0, 4, 3, 0}, {2, 1, 4, 4, 3, 4}, {0, 1, 2, 0, 3, 2}, {1, 3, 2, 1, 3, 2}, {6, 1, 2, 6, 3, 2}, {5, 3, 2, 5, 3, 2}, {2, 3, 1, 2, 3, 3}, {4, 3, 1, 4, 3, 3}, {3, 4, 2, 3, 4, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePackedIceState, biomePackedIceState, false);
            }
            IBlockState biomeBlueIceBlockState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModBlueIceBlockState(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 0, 1, 2, 0}, {5, 1, 0, 5, 2, 0}, {1, 1, 4, 1, 2, 4}, {5, 1, 4, 5, 2, 4}, {0, 1, 1, 0, 2, 1}, {0, 1, 3, 0, 2, 3}, {6, 1, 1, 6, 2, 1}, {6, 1, 3, 6, 2, 3}, {1, 3, 1, 1, 3, 1}, {1, 3, 3, 1, 3, 3}, {5, 3, 1, 5, 3, 1}, {5, 3, 3, 5, 3, 3}, {2, 4, 2, 2, 4, 2}, {4, 4, 2, 4, 4, 2}, {3, 4, 1, 3, 4, 1}, {3, 4, 3, 3, 4, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeBlueIceBlockState, biomeBlueIceBlockState, false);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 0, 0}, {0, 1, 4, 0}, {6, 1, 0, 0}, {6, 1, 4, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{1, 2, 2, 1}, {5, 2, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{1, 1, 2, 2, GeneralConfig.useVillageColors ? this.townColor : 11}, {5, 1, 2, 2, GeneralConfig.useVillageColors ? this.townColor : 11}}) {
                boolean[] blArray = new boolean[]{false, true};
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean isHead = blArray[i];
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uvwo : new int[][]{{3, 1, 3, 2}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 0, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{2, 1, 2, -1, 0}, {4, 1, 2, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SnowyMediumHouse2
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{" FFFFFFFFFFFFF", "FFFFFFFFFFFFFF", " FFFFFFFFFFFFF", "FFFFFFFFFFFFFF", " FFFFFFFFFFFFF", "FFFFFFFFFFFFFF", " FFFFFFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 10;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 1;
        private int averageGroundLevel = -1;

        public SnowyMediumHouse2() {
        }

        public SnowyMediumHouse2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyMediumHouse2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)10, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyMediumHouse2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyMediumHouse2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeLogVertState;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 1 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 1)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeStrippedWoodOrLogOrLogVerticState = biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedWoodState(biomeLogVertState, 0);
            if (biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150364_r || biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (String)new int[][]{{2, 1, 1, 3, 3, 1}, {5, 1, 1, 7, 3, 1}, {9, 1, 1, 10, 3, 1}, {2, 4, 1, 10, 5, 1}, {2, 1, 4, 10, 5, 4}, {2, 1, 2, 2, 7, 3}, {10, 1, 2, 10, 7, 3}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedWoodOrLogOrLogVerticState, biomeStrippedWoodOrLogOrLogVerticState, false);
            }
            for (Object uvwo : (String)new int[][]{{6, 3, 3, 2}, {8, 3, 3, 2}, {3, 6, 3, 1}, {3, 6, 2, 1}, {9, 6, 3, 3}, {9, 6, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta((int)uvwo[3])), (int)uvwo[0], (int)uvwo[1], (int)uvwo[2], structureBB);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeStrippedLogHorizAlongState = biomeLogHorAlongState;
            if (biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
                }
            }
            for (int[] uuvvww : new int[][]{{4, 1, 1, 4, 1, 1}, {8, 1, 1, 8, 1, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAlongState, biomeStrippedLogHorizAlongState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 5, 0, 11, 5, 0}, {2, 4, 0, 2, 4, 0}, {4, 4, 0, 4, 4, 0}, {6, 4, 0, 6, 4, 0}, {8, 4, 0, 8, 4, 0}, {10, 4, 0, 10, 4, 0}, {1, 6, 1, 11, 7, 1}, {1, 8, 2, 11, 8, 3}, {1, 6, 4, 11, 7, 4}, {2, 4, 5, 2, 4, 5}, {4, 4, 5, 4, 4, 5}, {6, 4, 5, 6, 4, 5}, {8, 4, 5, 8, 4, 5}, {10, 4, 5, 10, 4, 5}, {1, 5, 5, 11, 5, 5}, {3, 1, 2, 9, 1, 3}, {5, 2, 2, 5, 2, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 4, 0}, {3, 4, 0}, {5, 4, 0}, {7, 4, 0}, {9, 4, 0}, {11, 4, 0}, {1, 4, 5}, {3, 4, 5}, {5, 4, 5}, {7, 4, 5}, {9, 4, 5}, {11, 4, 5}, {1, 5, 1}, {1, 7, 2}, {1, 7, 3}, {1, 5, 4}, {11, 5, 1}, {11, 7, 2}, {11, 7, 3}, {11, 5, 4}, {3, 4, 3}, {4, 4, 3}, {5, 4, 3}, {6, 4, 3}, {7, 4, 3}, {8, 4, 3}, {9, 4, 3}, {3, 4, 2}, {8, 4, 2}, {9, 4, 2}}) {
                this.func_175811_a(world, biomeWoodSlabTopState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 6, 0}, {4, 6, 0}, {5, 6, 0}, {7, 6, 0}, {8, 6, 0}, {10, 6, 0}, {3, 8, 1}, {6, 8, 1}, {9, 8, 1}, {3, 8, 4}, {6, 8, 4}, {9, 8, 4}, {2, 6, 5}, {4, 6, 5}, {5, 6, 5}, {7, 6, 5}, {8, 6, 5}, {10, 6, 5}}) {
                this.func_175811_a(world, biomeWoodSlabBottomState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 1, 0, 3}, {8, 1, 0, 3}, {6, 2, 2, 1}, {5, 3, 2, 1}, {4, 4, 2, 1}, {9, 5, 2, 0}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 3, 4}, {5, 3, 4}, {7, 3, 4}, {9, 3, 4}, {3, 6, 1}, {6, 6, 1}, {9, 6, 1}, {3, 6, 4}, {6, 6, 4}, {9, 6, 4}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{9, 5, 3, 3}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            IBlockState biomeSnowState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150433_aE.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 1, 0, 6, 1, 0}, {10, 1, 0, 10, 1, 0}, {5, 1, 5, 6, 1, 5}, {6, 2, 5, 6, 2, 5}, {0, 1, 1, 0, 1, 1}, {0, 1, 3, 0, 1, 3}, {0, 1, 5, 0, 1, 5}, {1, 1, 0, 1, 1, 4}, {1, 2, 3, 1, 2, 3}, {11, 1, 1, 11, 1, 4}, {11, 2, 2, 11, 2, 2}, {12, 1, 1, 12, 1, 1}, {12, 1, 3, 12, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSnowState, biomeSnowState, false);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 2, 3, 3}, {0, 2, 5, 0}, {1, 2, 0, 0}, {1, 2, 1, 3}, {1, 2, 2, 4}, {1, 2, 4, 0}, {1, 1, 5, 3}, {1, 1, 6, 1}, {2, 1, 0, 3}, {2, 1, 5, 1}, {2, 1, 6, 0}, {3, 1, 0, 1}, {3, 1, 5, 0}, {3, 1, 6, 1}, {4, 1, 5, 4}, {4, 1, 6, 1}, {5, 1, 0, 1}, {5, 2, 5, 1}, {5, 1, 6, 3}, {6, 1, 6, 0}, {7, 1, 0, 3}, {7, 1, 5, 5}, {7, 1, 6, 2}, {8, 1, 5, 2}, {8, 1, 6, 0}, {9, 1, 0, 3}, {9, 1, 5, 0}, {9, 1, 6, 0}, {10, 1, 5, 5}, {10, 1, 6, 0}, {11, 1, 0, 3}, {11, 2, 1, 1}, {11, 2, 3, 1}, {11, 2, 4, 3}, {11, 1, 5, 1}, {11, 1, 6, 0}, {12, 1, 0, 2}, {12, 1, 2, 3}, {12, 2, 3, 0}, {12, 1, 4, 0}, {12, 1, 5, 3}, {12, 1, 6, 0}, {13, 1, 0, 0}, {13, 1, 1, 0}, {13, 1, 2, 0}, {13, 1, 3, 4}, {13, 1, 4, 0}, {13, 1, 5, 0}, {13, 1, 6, 0}, {1, 6, 0, 0}, {1, 8, 1, 0}, {1, 9, 2, 0}, {1, 9, 3, 0}, {1, 8, 4, 0}, {1, 6, 5, 0}, {2, 8, 1, 0}, {2, 9, 2, 0}, {2, 9, 3, 0}, {2, 8, 4, 0}, {3, 6, 0, 0}, {3, 9, 2, 0}, {3, 9, 3, 0}, {4, 8, 1, 0}, {4, 9, 2, 0}, {4, 9, 3, 0}, {4, 8, 4, 0}, {5, 8, 1, 0}, {5, 9, 2, 0}, {5, 9, 3, 0}, {5, 8, 4, 0}, {6, 6, 0, 0}, {6, 9, 2, 0}, {6, 9, 3, 0}, {6, 6, 5, 0}, {7, 8, 1, 0}, {7, 9, 2, 0}, {7, 9, 3, 0}, {7, 8, 4, 0}, {8, 8, 1, 0}, {8, 9, 2, 0}, {8, 9, 3, 0}, {8, 8, 4, 1}, {9, 6, 0, 0}, {9, 9, 2, 0}, {9, 9, 3, 0}, {9, 6, 5, 0}, {10, 8, 1, 0}, {10, 9, 2, 0}, {10, 9, 3, 0}, {10, 8, 4, 1}, {11, 6, 0, 0}, {11, 8, 1, 1}, {11, 9, 2, 0}, {11, 9, 3, 0}, {11, 8, 4, 0}, {11, 6, 5, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{3, 2, 2, 2, GeneralConfig.useVillageColors ? this.townColor : 11}, {9, 2, 2, 2, GeneralConfig.useVillageColors ? this.townColor2 : 14}}) {
                boolean[] blArray = new boolean[]{false, true};
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean isHead = blArray[i];
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 2, 1, 2, 1, 0}, {8, 2, 1, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{4, 1, -1}, {8, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{4, 2, 3, -1, 0}, {9, 2, 3, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SnowyMediumHouse1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowyMediumHouse1() {
        }

        public SnowyMediumHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyMediumHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyMediumHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyMediumHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeSnowState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150433_aE.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 1, 0, 5, 3, 0}, {3, 1, 6, 5, 3, 6}, {1, 1, 2, 1, 2, 4}, {2, 1, 1, 2, 3, 1}, {2, 1, 5, 2, 3, 5}, {2, 3, 2, 2, 3, 4}, {7, 1, 2, 7, 2, 4}, {6, 1, 1, 6, 3, 1}, {6, 1, 5, 6, 3, 5}, {6, 3, 2, 6, 3, 4}, {3, 4, 1, 5, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSnowState, biomeSnowState, false);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 0, 0}, {0, 1, 1, 0}, {0, 1, 2, 0}, {0, 1, 3, 0}, {0, 1, 4, 0}, {0, 1, 5, 0}, {0, 1, 6, 0}, {1, 1, 0, 0}, {1, 1, 1, 0}, {1, 3, 4, 0}, {1, 1, 5, 0}, {1, 1, 6, 0}, {2, 1, 0, 0}, {2, 4, 4, 0}, {2, 4, 5, 0}, {2, 1, 6, 0}, {3, 5, 2, 0}, {3, 5, 3, 0}, {3, 5, 4, 0}, {3, 5, 5, 0}, {3, 4, 6, 0}, {4, 4, 0, 0}, {4, 5, 1, 0}, {4, 5, 2, 0}, {4, 5, 3, 0}, {4, 5, 4, 0}, {4, 5, 5, 0}, {4, 4, 6, 0}, {5, 5, 1, 0}, {5, 5, 2, 0}, {5, 5, 3, 0}, {5, 5, 4, 0}, {5, 5, 5, 0}, {5, 4, 6, 0}, {6, 1, 0, 0}, {6, 4, 1, 0}, {6, 4, 2, 0}, {6, 4, 3, 0}, {6, 4, 4, 0}, {6, 4, 5, 0}, {6, 1, 6, 0}, {7, 1, 0, 0}, {7, 1, 1, 0}, {7, 3, 2, 0}, {7, 3, 3, 0}, {7, 3, 4, 0}, {7, 1, 5, 0}, {7, 1, 6, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvwo : new int[][]{{4, 3, 4}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{3, 1, 4, 2, GeneralConfig.useVillageColors ? this.townColor3 : 0}, {5, 1, 4, 2, GeneralConfig.useVillageColors ? this.townColor3 : 0}}) {
                boolean[] blArray = new boolean[]{false, true};
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean isHead = blArray[i];
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 1, 0, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{4, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 1, 3, -1, 0}, {5, 1, 3, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SnowyMasonsHouse2
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 11;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowyMasonsHouse2() {
        }

        public SnowyMasonsHouse2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyMasonsHouse2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)11, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyMasonsHouse2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyMasonsHouse2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeLogVertState;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeStrippedWoodOrLogOrLogVerticState = biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedWoodState(biomeLogVertState, 0);
            if (biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150364_r || biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (String)new int[][]{{3, 1, 2, 3, 4, 2}, {4, 5, 2, 4, 5, 2}, {5, 1, 2, 5, 4, 2}, {1, 1, 3, 2, 4, 3}, {6, 1, 3, 7, 4, 3}, {2, 5, 3, 2, 5, 3}, {6, 5, 3, 6, 5, 3}, {3, 6, 3, 3, 6, 3}, {5, 6, 3, 5, 6, 3}, {1, 1, 6, 2, 4, 6}, {6, 1, 6, 7, 4, 6}, {2, 5, 6, 2, 5, 6}, {6, 5, 6, 6, 5, 6}, {1, 1, 4, 1, 3, 5}, {7, 1, 4, 7, 3, 5}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedWoodOrLogOrLogVerticState, biomeStrippedWoodOrLogOrLogVerticState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(4 + (this.func_186165_e().func_176736_b() % 2 != 0 ? 4 : 0)), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogHorizAcrossState = biomeLogHorAcrossState;
            if (biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 1);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 1);
                }
            }
            for (int[] uuvvww : new int[][]{{3, 1, 1, 5, 1, 1}, {4, 1, 2, 4, 1, 2}, {3, 5, 3, 5, 5, 3}, {4, 7, 3, 4, 7, 3}, {1, 4, 4, 1, 4, 5}, {7, 4, 4, 7, 4, 5}, {3, 5, 6, 3, 6, 6}, {5, 5, 6, 5, 6, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAcrossState, biomeStrippedLogHorizAcrossState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeStrippedLogHorizAlongState = biomeLogHorAlongState;
            if (biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
                }
            }
            for (int[] uuvvww : new int[][]{{4, 4, 2, 4, 4, 2}, {4, 6, 3, 4, 6, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAlongState, biomeStrippedLogHorizAlongState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 3, 2, 0, 4, 8}, {1, 5, 2, 1, 6, 8}, {2, 6, 2, 2, 7, 8}, {3, 7, 2, 3, 8, 8}, {4, 8, 2, 4, 9, 8}, {5, 7, 2, 5, 8, 8}, {6, 6, 2, 6, 7, 8}, {7, 5, 2, 7, 6, 8}, {8, 3, 2, 8, 4, 8}, {2, 3, 0, 2, 4, 2}, {3, 5, 0, 3, 5, 2}, {4, 6, 0, 4, 6, 2}, {5, 5, 0, 5, 5, 2}, {6, 3, 0, 6, 4, 2}, {3, 1, 3, 5, 1, 4}, {2, 1, 4, 2, 1, 5}, {6, 1, 4, 6, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 5, 2}, {0, 5, 3}, {0, 5, 4}, {0, 5, 5}, {0, 5, 6}, {0, 5, 7}, {0, 5, 8}, {2, 8, 2}, {2, 8, 3}, {2, 8, 4}, {2, 8, 5}, {2, 8, 6}, {2, 8, 7}, {2, 8, 8}, {3, 9, 2}, {3, 9, 3}, {3, 9, 4}, {3, 9, 5}, {3, 9, 6}, {3, 9, 7}, {3, 9, 8}, {5, 9, 2}, {5, 9, 3}, {5, 9, 4}, {5, 9, 5}, {5, 9, 6}, {5, 9, 7}, {5, 9, 8}, {6, 8, 2}, {6, 8, 3}, {6, 8, 4}, {6, 8, 5}, {6, 8, 6}, {6, 8, 7}, {6, 8, 8}, {8, 5, 2}, {8, 5, 3}, {8, 5, 4}, {8, 5, 5}, {8, 5, 6}, {8, 5, 7}, {8, 5, 8}, {2, 5, 0}, {2, 5, 1}, {2, 5, 2}, {3, 6, 0}, {3, 6, 1}, {3, 6, 2}, {5, 6, 0}, {5, 6, 1}, {5, 6, 2}, {6, 5, 0}, {6, 5, 1}, {6, 5, 2}}) {
                this.func_175811_a(world, biomeWoodSlabBottomState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] nArray : new int[][]{{3, 1, 0, 3}, {4, 1, 0, 3}, {5, 1, 0, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(nArray[3] % 4 + nArray[3] / 4 * 4), nArray[0], nArray[1], nArray[2], structureBB);
            }
            IBlockState dioriteBlockState = Blocks.field_150348_b.func_176203_a(3);
            Block dioriteStairsBlock = ModObjects.chooseModDioriteStairsBlock();
            IBlockState dioriteWallState = ModObjects.chooseModDioriteWallState();
            if (dioriteStairsBlock == null || dioriteWallState == null) {
                dioriteBlockState = Blocks.field_150347_e.func_176203_a(0);
                dioriteStairsBlock = Blocks.field_150446_ar;
                dioriteWallState = Blocks.field_150463_bK.func_176223_P();
            }
            for (int[] uuvvww : new int[][]{{3, 1, 5, 5, 1, 7}, {3, 2, 6, 3, 2, 6}, {5, 2, 6, 5, 2, 6}, {3, 2, 7, 5, 4, 7}, {4, 5, 6, 4, 7, 7}, {4, 8, 6, 4, 9, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], dioriteBlockState, dioriteBlockState, false);
            }
            for (int[] uvwo : new int[][]{{2, 2, 5, 1}, {6, 2, 5, 0}, {6, 2, 4, 0}, {3, 5, 7, 0}, {5, 5, 7, 1}}) {
                this.func_175811_a(world, dioriteStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{4, 3, 6, 4, 4, 6}, {4, 10, 6, 4, 10, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], dioriteWallState, dioriteWallState, false);
            }
            for (int[] uvwo : new int[][]{{4, 2, 6, 2}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            IBlockState iBlockState = ModObjects.chooseModStonecutterState(1, this.func_186165_e());
            this.func_175811_a(world, iBlockState, 2, 2, 4, structureBB);
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvwo : new int[][]{{3, 4, 0}, {5, 4, 0}, {4, 7, 8}, {4, 7, 4}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
            for (int[] uvwo : new int[][]{{5, 3, 6}}) {
                this.func_175811_a(world, biomeSittingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 2, 2, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 0, 0}, {0, 1, 1, 0}, {0, 1, 2, 0}, {0, 1, 3, 0}, {0, 1, 4, 0}, {0, 1, 5, 0}, {0, 1, 6, 0}, {0, 1, 7, 0}, {0, 1, 8, 0}, {1, 1, 0, 0}, {1, 1, 1, 0}, {1, 1, 2, 0}, {1, 1, 7, 0}, {1, 1, 8, 0}, {2, 1, 0, 0}, {2, 1, 1, 0}, {2, 1, 2, 0}, {2, 1, 7, 0}, {2, 1, 8, 0}, {3, 1, 8, 0}, {4, 1, 8, 0}, {5, 1, 8, 0}, {6, 1, 0, 0}, {6, 1, 1, 0}, {6, 1, 2, 0}, {6, 1, 7, 0}, {6, 1, 8, 0}, {7, 1, 0, 0}, {7, 1, 1, 0}, {7, 1, 2, 0}, {7, 1, 7, 0}, {7, 1, 8, 0}, {8, 1, 0, 0}, {8, 1, 1, 0}, {8, 1, 2, 0}, {8, 1, 3, 0}, {8, 1, 4, 0}, {8, 1, 5, 0}, {8, 1, 6, 0}, {8, 1, 7, 0}, {8, 1, 8, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, -1}, {4, 1, -1}, {5, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3 + random.nextInt(3);
                int v = 2;
                int w = 3 + random.nextInt(3);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 4, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class SnowyMasonsHouse1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowyMasonsHouse1() {
        }

        public SnowyMasonsHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyMasonsHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyMasonsHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyMasonsHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeLogVertState;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeStrippedWoodOrLogOrLogVerticState = biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedWoodState(biomeLogVertState, 0);
            if (biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150364_r || biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (String)new int[][]{{2, 1, 2, 3, 3, 2}, {6, 1, 2, 7, 3, 2}, {3, 4, 2, 6, 5, 2}, {4, 6, 2, 5, 6, 2}, {4, 1, 2, 5, 1, 2}, {2, 1, 6, 7, 3, 6}, {3, 4, 6, 6, 5, 6}, {4, 6, 6, 5, 6, 6}, {3, 1, 3, 6, 1, 5}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedWoodOrLogOrLogVerticState, biomeStrippedWoodOrLogOrLogVerticState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeStrippedLogHorizAlongState = biomeLogHorAlongState;
            if (biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
                }
            }
            for (int[] uuvvww : new int[][]{{4, 2, 2, 5, 2, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAlongState, biomeStrippedLogHorizAlongState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 2, 1, 1, 3, 7}, {2, 4, 1, 2, 5, 7}, {3, 6, 1, 3, 6, 7}, {4, 7, 1, 5, 7, 7}, {6, 6, 1, 6, 6, 7}, {7, 4, 1, 7, 5, 7}, {8, 2, 1, 8, 3, 7}, {2, 2, 3, 7, 2, 5}, {6, 3, 3, 6, 3, 3}, {6, 3, 5, 6, 3, 5}, {7, 3, 3, 7, 3, 5}, {4, 1, 1, 5, 1, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvw : new int[][]{{4, 4, 6}, {5, 4, 6}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 1, 0, 3}, {5, 1, 0, 3}, {4, 2, 1, 3}, {5, 2, 1, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwm : new int[][]{{4, 3, 3, GeneralConfig.useVillageColors ? this.townColor : 11}, {5, 3, 3, GeneralConfig.useVillageColors ? this.townColor2 : 14}, {4, 3, 4, GeneralConfig.useVillageColors ? this.townColor2 : 14}, {5, 3, 4, GeneralConfig.useVillageColors ? this.townColor : 11}, {4, 3, 5, GeneralConfig.useVillageColors ? this.townColor : 11}, {5, 3, 5, GeneralConfig.useVillageColors ? this.townColor2 : 14}}) {
                this.func_175811_a(world, Blocks.field_150404_cg.func_176203_a(uvwm[3]), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            IBlockState stonecutterState = ModObjects.chooseModStonecutterState(3, this.func_186165_e());
            this.func_175811_a(world, stonecutterState, 6, 3, 4, structureBB);
            for (int[] uvwo : new int[][]{{2, 3, 3, 1}, {2, 3, 4, 1}, {2, 3, 5, 1}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvwo : new int[][]{{3, 5, 4}, {6, 5, 4}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 3, 2, 2, 1, 1}, {5, 3, 2, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeSnowState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150433_aE.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 0, 2, 1, 0}, {2, 1, 1, 3, 1, 1}, {3, 2, 1, 3, 2, 1}, {6, 1, 1, 8, 1, 1}, {7, 2, 1, 7, 2, 1}, {7, 1, 0, 8, 1, 0}, {2, 1, 7, 2, 2, 7}, {3, 1, 7, 6, 1, 7}, {8, 1, 7, 8, 1, 7}, {7, 2, 7, 7, 2, 7}, {3, 1, 8, 3, 1, 8}, {6, 1, 8, 6, 1, 8}, {8, 1, 8, 8, 2, 8}, {0, 1, 1, 0, 2, 1}, {0, 1, 3, 0, 1, 3}, {1, 1, 1, 1, 1, 3}, {8, 1, 6, 9, 1, 6}, {9, 2, 6, 9, 2, 6}, {9, 1, 7, 9, 2, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSnowState, biomeSnowState, false);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 0, 2}, {0, 1, 2, 1}, {0, 2, 3, 0}, {0, 1, 4, 2}, {0, 1, 5, 1}, {0, 1, 6, 0}, {0, 1, 7, 1}, {0, 1, 8, 1}, {1, 2, 0, 4}, {1, 1, 3, 0}, {1, 1, 4, 0}, {1, 1, 5, 0}, {1, 1, 6, 0}, {1, 1, 7, 3}, {1, 1, 8, 1}, {2, 2, 0, 0}, {2, 2, 1, 0}, {2, 1, 8, 0}, {3, 1, 0, 0}, {3, 2, 7, 0}, {3, 2, 8, 0}, {4, 1, 8, 0}, {5, 1, 8, 0}, {6, 1, 0, 0}, {7, 1, 7, 0}, {7, 1, 8, 0}, {8, 2, 0, 0}, {8, 1, 2, 0}, {8, 1, 3, 0}, {8, 1, 4, 0}, {8, 1, 5, 0}, {8, 3, 8, 0}, {9, 1, 0, 0}, {9, 1, 1, 0}, {9, 1, 2, 0}, {9, 1, 3, 0}, {9, 1, 4, 0}, {9, 1, 5, 0}, {9, 3, 7, 7}, {9, 4, 7, 0}, {9, 1, 8, 0}, {1, 4, 1, 0}, {1, 4, 2, 7}, {1, 5, 2, 7}, {1, 6, 2, 0}, {1, 4, 3, 0}, {1, 4, 4, 0}, {1, 4, 5, 0}, {1, 4, 6, 0}, {1, 4, 7, 0}, {2, 6, 1, 0}, {2, 6, 2, 7}, {2, 7, 2, 0}, {2, 6, 3, 0}, {2, 6, 4, 0}, {2, 6, 5, 0}, {2, 6, 6, 0}, {2, 6, 7, 0}, {3, 7, 1, 0}, {3, 7, 2, 0}, {3, 7, 3, 0}, {3, 7, 4, 0}, {3, 7, 5, 0}, {3, 7, 6, 0}, {3, 7, 7, 0}, {4, 8, 1, 0}, {4, 8, 2, 0}, {4, 8, 3, 0}, {4, 8, 4, 0}, {4, 8, 5, 0}, {4, 8, 6, 0}, {4, 8, 7, 0}, {5, 8, 1, 0}, {5, 8, 2, 0}, {5, 8, 3, 0}, {5, 8, 4, 0}, {5, 8, 5, 0}, {5, 8, 6, 0}, {5, 8, 7, 0}, {6, 7, 1, 0}, {6, 7, 2, 0}, {6, 7, 3, 0}, {6, 7, 4, 0}, {6, 7, 5, 0}, {6, 7, 6, 0}, {6, 7, 7, 0}, {7, 6, 1, 0}, {7, 6, 2, 0}, {7, 6, 3, 0}, {7, 6, 4, 0}, {7, 6, 5, 0}, {7, 6, 6, 0}, {7, 6, 7, 0}, {8, 4, 1, 0}, {8, 4, 2, 7}, {8, 5, 2, 0}, {8, 4, 3, 0}, {8, 4, 5, 0}, {8, 4, 6, 0}, {8, 4, 7, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3 + random.nextInt(3);
                int v = 3;
                int w = 3 + random.nextInt(3);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 4, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class SnowyLibrary1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 11;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowyLibrary1() {
        }

        public SnowyLibrary1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyLibrary1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)11, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyLibrary1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyLibrary1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeLogVertState;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 4, 1, 0, 5, 11}, {1, 6, 1, 1, 7, 11}, {2, 8, 1, 2, 8, 11}, {3, 9, 1, 3, 9, 11}, {4, 8, 1, 4, 8, 11}, {5, 6, 1, 5, 7, 11}, {6, 4, 1, 6, 5, 11}, {2, 1, 3, 4, 1, 9}, {2, 7, 6, 2, 7, 6}, {2, 2, 9, 2, 2, 9}, {4, 2, 9, 4, 2, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 3, 2, 2, 3}, {4, 2, 3, 4, 2, 3}, {2, 6, 3, 2, 6, 4}, {2, 6, 6, 2, 6, 9}, {3, 7, 6, 3, 8, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwo : new int[][]{{2, 3, 3, -1}, {4, 3, 3, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeStrippedWoodOrLogOrLogVerticState = biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedWoodState(biomeLogVertState, 0);
            if (biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150364_r || biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 1, 2, 5, 5, 2}, {2, 6, 2, 4, 7, 2}, {3, 8, 2, 3, 8, 2}, {1, 1, 10, 5, 5, 10}, {2, 6, 10, 4, 7, 10}, {3, 8, 10, 3, 8, 10}, {1, 1, 3, 1, 5, 9}, {5, 1, 3, 5, 5, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedWoodOrLogOrLogVerticState, biomeStrippedWoodOrLogOrLogVerticState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(4 + (this.func_186165_e().func_176736_b() % 2 != 0 ? 4 : 0)), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogHorizAcrossState = biomeLogHorAcrossState;
            if (biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 1);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 1);
                }
            }
            for (int[] uuvvww : new int[][]{{3, 1, 2, 3, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAcrossState, biomeStrippedLogHorizAcrossState, false);
            }
            for (int[] uvw : new int[][]{{1, 2, 4}, {1, 3, 4}, {1, 2, 6}, {1, 3, 6}, {1, 2, 8}, {1, 3, 8}, {3, 2, 10}, {3, 3, 10}, {3, 5, 10}, {3, 6, 10}, {5, 2, 4}, {5, 3, 4}, {5, 2, 6}, {5, 3, 6}, {5, 2, 8}, {5, 3, 8}, {3, 5, 2}, {3, 6, 2}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{3, 1, 1, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{3, 2, 7, 2}}) {
                ModObjects.setModLecternState(world, this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2]), uvwo[3], this.func_186165_e(), biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] uuvvww : new int[][]{{2, 2, 5, 2, 6, 5}, {2, 7, 3, 2, 7, 5}, {2, 7, 7, 2, 7, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvwo : new int[][]{{3, 6, 6}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
            for (int[] uvwo : new int[][]{{4, 3, 9}}) {
                this.func_175811_a(world, biomeSittingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 2, 2, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeSnowState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150433_aE.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 1, 2, 1, 1}, {2, 2, 1, 2, 2, 1}, {4, 1, 1, 5, 1, 1}, {1, 1, 11, 3, 1, 11}, {2, 2, 11, 2, 2, 11}, {0, 1, 6, 0, 1, 6}, {6, 1, 4, 6, 2, 4}, {6, 1, 5, 6, 1, 5}, {6, 1, 10, 6, 1, 11}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSnowState, biomeSnowState, false);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 0, 0}, {0, 1, 1, 3}, {0, 1, 2, 3}, {0, 1, 3, 0}, {0, 1, 4, 0}, {0, 1, 5, 3}, {0, 2, 6, 2}, {0, 1, 7, 4}, {0, 1, 8, 3}, {0, 1, 9, 0}, {0, 1, 10, 0}, {0, 1, 11, 1}, {0, 1, 12, 0}, {6, 1, 0, 0}, {6, 1, 1, 0}, {6, 1, 2, 0}, {6, 1, 3, 4}, {6, 1, 6, 2}, {6, 1, 7, 0}, {6, 1, 8, 0}, {6, 1, 9, 3}, {6, 2, 10, 1}, {6, 1, 12, 0}, {1, 1, 0, 3}, {2, 1, 0, 5}, {4, 1, 0, 2}, {5, 1, 0, 0}, {4, 2, 1, 2}, {1, 2, 11, 3}, {2, 3, 11, 0}, {3, 2, 11, 2}, {4, 1, 11, 0}, {5, 1, 11, 4}, {1, 1, 12, 4}, {2, 1, 12, 0}, {3, 1, 12, 4}, {4, 1, 12, 0}, {5, 1, 12, 0}, {0, 6, 1, 3}, {0, 6, 2, 7}, {0, 6, 3, 3}, {0, 6, 4, 0}, {0, 6, 5, 0}, {0, 6, 6, 0}, {0, 6, 7, 0}, {0, 6, 8, 0}, {0, 6, 9, 0}, {0, 6, 10, 0}, {0, 6, 11, 0}, {1, 8, 1, 0}, {1, 8, 2, 0}, {1, 8, 3, 0}, {1, 8, 4, 0}, {1, 8, 5, 0}, {1, 8, 6, 0}, {1, 8, 7, 0}, {1, 8, 8, 0}, {1, 8, 9, 0}, {1, 8, 10, 0}, {1, 8, 11, 0}, {2, 9, 1, 0}, {2, 9, 2, 0}, {2, 9, 3, 1}, {2, 9, 4, 0}, {2, 9, 5, 0}, {2, 9, 6, 2}, {2, 9, 7, 1}, {2, 9, 8, 0}, {2, 9, 9, 2}, {2, 9, 10, 0}, {2, 9, 11, 0}, {3, 10, 1, 0}, {3, 10, 2, 0}, {3, 10, 3, 1}, {3, 10, 4, 2}, {3, 10, 5, 3}, {3, 10, 6, 0}, {3, 10, 7, 0}, {3, 10, 8, 2}, {3, 10, 9, 0}, {3, 10, 10, 0}, {3, 10, 11, 0}, {4, 9, 1, 0}, {4, 9, 2, 0}, {4, 9, 3, 0}, {4, 9, 4, 0}, {4, 9, 5, 0}, {4, 9, 6, 0}, {4, 9, 7, 0}, {4, 9, 8, 0}, {4, 9, 9, 0}, {4, 9, 10, 0}, {4, 9, 11, 0}, {5, 8, 1, 1}, {5, 8, 2, 4}, {5, 8, 3, 2}, {5, 8, 4, 1}, {5, 8, 5, 0}, {5, 8, 6, 0}, {5, 8, 7, 0}, {5, 8, 8, 0}, {5, 8, 9, 0}, {5, 8, 10, 0}, {5, 8, 11, 0}, {6, 6, 2, 0}, {6, 6, 3, 1}, {6, 6, 4, 2}, {6, 6, 5, 0}, {6, 6, 6, 0}, {6, 6, 7, 0}, {6, 6, 8, 0}, {6, 6, 9, 0}, {6, 6, 10, 0}, {6, 6, 11, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3;
                int v = 2;
                int w = 7;
                while (u == 2 && w == 5 || u == 3 && w == 7 || u == 2 && w == 9 || u == 4 && w == 9) {
                    u = 2 + random.nextInt(3);
                    w = 4 + random.nextInt(6);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 1, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 1;
        }
    }

    public static class SnowyFletcherHouse1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowyFletcherHouse1() {
        }

        public SnowyFletcherHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyFletcherHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyFletcherHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyFletcherHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (String)new int[][]{{1, 1, 1, 1, 3, 1}, {2, 5, 1, 2, 5, 1}, {5, 1, 1, 5, 3, 1}, {4, 5, 1, 4, 5, 1}, {1, 1, 7, 1, 3, 7}, {2, 1, 7, 2, 2, 7}, {2, 5, 7, 2, 5, 7}, {3, 1, 7, 3, 1, 7}, {3, 6, 7, 3, 6, 7}, {5, 1, 7, 5, 3, 7}, {4, 1, 7, 4, 2, 7}, {4, 5, 7, 4, 5, 7}, {1, 1, 2, 1, 1, 6}, {1, 2, 3, 1, 2, 3}, {1, 2, 5, 1, 2, 5}, {1, 3, 2, 1, 3, 2}, {1, 3, 4, 1, 3, 4}, {1, 3, 6, 1, 3, 6}, {5, 1, 2, 5, 1, 6}, {5, 2, 3, 5, 2, 3}, {5, 2, 5, 5, 2, 5}, {5, 3, 2, 5, 3, 2}, {5, 3, 4, 5, 3, 4}, {5, 3, 6, 5, 3, 6}, {3, 1, 2, 3, 1, 2}, {2, 1, 3, 2, 1, 3}, {4, 1, 3, 4, 1, 3}, {3, 1, 4, 3, 1, 4}, {2, 1, 5, 2, 1, 5}, {4, 1, 5, 4, 1, 5}, {3, 1, 6, 3, 1, 6}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(4 + (this.func_186165_e().func_176736_b() % 2 != 0 ? 4 : 0)), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogHorizAcrossState = biomeLogHorAcrossState;
            if (biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 1);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 1);
                }
            }
            for (int[] uuvvww : new int[][]{{3, 1, 1, 3, 1, 1}, {1, 2, 2, 1, 2, 2}, {1, 2, 4, 1, 2, 4}, {1, 2, 6, 1, 2, 6}, {1, 3, 3, 1, 3, 3}, {1, 3, 5, 1, 3, 5}, {5, 2, 2, 5, 2, 2}, {5, 2, 4, 5, 2, 4}, {5, 2, 6, 5, 2, 6}, {5, 3, 3, 5, 3, 3}, {5, 3, 5, 5, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAcrossState, biomeStrippedLogHorizAcrossState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeStrippedLogHorizAlongState = biomeLogHorAlongState;
            if (biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 1, 1, 2, 4, 1}, {3, 4, 1, 3, 6, 1}, {4, 1, 1, 4, 4, 1}, {3, 2, 7, 3, 2, 7}, {2, 3, 7, 2, 4, 7}, {4, 3, 7, 4, 4, 7}, {3, 5, 7, 3, 5, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAlongState, biomeStrippedLogHorizAlongState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 3, 0, 0, 3, 8}, {1, 4, 0, 1, 5, 8}, {2, 6, 0, 2, 6, 8}, {3, 7, 0, 3, 7, 8}, {4, 6, 0, 4, 6, 8}, {5, 4, 0, 5, 5, 8}, {6, 3, 0, 6, 3, 8}, {2, 1, 2, 2, 1, 2}, {4, 1, 2, 4, 1, 2}, {3, 1, 3, 3, 1, 3}, {2, 1, 4, 2, 1, 4}, {4, 1, 4, 4, 1, 4}, {3, 1, 5, 3, 1, 5}, {2, 1, 6, 2, 1, 6}, {4, 1, 6, 4, 1, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 3, 2, 2, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwm : new int[][]{{2, 3, 3, GeneralConfig.useVillageColors ? this.townColor : 11}}) {
                this.func_175811_a(world, Blocks.field_150404_cg.func_176203_a(uvwm[3]), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{3, 5, 2, 0}, {3, 5, 6, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 4, 7}, {3, 3, 7}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 1, 0, 0}, {3, 1, 0, 3}, {4, 1, 0, 1}, {2, 2, 2, 2}, {2, 2, 4, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState fletchingTableState = ModObjects.chooseModFletchingTableState(2, this.func_186165_e());
            this.func_175811_a(world, fletchingTableState, 3, 2, 6, structureBB);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 2, 1, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 0, 0}, {0, 1, 1, 0}, {0, 1, 2, 0}, {0, 1, 3, 0}, {0, 1, 4, 0}, {0, 1, 5, 0}, {0, 1, 6, 0}, {0, 1, 7, 0}, {0, 1, 8, 0}, {1, 1, 0, 0}, {1, 1, 8, 0}, {2, 1, 8, 0}, {3, 1, 8, 0}, {4, 1, 8, 0}, {5, 1, 0, 0}, {5, 1, 8, 0}, {6, 1, 0, 0}, {6, 1, 2, 0}, {6, 1, 3, 0}, {6, 1, 5, 0}, {6, 1, 6, 0}, {6, 1, 7, 0}, {6, 1, 8, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 1, -1}, {2, 1, -1}, {3, 1, -1}, {4, 1, -1}, {5, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3 + random.nextInt(2);
                int v = 2;
                int w = 2 + random.nextInt(4);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 4, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SnowyFisherCottage
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 4;
        private int averageGroundLevel = -1;

        public SnowyFisherCottage() {
        }

        public SnowyFisherCottage(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyFisherCottage buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyFisherCottage.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyFisherCottage(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 4 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 4)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (String)new int[][]{{4, 1, 1, 4, 3, 5}, {4, 4, 2, 4, 4, 4}, {4, 5, 3, 4, 5, 3}, {7, 1, 1, 7, 3, 1}, {7, 1, 2, 7, 2, 2}, {7, 4, 2, 7, 4, 2}, {7, 1, 3, 7, 1, 3}, {7, 5, 3, 7, 5, 3}, {7, 1, 4, 7, 2, 4}, {7, 4, 4, 7, 4, 4}, {7, 1, 5, 7, 3, 5}, {5, 1, 1, 6, 3, 1}, {5, 1, 5, 6, 3, 5}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(4 + (this.func_186165_e().func_176736_b() % 2 != 0 ? 4 : 0)), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogHorizAcrossState = biomeLogHorAcrossState;
            if (biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 1);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 1);
                }
            }
            for (int[] uuvvww : new int[][]{{4, 4, 3, 4, 4, 3}, {7, 4, 3, 7, 4, 3}, {7, 2, 3, 7, 2, 3}, {7, 3, 2, 7, 3, 2}, {7, 3, 4, 7, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAcrossState, biomeStrippedLogHorizAcrossState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 3, 0, 8, 3, 0}, {3, 4, 1, 8, 4, 1}, {3, 5, 2, 8, 5, 2}, {3, 6, 3, 8, 6, 3}, {3, 5, 4, 8, 5, 4}, {3, 4, 5, 8, 4, 5}, {3, 3, 6, 8, 3, 6}, {5, 1, 2, 6, 1, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{3, 2, 0}, {5, 2, 0}, {6, 2, 0}, {8, 2, 0}, {3, 2, 6}, {5, 2, 6}, {6, 2, 6}, {8, 2, 6}}) {
                this.func_175811_a(world, biomeWoodSlabTopState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{3, 4, 0}, {5, 4, 0}, {6, 4, 0}, {8, 4, 0}, {3, 5, 1}, {5, 5, 1}, {6, 5, 1}, {8, 5, 1}, {3, 6, 2}, {5, 6, 2}, {6, 6, 2}, {8, 6, 2}, {3, 7, 3}, {5, 7, 3}, {6, 7, 3}, {8, 7, 3}, {3, 6, 4}, {5, 6, 4}, {6, 6, 4}, {8, 6, 4}, {3, 5, 5}, {5, 5, 5}, {6, 5, 5}, {8, 5, 5}, {3, 4, 6}, {5, 4, 6}, {6, 4, 6}, {8, 4, 6}}) {
                this.func_175811_a(world, biomeWoodSlabBottomState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 2, 2, 0, 3, 2}, {0, 2, 5, 0, 3, 5}, {0, 4, 2, 0, 4, 5}, {1, 4, 5, 2, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvwo : new int[][]{{0, 3, 4}, {1, 3, 5}, {6, 5, 3}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{7, 3, 3}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 1, 1, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            Block barrelBlock = ModObjects.chooseModBarrelBlockState();
            for (int[] uvwoo : new int[][]{{5, 2, 4, 2, -1}, {6, 2, 4, 2, -1}, {6, 3, 4, 2, 2}}) {
                if (barrelBlock == null) {
                    barrelBlock = Blocks.field_150486_ae;
                }
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwoo[0], uvwoo[2]), this.func_74862_a(uvwoo[1]), this.func_74873_b(uvwoo[0], uvwoo[2])), barrelBlock.func_176203_a(barrelBlock == Blocks.field_150486_ae ? StructureVillageVN.chooseFurnaceMeta(uvwoo[3], this.func_186165_e()) : StructureVillageVN.chooseFurnaceMeta(uvwoo[4], this.func_186165_e())), 2);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 2, 3, 3, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 1, 2, 0, 1, 5}, {1, 1, 5, 3, 1, 5}, {3, 1, 4, 3, 1, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            IBlockState grassPathState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_185774_da.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 1, 3, 3, 1, 3}, {1, 1, 2, 3, 1, 2}, {1, 0, 0, 1, 0, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], grassPathState, grassPathState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 3, 2, 1, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150358_i.func_176203_a(0), Blocks.field_150358_i.func_176203_a(0), false);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 0, 0}, {2, 1, 0, 0}, {3, 1, 0, 0}, {4, 1, 0, 0}, {5, 1, 0, 0}, {6, 1, 0, 0}, {7, 1, 0, 0}, {8, 1, 0, 0}, {0, 1, 1, 0}, {2, 1, 1, 0}, {3, 1, 1, 0}, {8, 1, 1, 0}, {8, 1, 2, 0}, {8, 1, 3, 0}, {8, 1, 4, 0}, {8, 1, 5, 0}, {0, 1, 6, 0}, {2, 1, 6, 0}, {3, 1, 6, 0}, {4, 1, 6, 0}, {5, 1, 6, 0}, {6, 1, 6, 0}, {6, 1, 6, 0}, {8, 1, 6, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 5 + random.nextInt(2);
                int v = 2;
                int w = 2 + random.nextInt(2);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 4, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SnowyFarm2
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 4;
        private int averageGroundLevel = -1;

        public SnowyFarm2() {
        }

        public SnowyFarm2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyFarm2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyFarm2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyFarm2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 4 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 4)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeSnowState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150433_aE.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 3, 0, 1, 3}, {1, 1, 2, 1, 1, 5}, {1, 2, 3, 1, 2, 3}, {2, 1, 5, 2, 1, 6}, {3, 1, 0, 3, 1, 0}, {3, 1, 6, 5, 1, 6}, {4, 1, 0, 4, 1, 0}, {4, 1, 3, 4, 1, 3}, {5, 1, 1, 5, 1, 1}, {6, 1, 0, 6, 1, 0}, {6, 1, 1, 6, 2, 1}, {6, 1, 5, 6, 2, 5}, {7, 1, 3, 7, 1, 5}, {7, 2, 4, 7, 2, 4}, {8, 1, 1, 8, 1, 3}, {8, 2, 3, 8, 2, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSnowState, biomeSnowState, false);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 0, 0}, {0, 1, 1, 0}, {0, 1, 2, 0}, {0, 1, 4, 0}, {0, 1, 5, 0}, {0, 1, 6, 0}, {1, 1, 0, 0}, {1, 1, 1, 4}, {1, 2, 2, 2}, {1, 1, 6, 0}, {2, 1, 6, 2}, {5, 1, 0, 3}, {6, 2, 0, 0}, {6, 1, 6, 3}, {7, 1, 0, 0}, {7, 1, 1, 3}, {7, 1, 6, 0}, {8, 1, 0, 0}, {8, 1, 4, 4}, {8, 1, 5, 0}, {8, 1, 6, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvwmm : new int[][]{{2, 1, 1, 7, 0}, {2, 1, 2, 7, 0}, {2, 1, 3, 7, 0}, {2, 1, 4, 0, 0}, {3, 1, 1, 7, 0}, {3, 1, 2, 0, 0}, {3, 1, 4, 7, 0}, {3, 1, 5, 0, 0}, {4, 1, 1, 0, 0}, {4, 1, 2, 7, 0}, {4, 1, 4, 7, 0}, {4, 1, 5, 7, 0}, {5, 1, 2, 7, 0}, {5, 1, 4, 7, 0}, {5, 1, 5, 0, 0}, {6, 1, 2, 7, 0}, {6, 1, 3, 7, 0}, {6, 1, 4, 7, 0}, {7, 1, 2, 0, 0}}) {
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(uvwmm[3]), uvwmm[0], uvwmm[1], uvwmm[2], structureBB);
                this.func_175811_a(world, Blocks.field_150464_aj.func_176203_a(uvwmm[4]), uvwmm[0], uvwmm[1] + 1, uvwmm[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, 3}, {5, 1, 3}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
                this.func_175811_a(world, biomeGrassState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
            }
            IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
            for (int[] uvwo : new int[][]{{4, 2, 3}}) {
                this.func_175811_a(world, biomeSittingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 1, 0, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState compostBinState = ModObjects.chooseModComposterState();
            for (int[] uvw : new int[][]{{7, 2, 3}}) {
                if (compostBinState == null) continue;
                this.func_175811_a(world, compostBinState.func_177230_c().func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 1, -1}, {2, 1, -1}, {3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3;
                int v = 2;
                int w = 2;
                int s = random.nextInt(19);
                if (s <= 3) {
                    u = 2;
                    w = s + 1;
                } else if (s <= 5) {
                    u = 3;
                    w = s - 3;
                } else if (s <= 7) {
                    u = 3;
                    w = s - 2;
                } else if (s <= 9) {
                    u = 4;
                    w = s - 7;
                } else if (s <= 11) {
                    u = 4;
                    w = s - 6;
                } else if (s == 12) {
                    u = 5;
                    w = 2;
                } else if (s <= 14) {
                    u = 5;
                    w = s - 9;
                } else if (s <= 17) {
                    u = 6;
                    w = s - 13;
                } else if (s == 18) {
                    u = 7;
                    w = 2;
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SnowyFarm1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowyFarm1() {
        }

        public SnowyFarm1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyFarm1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyFarm1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyFarm1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (String)new int[][]{{0, 0, 0, 0, 0, 0}, {6, 0, 0, 6, 0, 0}, {0, 0, 5, 0, 0, 5}, {6, 0, 5, 6, 0, 5}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeStrippedLogHorizAlongState = biomeLogHorAlongState;
            if (biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 0, 1, 0, 0, 4}, {6, 0, 1, 6, 0, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAlongState, biomeStrippedLogHorizAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(4 + (this.func_186165_e().func_176736_b() % 2 != 0 ? 4 : 0)), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogHorizAcrossState = biomeLogHorAcrossState;
            if (biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 1);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 1);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 0, 0, 1, 0, 0}, {5, 0, 0, 5, 0, 0}, {1, 0, 5, 5, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAcrossState, biomeStrippedLogHorizAcrossState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 1, 5, 3, 4, 5}, {3, 4, 3, 3, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvwo : new int[][]{{3, 3, 3}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 0, 0, 3}, {3, 0, 0, 3}, {4, 0, 0, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState compostBinState = ModObjects.chooseModComposterState();
            for (int[] uvw : new int[][]{{5, 1, 5}}) {
                if (compostBinState == null) continue;
                this.func_175811_a(world, compostBinState.func_177230_c().func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            Block[][] cropPairPair = new Block[][]{StructureVillageVN.chooseCropPair(random), StructureVillageVN.chooseCropPair(random)};
            for (int[] uvwmc : new int[][]{{1, 0, 1, 0, 0}, {2, 0, 1, 1, 0}, {3, 0, 1, 0, 0}, {4, 0, 1, 0, 0}, {5, 0, 1, 0, 0}, {1, 0, 4, 1, 1}, {2, 0, 4, 1, 1}, {3, 0, 4, 0, 1}, {4, 0, 4, 0, 1}, {5, 0, 4, 0, 1}, {1, 0, 2, 0, 2}, {1, 0, 3, 0, 2}, {2, 0, 2, 0, 2}, {2, 0, 3, 0, 2}, {4, 0, 2, 0, 3}, {4, 0, 3, 0, 3}, {5, 0, 2, 0, 3}, {5, 0, 3, 1, 3}}) {
                IBlockState cropState;
                int cropProgressMeta = uvwmc[3];
                while (true) {
                    try {
                        cropState = cropPairPair[uvwmc[4] / 2][uvwmc[4] % 2].func_176203_a(cropProgressMeta);
                    }
                    catch (IllegalArgumentException e) {
                        if (cropProgressMeta == 0) {
                            cropState = Blocks.field_150464_aj.func_176203_a(uvwmc[3]);
                            break;
                        }
                        cropProgressMeta /= 2;
                        continue;
                    }
                    break;
                }
                this.func_175811_a(world, cropState, uvwmc[0], uvwmc[1] + 1, uvwmc[2], structureBB);
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(7), uvwmc[0], uvwmc[1], uvwmc[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 0, 2}, {3, 0, 3}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 0, -1}, {3, 0, -1}, {4, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3;
                int v = 1;
                int w = 3;
                while (u == 3 && w == 3 || u == 3 && w == 2) {
                    u = 1 + random.nextInt(5);
                    w = 1 + random.nextInt(4);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SnowyCartographerHouse1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowyCartographerHouse1() {
        }

        public SnowyCartographerHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyCartographerHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyCartographerHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyCartographerHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (String)new int[][]{{4, 1, 2, 4, 4, 2}, {5, 5, 2, 5, 5, 2}, {6, 1, 2, 6, 4, 2}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            for (Object uvwo : (String)new int[][]{{4, 3, 1, 2}, {6, 3, 1, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta((int)uvwo[3])), (int)uvwo[0], (int)uvwo[1], (int)uvwo[2], structureBB);
            }
            for (Object uuvvww : (String)new int[][]{{1, 1, 1, 1, 5, 1}, {2, 1, 1, 2, 1, 1}, {2, 5, 1, 2, 6, 1}, {3, 1, 1, 3, 5, 1}, {4, 1, 2, 4, 4, 2}, {5, 5, 2, 5, 5, 2}, {6, 1, 2, 6, 4, 2}, {7, 1, 1, 7, 5, 1}, {8, 1, 1, 8, 1, 1}, {8, 5, 1, 8, 6, 1}, {9, 1, 1, 9, 5, 1}, {1, 1, 5, 1, 5, 5}, {2, 1, 5, 2, 1, 5}, {2, 5, 5, 2, 6, 5}, {3, 1, 5, 3, 5, 5}, {4, 1, 5, 4, 4, 5}, {5, 1, 5, 5, 1, 5}, {5, 5, 5, 5, 5, 5}, {6, 1, 5, 6, 4, 5}, {7, 1, 5, 7, 5, 5}, {8, 1, 5, 8, 1, 5}, {8, 5, 5, 8, 6, 5}, {9, 1, 5, 9, 5, 5}, {1, 2, 2, 1, 2, 2}, {1, 1, 3, 1, 1, 3}, {1, 3, 3, 1, 3, 3}, {1, 2, 4, 1, 2, 4}, {9, 2, 2, 9, 2, 2}, {9, 1, 3, 9, 1, 3}, {9, 3, 3, 9, 3, 3}, {9, 2, 4, 9, 2, 4}, {2, 1, 2, 2, 1, 3}, {5, 1, 2, 5, 1, 3}, {8, 1, 2, 8, 1, 3}, {2, 1, 4, 8, 1, 4}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeStrippedLogHorizAlongState = biomeLogHorAlongState;
            if (biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 2, 1, 2, 2, 1}, {2, 4, 1, 2, 4, 1}, {8, 2, 1, 8, 2, 1}, {8, 4, 1, 8, 4, 1}, {5, 4, 2, 5, 4, 2}, {2, 2, 5, 2, 2, 5}, {2, 4, 5, 2, 4, 5}, {5, 2, 5, 5, 2, 5}, {5, 4, 5, 5, 4, 5}, {8, 2, 5, 8, 2, 5}, {8, 4, 5, 8, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAlongState, biomeStrippedLogHorizAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(4 + (this.func_186165_e().func_176736_b() % 2 != 0 ? 4 : 0)), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogHorizAcrossState = biomeLogHorAcrossState;
            if (biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 1);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 1);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 1, 2, 1, 1, 2}, {1, 3, 2, 1, 3, 2}, {1, 2, 3, 1, 2, 3}, {1, 1, 4, 1, 1, 4}, {1, 3, 4, 1, 3, 4}, {1, 4, 2, 1, 5, 4}, {9, 1, 2, 9, 1, 2}, {9, 3, 2, 9, 3, 2}, {9, 2, 3, 9, 2, 3}, {9, 1, 4, 9, 1, 4}, {9, 3, 4, 9, 3, 4}, {9, 4, 2, 9, 5, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAcrossState, biomeStrippedLogHorizAcrossState, false);
            }
            for (int[] uvwo : new int[][]{{2, 5, 3, 1}, {5, 4, 4, 2}, {8, 5, 3, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 4, 0, 0, 5, 6}, {1, 6, 0, 1, 6, 6}, {2, 7, 0, 2, 7, 6}, {3, 6, 0, 3, 6, 6}, {4, 5, 0, 4, 5, 6}, {5, 6, 0, 5, 6, 6}, {6, 5, 0, 6, 5, 6}, {7, 6, 0, 7, 6, 6}, {8, 7, 0, 8, 7, 6}, {9, 6, 0, 9, 6, 6}, {10, 4, 0, 10, 5, 6}, {4, 1, 1, 6, 1, 1}, {3, 1, 2, 3, 1, 3}, {4, 1, 3, 4, 1, 3}, {7, 1, 2, 7, 1, 3}, {6, 1, 3, 6, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 5, 0}, {2, 6, 0}, {3, 5, 0}, {4, 4, 0}, {5, 5, 0}, {6, 4, 0}, {7, 5, 0}, {8, 6, 0}, {9, 5, 0}, {1, 5, 6}, {2, 6, 6}, {3, 5, 6}, {4, 4, 6}, {5, 5, 6}, {6, 4, 6}, {7, 5, 6}, {8, 6, 6}, {9, 5, 6}}) {
                this.func_175811_a(world, biomeWoodSlabTopState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 6, 0}, {6, 6, 0}, {4, 6, 6}, {6, 6, 6}}) {
                this.func_175811_a(world, biomeWoodSlabBottomState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 0, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 3, 1}, {8, 3, 1}, {2, 3, 5}, {5, 3, 5}, {8, 3, 5}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{3, 1, 0, 0}, {4, 1, 0, 3}, {5, 1, 0, 3}, {6, 1, 0, 3}, {7, 1, 0, 1}, {7, 2, 2, 2}, {8, 2, 2, 2}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState cartographyTableState = ModObjects.chooseModCartographyTableState(2, this.func_186165_e());
            for (int[] uvw : new int[][]{{2, 2, 2}}) {
                this.func_175811_a(world, cartographyTableState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            int chestU = 3;
            int chestV = 2;
            int chestW = 2;
            int chestO = 0;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_cartographer");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{5, 2, 2, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{2, 1, -1}, {3, 1, -1}, {4, 1, -1}, {5, 1, -1}, {6, 1, -1}, {7, 1, -1}, {8, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 2 + random.nextInt(7);
                int v = 2;
                int w = 3 + random.nextInt(2);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 1, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 1;
        }
    }

    public static class SnowyButchersShop2
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowyButchersShop2() {
        }

        public SnowyButchersShop2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyButchersShop2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyButchersShop2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyButchersShop2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 1, 1, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 1, 3, 3, 1, 3}, {0, 1, 4, 0, 1, 9}, {4, 1, 4, 4, 1, 9}, {1, 1, 9, 3, 1, 9}, {4, 2, 6, 4, 3, 6}, {3, 4, 6, 4, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvwo : new int[][]{{3, 3, 6}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{3, 2, 3, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeSnowState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150433_aE.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 0, 3, 3, 0}, {1, 1, 4, 3, 3, 4}, {0, 1, 1, 0, 2, 3}, {4, 1, 1, 4, 2, 3}, {1, 3, 1, 1, 3, 3}, {2, 4, 1, 2, 4, 3}, {3, 3, 1, 3, 3, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSnowState, biomeSnowState, false);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 0, 0}, {4, 1, 0, 0}, {2, 1, 1, 0}, {2, 1, 2, 0}, {3, 1, 1, 0}, {1, 1, 5, 0}, {1, 1, 6, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 1, 3, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState smokerState = ModObjects.chooseModSmokerState(3, this.func_186165_e());
            for (int[] uvwo : new int[][]{{2, 1, 7, 2}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), smokerState.func_177230_c().func_176203_a(smokerState.func_177230_c() == Block.func_149684_b((String)"futuremc:smoker") ? StructureVillageVN.chooseBlastFurnaceMeta(uvwo[3], this.func_186165_e()) : StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{2, 1, 0, 0, 1, 0}, {2, 1, 4, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{1, 1, -1}, {2, 1, -1}, {3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                for (int[] uvw : new int[][]{{2, 1, 5}}) {
                    BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                    EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                    animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)animal);
                }
                int u = 3;
                int v = 1;
                int w = 3;
                while (u == 3 && w == 3) {
                    u = 2 + random.nextInt(2);
                    w = 1 + random.nextInt(3);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 4, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 4;
        }
    }

    public static class SnowyButchersShop1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowyButchersShop1() {
        }

        public SnowyButchersShop1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyButchersShop1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyButchersShop1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyButchersShop1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeLogVertState;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeStrippedWoodOrLogOrLogVerticState = biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedWoodState(biomeLogVertState, 0);
            if (biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150364_r || biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (String)new int[][]{{1, 1, 1, 2, 3, 1}, {4, 1, 1, 5, 3, 1}, {2, 4, 1, 4, 5, 1}, {3, 6, 1, 3, 6, 1}, {1, 1, 5, 5, 3, 5}, {2, 4, 5, 4, 5, 5}, {3, 6, 5, 3, 6, 5}, {1, 1, 2, 1, 3, 4}, {5, 1, 2, 5, 3, 4}, {1, 1, 6, 1, 1, 8}, {2, 1, 8, 4, 1, 8}, {5, 1, 6, 5, 1, 8}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedWoodOrLogOrLogVerticState, biomeStrippedWoodOrLogOrLogVerticState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeStrippedLogHorizAlongState = biomeLogHorAlongState;
            if (biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
                }
            }
            for (int[] uuvvww : new int[][]{{3, 1, 1, 3, 1, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAlongState, biomeStrippedLogHorizAlongState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 1, 6, 4, 1, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 2, 1, 0, 2, 1}, {0, 2, 3, 0, 2, 3}, {0, 2, 5, 0, 2, 5}, {0, 3, 0, 0, 3, 6}, {1, 4, 0, 1, 5, 6}, {2, 6, 0, 2, 6, 6}, {3, 7, 0, 3, 7, 6}, {3, 6, 0, 3, 6, 0}, {4, 6, 0, 4, 6, 6}, {5, 4, 0, 5, 5, 6}, {6, 3, 0, 6, 3, 6}, {6, 2, 1, 6, 2, 1}, {6, 2, 3, 6, 2, 3}, {6, 2, 5, 6, 2, 5}, {2, 1, 2, 2, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 2, 0}, {0, 2, 2}, {0, 2, 4}, {0, 2, 6}, {2, 5, 0}, {2, 5, 6}, {3, 6, 6}, {4, 5, 0}, {4, 5, 6}, {6, 2, 0}, {6, 2, 2}, {6, 2, 4}, {6, 2, 6}}) {
                this.func_175811_a(world, biomeWoodSlabTopState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 4, 0}, {0, 4, 2}, {0, 4, 4}, {0, 4, 6}, {1, 6, 3}, {5, 6, 3}, {6, 4, 0}, {6, 4, 2}, {6, 4, 4}, {6, 4, 6}}) {
                this.func_175811_a(world, biomeWoodSlabBottomState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 6, 2, 3, 6, 2}, {3, 6, 4, 3, 6, 4}, {3, 5, 6, 3, 5, 7}, {1, 2, 6, 1, 2, 8}, {2, 2, 8, 4, 2, 8}, {5, 2, 6, 5, 2, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvwo : new int[][]{{3, 5, 0}, {3, 5, 2}, {3, 5, 4}, {3, 4, 7}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 0, 0}, {0, 1, 1, 0}, {0, 1, 2, 0}, {0, 1, 3, 0}, {0, 1, 4, 0}, {0, 1, 5, 0}, {0, 1, 6, 0}, {0, 1, 7, 0}, {0, 1, 8, 0}, {1, 1, 0, 0}, {5, 1, 0, 0}, {6, 1, 0, 0}, {6, 1, 1, 0}, {6, 1, 2, 0}, {6, 1, 3, 0}, {6, 1, 4, 0}, {6, 1, 5, 0}, {6, 1, 6, 0}, {6, 1, 7, 0}, {6, 1, 8, 0}, {0, 4, 1, 0}, {0, 4, 3, 0}, {0, 4, 5, 0}, {1, 6, 0, 0}, {1, 6, 1, 0}, {1, 6, 2, 0}, {1, 6, 5, 0}, {1, 6, 6, 0}, {2, 7, 0, 0}, {2, 7, 1, 0}, {2, 7, 2, 0}, {2, 7, 3, 0}, {2, 7, 5, 0}, {2, 7, 6, 0}, {3, 8, 0, 0}, {3, 8, 1, 0}, {3, 8, 2, 0}, {3, 8, 3, 0}, {3, 8, 4, 0}, {3, 8, 5, 0}, {3, 8, 6, 0}, {4, 7, 0, 0}, {4, 7, 1, 0}, {4, 7, 2, 0}, {4, 7, 3, 0}, {4, 7, 4, 0}, {4, 7, 5, 0}, {4, 7, 6, 0}, {5, 6, 0, 0}, {5, 6, 1, 0}, {5, 6, 2, 0}, {5, 6, 4, 0}, {5, 6, 5, 0}, {5, 6, 6, 0}, {6, 4, 1, 0}, {6, 4, 3, 0}, {6, 4, 5, 0}, {2, 2, 6, 0}, {4, 2, 6, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 1, 0, 0}, {3, 1, 0, 3}, {4, 1, 0, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 3, 2, 1, 3}, {2, 6, 4, 2, 6, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState smokerState = ModObjects.chooseModSmokerState(3, this.func_186165_e());
            for (int[] uvwo : new int[][]{{2, 2, 4, 2}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), smokerState.func_177230_c().func_176203_a(smokerState.func_177230_c() == Block.func_149684_b((String)"futuremc:smoker") ? StructureVillageVN.chooseBlastFurnaceMeta(uvwo[3], this.func_186165_e()) : StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 3, 4, 2, 5, 4}, {2, 7, 4, 2, 8, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            IBlockState smoothStoneState = ModObjects.chooseModSmoothStoneBlockState();
            for (int[] uuvvww : new int[][]{{4, 2, 3, 4, 2, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], smoothStoneState, smoothStoneState, false);
            }
            for (int[] uuvvww : new int[][]{{3, 1, 2, 4, 1, 2}, {3, 1, 3, 3, 1, 3}, {3, 1, 4, 4, 1, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150333_U.func_176203_a(8), Blocks.field_150333_U.func_176203_a(8), false);
            }
            for (int[] uvw : new int[][]{{1, 4, 3}, {5, 4, 3}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 2, 1, 2, 1, 1}, {3, 2, 5, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{1, 1, -1}, {2, 1, -1}, {3, 1, -1}, {4, 1, -1}, {5, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                for (int[] uvw : new int[][]{{2, 2, 7}}) {
                    BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                    EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                    animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)animal);
                }
                int u = 2;
                int v = 2;
                int w = 4;
                while (u == 2 && w == 4 || u == 4 && w == 3) {
                    u = 2 + random.nextInt(3);
                    w = 2 + random.nextInt(3);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 4, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 4;
        }
    }

    public static class SnowyArmorerHouse2
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowyArmorerHouse2() {
        }

        public SnowyArmorerHouse2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyArmorerHouse2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyArmorerHouse2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyArmorerHouse2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeLogVertState;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeStrippedWoodOrLogOrLogVerticState = biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedWoodState(biomeLogVertState, 0);
            if (biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150364_r || biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (String)new int[][]{{1, 1, 1, 2, 3, 1}, {4, 1, 1, 5, 3, 1}, {2, 4, 1, 4, 5, 1}, {3, 6, 1, 3, 6, 1}, {1, 1, 5, 5, 3, 5}, {2, 4, 5, 4, 5, 5}, {3, 6, 5, 3, 6, 5}, {1, 1, 2, 1, 3, 4}, {5, 1, 2, 5, 3, 4}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedWoodOrLogOrLogVerticState, biomeStrippedWoodOrLogOrLogVerticState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeStrippedLogHorizAlongState = biomeLogHorAlongState;
            if (biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
                }
            }
            for (int[] uuvvww : new int[][]{{3, 1, 1, 3, 1, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAlongState, biomeStrippedLogHorizAlongState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 2, 1, 0, 2, 1}, {0, 2, 3, 0, 2, 3}, {0, 2, 5, 0, 2, 5}, {0, 3, 0, 0, 3, 6}, {1, 4, 0, 1, 5, 6}, {2, 6, 0, 2, 6, 6}, {3, 7, 0, 3, 7, 6}, {3, 6, 0, 3, 6, 0}, {4, 6, 0, 4, 6, 6}, {5, 4, 0, 5, 5, 6}, {6, 3, 0, 6, 3, 6}, {6, 2, 1, 6, 2, 1}, {6, 2, 3, 6, 2, 3}, {6, 2, 5, 6, 2, 5}, {2, 1, 2, 4, 1, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 2, 0}, {0, 2, 2}, {0, 2, 4}, {0, 2, 6}, {2, 5, 0}, {2, 5, 6}, {3, 6, 6}, {4, 5, 0}, {4, 5, 6}, {6, 2, 0}, {6, 2, 2}, {6, 2, 4}, {6, 2, 6}}) {
                this.func_175811_a(world, biomeWoodSlabTopState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 4, 0}, {0, 4, 2}, {0, 4, 4}, {0, 4, 6}, {1, 6, 3}, {5, 6, 3}, {6, 4, 0}, {6, 4, 2}, {6, 4, 4}, {6, 4, 6}}) {
                this.func_175811_a(world, biomeWoodSlabBottomState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 6, 2, 3, 6, 2}, {3, 6, 4, 3, 6, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvwo : new int[][]{{3, 5, 0}, {3, 5, 2}, {3, 5, 4}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 0, 0}, {0, 1, 1, 0}, {0, 1, 2, 0}, {0, 1, 3, 0}, {0, 1, 4, 0}, {0, 1, 5, 0}, {0, 1, 6, 0}, {1, 1, 0, 0}, {1, 1, 6, 0}, {2, 1, 6, 0}, {3, 1, 6, 0}, {4, 1, 6, 0}, {5, 1, 0, 0}, {5, 1, 6, 0}, {6, 1, 0, 0}, {6, 1, 1, 0}, {6, 1, 2, 0}, {6, 1, 3, 0}, {6, 1, 4, 0}, {6, 1, 5, 0}, {6, 1, 6, 0}, {0, 4, 1, 0}, {0, 4, 3, 0}, {0, 4, 5, 0}, {1, 6, 0, 0}, {1, 6, 1, 0}, {1, 6, 2, 0}, {1, 6, 5, 0}, {1, 6, 6, 0}, {2, 7, 0, 0}, {2, 7, 1, 0}, {2, 7, 2, 0}, {2, 7, 3, 0}, {2, 7, 5, 0}, {2, 7, 6, 0}, {3, 8, 0, 0}, {3, 8, 1, 0}, {3, 8, 2, 0}, {3, 8, 3, 0}, {3, 8, 4, 0}, {3, 8, 5, 0}, {3, 8, 6, 0}, {4, 7, 0, 0}, {4, 7, 1, 0}, {4, 7, 2, 0}, {4, 7, 3, 0}, {4, 7, 4, 0}, {4, 7, 5, 0}, {4, 7, 6, 0}, {5, 6, 0, 0}, {5, 6, 1, 0}, {5, 6, 2, 0}, {5, 6, 4, 0}, {5, 6, 5, 0}, {5, 6, 6, 0}, {6, 4, 1, 0}, {6, 4, 3, 0}, {6, 4, 5, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 1, 0, 0}, {3, 1, 0, 3}, {4, 1, 0, 1}, {4, 2, 2, 2}, {4, 2, 4, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 3, 2, 1, 3}, {2, 6, 4, 2, 6, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uvw : new int[][]{{2, 2, 4, 2}}) {
                IBlockState blastFurnaceState = ModObjects.chooseModBlastFurnaceState(uvw[3], this.func_186165_e());
                this.func_175811_a(world, blastFurnaceState.func_177230_c().func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
                world.func_180501_a(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])), blastFurnaceState, 2);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 3, 4, 2, 5, 4}, {2, 7, 4, 2, 8, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            for (int[] uvw : new int[][]{{1, 4, 3}, {3, 4, 5}, {5, 4, 3}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 2, 1, 2, 0, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{1, 1, -1}, {2, 1, -1}, {3, 1, -1}, {4, 1, -1}, {5, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 2;
                int v = 2;
                int w = 4;
                while (u == 2 && w == 4) {
                    u = 2 + random.nextInt(2);
                    w = 2 + random.nextInt(3);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class SnowyArmorerHouse1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowyArmorerHouse1() {
        }

        public SnowyArmorerHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyArmorerHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyArmorerHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyArmorerHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (String)new int[][]{{1, 1, 1, 5, 1, 3}, {1, 1, 4, 1, 1, 5}, {5, 1, 4, 5, 1, 5}, {1, 2, 1, 1, 3, 1}, {5, 2, 1, 5, 3, 1}, {2, 4, 1, 2, 5, 1}, {4, 4, 1, 4, 5, 1}, {3, 5, 1, 3, 6, 1}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            for (Object uvwo : (String)new int[][]{{1, 2, 5, -1}, {5, 2, 5, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta((int)uvwo[3])), (int)uvwo[0], (int)uvwo[1], (int)uvwo[2], structureBB);
            }
            IBlockState dioriteBlockState = Blocks.field_150348_b.func_176203_a(3);
            Block dioriteStairsBlock = ModObjects.chooseModDioriteStairsBlock();
            IBlockState dioriteWallState = ModObjects.chooseModDioriteWallState();
            if (dioriteStairsBlock == null || dioriteWallState == null) {
                dioriteBlockState = Blocks.field_150347_e.func_176203_a(0);
                dioriteStairsBlock = Blocks.field_150446_ar;
                dioriteWallState = Blocks.field_150463_bK.func_176223_P();
            }
            for (int[] uuvvww : new int[][]{{2, 1, 4, 4, 1, 5}, {2, 2, 5, 2, 2, 5}, {4, 2, 5, 4, 2, 5}, {3, 3, 5, 3, 7, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], dioriteBlockState, dioriteBlockState, false);
            }
            for (int[] uvwo : new int[][]{{2, 3, 5, 0}, {4, 3, 5, 1}}) {
                this.func_175811_a(world, dioriteStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{3, 8, 5, 3, 8, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], dioriteWallState, dioriteWallState, false);
            }
            for (int[] uvw : new int[][]{{3, 2, 5, 2}}) {
                IBlockState blastFurnaceState = ModObjects.chooseModBlastFurnaceState(uvw[3], this.func_186165_e());
                this.func_175811_a(world, blastFurnaceState.func_177230_c().func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
                world.func_180501_a(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])), blastFurnaceState, 2);
            }
            for (int[] uvwo : new int[][]{{3, 5, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 2, 6}, {2, 1, 6}, {2, 3, 6}, {2, 5, 6}, {3, 2, 6}, {3, 4, 6}, {3, 6, 6}, {4, 1, 6}, {4, 3, 6}, {4, 5, 6}, {5, 2, 6}}) {
                this.func_175811_a(world, biomeStrippedLogVertState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeStrippedLogHorizAlongState = biomeLogHorAlongState;
            if (biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
                }
            }
            for (int[] uvw : new int[][]{{2, 2, 1}, {2, 3, 1}, {3, 4, 1}, {4, 2, 1}, {4, 3, 1}, {1, 1, 6}, {1, 3, 6}, {2, 2, 6}, {2, 4, 6}, {3, 1, 6}, {3, 3, 6}, {3, 5, 6}, {4, 2, 6}, {4, 4, 6}, {5, 1, 6}, {5, 3, 6}}) {
                this.func_175811_a(world, biomeStrippedLogHorizAlongState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 2, 0, 0, 3, 7}, {1, 4, 0, 1, 5, 7}, {2, 6, 0, 2, 6, 7}, {3, 7, 0, 3, 7, 4}, {3, 7, 6, 3, 7, 7}, {4, 6, 0, 4, 6, 7}, {5, 4, 0, 5, 5, 7}, {6, 2, 0, 6, 3, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 5, 0, 3, 6, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvwo : new int[][]{{3, 4, 0}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwg : new int[][]{{5, 1, 0, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 0, 0}, {0, 1, 1, 0}, {0, 1, 3, 0}, {0, 1, 4, 0}, {0, 1, 5, 0}, {0, 1, 7, 0}, {1, 1, 0, 0}, {1, 1, 7, 0}, {2, 1, 0, 0}, {2, 1, 7, 0}, {3, 1, 7, 0}, {4, 1, 0, 0}, {4, 1, 7, 0}, {5, 1, 7, 0}, {6, 1, 0, 0}, {6, 1, 1, 0}, {6, 1, 2, 0}, {6, 1, 3, 0}, {6, 1, 4, 0}, {6, 1, 5, 0}, {6, 1, 6, 0}, {6, 1, 7, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{3, 1, 0, 3}, {2, 7, 4, 3}, {4, 7, 4, 3}, {2, 7, 5, 0}, {2, 7, 6, 2}, {4, 7, 6, 2}, {4, 7, 5, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            int chestU = 5;
            int chestV = 2;
            int chestW = 2;
            int chestO = 3;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_armorer");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 2, 1, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{1, 1, -1}, {2, 1, -1}, {3, 1, -1}, {4, 1, -1}, {5, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 5;
                int v = 2;
                int w = 2;
                while (u == 5 && w == 2) {
                    u = 1 + random.nextInt(5);
                    w = 2 + random.nextInt(3);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class SnowyAnimalPen2
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", " FFFFFFFF", " FFFF    ", " FFFF    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 3;
        private int averageGroundLevel = -1;

        public SnowyAnimalPen2() {
        }

        public SnowyAnimalPen2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyAnimalPen2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyAnimalPen2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyAnimalPen2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 3 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 3)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 1, 0, 4, 1, 2}, {5, 1, 2, 8, 1, 2}, {8, 1, 3, 8, 1, 7}, {0, 1, 7, 7, 1, 7}, {0, 1, 3, 0, 1, 6}, {1, 1, 0, 1, 1, 3}, {2, 1, 0, 2, 1, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeFenceGateState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwos : new int[][]{{3, 1, 0, 2, 0}}) {
                this.func_175811_a(world, biomeFenceGateState.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(uvwos[3], uvwos[4] == 1)), uvwos[0], uvwos[1], uvwos[2], structureBB);
            }
            IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
            for (int[] uvwo : new int[][]{{0, 2, 7}}) {
                this.func_175811_a(world, biomeSittingLanternState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 0, 5}, {1, 0, 6}, {2, 0, 6}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 0, 3}}) {
                this.func_74871_b(world, uvw[0], uvw[1], uvw[2], structureBB);
                this.func_175811_a(world, biomeGrassState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{2, 1, 4, 0}, {3, 1, 2, 0}, {3, 1, 3, 0}, {3, 1, 4, 0}, {3, 1, 5, 3}, {4, 1, 3, 0}, {4, 1, 6, 0}, {5, 1, 3, 0}, {5, 1, 4, 2}, {5, 1, 6, 0}, {6, 1, 3, 0}, {6, 1, 5, 0}, {6, 1, 6, 0}, {7, 1, 4, 0}, {7, 1, 5, 0}, {7, 1, 6, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            IBlockState biomeSnowState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150433_aE.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{4, 1, 4}, {4, 1, 5}, {4, 2, 5}, {5, 1, 5}}) {
                this.func_175811_a(world, biomeSnowState, uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 1, -1}, {3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                for (int[] uvw : new int[][]{{2, 0, 3}, {6, 1, 4}}) {
                    BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                    EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                    animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)animal);
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SnowyAnimalPen1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFF "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 2;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public SnowyAnimalPen1() {
        }

        public SnowyAnimalPen1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SnowyAnimalPen1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SnowyAnimalPen1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SnowyAnimalPen1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 2 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 2), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (String)new int[][]{{2, 1, 1, 8, 1, 1}, {2, 1, 7, 8, 1, 7}, {2, 1, 2, 2, 1, 6}, {8, 1, 2, 8, 1, 6}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            for (Object uuvvww : (String)new int[][]{{3, 1, 2, 7, 1, 6}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 1, 3, 2, 1}, {7, 2, 1, 8, 2, 1}, {2, 2, 7, 8, 2, 7}, {2, 2, 2, 2, 2, 6}, {8, 2, 2, 8, 2, 6}, {4, 2, 1, 4, 3, 1}, {6, 2, 1, 6, 3, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeFenceGateState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwos : new int[][]{{5, 2, 1, 2, 0}}) {
                this.func_175811_a(world, biomeFenceGateState.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(uvwos[3], uvwos[4] == 1)), uvwos[0], uvwos[1], uvwos[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{4, 4, 1, -1}, {6, 4, 1, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 2, 3, 6, 2, 3}, {4, 2, 4, 4, 2, 4}, {4, 2, 5, 6, 2, 5}, {6, 2, 4, 6, 2, 4}, {5, 1, 4, 5, 1, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvw : new int[][]{{5, 2, 4}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 1, 0, 0}, {5, 1, 0, 3}, {6, 1, 0, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 0, 0}, {0, 1, 1, 0}, {0, 1, 2, 0}, {0, 1, 3, 5}, {0, 1, 5, 3}, {0, 1, 6, 0}, {0, 1, 7, 0}, {1, 1, 0, 0}, {1, 1, 1, 0}, {1, 1, 2, 4}, {1, 2, 5, 2}, {1, 1, 6, 4}, {1, 1, 7, 0}, {2, 1, 0, 0}, {3, 1, 0, 4}, {7, 1, 0, 4}, {3, 2, 2, 0}, {3, 2, 3, 0}, {3, 2, 4, 0}, {3, 2, 5, 0}, {3, 2, 6, 0}, {4, 2, 2, 0}, {4, 2, 6, 0}, {5, 2, 6, 0}, {6, 2, 2, 0}, {6, 2, 6, 0}, {7, 2, 2, 0}, {7, 2, 3, 0}, {7, 2, 4, 0}, {7, 2, 5, 0}, {7, 2, 6, 0}}) {
                this.func_175811_a(world, biomeSnowLayerState.func_177230_c().func_176203_a(biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? uvwm[3] : 0), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            IBlockState biomeSnowState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150433_aE.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{0, 1, 4}, {1, 1, 3}, {1, 1, 4}, {1, 2, 4}, {1, 1, 5}}) {
                this.func_175811_a(world, biomeSnowState, uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvw : new int[][]{{4, 1, -1}, {5, 1, -1}, {6, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                for (int[] uvw : new int[][]{{5, 2, 2}}) {
                    BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                    EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                    animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)animal);
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SnowyMeetingPoint3
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{"F PPP  ", " PPPPP ", "PPFPFPP", "PPPPPPP", "PPFPFPP", " PPPPPF", "  PPPF "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        public static final int GROUND_LEVEL = 1;

        public SnowyMeetingPoint3() {
        }

        public SnowyMeetingPoint3(BiomeProvider chunkManager, int componentType, Random random, int posX, int posZ, List components, float terrainType) {
            super(chunkManager, componentType, random, posX, posZ, components, terrainType);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 70, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 70, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 2, EnumFacing.EAST, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 2, EnumFacing.WEST, this.func_74877_c());
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.field_143015_k < 0 && this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWallSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150444_as.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLanternState = ModObjects.chooseModLanternBlockState(true);
            IBlockState biomeStrippedWoodOrLogOrLogVerticState = biomeLogState;
            IBlockState biomeStrippedWoodOrLogOrLogHorAlongState = biomeLogState;
            IBlockState biomeStrippedWoodOrLogOrLogHorAcrossState = biomeLogState;
            if (biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150364_r || biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150363_s) {
                biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedWoodState(biomeLogState, 0);
                biomeStrippedWoodOrLogOrLogHorAlongState = ModObjects.chooseModStrippedWoodState(biomeLogState, 2);
                biomeStrippedWoodOrLogOrLogHorAcrossState = ModObjects.chooseModStrippedWoodState(biomeLogState, 1);
            }
            if (biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150364_r || biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150363_s) {
                biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogState.func_177230_c().func_176201_c(biomeLogState), 0);
                biomeStrippedWoodOrLogOrLogHorAlongState = ModObjects.chooseModStrippedLogState(biomeLogState.func_177230_c().func_176201_c(biomeLogState), 2);
                biomeStrippedWoodOrLogOrLogHorAcrossState = ModObjects.chooseModStrippedLogState(biomeLogState.func_177230_c().func_176201_c(biomeLogState), 1);
            }
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(3, 3), this.func_74862_a(3), this.func_74873_b(3, 3));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            this.func_175811_a(world, biomeGrassState, 2, 0, 2, structureBB);
            this.func_175811_a(world, biomeGrassState, 2, 0, 4, structureBB);
            this.func_175811_a(world, biomeGrassState, 4, 0, 4, structureBB);
            this.func_175811_a(world, biomeGrassState, 4, 0, 2, structureBB);
            for (int[] uw : new int[][]{{0, 6}, {5, 0}, {6, 1}}) {
                int k = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uw[0], uw[1]), 0, this.func_74873_b(uw[0], uw[1]))).func_177977_b().func_177956_o();
                if (k <= -1) continue;
                this.func_175811_a(world, biomeGrassState, uw[0], k + 1 - this.field_74887_e.field_78895_b, uw[1], structureBB);
            }
            this.func_175804_a(world, structureBB, 2, 1, 2, 2, 3, 2, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 2, 1, 4, 2, 3, 4, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 4, 1, 4, 4, 3, 4, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 4, 1, 2, 4, 3, 2, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 2, 4, 2, 3, 4, 2, biomeStrippedWoodOrLogOrLogHorAcrossState, biomeStrippedWoodOrLogOrLogHorAcrossState, false);
            this.func_175804_a(world, structureBB, 2, 4, 3, 2, 4, 4, biomeStrippedWoodOrLogOrLogHorAlongState, biomeStrippedWoodOrLogOrLogHorAlongState, false);
            this.func_175804_a(world, structureBB, 3, 4, 4, 4, 4, 4, biomeStrippedWoodOrLogOrLogHorAcrossState, biomeStrippedWoodOrLogOrLogHorAcrossState, false);
            this.func_175804_a(world, structureBB, 4, 4, 2, 4, 4, 3, biomeStrippedWoodOrLogOrLogHorAlongState, biomeStrippedWoodOrLogOrLogHorAlongState, false);
            this.func_175811_a(world, biomeFenceState, 1, 4, 3, structureBB);
            this.func_175811_a(world, biomeLanternState, 1, 3, 3, structureBB);
            this.func_175811_a(world, biomeFenceState, 5, 4, 3, structureBB);
            this.func_175811_a(world, biomeLanternState, 5, 3, 3, structureBB);
            this.func_175811_a(world, biomeFenceState, 3, 4, 1, structureBB);
            this.func_175811_a(world, biomeLanternState, 3, 3, 1, structureBB);
            this.func_175811_a(world, biomeFenceState, 3, 4, 5, structureBB);
            this.func_175811_a(world, biomeLanternState, 3, 3, 5, structureBB);
            if (GeneralConfig.useVillageColors) {
                IBlockState concreteBlockstate = Blocks.field_192443_dR.func_176203_a(this.townColor);
                this.func_175804_a(world, structureBB, 3, 3, 3, 3, 5, 3, concreteBlockstate, concreteBlockstate, false);
            } else {
                this.func_175804_a(world, structureBB, 3, 3, 3, 3, 5, 3, biomeStrippedWoodOrLogOrLogVerticState, biomeStrippedWoodOrLogOrLogVerticState, false);
            }
            if (GeneralConfig.nameSign) {
                int signXBB = 2;
                int signYBB = 3;
                int signZBB = 3;
                int signX = this.func_74865_a(signXBB, signZBB);
                int signY = this.func_74862_a(signYBB);
                int signZ = this.func_74873_b(signXBB, signZBB);
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeWallSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(3, this.func_186165_e().func_176736_b(), true)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
                int signXBB2 = 4;
                int signX2 = this.func_74865_a(signXBB2, signZBB);
                int signZ2 = this.func_74873_b(signXBB2, signZBB);
                TileEntitySign signContents2 = new TileEntitySign();
                for (int i = 0; i < 4; ++i) {
                    signContents2.field_145915_a[i] = signContents.field_145915_a[i];
                }
                world.func_180501_a(new BlockPos(signX2, signY, signZ2), biomeWallSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(1, this.func_186165_e().func_176736_b(), true)), 2);
                world.func_175690_a(new BlockPos(signX2, signY, signZ2), (TileEntity)signContents2);
            }
            if (GeneralConfig.villageBanners) {
                int bannerXBB = 5;
                int bannerZBB = 0;
                int bannerYBB = 1;
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                this.func_175811_a(world, biomeGrassState, bannerXBB, bannerYBB - 1, bannerZBB, structureBB);
                this.func_175808_b(world, biomeFillerState, bannerXBB, bannerYBB - 2, bannerZBB, structureBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180393_cK.func_176203_a(StructureVillageVN.getSignRotationMeta(4, this.func_186165_e().func_176736_b(), false)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                tilebanner.func_175112_a(villageBanner, false);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{5, 1, 1, -1, 0}, {5, 1, 5, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        if (random.nextInt(3) == 0) {
                            entityvillager.func_70938_b(5);
                        } else {
                            entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        }
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }

    public static class SnowyMeetingPoint2
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{"    PPP    ", "  PPPPPPP  ", " PPPFFFPPP ", "PPPFFFFFPPP", "PPPFFFFFPFP", "PPPFFFFFPPP", " PPPFFFPPPF", "  PPPPPPP  ", "    PPP F  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        public static final int GROUND_LEVEL = 1;

        public SnowyMeetingPoint2() {
        }

        public SnowyMeetingPoint2(BiomeProvider chunkManager, int componentType, Random random, int posX, int posZ, List components, float terrainType) {
            super(chunkManager, componentType, random, posX, posZ, components, terrainType);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 68, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 68, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 4 : 3), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 3 : 4), EnumFacing.EAST, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 4 : 3), this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 3 : 4), EnumFacing.WEST, this.func_74877_c());
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.field_143015_k < 0 && this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStandingSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150472_an.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodenStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(9, 4), this.func_74862_a(1), this.func_74873_b(9, 4));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            this.func_175811_a(world, biomeGrassState, 8, 0, 0, structureBB);
            this.func_175811_a(world, biomeGrassState, 10, 0, 2, structureBB);
            this.func_175804_a(world, structureBB, 4, 0, 2, 6, 0, 6, biomeGrassState, biomeGrassState, false);
            this.func_175804_a(world, structureBB, 3, 0, 3, 3, 0, 5, biomeGrassState, biomeGrassState, false);
            this.func_175804_a(world, structureBB, 7, 0, 3, 7, 0, 5, biomeGrassState, biomeGrassState, false);
            this.func_175804_a(world, structureBB, 5, 0, 2, 8, 0, 5, biomeDirtState, biomeDirtState, false);
            this.func_175811_a(world, biomeDirtState, 2, 0, 5, structureBB);
            this.func_175804_a(world, structureBB, 5, 0, 3, 5, 0, 5, biomeDirtState, biomeDirtState, false);
            this.func_175811_a(world, biomeDirtState, 4, 0, 4, structureBB);
            this.func_175811_a(world, biomeDirtState, 6, 0, 4, structureBB);
            IBlockState biomeStoneBrickState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            this.func_175811_a(world, biomeStoneBrickState, 6, 0, 3, structureBB);
            IBlockState biomePackedIceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150403_cj.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            this.func_175804_a(world, structureBB, 5, 1, 3, 5, 2, 5, biomePackedIceState, biomePackedIceState, false);
            this.func_175804_a(world, structureBB, 4, 1, 4, 4, 2, 4, biomePackedIceState, biomePackedIceState, false);
            this.func_175804_a(world, structureBB, 6, 1, 4, 6, 2, 4, biomePackedIceState, biomePackedIceState, false);
            this.func_175811_a(world, biomePackedIceState, 5, 3, 4, structureBB);
            for (int[] uvwo : new int[][]{{5, 4, 4, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwm : new int[][]{{6, 1, 2, 3}, {5, 1, 2, 3}, {4, 1, 2, 0}, {4, 1, 3, 3}, {3, 1, 3, 0}, {3, 1, 4, 0}, {3, 1, 5, 2}, {4, 1, 5, 0}, {4, 1, 6, 2}, {5, 1, 6, 2}, {6, 1, 6, 1}, {6, 1, 5, 2}, {7, 1, 5, 1}, {7, 1, 4, 1}, {7, 1, 3, 3}, {6, 1, 3, 1}}) {
                this.func_175811_a(world, biomeWoodenStairsState.func_177230_c().func_176203_a(uvwm[3]), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            if (GeneralConfig.useVillageColors) {
                IBlockState concreteBlockstate = Blocks.field_192443_dR.func_176203_a(this.townColor);
                this.func_175811_a(world, concreteBlockstate, 9, 0, 4, structureBB);
            } else {
                this.func_175811_a(world, biomePlankState, 9, 0, 4, structureBB);
            }
            if (GeneralConfig.nameSign) {
                int signXBB = 9;
                int signYBB = 1;
                int signZBB = 4;
                int signX = this.func_74865_a(signXBB, signZBB);
                int signY = this.func_74862_a(signYBB);
                int signZ = this.func_74873_b(signXBB, signZBB);
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), Blocks.field_150472_an.func_176203_a(StructureVillageVN.getSignRotationMeta(4, this.func_186165_e().func_176736_b(), false)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
            }
            if (GeneralConfig.villageBanners) {
                int bannerXBB = 8;
                int bannerZBB = 7;
                int bannerYBB = 1;
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                this.func_175811_a(world, biomePlankState, bannerXBB, bannerYBB - 1, bannerZBB, structureBB);
                this.func_175808_b(world, biomeFillerState, bannerXBB, bannerYBB - 2, bannerZBB, structureBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180393_cK.func_176203_a(StructureVillageVN.getSignRotationMeta(4, this.func_186165_e().func_176736_b(), false)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                tilebanner.func_175112_a(villageBanner, false);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{7, 1, 1, -1, 0}, {9, 1, 2, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        if (random.nextInt(3) == 0) {
                            entityvillager.func_70938_b(5);
                        } else {
                            entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        }
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }

    public static class SnowyMeetingPoint1
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{"FFPPPFFFFFFF", "PPPPPPPPPPPP", "PPFPPFFFFPPP", "PPPPPFFFFPPP", "FPPPPFFFFPPF", "FFPPPFFFFPPF", "FFFPPPPPPPPF", "FFFFFFFFPPPF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        public static final int GROUND_LEVEL = 1;

        public SnowyMeetingPoint1() {
        }

        public SnowyMeetingPoint1(BiomeProvider chunkManager, int componentType, Random random, int posX, int posZ, List components, float terrainType) {
            super(chunkManager, componentType, random, posX, posZ, components, terrainType);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 71, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 71, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (new int[]{8, 1, 2, 4})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (new int[]{4, 8, 1, 2})[this.func_186165_e().func_176736_b()], EnumFacing.EAST, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (new int[]{2, 1, 8, 4})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (new int[]{4, 2, 1, 8})[this.func_186165_e().func_176736_b()], EnumFacing.WEST, this.func_74877_c());
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.field_143015_k < 0 && this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStandingSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150472_an.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLanternState = ModObjects.chooseModLanternBlockState(true);
            IBlockState biomeStrippedWoodOrLogOrLogVerticState = biomeLogState;
            IBlockState biomeStrippedWoodOrLogOrLogHorAlongState = biomeLogState;
            IBlockState biomeStrippedWoodOrLogOrLogHorAcrossState = biomeLogState;
            if (biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150364_r || biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150363_s) {
                biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedWoodState(biomeLogState, 0);
                biomeStrippedWoodOrLogOrLogHorAlongState = ModObjects.chooseModStrippedWoodState(biomeLogState, 2);
                biomeStrippedWoodOrLogOrLogHorAcrossState = ModObjects.chooseModStrippedWoodState(biomeLogState, 1);
            }
            if (biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150364_r || biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150363_s) {
                biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogState.func_177230_c().func_176201_c(biomeLogState), 0);
                biomeStrippedWoodOrLogOrLogHorAlongState = ModObjects.chooseModStrippedLogState(biomeLogState.func_177230_c().func_176201_c(biomeLogState), 2);
                biomeStrippedWoodOrLogOrLogHorAcrossState = ModObjects.chooseModStrippedLogState(biomeLogState.func_177230_c().func_176201_c(biomeLogState), 1);
            }
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(2, 5), this.func_74862_a(2), this.func_74873_b(2, 5));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            this.func_175804_a(world, structureBB, 0, 0, 7, 1, 0, 7, biomeGrassState, biomeGrassState, false);
            this.func_175804_a(world, structureBB, 0, 0, 0, 0, 0, 3, biomeGrassState, biomeGrassState, false);
            this.func_175804_a(world, structureBB, 1, 0, 0, 1, 0, 2, biomeGrassState, biomeGrassState, false);
            this.func_175804_a(world, structureBB, 2, 0, 0, 2, 0, 1, biomeGrassState, biomeGrassState, false);
            this.func_175804_a(world, structureBB, 3, 0, 0, 7, 0, 0, biomeGrassState, biomeGrassState, false);
            this.func_175804_a(world, structureBB, 5, 0, 7, 11, 0, 7, biomeGrassState, biomeGrassState, false);
            this.func_175804_a(world, structureBB, 11, 0, 0, 11, 0, 3, biomeGrassState, biomeGrassState, false);
            this.func_175804_a(world, structureBB, 5, 0, 2, 8, 0, 5, biomeDirtState, biomeDirtState, false);
            this.func_175811_a(world, biomeDirtState, 2, 0, 5, structureBB);
            this.func_175804_a(world, structureBB, 5, 1, 2, 7, 1, 2, biomeStrippedWoodOrLogOrLogHorAcrossState, biomeStrippedWoodOrLogOrLogHorAcrossState, false);
            this.func_175804_a(world, structureBB, 5, 1, 3, 5, 1, 5, biomeStrippedWoodOrLogOrLogHorAlongState, biomeStrippedWoodOrLogOrLogHorAlongState, false);
            this.func_175804_a(world, structureBB, 6, 1, 5, 8, 1, 5, biomeStrippedWoodOrLogOrLogHorAcrossState, biomeStrippedWoodOrLogOrLogHorAcrossState, false);
            this.func_175804_a(world, structureBB, 8, 1, 2, 8, 1, 4, biomeStrippedWoodOrLogOrLogHorAlongState, biomeStrippedWoodOrLogOrLogHorAlongState, false);
            IBlockState biomeSnowLayerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150431_aC.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            this.func_175811_a(world, biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? Blocks.field_150431_aC.func_176203_a(0) : biomeSnowLayerState, 0, 1, 7, structureBB);
            this.func_175804_a(world, structureBB, 0, 1, 1, 0, 1, 3, biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? Blocks.field_150431_aC.func_176203_a(0) : biomeSnowLayerState, biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? Blocks.field_150431_aC.func_176203_a(0) : biomeSnowLayerState, false);
            this.func_175804_a(world, structureBB, 0, 1, 0, 5, 1, 0, biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? Blocks.field_150431_aC.func_176203_a(0) : biomeSnowLayerState, biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? Blocks.field_150431_aC.func_176203_a(0) : biomeSnowLayerState, false);
            this.func_175811_a(world, biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? Blocks.field_150431_aC.func_176203_a(0) : biomeSnowLayerState, 8, 1, 7, structureBB);
            this.func_175804_a(world, structureBB, 10, 1, 7, 11, 1, 7, biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? Blocks.field_150431_aC.func_176203_a(0) : biomeSnowLayerState, biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? Blocks.field_150431_aC.func_176203_a(0) : biomeSnowLayerState, false);
            this.func_175804_a(world, structureBB, 11, 1, 0, 11, 1, 3, biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? Blocks.field_150431_aC.func_176203_a(0) : biomeSnowLayerState, biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? Blocks.field_150431_aC.func_176203_a(0) : biomeSnowLayerState, false);
            this.func_175804_a(world, structureBB, 5, 2, 2, 8, 2, 5, biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? Blocks.field_150431_aC.func_176203_a(0) : biomeSnowLayerState, biomeSnowLayerState.func_177230_c() == Blocks.field_150431_aC ? Blocks.field_150431_aC.func_176203_a(0) : biomeSnowLayerState, false);
            IBlockState biomePackedIceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150403_cj.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            this.func_175804_a(world, structureBB, 6, 1, 3, 7, 2, 4, biomePackedIceState, biomePackedIceState, false);
            this.func_175804_a(world, structureBB, 6, 3, 4, 6, 7, 4, biomePackedIceState, biomePackedIceState, false);
            this.func_175804_a(world, structureBB, 7, 3, 3, 7, 5, 3, biomePackedIceState, biomePackedIceState, false);
            if (GeneralConfig.useVillageColors) {
                IBlockState concreteBlockstate = Blocks.field_192443_dR.func_176203_a(this.townColor);
                this.func_175811_a(world, concreteBlockstate, 2, 1, 5, structureBB);
            } else {
                this.func_175811_a(world, biomePackedIceState, 2, 1, 5, structureBB);
            }
            if (GeneralConfig.nameSign) {
                int signXBB = 2;
                int signYBB = 2;
                int signZBB = 5;
                int signX = this.func_74865_a(signXBB, signZBB);
                int signY = this.func_74862_a(signYBB);
                int signZ = this.func_74873_b(signXBB, signZBB);
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeStandingSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(0, this.func_186165_e().func_176736_b(), false)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
            }
            if (GeneralConfig.villageBanners) {
                int bannerXBB = 10;
                int bannerZBB = 2;
                int bannerYBB = 1;
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                this.func_175811_a(world, biomeGrassState, bannerXBB, bannerYBB - 1, bannerZBB, structureBB);
                this.func_175808_b(world, biomeFillerState, bannerXBB, bannerYBB - 2, bannerZBB, structureBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180393_cK.func_176203_a(StructureVillageVN.getSignRotationMeta(4, this.func_186165_e().func_176736_b(), false)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                tilebanner.func_175112_a(villageBanner, false);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            int[][] decorUVW = new int[][]{{1, 1, 1}, {9, 1, 7}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                int decorHeightY = uvw[1];
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, false);
                for (BlueprintData b : decorBlueprint) {
                    this.func_175811_a(world, b.getBlockState(), uvw[0] + b.getUPos(), decorHeightY + b.getVPos(), uvw[2] + b.getWPos(), structureBB);
                    if ((b.getfillFlag() & 1) != 0) {
                        this.func_175808_b(world, b.getBlockState(), uvw[0] + b.getUPos(), decorHeightY + b.getVPos() - 1, uvw[2] + b.getWPos(), structureBB);
                    }
                    if ((b.getfillFlag() & 2) == 0) continue;
                    this.func_74871_b(world, uvw[0] + b.getUPos(), decorHeightY + b.getVPos() + 1, uvw[2] + b.getWPos(), structureBB);
                }
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{3, 1, 3, -1, 0}, {10, 1, 4, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        if (random.nextInt(3) == 0) {
                            entityvillager.func_70938_b(5);
                        } else {
                            entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        }
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }
}

