/*
 * Decompiled with CFR 0.152.
 */
package squeek.wailaharvestability;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.SilverfishBlock;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.ToolType;
import squeek.wailaharvestability.Config;
import squeek.wailaharvestability.helpers.BlockHelper;
import squeek.wailaharvestability.helpers.ColorHelper;
import squeek.wailaharvestability.helpers.OreHelper;
import squeek.wailaharvestability.helpers.StringHelper;
import squeek.wailaharvestability.helpers.ToolHelper;

@WailaPlugin(value="wailaharvestability")
public class WailaHandler
implements IComponentProvider,
IWailaPlugin {
    public static HashMap<ResourceLocation, Boolean> configOptions = new HashMap();

    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        Block stackBlock;
        BlockState state = accessor.getBlockState();
        ItemStack stack = accessor.getStack();
        PlayerEntity player = accessor.getPlayer();
        if (accessor.getBlock() instanceof SilverfishBlock && (stackBlock = Block.func_149634_a((Item)stack.func_77973_b())) != accessor.getBlock()) {
            state = stackBlock.func_176223_P();
        }
        boolean minimalLayout = config.get(new ResourceLocation("harvestability", "minimal"), false);
        ArrayList<ITextComponent> stringParts = new ArrayList<ITextComponent>();
        try {
            this.getHarvestability(stringParts, player, state, accessor.getPosition(), config, minimalLayout);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!stringParts.isEmpty()) {
            if (minimalLayout) {
                tooltip.add(StringHelper.concatenateStringList(stringParts, TextFormatting.RESET + (String)Config.MAIN.minimalSeparatorString.get()));
            } else {
                tooltip.addAll(stringParts);
            }
        }
    }

    public void getHarvestability(List<ITextComponent> stringList, PlayerEntity player, BlockState state, BlockPos pos, IPluginConfig config, boolean minimalLayout) {
        boolean isSneaking = player.func_70093_af();
        boolean showHarvestLevel = config.get(new ResourceLocation("harvestability", "harvestlevel")) && (!config.get(new ResourceLocation("harvestability", "harvestlevel.sneakingonly")) || isSneaking);
        boolean showHarvestLevelNum = config.get(new ResourceLocation("harvestability", "harvestlevelnum")) && (!config.get(new ResourceLocation("harvestability", "harvestlevelnum.sneakingonly")) || isSneaking);
        boolean showEffectiveTool = config.get(new ResourceLocation("harvestability", "effectivetool")) && (!config.get(new ResourceLocation("harvestability", "effectivetool.sneakingonly")) || isSneaking);
        boolean showCurrentlyHarvestable = config.get(new ResourceLocation("harvestability", "currentlyharvestable")) && (!config.get(new ResourceLocation("harvestability", "currentlyharvestable.sneakingonly")) || isSneaking);
        boolean hideWhileHarvestable = config.get(new ResourceLocation("harvestability", "unharvestableonly"), false);
        boolean showOresOnly = config.get(new ResourceLocation("harvestability", "oresonly"), false);
        boolean toolRequiredOnly = config.get(new ResourceLocation("harvestability", "toolrequiredonly"));
        if (showHarvestLevel || showEffectiveTool || showCurrentlyHarvestable) {
            String currentlyHarvestable;
            boolean isCurrentlyHarvestable;
            if (showOresOnly && !OreHelper.isBlockAnOre(state.func_177230_c())) {
                return;
            }
            if (BlockHelper.isAdventureModeAndBlockIsUnbreakable(player, pos) || BlockHelper.isBlockUnbreakable(player.field_70170_p, pos, state)) {
                ITextComponent unbreakableString = new StringTextComponent(ColorHelper.getBooleanColor(false)).func_150258_a((String)Config.MAIN.notCurrentlyHarvestableString.get()).func_150258_a(" ").func_150257_a((ITextComponent)(!minimalLayout ? new TranslationTextComponent("wailaharvestability.harvestable", new Object[0]).func_211708_a(TextFormatting.RESET) : new StringTextComponent("")));
                stringList.add(unbreakableString);
                return;
            }
            int harvestLevel = state.getHarvestLevel();
            ToolType effectiveTool = BlockHelper.getEffectiveToolOf(player.field_70170_p, pos, state);
            if (effectiveTool != null && harvestLevel < 0) {
                harvestLevel = 0;
            }
            boolean blockHasEffectiveTools = harvestLevel >= 0 && effectiveTool != null;
            String shearability = this.getShearabilityString(player, state, pos, config);
            if (toolRequiredOnly && state.func_185904_a().func_76229_l() && !blockHasEffectiveTools && shearability.isEmpty()) {
                return;
            }
            boolean canHarvest = false;
            boolean isEffective = false;
            boolean isAboveMinHarvestLevel = false;
            boolean isHoldingTinkersTool = false;
            ItemStack heldStack = player.func_184614_ca();
            if (!heldStack.func_190926_b()) {
                canHarvest = ToolHelper.canToolHarvestBlock(heldStack, state) || !isHoldingTinkersTool && BlockHelper.canHarvestBlock(state, player);
                isAboveMinHarvestLevel = (showCurrentlyHarvestable || showHarvestLevel) && ToolHelper.canToolHarvestLevel(heldStack, (IWorldReader)player.field_70170_p, pos, player, harvestLevel);
                isEffective = showEffectiveTool && ToolHelper.isToolEffectiveAgainst(heldStack, (IWorldReader)player.field_70170_p, pos, effectiveTool);
            }
            boolean bl = isCurrentlyHarvestable = canHarvest && isAboveMinHarvestLevel || !isHoldingTinkersTool && BlockHelper.canHarvestBlock(state, player);
            if (hideWhileHarvestable && isCurrentlyHarvestable) {
                return;
            }
            String string = showCurrentlyHarvestable ? ColorHelper.getBooleanColor(isCurrentlyHarvestable) + (isCurrentlyHarvestable ? (String)Config.MAIN.currentlyHarvestableString.get() : (String)Config.MAIN.notCurrentlyHarvestableString.get()) + " " + (!minimalLayout ? TextFormatting.RESET + I18n.func_135052_a((String)"wailaharvestability.currentlyharvestable", (Object[])new Object[0]) : "") : (currentlyHarvestable = "");
            if (!currentlyHarvestable.isEmpty() || !shearability.isEmpty()) {
                String separator = !shearability.isEmpty() ? " " : "";
                stringList.add((ITextComponent)new StringTextComponent(currentlyHarvestable + separator + shearability));
            }
            if (harvestLevel != -1 && showEffectiveTool && effectiveTool != null) {
                String effectiveToolString;
                if (I18n.func_188566_a((String)("wailaharvestability.toolclass." + effectiveTool))) {
                    effectiveToolString = I18n.func_135052_a((String)("wailaharvestability.toolclass." + effectiveTool), (Object[])new Object[0]);
                } else {
                    String effectiveToolName = effectiveTool.getName();
                    effectiveToolString = effectiveToolName.substring(0, 1).toUpperCase() + effectiveToolName.substring(1);
                }
                stringList.add(new TranslationTextComponent(!minimalLayout ? "wailaharvestability.effectivetool" : "", new Object[0]).func_150258_a(" ").func_150258_a(ColorHelper.getBooleanColor(isEffective && (!isHoldingTinkersTool || canHarvest), isHoldingTinkersTool && isEffective && !canHarvest) + effectiveToolString));
            }
            if (harvestLevel >= 1 && (showHarvestLevel || showHarvestLevelNum)) {
                String harvestLevelString = "";
                String harvestLevelName = StringHelper.stripFormatting(StringHelper.getHarvestLevelName(harvestLevel));
                String harvestLevelNum = String.valueOf(harvestLevel);
                boolean bl2 = showHarvestLevelNum = showHarvestLevelNum && (!showHarvestLevel || !harvestLevelName.equals(harvestLevelNum));
                if (showHarvestLevel) {
                    harvestLevelString = harvestLevelName + (showHarvestLevelNum ? String.format(" (%d)", harvestLevel) : "");
                } else if (showHarvestLevelNum) {
                    harvestLevelString = harvestLevelNum;
                }
                stringList.add(new TranslationTextComponent(!minimalLayout ? "wailaharvestability.harvestlevel" : "", new Object[0]).func_150258_a(" ").func_150258_a(ColorHelper.getBooleanColor(isAboveMinHarvestLevel && canHarvest) + harvestLevelString));
            }
        }
    }

    public String getShearabilityString(PlayerEntity player, BlockState state, BlockPos pos, IPluginConfig config) {
        boolean canBeSheared;
        boolean isSneaking = player.func_70093_af();
        boolean showShearability = config.get(new ResourceLocation("harvestability", "shearability")) && (!config.get(new ResourceLocation("harvestability", "shearability.sneakingonly")) || isSneaking);
        boolean isDoublePlant = state.func_177230_c() instanceof DoublePlantBlock;
        boolean bl = canBeSheared = state.func_177230_c() instanceof IShearable || isDoublePlant;
        if (showShearability && canBeSheared) {
            ItemStack heldStack = player.func_184614_ca();
            boolean isHoldingShears = !heldStack.func_190926_b() && heldStack.func_77973_b() instanceof ShearsItem;
            boolean isShearable = isHoldingShears && (isDoublePlant || ((IShearable)state.func_177230_c()).isShearable(heldStack, (IWorldReader)player.field_70170_p, pos));
            return ColorHelper.getBooleanColor(isShearable, !isShearable && isHoldingShears) + (String)Config.MAIN.shearabilityString.get();
        }
        return "";
    }

    public void register(IRegistrar registrar) {
        for (Map.Entry<ResourceLocation, Boolean> entry : configOptions.entrySet()) {
            registrar.addConfig(entry.getKey(), entry.getValue().booleanValue());
        }
        WailaHandler instance = new WailaHandler();
        registrar.registerComponentProvider((IComponentProvider)instance, TooltipPosition.BODY, Block.class);
    }

    static {
        configOptions.put(new ResourceLocation("harvestability", "harvestlevel"), true);
        configOptions.put(new ResourceLocation("harvestability", "harvestlevelnum"), false);
        configOptions.put(new ResourceLocation("harvestability", "effectivetool"), true);
        configOptions.put(new ResourceLocation("harvestability", "currentlyharvestable"), true);
        configOptions.put(new ResourceLocation("harvestability", "harvestlevel.sneakingonly"), false);
        configOptions.put(new ResourceLocation("harvestability", "harvestlevelnum.sneakingonly"), false);
        configOptions.put(new ResourceLocation("harvestability", "effectivetool.sneakingonly"), false);
        configOptions.put(new ResourceLocation("harvestability", "currentlyharvestable.sneakingonly"), false);
        configOptions.put(new ResourceLocation("harvestability", "oresonly"), false);
        configOptions.put(new ResourceLocation("harvestability", "minimal"), false);
        configOptions.put(new ResourceLocation("harvestability", "unharvestableonly"), false);
        configOptions.put(new ResourceLocation("harvestability", "toolrequiredonly"), true);
        configOptions.put(new ResourceLocation("harvestability", "shearability"), true);
        configOptions.put(new ResourceLocation("harvestability", "shearability.sneakingonly"), false);
    }
}

